/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.webp;

import com.idrsolutions.image.Decoder;
import com.idrsolutions.image.JDeliImage;
import com.idrsolutions.image.utility.DataByteLittle;
import com.idrsolutions.image.utility.DataFileLittle;
import com.idrsolutions.image.webp.data.Frame;
import com.idrsolutions.image.webp.data.Vp8LBit;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;

public class WebpDecoder
extends JDeliImage
implements Decoder {
    @Override
    public BufferedImage read(byte[] rawData) throws Exception {
        DataByteLittle reader = new DataByteLittle(rawData);
        String ss = reader.getFOURCC();
        if (!"RIFF".equals(ss)) {
            throw new Exception("Not a valid WEBP file : RIFF header not found");
        }
        int fileSize = reader.getU32();
        ss = reader.getFOURCC();
        if (!"WEBP".equals(ss)) {
            throw new Exception("Not a valid WEBP file : WEBP header not found - filesize" + fileSize);
        }
        int maxRead = rawData.length - 8;
        block10: while (reader.getPosition() < maxRead) {
            ss = reader.getFOURCC();
            int chunkSize = reader.getU32();
            switch (ss) {
                case "VP8 ": {
                    Frame frm = new Frame(reader);
                    frm.decodeFrame();
                    BufferedImage image = frm.getBufferedImage();
                    return WebpDecoder.optimiseImage(image);
                }
                case "VP8L": {
                    byte[] temp = new byte[chunkSize];
                    reader.read(temp);
                    return Frame.decodeLossless(temp);
                }
                case "ANMF": {
                    reader.skip(16);
                    continue block10;
                }
            }
            reader.skip(chunkSize);
            if (chunkSize % 2 != 1) continue;
            reader.skip(1);
        }
        return null;
    }

    @Override
    public Rectangle readDimension(File file) throws Exception {
        DataFileLittle readerx = new DataFileLittle(file);
        int maxRead = Math.min(256, (int)file.length());
        byte[] temp = new byte[maxRead];
        readerx.read(temp);
        readerx.close();
        return this.readDimension(temp);
    }

    @Override
    public Rectangle readDimension(byte[] rawData) throws Exception {
        DataByteLittle reader = new DataByteLittle(rawData);
        String ss = reader.getFOURCC();
        if (!"RIFF".equals(ss)) {
            throw new Exception("Not a valid WEBP file : RIFF header not found");
        }
        int fileSize = reader.getU32();
        ss = reader.getFOURCC();
        if (!"WEBP".equals(ss)) {
            throw new Exception("Not a valid WEBP file : WEBP header not found - filesize" + fileSize);
        }
        int maxRead = rawData.length - 8;
        block10: while (reader.getPosition() < maxRead) {
            ss = reader.getFOURCC();
            int chunkSize = reader.getU32();
            switch (ss) {
                case "VP8 ": {
                    Frame frm = new Frame(reader);
                    return frm.readDimension();
                }
                case "VP8L": {
                    byte[] temp = new byte[8];
                    reader.read(temp);
                    Vp8LBit br_ = new Vp8LBit(temp);
                    br_.readBits(8);
                    int width = br_.readBits(14) + 1;
                    int height = br_.readBits(14) + 1;
                    return new Rectangle(width, height);
                }
                case "ANMF": {
                    reader.skip(16);
                    continue block10;
                }
            }
            reader.skip(chunkSize);
            if (chunkSize % 2 != 1) continue;
            reader.skip(1);
        }
        return new Rectangle(0, 0);
    }

    @Override
    public BufferedImage read(File imageFile) throws Exception {
        try (FileInputStream fis = new FileInputStream(imageFile);){
            byte[] data = new byte[(int)imageFile.length()];
            fis.read(data);
            BufferedImage bufferedImage = this.read(data);
            return bufferedImage;
        }
    }
}

