/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.viewer;

import com.idrsolutions.image.JDeli;
import com.idrsolutions.image.JDeliImage;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.jpedal.utils.LogWriter;

abstract class JavaImageViewer
extends JFrame
implements ActionListener {
    JLabel imageLabel;
    private JMenuItem docProperties;
    private JMenuItem open;
    private JMenuItem close;
    private JMenuItem save;
    private JMenuItem about;
    private JMenuItem visitWebsite;
    private JMenuItem openTutorials;
    private final String viewerTitle;
    final JMenuBar toolBar = new JMenuBar();
    static int frameWidth;
    static int frameHeight;
    int windowWidth;
    int windowHeight;
    File file;
    private static final String VERSION;

    JavaImageViewer(String title) {
        String viewerTtl = title + "   -   Version: " + VERSION;
        int bb = JDeliImage.bb;
        this.viewerTitle = bb != -5 ? bb + " days left   -   " + viewerTtl : viewerTtl;
        this.setPreferredSize(new Dimension(frameWidth, frameHeight));
    }

    void run() throws Exception {
        UIManager.put("PopupMenu.border", BorderFactory.createLineBorder(Color.GRAY, 1, true));
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        this.setTitle(this.viewerTitle);
        this.setSize(frameWidth, frameHeight);
        this.setLocationRelativeTo(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                JavaImageViewer.this.close();
            }
        });
        JPanel window = new JPanel();
        this.windowWidth = frameWidth - 20;
        this.windowHeight = frameHeight - 100;
        this.imageLabel = new JLabel();
        this.imageLabel.setBounds(10, 10, 500, 500);
        this.imageLabel.setHorizontalAlignment(0);
        this.imageLabel.setVerticalAlignment(0);
        JScrollPane scrollPane = new JScrollPane(this.imageLabel);
        scrollPane.setSize(600, 600);
        this.toolBar.setBounds(0, 0, 400, 20);
        JMenu fileMenu = JavaImageViewer.getMenu("File");
        JMenu helpMenu = JavaImageViewer.getMenu("Help");
        this.docProperties = new JMenuItem("Document Properties");
        this.docProperties.addActionListener(this);
        this.open = new JMenuItem("Open");
        this.open.addActionListener(this);
        this.close = new JMenuItem("Close");
        this.close.addActionListener(this);
        this.save = new JMenuItem("Save");
        this.save.addActionListener(this);
        this.about = new JMenuItem("About");
        this.about.addActionListener(this);
        this.visitWebsite = new JMenuItem("Visit Website");
        this.visitWebsite.addActionListener(this);
        this.openTutorials = new JMenuItem("Documentation");
        this.openTutorials.addActionListener(this);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)window, "Center");
        this.add(panel);
        this.toolBar.add(fileMenu);
        this.toolBar.add(helpMenu);
        fileMenu.add(this.open);
        fileMenu.addSeparator();
        fileMenu.add(this.save);
        fileMenu.addSeparator();
        fileMenu.add(this.docProperties);
        fileMenu.addSeparator();
        fileMenu.add(this.close);
        helpMenu.add(this.about);
        helpMenu.addSeparator();
        helpMenu.add(this.visitWebsite);
        helpMenu.addSeparator();
        helpMenu.add(this.openTutorials);
        window.setLayout(new BorderLayout());
        window.add((Component)scrollPane, "Center");
    }

    private static JMenu getMenu(String name) {
        JMenu menu = new JMenu(name);
        menu.setBorderPainted(true);
        return menu;
    }

    private void selectFile() {
        FileDialog fileChooser = new FileDialog((Frame)null, "File chooser");
        fileChooser.setMode(0);
        fileChooser.setFilenameFilter((f, name) -> this.isImageFormatSupported(name.substring(name.lastIndexOf(46) + 1)));
        fileChooser.setVisible(true);
        if (fileChooser.getDirectory() != null && fileChooser.getFile() != null) {
            this.file = new File(fileChooser.getDirectory() + fileChooser.getFile());
        }
    }

    private boolean canConvert() {
        if (this.file == null) {
            JOptionPane.showMessageDialog(this, "No File Selected");
            return false;
        }
        if (!this.file.exists()) {
            JOptionPane.showMessageDialog(this, "File does not exist: " + String.valueOf(this.file));
            return false;
        }
        if (!this.file.isFile()) {
            JOptionPane.showMessageDialog(this, "File selected is not a valid file: " + String.valueOf(this.file));
            return false;
        }
        String ext = this.getExtension();
        if (!this.isImageFormatSupported(ext)) {
            JOptionPane.showMessageDialog(this, ext + " is not a supported image format");
            return false;
        }
        return true;
    }

    String getExtension() {
        String fileName = this.file.getName();
        int index = fileName.lastIndexOf(46) + 1;
        return fileName.substring(index).toLowerCase();
    }

    void setAndDisplayFile(File file) {
        this.file = file;
        if (this.canConvert()) {
            this.displayImage();
        }
    }

    abstract BufferedImage getImage();

    abstract Rectangle getImageDimension();

    abstract String getImageType();

    abstract void saveFile();

    abstract boolean isImageFormatSupported(String var1);

    void displayImage() {
        this.draw();
    }

    private void displayProperties() {
        if (!this.canConvert()) {
            return;
        }
        JFrame propertiesWindow = new JFrame("Document Properties");
        propertiesWindow.setDefaultCloseOperation(2);
        propertiesWindow.setSize(400, 300);
        propertiesWindow.setLocationRelativeTo(null);
        propertiesWindow.setVisible(true);
        propertiesWindow.getContentPane().setLayout(new BoxLayout(propertiesWindow.getContentPane(), 1));
        JPanel propertiesPanel = new JPanel();
        propertiesWindow.getContentPane().add(propertiesPanel);
        Dimension panelDimensions = new Dimension(200, 250);
        propertiesPanel.setPreferredSize(panelDimensions);
        propertiesPanel.setMaximumSize(panelDimensions);
        propertiesPanel.setAlignmentX(0.5f);
        propertiesPanel.setAlignmentY(0.5f);
        propertiesPanel.setLayout(new GridLayout(3, 0));
        Rectangle dimension = this.getImageDimension();
        int h = dimension.height;
        int w = dimension.width;
        String type = this.getImageType();
        JLabel widthData = new JLabel("Width: " + w);
        JLabel heightData = new JLabel("Height: " + h);
        JLabel typeData = new JLabel("Type: " + type);
        typeData.setAlignmentX(0.5f);
        propertiesPanel.add(typeData);
        propertiesPanel.add(widthData);
        propertiesPanel.add(heightData);
        propertiesPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
    }

    private void close() {
        int saveOnClose;
        if (this.file != null && (saveOnClose = JOptionPane.showOptionDialog(this, "Save Image?", "Save", 0, 2, null, null, null)) == 0) {
            this.saveFile();
        }
        this.dispose();
        System.exit(0);
    }

    void displayAbout() {
        JFrame aboutWindow = new JFrame("About");
        aboutWindow.setDefaultCloseOperation(2);
        aboutWindow.setSize(450, 400);
        aboutWindow.setLocationRelativeTo(null);
        aboutWindow.setVisible(true);
        final JPanel aboutPanel = new JPanel();
        aboutPanel.setBackground(new Color(84, 130, 31));
        aboutPanel.setForeground(Color.WHITE);
        Dimension panelDimensions = new Dimension(450, 400);
        aboutPanel.setPreferredSize(panelDimensions);
        aboutPanel.setMaximumSize(panelDimensions);
        aboutPanel.setAlignmentX(0.5f);
        aboutPanel.setAlignmentY(0.5f);
        GridBagLayout gl = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        JLabel title = new JLabel(this.viewerTitle.substring(0, this.viewerTitle.lastIndexOf(45)));
        title.setFont(new Font("SansSerif", 1, 14));
        title.setHorizontalAlignment(0);
        title.setForeground(Color.WHITE);
        ImageIcon logo = new ImageIcon(Objects.requireNonNull(JDeli.class.getResource("/com/idrsolutions/image/res/jdeliLogo.png")));
        logo = new ImageIcon(logo.getImage().getScaledInstance(logo.getIconWidth() / 2, logo.getIconHeight() / 2, 2));
        JLabel idrLogo = new JLabel(logo);
        idrLogo.setVerticalAlignment(3);
        idrLogo.setPreferredSize(new Dimension(150, 105));
        JLabel versionsHeaderLabel = new JLabel(" -Version- ");
        versionsHeaderLabel.setFont(new Font("SansSerif", 1, 14));
        versionsHeaderLabel.setForeground(Color.WHITE);
        versionsHeaderLabel.setLayout(gl);
        versionsHeaderLabel.setBorder(new EmptyBorder(20, 0, 0, 0));
        JLabel jdeliLabel = new JLabel("JDeli: " + VERSION);
        JLabel javaLabel = new JLabel("Java: " + System.getProperty("java.version"));
        jdeliLabel.setLayout(gl);
        javaLabel.setLayout(gl);
        javaLabel.setForeground(Color.WHITE);
        jdeliLabel.setForeground(Color.WHITE);
        jdeliLabel.setBorder(new EmptyBorder(0, 0, 15, 0));
        javaLabel.setBorder(new EmptyBorder(0, 0, 50, 0));
        JTextArea aboutUsSection = new JTextArea("Our Java swing Image Viewer is split for JDeli and ImageIO so no matter how you use JDeli, you can view your images.");
        aboutUsSection.setOpaque(false);
        aboutUsSection.setLineWrap(true);
        aboutUsSection.setBounds(aboutUsSection.getX(), aboutUsSection.getY(), 400, 20);
        aboutUsSection.setWrapStyleWord(true);
        aboutUsSection.setEditable(false);
        aboutUsSection.setForeground(Color.WHITE);
        final JLabel url = new JLabel("<html><center>Take me to JDeli");
        url.setForeground(Color.blue);
        url.setHorizontalAlignment(0);
        url.setAlignmentX(0.5f);
        url.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                aboutPanel.setCursor(new Cursor(12));
                url.setText("<html><center><a href='https://www.idrsolutions.com/jdeli/'>Take me to JDeli</a></center>");
            }

            @Override
            public void mouseExited(MouseEvent e) {
                aboutPanel.setCursor(new Cursor(0));
                url.setText("<html><center>Take me to JDeli");
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    Desktop.getDesktop().browse(new URI("https://www.idrsolutions.com/jdeli/"));
                }
                catch (Exception e1) {
                    LogWriter.writeLog("Exception attempting launch browser: " + String.valueOf(e1));
                }
            }
        });
        aboutPanel.setLayout(gl);
        gl.setConstraints(aboutPanel, constraints);
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridheight = 1;
        constraints.fill = 0;
        constraints.gridwidth = 2;
        constraints.gridx = 0;
        constraints.gridy = 0;
        aboutPanel.add((Component)title, constraints);
        constraints.gridwidth = 1;
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridheight = 3;
        aboutPanel.add((Component)idrLogo, constraints);
        constraints.gridheight = 1;
        constraints.gridx = 1;
        constraints.gridy = 1;
        aboutPanel.add((Component)versionsHeaderLabel, constraints);
        constraints.weighty = 0.0;
        constraints.gridx = 1;
        constraints.gridy = 2;
        aboutPanel.add((Component)jdeliLabel, constraints);
        constraints.gridx = 1;
        constraints.gridy = 3;
        aboutPanel.add((Component)javaLabel, constraints);
        constraints.weighty = 1.0;
        constraints.gridwidth = 2;
        constraints.gridx = 0;
        constraints.gridy = 4;
        aboutPanel.add((Component)aboutUsSection, constraints);
        constraints.gridx = 0;
        constraints.gridy = 5;
        aboutPanel.add((Component)url, constraints);
        aboutWindow.getContentPane().add(aboutPanel);
        aboutPanel.paint(aboutPanel.getGraphics());
    }

    private static void openWebsite(String url) {
        try {
            Desktop.getDesktop().browse(new URI(url));
        }
        catch (IOException | URISyntaxException e) {
            LogWriter.writeLog("Failed to open website: " + e.getMessage());
        }
    }

    void draw() {
        BufferedImage original = this.getImage();
        if (original == null) {
            return;
        }
        double zoomAmount = JavaImageViewer.calculateFitToScreen(original.getWidth(), original.getHeight());
        double zoomWidth = (double)original.getWidth() * zoomAmount;
        double zoomHeight = (double)original.getHeight() * zoomAmount;
        this.imageLabel.setIcon(new ImageIcon(original.getScaledInstance((int)zoomWidth, (int)zoomHeight, 4)));
    }

    static float calculateFitToScreen(int imageWidth, int imageHeight) {
        if (imageWidth > imageHeight) {
            return (float)frameWidth / (float)imageWidth;
        }
        return (float)frameHeight / (float)imageHeight;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.open) {
            try {
                this.selectFile();
                if (this.canConvert()) {
                    this.displayImage();
                }
            }
            catch (Exception exception) {
                LogWriter.writeLog("Failed to open file: " + exception.getMessage());
            }
        }
        if (e.getSource() == this.docProperties) {
            try {
                this.displayProperties();
            }
            catch (Exception exception) {
                LogWriter.writeLog("Failed to gather file properties: " + exception.getMessage());
            }
        }
        if (e.getSource() == this.close) {
            this.close();
        }
        if (e.getSource() == this.about) {
            this.displayAbout();
        }
        if (e.getSource() == this.save && this.canConvert()) {
            this.saveFile();
        }
        if (e.getSource() == this.visitWebsite) {
            JavaImageViewer.openWebsite("https://www.idrsolutions.com/jdeli/pricing");
        }
        if (e.getSource() == this.openTutorials) {
            JavaImageViewer.openWebsite("https://support.idrsolutions.com/jdeli/");
        }
    }

    static {
        Dimension screenDimension = Toolkit.getDefaultToolkit().getScreenSize();
        frameWidth = (int)(screenDimension.getWidth() / 1.5);
        frameHeight = (int)(screenDimension.getHeight() / 1.5);
        Properties props = new Properties();
        try (InputStream is = JavaImageViewer.class.getResourceAsStream("/version.num");){
            if (is != null) {
                try {
                    props.load(is);
                }
                catch (IOException ex) {
                    LogWriter.writeLog("Exception: " + ex.getMessage());
                }
            }
        }
        catch (IOException e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
        String versionSet = props.getProperty("release");
        VERSION = versionSet != null ? versionSet : "@VERSION@";
    }
}

