/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.tika;

import com.idrsolutions.image.JDeli;
import com.idrsolutions.image.metadata.Metadata;
import com.idrsolutions.image.utility.SupportedFormats;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class MetadataParser
implements Parser {
    private final Set<MediaType> supportedTypes;

    public MetadataParser() {
        ArrayList<MediaType> supportedTypes = new ArrayList<MediaType>();
        String[][] stringArray = SupportedFormats.getSupportedImageMetadatas();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String[] imageType;
            for (String mimeType : imageType = stringArray[i]) {
                supportedTypes.add(MediaType.image((String)mimeType));
            }
        }
        this.supportedTypes = new HashSet<MediaType>(supportedTypes);
    }

    public Set<MediaType> getSupportedTypes(ParseContext parseContext) {
        return this.supportedTypes;
    }

    public void parse(InputStream inputStream, ContentHandler contentHandler, org.apache.tika.metadata.Metadata metadata, ParseContext parseContext) throws IOException, SAXException, TikaException {
        Metadata imageMetadata;
        TikaInputStream tikaStream = TikaInputStream.cast((InputStream)inputStream);
        if (tikaStream == null) {
            throw new UnsupportedOperationException("File path should be passed as a TikaInputStream");
        }
        try {
            imageMetadata = JDeli.getImageInfo(tikaStream.getFile());
        }
        catch (Exception e) {
            throw new TikaException("Cannot parse image metadata");
        }
        XHTMLContentHandler xhtml = new XHTMLContentHandler(contentHandler, metadata);
        xhtml.startDocument();
        xhtml.startElement("h1");
        xhtml.characters(imageMetadata.getImageMetadataType().toString());
        xhtml.endElement("h1");
        String imageMetadataString = imageMetadata.toString();
        String[] jsonKeyValuePairs = imageMetadataString.substring(1, imageMetadataString.length() - 1).split("[:,]");
        if (jsonKeyValuePairs.length % 2 != 0) {
            throw new TikaException("Invalid metadata returned");
        }
        ArrayList<String> headings = new ArrayList<String>();
        ArrayList<String> data = new ArrayList<String>();
        for (int i = 0; i < jsonKeyValuePairs.length; ++i) {
            String value = jsonKeyValuePairs[i];
            int valueLastChar = value.length() - 1;
            if (value.charAt(0) == '\"' && value.charAt(valueLastChar) == '\"') {
                value = value.substring(1, valueLastChar);
            }
            if (i % 2 == 0) {
                headings.add(value);
                continue;
            }
            data.add(value);
        }
        xhtml.startElement("table");
        xhtml.startElement("tr");
        for (String heading : headings) {
            xhtml.startElement("th");
            xhtml.characters(heading);
            xhtml.endElement("th");
        }
        xhtml.endElement("tr");
        xhtml.startElement("tr");
        for (String datum : data) {
            xhtml.startElement("th");
            xhtml.characters(datum);
            xhtml.endElement("th");
        }
        xhtml.endElement("tr");
        xhtml.endElement("table");
        xhtml.endDocument();
    }
}

