/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.tika;

import com.idrsolutions.image.ImageFormat;
import com.idrsolutions.image.ImageTypeFinder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.tika.detect.Detector;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;

public class ImageDetector
implements Detector {
    public MediaType detect(InputStream inputStream, Metadata metadata) throws IOException {
        int nRead;
        if (inputStream == null) {
            throw new IOException("Stream must not be null");
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[4];
        while ((nRead = TikaInputStream.get((InputStream)inputStream).read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        return ImageDetector.imageFormatToMediaType(ImageTypeFinder.getImageType(buffer.toByteArray()));
    }

    private static MediaType imageFormatToMediaType(ImageFormat imageFormat) {
        return switch (imageFormat) {
            case ImageFormat.BMP_IMAGE -> MediaType.image((String)"bmp");
            case ImageFormat.DICOM_IMAGE -> MediaType.application((String)"dicom");
            case ImageFormat.EMF_IMAGE -> MediaType.image((String)"emf");
            case ImageFormat.GIF_IMAGE, ImageFormat.ANIMATED_GIF -> MediaType.image((String)"gif");
            case ImageFormat.HEIC_MULTI_FRAME_IMAGE, ImageFormat.HEIC_IMAGE -> MediaType.image((String)"heic");
            case ImageFormat.JPEG_IMAGE -> MediaType.image((String)"jpeg");
            case ImageFormat.JPEG2000_IMAGE -> MediaType.image((String)"jpx");
            case ImageFormat.PNG_IMAGE -> MediaType.image((String)"png");
            case ImageFormat.PSD_IMAGE -> MediaType.image((String)"vnd.adobe.photoshop");
            case ImageFormat.SGI_IMAGE -> MediaType.image((String)"sgi");
            case ImageFormat.TIFF_IMAGE -> MediaType.image((String)"tiff");
            case ImageFormat.WEBP_IMAGE -> MediaType.image((String)"webp");
            case ImageFormat.WMF_IMAGE -> MediaType.image((String)"wmf");
            default -> MediaType.EMPTY;
        };
    }
}

