/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.tiff.options;

import com.idrsolutions.image.encoder.OutputFormat;
import com.idrsolutions.image.encoder.options.EncoderOptions;
import com.idrsolutions.image.tiff.options.TiffCompressionFormat;
import com.idrsolutions.image.tiff.options.TiffResolutionUnit;
import java.util.Arrays;

public class TiffEncoderOptions
implements EncoderOptions {
    private String xmpMetaData;
    private int xresolution = -1;
    private int yresolution = -1;
    private TiffResolutionUnit resolutionUnit = TiffResolutionUnit.NONE;
    private TiffCompressionFormat tiffCompression = TiffCompressionFormat.DEFLATE_BETTER_COMPRESSION;

    public TiffEncoderOptions() {
        this.setJVMparams();
    }

    private void setJVMparams() {
        String compression = System.getProperty("image.tiff.compression");
        Object errorMessage = "";
        try {
            String dpi;
            if (compression != null) {
                errorMessage = "'" + compression + "' for 'image.tiff.compression'. The following arguments are accepted : " + Arrays.toString((Object[])TiffCompressionFormat.values());
                this.tiffCompression = TiffCompressionFormat.valueOf(compression.toUpperCase());
            }
            if ((dpi = System.getProperty("image.tiff.dpi")) != null) {
                errorMessage = "'" + dpi + "' for 'image.tiff.dpi'. The following arguments are accepted : Any positive number.  ";
                this.resolutionUnit = TiffResolutionUnit.INCH;
                this.xresolution = Integer.parseInt(dpi);
                this.yresolution = Integer.parseInt(dpi);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Invalid argument passed : " + (String)errorMessage);
        }
    }

    @Override
    public OutputFormat getOutputFormat() {
        return OutputFormat.TIFF;
    }

    public void setCompressionFormat(TiffCompressionFormat tiffCompression) {
        this.tiffCompression = tiffCompression;
    }

    public TiffCompressionFormat getCompressionFormat() {
        return this.tiffCompression;
    }

    public void setXmpMetaData(String xmpMetaData) {
        this.xmpMetaData = xmpMetaData;
    }

    public String getXmpMetaData() {
        return this.xmpMetaData;
    }

    public int getYResolution() {
        return this.yresolution;
    }

    public int getXResolution() {
        return this.xresolution;
    }

    public void setResolutionUnit(TiffResolutionUnit resolutionUnit) {
        this.resolutionUnit = resolutionUnit;
    }

    public TiffResolutionUnit getResolutionUnit() {
        return this.resolutionUnit;
    }

    public void setXResolution(int xresolution) {
        this.xresolution = xresolution;
    }

    public void setYResolution(int yresolution) {
        this.yresolution = yresolution;
    }
}

