/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.tiff;

import java.io.ByteArrayOutputStream;
import java.io.IOException;

final class PackBits {
    private PackBits() {
    }

    public static byte[] decompress(byte[] input, int expected) throws IOException {
        int total = 0;
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream(input.length * 2);){
            int i = 0;
            while (total < expected) {
                byte n;
                if (i >= input.length) {
                    throw new IOException("Error in packbit decompression ");
                }
                if ((n = input[i++]) >= 0) {
                    int cc = n + 1;
                    total += cc;
                    for (int j = 0; j < cc; ++j) {
                        bos.write(input[i++]);
                    }
                    continue;
                }
                if (n >= -127) {
                    byte b = input[i++];
                    int count = -n + 1;
                    total += count;
                    for (int j = 0; j < count; ++j) {
                        bos.write(b);
                    }
                    continue;
                }
                throw new IOException("Error in packbit decompression ");
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }
}

