/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.tiff;

import java.util.HashMap;

public enum IFDColorSpace {
    WhiteIsZero(0),
    RGB(2),
    RGB_Palette(3),
    CMYK(5),
    YCbCr(6),
    JDELI_UNSUPPORTED(-1);

    final int value;
    private static final HashMap<Integer, IFDColorSpace> lookup;

    private IFDColorSpace(int val) {
        this.value = val;
    }

    public static IFDColorSpace getIFD(int val) {
        IFDColorSpace key = lookup.get(val);
        if (key == null) {
            return JDELI_UNSUPPORTED;
        }
        return key;
    }

    static {
        lookup = new HashMap();
        for (IFDColorSpace value : IFDColorSpace.values()) {
            lookup.put(value.value, value);
        }
    }
}

