/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.psd;

import com.idrsolutions.image.Decoder;
import com.idrsolutions.image.JDeliImage;
import com.idrsolutions.image.jpeg2000.EnumeratedSpace;
import com.idrsolutions.image.psd.data.ImageResource;
import com.idrsolutions.image.psd.data.Info;
import com.idrsolutions.image.utility.DataByteBig;
import com.idrsolutions.image.utility.DataFileBig;
import com.idrsolutions.image.utility.DataReader;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.IndexColorModel;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import org.jpedal.utils.LogWriter;

public class PsdDecoder
extends JDeliImage
implements Decoder {
    private DataReader reader;

    @Override
    public BufferedImage read(byte[] psdRawData) throws Exception {
        this.reader = new DataByteBig(psdRawData);
        Info info = new Info();
        PsdDecoder.readHeader(info, this.reader);
        PsdDecoder.readColorModeData(info, this.reader);
        PsdDecoder.readImageResources(info, this.reader);
        PsdDecoder.readLayersAndMask(this.reader);
        return PsdDecoder.optimiseImage(PsdDecoder.readChannelImageData(info, this.reader));
    }

    @Override
    public BufferedImage read(File file) throws Exception {
        this.reader = new DataFileBig(file);
        Info info = new Info();
        PsdDecoder.readHeader(info, this.reader);
        PsdDecoder.readColorModeData(info, this.reader);
        PsdDecoder.readImageResources(info, this.reader);
        PsdDecoder.readLayersAndMask(this.reader);
        BufferedImage image = PsdDecoder.readChannelImageData(info, this.reader);
        this.reader.close();
        return PsdDecoder.optimiseImage(image);
    }

    @Override
    public Rectangle readDimension(File psdFile) throws IOException {
        DataFileBig reader = new DataFileBig(psdFile);
        Info info = new Info();
        PsdDecoder.readHeader(info, reader);
        reader.close();
        return new Rectangle(info.width, info.height);
    }

    @Override
    public Rectangle readDimension(byte[] psdData) throws IOException {
        DataByteBig reader = new DataByteBig(psdData);
        Info info = new Info();
        PsdDecoder.readHeader(info, reader);
        return new Rectangle(info.width, info.height);
    }

    private static void readHeader(Info info, DataReader reader) throws IOException {
        int signature = reader.getU32();
        if (signature != 943870035) {
            throw new IOException("Not a valid PSD File");
        }
        int version = reader.getU16();
        if (version != 1) {
            throw new IOException("Invalid PSD version found");
        }
        reader.getU32();
        reader.getU16();
        info.nComp = reader.getU16();
        info.height = reader.getU32();
        info.width = reader.getU32();
        info.bps = reader.getU16();
        info.colorMode = reader.getU16();
    }

    private static void readColorModeData(Info info, DataReader reader) throws IOException {
        int length = reader.getU32();
        info.colorData = new byte[length];
        reader.read(info.colorData);
    }

    private static void readImageResources(Info info, DataReader reader) throws IOException {
        int length = reader.getU32();
        int resourceEnd = reader.getPosition() + length;
        while (reader.getPosition() < resourceEnd) {
            ImageResource ir = new ImageResource();
            reader.getU32();
            ir.id = reader.getU16();
            byte[] ss = new byte[2];
            reader.read(ss);
            ir.name = new String(ss);
            int len = reader.getU32();
            ir.len = len % 2 == 0 ? len : len + 1;
            ir.offset = reader.getPosition();
            reader.moveTo(ir.offset + ir.len);
            info.imageResources.add(ir);
        }
        reader.moveTo(resourceEnd);
    }

    private static void readLayersAndMask(DataReader reader) throws IOException {
        int length = reader.getU32();
        int resourceEnd = reader.getPosition() + length;
        PsdDecoder.readLayerInfo(reader);
        reader.moveTo(resourceEnd);
    }

    private static void readLayerInfo(DataReader reader) throws IOException {
        int length = reader.getU32();
        int resourceEnd = reader.getPosition() + length;
        reader.moveTo(resourceEnd);
    }

    private static BufferedImage readChannelImageData(Info info, DataReader reader) throws IOException {
        int compression = reader.getU16();
        byte[] rawData = switch (compression) {
            case 0 -> PsdDecoder.decompressNormal(reader, info);
            case 1 -> PsdDecoder.decompressRunLength(reader, info);
            default -> null;
        };
        BufferedImage img = null;
        switch (info.colorMode) {
            case 0: {
                break;
            }
            case 1: {
                img = PsdDecoder.readGrayScale(info, rawData);
                break;
            }
            case 2: {
                img = PsdDecoder.readIndex(info, rawData);
                break;
            }
            case 3: 
            case 5: 
            case 9: {
                img = PsdDecoder.readRGB(info, rawData);
                break;
            }
            case 4: {
                img = PsdDecoder.readCMYK(info, rawData);
            }
        }
        return img;
    }

    private static byte[] decompressNormal(DataReader reader, Info info) throws IOException {
        int dim = info.width * info.height;
        int nDim = dim * info.nComp;
        byte[] output = new byte[nDim];
        for (int i = 0; i < info.nComp; ++i) {
            int p = 0;
            byte[] temp = new byte[dim];
            reader.read(temp);
            for (int z = i; z < nDim; z += info.nComp) {
                output[z] = temp[p++];
            }
        }
        return output;
    }

    private static byte[] decompressRunLength(DataReader reader, Info info) throws IOException {
        int[][] lineLengths = new int[info.nComp][info.height];
        for (int i = 0; i < info.nComp; ++i) {
            for (int j = 0; j < info.height; ++j) {
                lineLengths[i][j] = reader.getU16();
            }
        }
        int dim = info.width * info.height;
        int nDim = dim * info.nComp;
        byte[] output = new byte[nDim];
        for (int i = 0; i < info.nComp; ++i) {
            byte[] temp;
            try (ByteArrayOutputStream bos = new ByteArrayOutputStream(dim);){
                for (int j = 0; j < info.height; ++j) {
                    temp = new byte[lineLengths[i][j]];
                    reader.read(temp);
                    temp = PsdDecoder.runLengthDecode(temp);
                    bos.write(temp);
                }
                temp = bos.toByteArray();
            }
            int p = 0;
            for (int z = i; z < nDim; z += info.nComp) {
                output[z] = temp[p++];
            }
        }
        return output;
    }

    private static byte[] runLengthDecode(byte[] input) {
        int len = input.length;
        byte[] bosByteArray = null;
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream(len);){
            int pos = 0;
            while (pos < len) {
                int runLength;
                if ((runLength = input[pos++]) < 0) {
                    runLength = 1 - runLength;
                    int copyValue = input[pos++] & 0xFF;
                    while (runLength-- > 0) {
                        bos.write(copyValue);
                    }
                    continue;
                }
                runLength = 1 + runLength;
                while (runLength-- > 0) {
                    bos.write(input[pos++] & 0xFF);
                }
            }
            bosByteArray = bos.toByteArray();
        }
        catch (IOException e) {
            LogWriter.error(e, "Exception thrown decoding run-length");
        }
        return bosByteArray;
    }

    private static BufferedImage readGrayScale(Info info, byte[] rawData) {
        BufferedImage img = new BufferedImage(info.width, info.height, 10);
        byte[] bPixels = ((DataBufferByte)img.getRaster().getDataBuffer()).getData();
        System.arraycopy(rawData, 0, bPixels, 0, bPixels.length);
        return img;
    }

    private static BufferedImage readIndex(Info info, byte[] rawData) {
        int tColors = info.colorData.length / 3;
        byte[] r = new byte[tColors];
        byte[] g = new byte[tColors];
        byte[] b = new byte[tColors];
        System.arraycopy(info.colorData, 0, r, 0, tColors);
        System.arraycopy(info.colorData, tColors, g, 0, tColors);
        System.arraycopy(info.colorData, tColors * 2, b, 0, tColors);
        IndexColorModel cm = new IndexColorModel(info.bps, tColors, r, g, b);
        BufferedImage img = new BufferedImage(info.width, info.height, 13, cm);
        byte[] bPixels = ((DataBufferByte)img.getRaster().getDataBuffer()).getData();
        System.arraycopy(rawData, 0, bPixels, 0, bPixels.length);
        return img;
    }

    private static BufferedImage readRGB(Info info, byte[] rawData) {
        int p = 0;
        BufferedImage img = new BufferedImage(info.width, info.height, 2);
        int[] iPixels = ((DataBufferInt)img.getRaster().getDataBuffer()).getData();
        switch (info.nComp) {
            case 5: {
                for (int i = 0; i < iPixels.length; ++i) {
                    int r = rawData[p++] & 0xFF;
                    int g = rawData[p++] & 0xFF;
                    int b = rawData[p++] & 0xFF;
                    int a = rawData[p++] & 0xFF;
                    ++p;
                    iPixels[i] = a << 24 | r << 16 | g << 8 | b;
                }
                break;
            }
            case 4: {
                for (int i = 0; i < iPixels.length; ++i) {
                    int r = rawData[p++] & 0xFF;
                    int g = rawData[p++] & 0xFF;
                    int b = rawData[p++] & 0xFF;
                    int a = rawData[p++] & 0xFF;
                    iPixels[i] = a << 24 | r << 16 | g << 8 | b;
                }
                break;
            }
            default: {
                for (int i = 0; i < iPixels.length; ++i) {
                    int r = rawData[p++] & 0xFF;
                    int g = rawData[p++] & 0xFF;
                    int b = rawData[p++] & 0xFF;
                    iPixels[i] = 0xFF000000 | r << 16 | g << 8 | b;
                }
            }
        }
        return img;
    }

    private static BufferedImage readCMYK(Info info, byte[] rawData) {
        int p = 0;
        BufferedImage img = new BufferedImage(info.width, info.height, 2);
        int[] cPixels = ((DataBufferInt)img.getRaster().getDataBuffer()).getData();
        EnumeratedSpace es = new EnumeratedSpace();
        if (info.nComp == 5) {
            for (int i = 0; i < cPixels.length; ++i) {
                int c = 255 - (rawData[p++] & 0xFF);
                int m = 255 - (rawData[p++] & 0xFF);
                int y = 255 - (rawData[p++] & 0xFF);
                int k = 255 - (rawData[p++] & 0xFF);
                int a = rawData[p++] & 0xFF;
                cPixels[i] = a << 24 | es.getRGB(c, m, y, k);
            }
        } else {
            for (int i = 0; i < cPixels.length; ++i) {
                int c = rawData[p++] & 0xFF;
                int m = rawData[p++] & 0xFF;
                int y = rawData[p++] & 0xFF;
                int k = rawData[p++] & 0xFF;
                cPixels[i] = 0xFF000000 | es.getRGB(c, m, y, k);
            }
        }
        return img;
    }
}

