/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.process;

import com.idrsolutions.image.process.ImageOperation;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public final class Watermark
implements ImageOperation {
    private String text;
    private Color color;
    private final WatermarkPosition pos;
    private Font font;
    private boolean wrapText;
    private Shape shape;
    private BufferedImage watermarkImage;
    private final WatermarkType type;
    private WatermarkShapeProperties properties;
    private AlphaComposite alphaComposite;

    public Watermark(String text, Color color, Font font, WatermarkPosition pos) {
        this.text = text;
        this.color = color;
        this.pos = pos;
        this.font = font;
        this.wrapText = text.contains("\n");
        this.type = WatermarkType.TEXT;
    }

    public Watermark(Shape shape2, Color color, WatermarkPosition pos, AlphaComposite alphaComposite, WatermarkShapeProperties properties) {
        this.shape = shape2;
        this.color = color;
        this.pos = pos;
        this.type = WatermarkType.SHAPE;
        this.alphaComposite = alphaComposite;
        this.properties = properties;
    }

    public Watermark(BufferedImage watermarkImage, WatermarkPosition pos, AlphaComposite alphaComposite) {
        this.watermarkImage = watermarkImage;
        this.pos = pos;
        this.type = WatermarkType.IMAGE;
        this.alphaComposite = alphaComposite;
    }

    @Override
    public BufferedImage apply(BufferedImage image) {
        return switch (this.type.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> this.applyImage(image);
            case 1 -> this.applyShape(image);
            case 2 -> this.applyText(image);
        };
    }

    private BufferedImage applyText(BufferedImage sourceImage) {
        Graphics2D g2d = (Graphics2D)sourceImage.getGraphics();
        g2d.setColor(this.color);
        int imageWidth = sourceImage.getWidth();
        int imageHeight = sourceImage.getHeight();
        switch (this.pos.ordinal()) {
            case 1: {
                g2d.setFont(Watermark.scaleFontToFit(this.text, imageWidth, g2d, g2d.getFont()));
                int msgWidth = (int)g2d.getFont().getStringBounds(this.text, g2d.getFontRenderContext()).getWidth();
                if (this.wrapText) {
                    String[] split = this.text.split("\n");
                    Font flagFont = Watermark.scaleFontToFit(split, imageHeight, imageWidth, g2d);
                    g2d.setFont(flagFont);
                    int y = imageHeight - g2d.getFontMetrics().getDescent();
                    for (int i = split.length - 1; i >= 0; --i) {
                        String w = split[i];
                        Rectangle2D rect = g2d.getFont().getStringBounds(w, g2d.getFontRenderContext());
                        msgWidth = (int)rect.getWidth();
                        int x = (imageWidth - msgWidth) / 2;
                        g2d.drawString(w, x, y);
                        y = (int)((double)y - rect.getHeight());
                    }
                } else {
                    g2d.drawString(this.text, (imageWidth - msgWidth) / 2, imageHeight - g2d.getFontMetrics().getDescent());
                }
                g2d.dispose();
                break;
            }
            case 0: {
                g2d.setFont(this.font);
                FontMetrics fontMetrics = g2d.getFontMetrics();
                Rectangle2D rect = fontMetrics.getStringBounds(this.text, g2d);
                if (this.wrapText) {
                    String[] split = this.text.split("\n");
                    int centreY = (int)((double)((sourceImage.getHeight() - (int)rect.getHeight() * split.length) / 2) + rect.getHeight());
                    for (String w : split) {
                        Rectangle2D rect1 = fontMetrics.getStringBounds(w, g2d);
                        int centreX = (imageWidth - (int)rect1.getWidth()) / 2;
                        g2d.drawString(w, centreX, centreY);
                        centreY = (int)((double)centreY + rect1.getHeight());
                    }
                } else {
                    int centerX = (imageWidth - (int)rect.getWidth()) / 2;
                    int centerY = imageHeight / 2;
                    g2d.drawString(this.text, centerX, centerY);
                }
                g2d.dispose();
            }
        }
        return sourceImage;
    }

    private BufferedImage applyImage(BufferedImage sourceImage) {
        Graphics2D g2d = (Graphics2D)sourceImage.getGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_DEFAULT);
        g2d.setComposite(this.alphaComposite);
        AffineTransform aff = Watermark.getAffineTransform(new Rectangle(0, 0, this.watermarkImage.getWidth(), this.watermarkImage.getHeight()), new Rectangle(0, 0, sourceImage.getWidth(), sourceImage.getHeight()), this.pos);
        g2d.drawImage(this.watermarkImage, aff, null);
        g2d.dispose();
        return sourceImage;
    }

    private BufferedImage applyShape(BufferedImage sourceImage) {
        Graphics2D g2d = (Graphics2D)sourceImage.getGraphics();
        g2d.setComposite(this.alphaComposite);
        g2d.setColor(this.color);
        AffineTransform aff = Watermark.getAffineTransform(this.shape.getBounds(), new Rectangle(0, 0, sourceImage.getWidth(), sourceImage.getHeight()), this.pos);
        g2d.transform(aff);
        switch (this.properties.ordinal()) {
            case 0: {
                g2d.draw(this.shape);
                break;
            }
            case 1: {
                g2d.fill(this.shape);
            }
        }
        g2d.dispose();
        return sourceImage;
    }

    private static Font scaleFontToFit(String[] text, int height, int width, Graphics2D g2d) {
        int fontHeight;
        Font flagFont = null;
        for (String w : text) {
            Font font = Watermark.scaleFontToFit(w, width, g2d, g2d.getFont());
            if (flagFont != null && flagFont.getSize() <= font.getSize()) continue;
            flagFont = font;
        }
        if (flagFont != null && (fontHeight = (int)flagFont.getStringBounds(text[0], g2d.getFontRenderContext()).getHeight()) * text.length > height) {
            float fontSize = flagFont.getSize();
            float fHeight = g2d.getFontMetrics(flagFont).getHeight() * text.length;
            fontSize = (float)height / fHeight * fontSize;
            flagFont = flagFont.deriveFont(fontSize);
            fHeight = g2d.getFontMetrics(flagFont).getHeight() * text.length;
            while (fHeight >= (float)height) {
                flagFont = flagFont.deriveFont(fontSize -= 1.0f);
                fHeight = g2d.getFontMetrics(flagFont).getHeight() * text.length;
            }
        }
        return flagFont;
    }

    private static Font scaleFontToFit(String text, int width, Graphics2D g2d, Font pFont) {
        float fontSize = pFont.getSize();
        float fWidth = g2d.getFontMetrics(pFont).stringWidth(text);
        fontSize = (float)width / fWidth * fontSize;
        pFont = pFont.deriveFont(fontSize);
        fWidth = g2d.getFontMetrics(pFont).stringWidth(text);
        while (fWidth >= (float)width) {
            pFont = pFont.deriveFont(fontSize -= 1.0f);
            fWidth = g2d.getFontMetrics(pFont).stringWidth(text);
        }
        return pFont;
    }

    private static AffineTransform scaleToFit(Rectangle itemToDraw, Rectangle originalItem) {
        double scaleWidth = originalItem.getWidth() / itemToDraw.getWidth();
        double scaleHeight = originalItem.getHeight() / itemToDraw.getHeight();
        AffineTransform aff = AffineTransform.getScaleInstance(scaleWidth, scaleHeight);
        aff.translate(-itemToDraw.x, -itemToDraw.y);
        return aff;
    }

    private static AffineTransform getAffineTransform(Rectangle itemToDraw, Rectangle originalItem, WatermarkPosition pos) {
        AffineTransform aff = null;
        switch (pos.ordinal()) {
            case 2: {
                aff = AffineTransform.getTranslateInstance(itemToDraw.x, itemToDraw.y);
                break;
            }
            case 1: {
                aff = Watermark.scaleToFit(itemToDraw, originalItem);
                break;
            }
            case 0: {
                double topLeftX = (originalItem.width - itemToDraw.width) / 2 - itemToDraw.x;
                double topLeftY = (originalItem.height - itemToDraw.height) / 2 - itemToDraw.y;
                aff = AffineTransform.getTranslateInstance(topLeftX, topLeftY);
            }
        }
        return aff;
    }

    public static enum WatermarkPosition {
        Center,
        FitToImage,
        USE_SHAPE_COORDINATES;

    }

    public static enum WatermarkType {
        IMAGE,
        SHAPE,
        TEXT;

    }

    public static enum WatermarkShapeProperties {
        DRAW,
        FILL;

    }
}

