/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.process;

import com.idrsolutions.image.process.ImageOperation;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;

final class Scale
implements ImageOperation {
    private final double scaling;
    private int interpolation = 2;

    Scale(double scaling) {
        this.scaling = scaling;
    }

    Scale(double scaling, int interpolation) {
        this.scaling = scaling;
        if (interpolation != 1 && interpolation != 2 && interpolation != 3) {
            throw new RuntimeException("Value must be AffineTransformOp.TYPE_NEAREST_NEIGHBOR, AffineTransformOp.TYPE_BILINEAR or AffineTransformOp.TYPE_BICUBIC");
        }
        this.interpolation = interpolation;
    }

    @Override
    public BufferedImage apply(BufferedImage image) {
        int w = (int)((double)image.getWidth() * this.scaling);
        int h = (int)((double)image.getHeight() * this.scaling);
        WritableRaster writableRaster = image.getRaster().createCompatibleWritableRaster(w, h);
        BufferedImage after = new BufferedImage(image.getColorModel(), writableRaster, image.isAlphaPremultiplied(), null);
        AffineTransform at = new AffineTransform();
        at.scale(this.scaling, this.scaling);
        AffineTransformOp scaleOp = new AffineTransformOp(at, this.interpolation);
        return scaleOp.filter(image, after);
    }
}

