/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.process;

import com.idrsolutions.image.process.ImageOperation;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;

final class Rotate
implements ImageOperation {
    private final double angleAsDegrees;

    Rotate(double degrees) {
        this.angleAsDegrees = degrees % 360.0;
    }

    @Override
    public BufferedImage apply(BufferedImage image) {
        int iw = image.getWidth();
        int ih = image.getHeight();
        double rads = Math.toRadians(this.angleAsDegrees);
        double sin = Math.abs(Math.sin(rads));
        double cos = Math.abs(Math.cos(rads));
        int w = (int)Math.floor((double)iw * cos + (double)ih * sin);
        int h = (int)Math.floor((double)ih * cos + (double)iw * sin);
        WritableRaster writableRaster = image.getRaster().createCompatibleWritableRaster(w, h);
        BufferedImage after = new BufferedImage(image.getColorModel(), writableRaster, image.isAlphaPremultiplied(), null);
        AffineTransform at = new AffineTransform();
        at.translate((double)w / 2.0 - (double)iw / 2.0, (double)h / 2.0 - (double)ih / 2.0);
        at.rotate(rads, (double)iw / 2.0, (double)ih / 2.0);
        AffineTransformOp rotateOp = new AffineTransformOp(at, 2);
        return rotateOp.filter(image, after);
    }
}

