/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.process;

import com.idrsolutions.image.process.ImageOperation;
import com.idrsolutions.image.scale.QualityScaler;
import java.awt.image.BufferedImage;

final class ResizeToFit
implements ImageOperation {
    private final int newWidth;
    private final int newHeight;

    ResizeToFit(int newWidth, int newHeight) {
        this.newWidth = newWidth;
        this.newHeight = newHeight;
    }

    @Override
    public BufferedImage apply(BufferedImage image) {
        double scalingW;
        double scalingH = (double)this.newHeight / (double)image.getHeight();
        if (scalingH < (scalingW = (double)this.newWidth / (double)image.getWidth())) {
            int w = (int)((double)image.getWidth() * scalingH);
            return QualityScaler.getScaledImage(image, w, this.newHeight);
        }
        int h = (int)((double)image.getHeight() * scalingW);
        return QualityScaler.getScaledImage(image, this.newWidth, h);
    }
}

