/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.process;

import com.idrsolutions.image.process.Blur;
import com.idrsolutions.image.process.Brighten;
import com.idrsolutions.image.process.Clip;
import com.idrsolutions.image.process.Crop;
import com.idrsolutions.image.process.EdgeDetection;
import com.idrsolutions.image.process.Emboss;
import com.idrsolutions.image.process.Exposure;
import com.idrsolutions.image.process.GaussianBlur;
import com.idrsolutions.image.process.ImageOperation;
import com.idrsolutions.image.process.ImageProcessingOps;
import com.idrsolutions.image.process.InvertColors;
import com.idrsolutions.image.process.Kernel;
import com.idrsolutions.image.process.Mirror;
import com.idrsolutions.image.process.MirrorOperations;
import com.idrsolutions.image.process.QualityScale;
import com.idrsolutions.image.process.ResizeToFit;
import com.idrsolutions.image.process.ResizeToHeight;
import com.idrsolutions.image.process.ResizeToWidth;
import com.idrsolutions.image.process.Rotate;
import com.idrsolutions.image.process.Scale;
import com.idrsolutions.image.process.Sharpen;
import com.idrsolutions.image.process.StretchToFill;
import com.idrsolutions.image.process.SuperScale2x;
import com.idrsolutions.image.process.Thumbnail;
import com.idrsolutions.image.process.ToARGB;
import com.idrsolutions.image.process.ToBinary;
import com.idrsolutions.image.process.ToGrayscale;
import com.idrsolutions.image.process.ToIndexed;
import com.idrsolutions.image.process.ToRGB;
import com.idrsolutions.image.process.Watermark;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;

public class ImageProcessingOperations
implements ImageProcessingOps {
    private final List<ImageOperation> operations = new ArrayList<ImageOperation>();
    private final Deque<ImageOperation> lastOps = new ArrayDeque<ImageOperation>();

    @Override
    public BufferedImage apply(BufferedImage image) {
        for (ImageOperation conversion : this.operations) {
            image = conversion.apply(image);
        }
        return image;
    }

    public ImageProcessingOperations blur() {
        this.operations.add(new Blur());
        return this;
    }

    public ImageProcessingOperations custom(ImageOperation custom) {
        this.operations.add(custom);
        return this;
    }

    public ImageProcessingOperations clip(Shape s, boolean clipToShape) {
        this.operations.add(new Clip(s, clipToShape));
        return this;
    }

    public ImageProcessingOperations crop(Rectangle rec) {
        this.operations.add(new Crop(rec));
        return this;
    }

    public ImageProcessingOperations edgeDetection() {
        this.operations.add(new EdgeDetection());
        return this;
    }

    public ImageProcessingOperations emboss() {
        this.operations.add(new Emboss());
        return this;
    }

    public ImageProcessingOperations exposure(float exposure) {
        this.operations.add(new Exposure(exposure));
        return this;
    }

    public ImageProcessingOperations gaussianBlur() {
        this.operations.add(new GaussianBlur());
        return this;
    }

    public ImageProcessingOperations invertColors() {
        this.operations.add(new InvertColors());
        return this;
    }

    public ImageProcessingOperations kernel(float[] kernel) {
        this.operations.add(new Kernel(kernel));
        return this;
    }

    public ImageProcessingOperations brighten(float percent) {
        this.operations.add(new Brighten(percent));
        return this;
    }

    public ImageProcessingOperations mirror(MirrorOperations mirrorOp) {
        this.operations.add(new Mirror(mirrorOp));
        return this;
    }

    public ImageProcessingOperations mirror() {
        this.operations.add(new Mirror(MirrorOperations.HORIZONTAL));
        return this;
    }

    public ImageProcessingOperations resizeToFit(int newWidth, int newHeight) {
        this.operations.add(new ResizeToFit(newWidth, newHeight));
        return this;
    }

    public ImageProcessingOperations resizeToHeight(int newHeight) {
        this.operations.add(new ResizeToHeight(newHeight));
        return this;
    }

    public ImageProcessingOperations resizeToWidth(int newWidth) {
        this.operations.add(new ResizeToWidth(newWidth));
        return this;
    }

    public ImageProcessingOperations rotate(double degrees) {
        this.operations.add(new Rotate(degrees));
        return this;
    }

    public ImageProcessingOperations scale(double scaling) {
        this.operations.add(new Scale(scaling));
        return this;
    }

    public ImageProcessingOperations scale(double scaling, int interpolation) {
        this.operations.add(new Scale(scaling, interpolation));
        return this;
    }

    public ImageProcessingOperations sharpen() {
        this.operations.add(new Sharpen());
        return this;
    }

    public ImageProcessingOperations stretchToFill(int newWidth, int newHeight) {
        this.operations.add(new StretchToFill(newWidth, newHeight));
        return this;
    }

    public ImageProcessingOperations superScale2x() {
        this.operations.add(new SuperScale2x());
        return this;
    }

    public ImageProcessingOperations toARGB() {
        this.operations.add(new ToARGB());
        return this;
    }

    public ImageProcessingOperations toBinary() {
        this.operations.add(new ToBinary());
        return this;
    }

    public ImageProcessingOperations toGrayscale() {
        this.operations.add(new ToGrayscale());
        return this;
    }

    public ImageProcessingOperations toIndexed() {
        this.operations.add(new ToIndexed());
        return this;
    }

    public ImageProcessingOperations toRGB() {
        this.operations.add(new ToRGB());
        return this;
    }

    public ImageProcessingOperations qualityScale(double scaling) {
        this.operations.add(new QualityScale(scaling));
        return this;
    }

    public ImageProcessingOperations thumbnail(int width, int height) {
        this.operations.add(new Thumbnail(width, height));
        return this;
    }

    public ImageProcessingOperations watermark(String text, Color color, Font font, Watermark.WatermarkPosition pos) {
        this.operations.add(new Watermark(text, color, font, pos));
        return this;
    }

    public ImageProcessingOperations watermark(BufferedImage watermarkImage, Watermark.WatermarkPosition pos, AlphaComposite alphaComposite) {
        this.operations.add(new Watermark(watermarkImage, pos, alphaComposite));
        return this;
    }

    public ImageProcessingOperations watermark(Shape shape2, Color color, Watermark.WatermarkPosition pos, AlphaComposite alphaComposite, Watermark.WatermarkShapeProperties properties) {
        this.operations.add(new Watermark(shape2, color, pos, alphaComposite, properties));
        return this;
    }

    public ImageProcessingOperations undo() {
        if (!this.operations.isEmpty()) {
            this.lastOps.add(this.operations.get(this.operations.size() - 1));
            this.operations.remove(this.operations.size() - 1);
            if (this.lastOps.size() > 5) {
                this.lastOps.removeFirst();
            }
        }
        return this;
    }

    public ImageProcessingOperations redo() {
        if (!this.lastOps.isEmpty()) {
            this.operations.add(this.lastOps.getLast());
            this.lastOps.removeLast();
        }
        return this;
    }

    public int operationsListSize() {
        return this.operations.size();
    }
}

