/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.process;

import com.idrsolutions.image.process.ImageOperation;
import java.awt.image.BufferedImage;

final class Exposure
implements ImageOperation {
    private final float exposure;

    public Exposure(float exposure) {
        this.exposure = exposure;
    }

    @Override
    public BufferedImage apply(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int p = image.getRGB(x, y);
                p = (p >> 24 & 0xFF) << 24 | this.applyExposure(p >> 16 & 0xFF) << 16 | this.applyExposure(p >> 8 & 0xFF) << 8 | this.applyExposure(p >> 8 & 0xFF);
                image.setRGB(x, y, p);
            }
        }
        return image;
    }

    private int applyExposure(int i) {
        return (int)(255.0f * (1.0f - (float)Math.exp(-((float)i / 255.0f) * this.exposure)));
    }
}

