/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.process;

import com.idrsolutions.image.process.ImageOperation;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;

final class Clip
implements ImageOperation {
    private Shape s;
    private final boolean clipToS;

    Clip(Shape shape2, boolean clipToShape) {
        this.s = shape2;
        this.clipToS = clipToShape;
    }

    @Override
    public BufferedImage apply(BufferedImage image) {
        Graphics2D g2d = (Graphics2D)image.getGraphics();
        g2d.clip(this.s);
        if (this.clipToS) {
            image = this.clipToShape(image);
            return image;
        }
        int imageType = image.getType() == 0 ? 1 : image.getType();
        BufferedImage im = new BufferedImage(image.getWidth(), image.getHeight(), imageType);
        Graphics2D g2 = im.createGraphics();
        g2.drawImage((Image)image, 0, 0, null);
        g2.setComposite(AlphaComposite.Src);
        g2.setColor(new Color(0, 0, 0, 0));
        g2.fill(this.s);
        g2.setBackground(new Color(0, 0, 0, 0));
        return im;
    }

    private BufferedImage clipToShape(BufferedImage im) {
        int x = -this.s.getBounds().x;
        int y = -this.s.getBounds().y;
        int imageType = im.getType() == 0 ? 1 : im.getType();
        BufferedImage image = new BufferedImage(this.s.getBounds().width, this.s.getBounds().height, imageType);
        Graphics2D g2 = image.createGraphics();
        AffineTransform af = new AffineTransform();
        af.translate(x, y);
        this.s = af.createTransformedShape(this.s);
        g2.setClip(this.s);
        g2.drawImage((Image)im, x, y, null);
        return image;
    }
}

