/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.metadata.ifd;

import java.util.HashMap;

public enum IFDKeys {
    GPSVersionID(0),
    GPSLatitudeRef(1),
    GPSLatitude(2),
    GPSLongitudeRef(3),
    GPSLongitude(4),
    GPSAltitudeRef(5),
    GPSAltitude(6),
    GPSTimeStamp(7),
    GPSSatellites(8),
    GPSStatus(9),
    GPSMeasureMode(10),
    GPSDOP(11),
    GPSSpeedRef(12),
    GPSSpeed(13),
    GPSTrackRef(14),
    GPSTrack(15),
    GPSImgDirectionRef(16),
    GPSImgDirection(17),
    GPSMapDatum(18),
    GPSDestLatitudeRef(19),
    GPSDestLatitude(20),
    GPSDestLongitudeRef(21),
    GPSDestLongitude(22),
    GPSDestBearingRef(23),
    GPSDestBearing(24),
    GPSDestDistanceRef(25),
    GPSDestDistance(26),
    GPSProcessingMethod(27),
    GPSAreaInformation(28),
    GPSDateStamp(29),
    GPSDifferential(30),
    ImageWidth(256),
    ImageHeight(257),
    BitsPerSample(258),
    Compression(259),
    PhotometricInterpolation(262),
    FillOrder(266),
    Make(271),
    Model(272),
    StripOffsets(273),
    Orientation(274),
    SamplesPerPixel(277),
    RowsPerStrip(278),
    StripByteCounts(279),
    Xresolution(282),
    Yresolution(283),
    PlanarConfiguration(284),
    T4Options(292),
    T6Options(293),
    ResolutionUnit(296),
    DATETIME(306),
    Predictor(317),
    ColorMap(320),
    TileWidth(322),
    TileLength(323),
    TIleOffsets(324),
    TIleByteCounts(325),
    SampleFormat(339),
    JPEGTables(347),
    JPEGProc(512),
    JPEGInterchangeFormat(513),
    JPEGInterchangeFormatLength(514),
    JPEGRestartInterval(515),
    JPEGQTables(519),
    JPEGDCTables(520),
    JPEGACTables(521),
    XMP(700),
    ICC(34675),
    GPS(34853),
    JDELI_UNSUPPORTED(-1);

    public final int value;
    private static final HashMap<Integer, IFDKeys> lookup;

    private IFDKeys(int val) {
        this.value = val;
    }

    public static IFDKeys getIFDKey(int val) {
        IFDKeys key = lookup.get(val);
        if (key == null) {
            return JDELI_UNSUPPORTED;
        }
        return key;
    }

    static {
        lookup = new HashMap();
        for (IFDKeys value : IFDKeys.values()) {
            lookup.put(value.value, value);
        }
    }
}

