/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpegxl.data;

import com.idrsolutions.image.jpegxl.data.BitXL;
import java.io.IOException;

class VLC {
    private final int[][] table;
    private final int bits;

    VLC(int bits, int[][] table) {
        this.bits = bits;
        this.table = table;
    }

    VLC(int bits, int[] lengths, int[] symbols) {
        int i;
        this.bits = bits;
        this.table = new int[1 << bits][2];
        int[] codes = new int[lengths.length];
        int[] nLengths = new int[lengths.length];
        int[] nSymbols = new int[lengths.length];
        int count = 0;
        long code = 0L;
        for (i = 0; i < lengths.length; ++i) {
            int len = lengths[i];
            if (len > 0) {
                nLengths[count] = len;
                nSymbols[count] = symbols != null ? symbols[i] : i;
                codes[count] = (int)code;
                ++count;
            } else {
                if (len >= 0) continue;
                len = -len;
            }
            code += 1L << 32 - len;
        }
        for (i = 0; i < count; ++i) {
            if (nLengths[i] > bits) continue;
            int index = Integer.reverse(codes[i]);
            int number = 1 << bits - nLengths[i];
            int offset = 1 << nLengths[i];
            for (int j = 0; j < number; ++j) {
                this.table[index][0] = nSymbols[i];
                this.table[index][1] = nLengths[i];
                index += offset;
            }
        }
        for (int[] table1 : this.table) {
            if (table1[1] != 0) continue;
            table1[0] = -1;
        }
    }

    int getVLC(BitXL reader) throws IOException {
        int index = reader.showBits(this.bits);
        int symbol = this.table[index][0];
        int length = this.table[index][1];
        reader.skipBits(length);
        return symbol;
    }
}

