/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpegxl.data;

import com.idrsolutions.image.jpegxl.data.ITX;
import com.idrsolutions.image.jpegxl.data.IntXL;
import com.idrsolutions.image.jpegxl.data.LFGroup;

class VBlock {
    final IntXL blockPosInLFGroup;
    final IntXL groupPosInLFGroup;
    final IntXL blockPosInGroup;
    final IntXL pixelPosInGroup;
    final IntXL pixelPosInLFGroup;
    final int groupID;
    final LFGroup lfGroup;

    VBlock(LFGroup lfGroup, IntXL blockPosInLFGroup) {
        this.lfGroup = lfGroup;
        this.blockPosInLFGroup = blockPosInLFGroup;
        this.pixelPosInLFGroup = new IntXL(blockPosInLFGroup.x << 3, blockPosInLFGroup.y << 3);
        this.groupPosInLFGroup = blockPosInLFGroup.toRight(5);
        int x = blockPosInLFGroup.x - (this.groupPosInLFGroup.x << 5);
        int y = blockPosInLFGroup.y - (this.groupPosInLFGroup.y << 5);
        this.blockPosInGroup = new IntXL(x, y);
        this.pixelPosInGroup = new IntXL(x << 3, y << 3);
        IntXL lfgXY = lfGroup.frame.getLFGroupXY(lfGroup.lfGroupID);
        x = (lfgXY.x << 3) + this.groupPosInLFGroup.x;
        y = (lfgXY.y << 3) + this.groupPosInLFGroup.y;
        this.groupID = y * lfGroup.frame.getGroupRowStride() + x;
    }

    ITX transformType() {
        return this.lfGroup.hfMetadata.dctSelect[this.blockPosInLFGroup.y][this.blockPosInLFGroup.x];
    }

    int hfMult() {
        return this.lfGroup.hfMetadata.hfMultiplier[this.blockPosInLFGroup.y][this.blockPosInLFGroup.x];
    }

    IntXL sizeInBlocks() {
        ITX tt = this.transformType();
        return new IntXL(tt.dctW, tt.dctH);
    }

    IntXL sizeInPixels() {
        return this.transformType().getPixelSize();
    }

    boolean isCorner(IntXL shift) {
        int x = this.blockPosInLFGroup.x >> shift.x;
        int y = this.blockPosInLFGroup.y >> shift.y;
        return x << shift.x == this.blockPosInLFGroup.x && y << shift.y == this.blockPosInLFGroup.y;
    }
}

