/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpegxl.data;

import com.idrsolutions.image.jpegxl.data.BitXL;
import com.idrsolutions.image.jpegxl.data.Entropy;
import com.idrsolutions.image.jpegxl.data.IntXL;
import com.idrsolutions.image.jpegxl.data.MathXL;
import java.io.IOException;

class SplinesGroup {
    final int numSplines;
    final int quantAdjust;
    final IntXL[] splinePos;
    final int[] controlCount;
    final IntXL[][] points;
    final int[][] coeffX;
    final int[][] coeffY;
    final int[][] coeffB;
    final int[][] coeffSigma;

    SplinesGroup(BitXL reader) throws IOException {
        int i;
        Entropy entropy = new Entropy(reader, 6);
        this.numSplines = 1 + entropy.readSymbol(reader, 2);
        this.splinePos = new IntXL[this.numSplines];
        for (i = 0; i < this.numSplines; ++i) {
            int x = entropy.readSymbol(reader, 1);
            int y = entropy.readSymbol(reader, 1);
            if (i != 0) {
                x = MathXL.unpackSigned(x) + this.splinePos[i - 1].x;
                y = MathXL.unpackSigned(y) + this.splinePos[i - 1].y;
            }
            this.splinePos[i] = new IntXL(x, y);
        }
        this.quantAdjust = MathXL.unpackSigned(entropy.readSymbol(reader, 0));
        this.controlCount = new int[this.numSplines];
        this.points = new IntXL[this.numSplines][];
        this.coeffX = new int[this.numSplines][32];
        this.coeffY = new int[this.numSplines][32];
        this.coeffB = new int[this.numSplines][32];
        this.coeffSigma = new int[this.numSplines][32];
        for (i = 0; i < this.numSplines; ++i) {
            int j;
            this.controlCount[i] = 1 + entropy.readSymbol(reader, 3);
            this.points[i] = new IntXL[this.controlCount[i]];
            this.points[i][0] = new IntXL(this.splinePos[i]);
            IntXL[] delta = new IntXL[this.controlCount[i] - 1];
            for (int j2 = 0; j2 < delta.length; ++j2) {
                int x = MathXL.unpackSigned(entropy.readSymbol(reader, 4));
                int y = MathXL.unpackSigned(entropy.readSymbol(reader, 4));
                delta[j2] = new IntXL(x, y);
            }
            IntXL current = new IntXL(this.points[i][0]);
            IntXL deltaPoint = new IntXL();
            for (j = 1; j < this.controlCount[i]; ++j) {
                deltaPoint = deltaPoint.plus(delta[j - 1]);
                current = current.plus(deltaPoint);
                this.points[i][j] = new IntXL(current);
            }
            for (j = 0; j < 32; ++j) {
                this.coeffX[i][j] = MathXL.unpackSigned(entropy.readSymbol(reader, 5));
            }
            for (j = 0; j < 32; ++j) {
                this.coeffY[i][j] = MathXL.unpackSigned(entropy.readSymbol(reader, 5));
            }
            for (j = 0; j < 32; ++j) {
                this.coeffB[i][j] = MathXL.unpackSigned(entropy.readSymbol(reader, 5));
            }
            for (j = 0; j < 32; ++j) {
                this.coeffSigma[i][j] = MathXL.unpackSigned(entropy.readSymbol(reader, 5));
            }
        }
    }
}

