/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpegxl.data;

import com.idrsolutions.image.jpegxl.data.BitXL;
import com.idrsolutions.image.jpegxl.data.BlendInfo;
import com.idrsolutions.image.jpegxl.data.Entropy;
import com.idrsolutions.image.jpegxl.data.IntXL;
import com.idrsolutions.image.jpegxl.data.MathXL;
import java.io.IOException;

class Patch {
    final int width;
    final int height;
    final int ref;
    final IntXL origin;
    final IntXL[] positions;
    final BlendInfo[][] blendingInfos;

    Patch(Entropy entropy, BitXL reader, int extraChannelCount, int alphaChannelCount) throws IOException {
        this.ref = entropy.readSymbol(reader, 1);
        int x0 = entropy.readSymbol(reader, 3);
        int y0 = entropy.readSymbol(reader, 3);
        this.origin = new IntXL(x0, y0);
        this.width = 1 + entropy.readSymbol(reader, 2);
        this.height = 1 + entropy.readSymbol(reader, 2);
        int count = 1 + entropy.readSymbol(reader, 7);
        this.positions = new IntXL[count];
        this.blendingInfos = new BlendInfo[count][];
        for (int j = 0; j < count; ++j) {
            IntXL xy;
            if (j == 0) {
                x = entropy.readSymbol(reader, 4);
                y = entropy.readSymbol(reader, 4);
                xy = new IntXL(x, y);
            } else {
                x = entropy.readSymbol(reader, 6);
                y = entropy.readSymbol(reader, 6);
                x = MathXL.unpackSigned(x) + this.positions[j - 1].x;
                y = MathXL.unpackSigned(y) + this.positions[j - 1].y;
                xy = new IntXL(x, y);
            }
            this.positions[j] = xy;
            this.blendingInfos[j] = new BlendInfo[extraChannelCount + 1];
            for (int k = 0; k < extraChannelCount + 1; ++k) {
                int mode = entropy.readSymbol(reader, 5);
                int alpha = 0;
                boolean clamp = false;
                if (mode > 3 && alphaChannelCount > 1) {
                    alpha = entropy.readSymbol(reader, 8);
                }
                if (mode > 2) {
                    clamp = entropy.readSymbol(reader, 9) != 0;
                }
                this.blendingInfos[j][k] = new BlendInfo(mode, alpha, clamp, 0);
            }
        }
    }
}

