/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpegxl.data;

import com.idrsolutions.image.jpegxl.data.BitXL;
import com.idrsolutions.image.jpegxl.data.Frame;
import com.idrsolutions.image.jpegxl.data.HFCoefficients;
import com.idrsolutions.image.jpegxl.data.ITX;
import com.idrsolutions.image.jpegxl.data.IntXL;
import com.idrsolutions.image.jpegxl.data.MathXL;
import com.idrsolutions.image.jpegxl.data.ModularInfo;
import com.idrsolutions.image.jpegxl.data.ModularStream;
import com.idrsolutions.image.jpegxl.data.VBlock;
import java.io.IOException;

class PassGroup {
    private static final float[][] AFV_BASIS = new float[][]{{0.25f, 0.25f, 0.25f, 0.25f, 0.25f, 0.25f, 0.25f, 0.25f, 0.25f, 0.25f, 0.25f, 0.25f, 0.25f, 0.25f, 0.25f, 0.25f}, {0.87690294f, 0.2206518f, -0.1014005f, -0.1014005f, 0.2206518f, -0.1014005f, -0.1014005f, -0.1014005f, -0.1014005f, -0.1014005f, -0.1014005f, -0.1014005f, -0.1014005f, -0.1014005f, -0.1014005f, -0.1014005f}, {0.0f, 0.0f, 0.40670076f, 0.44444817f, 0.0f, 0.0f, 0.195744f, 0.29291f, -0.40670076f, -0.195744f, 0.0f, 0.11379074f, -0.44444817f, -0.29291f, -0.11379074f, 0.0f}, {0.0f, 0.0f, -0.21255748f, 0.3085497f, 0.0f, 0.47067022f, -0.16212052f, 0.0f, -0.21255748f, -0.16212052f, -0.47067022f, -0.14642918f, 0.3085497f, 0.0f, -0.14642918f, 0.42511496f}, {0.0f, -0.70710677f, 0.0f, 0.0f, 0.70710677f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {-0.41053775f, 0.6235485f, -0.06435072f, -0.06435072f, 0.6235485f, -0.06435072f, -0.06435072f, -0.06435072f, -0.06435072f, -0.06435072f, -0.06435072f, -0.06435072f, -0.06435072f, -0.06435072f, -0.06435072f, -0.06435072f}, {0.0f, 0.0f, -0.45175567f, 0.15854503f, 0.0f, -0.040385153f, 0.0074182265f, 0.39351034f, -0.45175567f, 0.0074182265f, 0.11074166f, 0.08298163f, 0.15854503f, 0.39351034f, 0.08298163f, -0.45175567f}, {0.0f, 0.0f, -0.30468476f, 0.51126164f, 0.0f, 0.0f, -0.29048014f, -0.06578702f, 0.30468476f, 0.29048014f, 0.0f, -0.23889774f, -0.51126164f, 0.06578702f, 0.23889774f, 0.0f}, {0.0f, 0.0f, 0.30179295f, 0.25792363f, 0.0f, 0.1627234f, 0.095200226f, 0.0f, 0.30179295f, 0.095200226f, -0.1627234f, -0.35312384f, 0.25792363f, 0.0f, -0.35312384f, -0.6035859f}, {0.0f, 0.0f, 0.4082483f, 0.0f, 0.0f, 0.0f, 0.0f, -0.4082483f, -0.4082483f, 0.0f, 0.0f, -0.4082483f, 0.0f, 0.4082483f, 0.4082483f, 0.0f}, {0.0f, 0.0f, 0.1747867f, 0.08126112f, 0.0f, 0.0f, -0.3675398f, -0.30788222f, -0.1747867f, 0.3675398f, 0.0f, 0.4826689f, -0.08126112f, 0.30788222f, -0.4826689f, 0.0f}, {0.0f, 0.0f, -0.21105601f, 0.1856718f, 0.0f, 0.0f, 0.4921586f, -0.38525015f, 0.21105601f, -0.4921586f, 0.0f, 0.17419413f, -0.1856718f, 0.38525015f, -0.17419413f, 0.0f}, {0.0f, 0.0f, -0.14266084f, -0.34164467f, 0.0f, 0.73674977f, 0.24627107f, -0.08574019f, -0.14266084f, 0.24627107f, 0.14883399f, -0.047686804f, -0.34164467f, -0.08574019f, -0.047686804f, -0.14266084f}, {0.0f, 0.0f, -0.1381354f, 0.33022827f, 0.0f, 0.08755115f, -0.079467066f, -0.46133748f, -0.1381354f, -0.079467066f, 0.49724647f, 0.12538059f, 0.33022827f, -0.46133748f, 0.12538059f, -0.1381354f}, {0.0f, 0.0f, -0.17437603f, 0.07027907f, 0.0f, -0.29210266f, 0.36238173f, 0.0f, -0.17437603f, 0.36238173f, 0.29210266f, -0.4326608f, 0.07027907f, 0.0f, -0.4326608f, 0.34875205f}, {0.0f, 0.0f, 0.11354987f, -0.074175045f, 0.0f, 0.19402893f, -0.4351905f, 0.21918684f, 0.11354987f, -0.4351905f, 0.55504435f, -0.25468278f, -0.074175045f, 0.21918684f, -0.25468278f, 0.11354987f}};
    final HFCoefficients hfCoefficients;
    final int[][][] modularPassGroupBuffer;
    final ModularInfo[] modularPassGroupInfo;
    final Frame frame;
    final int groupID;
    final int passID;

    PassGroup(BitXL reader, Frame frame, int pass, int group, ModularInfo[] replacedChannels) throws IOException {
        this.frame = frame;
        this.groupID = group;
        this.passID = pass;
        this.hfCoefficients = frame.getFrameHeader().encoding == 0 ? new HFCoefficients(reader, frame, pass, group) : null;
        ModularStream stream = new ModularStream(reader, frame, 18 + 3 * frame.getNumLFGroups() + frame.getNumGroups() * pass + group, replacedChannels);
        stream.decodeChannels(reader);
        this.modularPassGroupBuffer = stream.getDecodedBuffer();
        this.modularPassGroupInfo = new ModularInfo[this.modularPassGroupBuffer.length];
        for (int c = 0; c < this.modularPassGroupInfo.length; ++c) {
            this.modularPassGroupInfo[c] = new ModularInfo(stream.getChannelInfo(c));
        }
    }

    private static void layBlock(float[][] block, float[][] buffer, IntXL outPos, IntXL inSize) {
        for (int y = 0; y < inSize.y; ++y) {
            System.arraycopy(block[y + IntXL.ZERO.y], IntXL.ZERO.x, buffer[y + outPos.y], outPos.x, inSize.x);
        }
    }

    private static void invertAFV(float[][] coeffs, float[][] buffer, VBlock vBlock, IntXL pixelPosInFrame, float[][][] scratchBlock, IntXL shift) {
        int ix;
        int iy;
        IntXL p = vBlock.pixelPosInGroup.toRight(shift);
        IntXL ps = pixelPosInFrame.toRight(shift);
        scratchBlock[0][0][0] = (coeffs[p.y][p.x] + coeffs[p.y + 1][p.x] + coeffs[p.y][p.x + 1]) * 4.0f;
        for (int iy2 = 0; iy2 < 4; ++iy2) {
            int ix2;
            int n = ix2 = iy2 == 0 ? 1 : 0;
            while (ix2 < 4) {
                scratchBlock[0][iy2][ix2] = coeffs[p.y + iy2 * 2][p.x + ix2 * 2];
                ++ix2;
            }
        }
        ITX tt = vBlock.transformType();
        int flipX = tt == ITX.AFV1 || tt == ITX.AFV3 ? 1 : 0;
        int flipY = tt == ITX.AFV2 || tt == ITX.AFV3 ? 1 : 0;
        for (iy = 0; iy < 4; ++iy) {
            for (ix = 0; ix < 4; ++ix) {
                float sample = 0.0f;
                for (int j = 0; j < 16; ++j) {
                    int jx = j & 3;
                    int jy = j >> 2;
                    sample += scratchBlock[0][jy][jx] * AFV_BASIS[j][iy * 4 + ix];
                }
                scratchBlock[1][iy][ix] = sample;
            }
        }
        for (iy = 0; iy < 4; ++iy) {
            for (ix = 0; ix < 4; ++ix) {
                buffer[ps.y + flipY * 4 + iy][ps.x + flipX * 4 + ix] = scratchBlock[1][flipY == 1 ? 3 - iy : iy][flipX == 1 ? 3 - ix : ix];
            }
        }
        scratchBlock[0][0][0] = coeffs[p.y][p.x] + coeffs[p.y + 1][p.x] - coeffs[p.y][p.x + 1];
        for (iy = 0; iy < 4; ++iy) {
            int n = ix = iy == 0 ? 1 : 0;
            while (ix < 4) {
                scratchBlock[0][iy][ix] = coeffs[p.y + iy * 2][p.x + ix * 2 + 1];
                ++ix;
            }
        }
        MathXL.inverseDCT2D(scratchBlock[0], scratchBlock[1], IntXL.ZERO, IntXL.ZERO, new IntXL(4), scratchBlock[2], scratchBlock[3], false);
        for (iy = 0; iy < 4; ++iy) {
            for (ix = 0; ix < 4; ++ix) {
                buffer[ps.y + flipY * 4 + iy][ps.x + (flipX == 1 ? 0 : 4) + ix] = scratchBlock[1][ix][iy];
            }
        }
        scratchBlock[0][0][0] = coeffs[p.y][p.x] - coeffs[p.y + 1][p.x];
        for (iy = 0; iy < 4; ++iy) {
            System.arraycopy(coeffs[p.y + 1 + iy * 2], p.x + (iy == 0 ? 1 : 0), scratchBlock[0][iy], iy == 0 ? 1 : 0, 8 - (iy == 0 ? 1 : 0));
        }
        MathXL.inverseDCT2D(scratchBlock[0], scratchBlock[1], IntXL.ZERO, IntXL.ZERO, new IntXL(8, 4), scratchBlock[2], scratchBlock[3], false);
        for (iy = 0; iy < 4; ++iy) {
            System.arraycopy(scratchBlock[1][iy], 0, buffer[ps.y + (flipY == 1 ? 0 : 4) + iy], ps.x, 8);
        }
    }

    private static void auxDCT2(float[][] coeffs, float[][] result, IntXL p, IntXL ps, int s) {
        int num = s / 2;
        for (int iy = 0; iy < 4; ++iy) {
            for (int ix = 0; ix < 4; ++ix) {
                if (iy >= num || ix >= num) {
                    result[ps.y + iy * 2][ps.x + ix * 2] = coeffs[p.y + iy * 2][p.x + ix * 2];
                    result[ps.y + iy * 2 + 1][ps.x + ix * 2] = coeffs[p.y + iy * 2 + 1][p.x + ix * 2];
                    result[ps.y + iy * 2][ps.x + ix * 2 + 1] = coeffs[p.y + iy * 2][p.x + ix * 2 + 1];
                    result[ps.y + iy * 2 + 1][ps.x + ix * 2 + 1] = coeffs[p.y + iy * 2 + 1][p.x + ix * 2 + 1];
                    continue;
                }
                float c00 = coeffs[p.y + iy][p.x + ix];
                float c01 = coeffs[p.y + iy][p.x + ix + num];
                float c10 = coeffs[p.y + iy + num][p.x + ix];
                float c11 = coeffs[p.y + iy + num][p.x + ix + num];
                float r00 = c00 + c01 + c10 + c11;
                float r01 = c00 + c01 - c10 - c11;
                float r10 = c00 - c01 + c10 - c11;
                float r11 = c00 - c01 - c10 + c11;
                result[ps.y + iy * 2][ps.x + ix * 2] = r00;
                result[ps.y + iy * 2][ps.x + ix * 2 + 1] = r01;
                result[ps.y + iy * 2 + 1][ps.x + ix * 2] = r10;
                result[ps.y + iy * 2 + 1][ps.x + ix * 2 + 1] = r11;
            }
        }
    }

    void invertVarDCT(float[][][] frameBuffer, PassGroup prev) {
        IntXL[] shift = this.frame.getFrameHeader().jpegUpsampling;
        if (prev != null) {
            for (VBlock vblock : this.hfCoefficients.varblocks) {
                if (vblock == null) continue;
                IntXL size = vblock.sizeInPixels();
                for (int c = 0; c < 3; ++c) {
                    if (!vblock.isCorner(shift[c])) continue;
                    IntXL ppg = vblock.pixelPosInGroup.toRight(shift[c]);
                    for (int y = ppg.y; y < ppg.y + size.y; ++y) {
                        for (int x = ppg.x; x < ppg.x + size.x; ++x) {
                            int[] nArray = this.hfCoefficients.quantizedCoeffs[c][y];
                            int n = x;
                            nArray[n] = nArray[n] + prev.hfCoefficients.quantizedCoeffs[c][y][x];
                        }
                    }
                }
            }
        }
        this.hfCoefficients.bakeDequantizedCoeffs();
        this.hfCoefficients.finalizeLLF();
        float[][][] coeffs = this.hfCoefficients.dequantHFCoeff;
        float[][][] scratchBlk = new float[4][256][256];
        for (VBlock varblock : this.hfCoefficients.varblocks) {
            if (varblock == null) continue;
            block14: for (int c = 0; c < 3; ++c) {
                if (!varblock.isCorner(shift[c])) continue;
                ITX tt = varblock.transformType();
                IntXL ppg = varblock.pixelPosInGroup.toRight(shift[c]);
                IntXL pixelPosInFrame = varblock.pixelPosInGroup.plus(this.frame.groupXY(this.groupID).toLeft(8)).toRight(shift[c]);
                float[] lfs = new float[2];
                IntXL size = varblock.sizeInPixels();
                switch (tt.method) {
                    case 0: {
                        MathXL.inverseDCT2D(coeffs[c], frameBuffer[c], ppg, pixelPosInFrame, size, scratchBlk[0], scratchBlk[1], false);
                        continue block14;
                    }
                    case 4: {
                        int iy;
                        float coeff0 = coeffs[c][ppg.y][ppg.x];
                        float coeff1 = coeffs[c][ppg.y + 1][ppg.x];
                        lfs[0] = coeff0 + coeff1;
                        lfs[1] = coeff0 - coeff1;
                        for (int x = 0; x < 2; ++x) {
                            scratchBlk[0][0][0] = lfs[x];
                            for (iy = 0; iy < 4; ++iy) {
                                System.arraycopy(coeffs[c][ppg.y + x + iy * 2], ppg.x + (iy == 0 ? 1 : 0), scratchBlk[0][iy], iy == 0 ? 1 : 0, 8 - (iy == 0 ? 1 : 0));
                            }
                            MathXL.inverseDCT2D(scratchBlk[0], frameBuffer[c], IntXL.ZERO, new IntXL(4 * x, 0).plus(pixelPosInFrame), new IntXL(8, 4), scratchBlk[1], scratchBlk[2], true);
                        }
                        continue block14;
                    }
                    case 5: {
                        int y;
                        int iy;
                        float coeff0 = coeffs[c][ppg.y][ppg.x];
                        float coeff1 = coeffs[c][ppg.y + 1][ppg.x];
                        lfs[0] = coeff0 + coeff1;
                        lfs[1] = coeff0 - coeff1;
                        for (y = 0; y < 2; ++y) {
                            scratchBlk[0][0][0] = lfs[y];
                            for (iy = 0; iy < 4; ++iy) {
                                System.arraycopy(coeffs[c][ppg.y + y + iy * 2], ppg.x + (iy == 0 ? 1 : 0), scratchBlk[0][iy], iy == 0 ? 1 : 0, 8 - (iy == 0 ? 1 : 0));
                            }
                            MathXL.inverseDCT2D(scratchBlk[0], frameBuffer[c], IntXL.ZERO, new IntXL(0, 4 * y).plus(pixelPosInFrame), new IntXL(8, 4), scratchBlk[1], scratchBlk[2], false);
                        }
                        continue block14;
                    }
                    case 6: {
                        PassGroup.invertAFV(coeffs[c], frameBuffer[c], varblock, pixelPosInFrame, scratchBlk, shift[c]);
                        continue block14;
                    }
                    case 1: {
                        PassGroup.auxDCT2(coeffs[c], scratchBlk[0], ppg, IntXL.ZERO, 2);
                        PassGroup.auxDCT2(scratchBlk[0], scratchBlk[1], IntXL.ZERO, IntXL.ZERO, 4);
                        PassGroup.auxDCT2(scratchBlk[1], frameBuffer[c], IntXL.ZERO, pixelPosInFrame, 8);
                        continue block14;
                    }
                    case 3: {
                        int x;
                        int y;
                        PassGroup.auxDCT2(coeffs[c], scratchBlk[1], ppg, IntXL.ZERO, 2);
                        for (y = 0; y < 2; ++y) {
                            for (x = 0; x < 2; ++x) {
                                int ix;
                                int iy;
                                float blockLF = scratchBlk[1][y][x];
                                float residual = 0.0f;
                                for (iy = 0; iy < 4; ++iy) {
                                    int n = ix = iy == 0 ? 1 : 0;
                                    while (ix < 4) {
                                        residual += coeffs[c][ppg.y + y + iy * 2][ppg.x + x + ix * 2];
                                        ++ix;
                                    }
                                }
                                scratchBlk[0][4 * y + 1][4 * x + 1] = blockLF - residual / 16.0f;
                                for (iy = 0; iy < 4; ++iy) {
                                    for (ix = 0; ix < 4; ++ix) {
                                        if (ix == 1 && iy == 1) continue;
                                        scratchBlk[0][y * 4 + iy][x * 4 + ix] = coeffs[c][ppg.y + y + iy * 2][ppg.x + x + ix * 2] + scratchBlk[0][4 * y + 1][4 * x + 1];
                                    }
                                }
                                scratchBlk[0][4 * y][4 * x] = coeffs[c][ppg.y + y + 2][ppg.x + x + 2] + scratchBlk[0][4 * y + 1][4 * x + 1];
                            }
                        }
                        PassGroup.layBlock(scratchBlk[0], frameBuffer[c], pixelPosInFrame, size);
                        continue block14;
                    }
                    case 2: {
                        int x;
                        int y;
                        PassGroup.auxDCT2(coeffs[c], scratchBlk[1], ppg, IntXL.ZERO, 2);
                        for (y = 0; y < 2; ++y) {
                            for (x = 0; x < 2; ++x) {
                                int ix;
                                int iy;
                                scratchBlk[0][0][0] = scratchBlk[1][y][x];
                                for (iy = 0; iy < 4; ++iy) {
                                    int n = ix = iy == 0 ? 1 : 0;
                                    while (ix < 4) {
                                        scratchBlk[0][iy][ix] = coeffs[c][ppg.y + y + ix * 2][ppg.x + x + iy * 2];
                                        ++ix;
                                    }
                                }
                                MathXL.inverseDCT2D(scratchBlk[0], scratchBlk[1], IntXL.ZERO, new IntXL(8), new IntXL(4), scratchBlk[2], scratchBlk[3], false);
                                for (iy = 0; iy < 4; ++iy) {
                                    for (ix = 0; ix < 4; ++ix) {
                                        frameBuffer[c][pixelPosInFrame.y + 4 * y + iy][pixelPosInFrame.x + 4 * x + ix] = scratchBlk[1][8 + iy][8 + ix];
                                    }
                                }
                            }
                        }
                        continue block14;
                    }
                }
            }
        }
    }
}

