/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpegxl.data;

import com.idrsolutions.image.jpegxl.data.BitXL;
import com.idrsolutions.image.jpegxl.data.Entropy;
import com.idrsolutions.image.jpegxl.data.Frame;
import com.idrsolutions.image.jpegxl.data.ITXInfo;
import com.idrsolutions.image.jpegxl.data.MTree;
import com.idrsolutions.image.jpegxl.data.ModularChannel;
import com.idrsolutions.image.jpegxl.data.ModularInfo;
import com.idrsolutions.image.jpegxl.data.SqueezeInfo;
import com.idrsolutions.image.jpegxl.data.WPInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class ModularStream {
    private static final int[][] DELTAS = new int[][]{{0, 0, 0}, {4, 4, 4}, {11, 0, 0}, {0, 0, -13}, {0, -12, 0}, {-10, -10, -10}, {-18, -18, -18}, {-27, -27, -27}, {-18, -18, 0}, {0, 0, -32}, {-32, 0, 0}, {-37, -37, -37}, {0, -32, -32}, {24, 24, 45}, {50, 50, 50}, {-45, -24, -24}, {-24, -45, -45}, {0, -24, -24}, {-34, -34, 0}, {-24, 0, -24}, {-45, -45, -24}, {64, 64, 64}, {-32, 0, -32}, {0, -32, 0}, {-32, 0, 32}, {-24, -45, -24}, {45, 24, 45}, {24, -24, -45}, {-45, -24, 24}, {80, 80, 80}, {64, 0, 0}, {0, 0, -64}, {0, -64, -64}, {-24, -24, 45}, {96, 96, 96}, {64, 64, 0}, {45, -24, -24}, {34, -34, 0}, {112, 112, 112}, {24, -45, -45}, {45, 45, -24}, {0, -32, 32}, {24, -24, 45}, {0, 96, 96}, {45, -24, 24}, {24, -45, -24}, {-24, -45, 24}, {0, -64, 0}, {96, 0, 0}, {128, 128, 128}, {64, 0, 64}, {144, 144, 144}, {96, 96, 0}, {-36, -36, 36}, {45, -24, -45}, {45, -45, -24}, {0, 0, -96}, {0, 128, 128}, {0, 96, 0}, {45, 24, -45}, {-128, 0, 0}, {24, -45, 24}, {-45, 24, -45}, {64, 0, -64}, {64, -64, -64}, {96, 0, 96}, {45, -45, 24}, {24, 45, -45}, {64, 64, -64}, {128, 128, 0}, {0, 0, -128}, {-24, 45, -45}};
    private static final int[][] permutationLut = new int[][]{{0, 1, 2}, {1, 2, 0}, {2, 0, 1}, {0, 2, 1}, {1, 0, 2}, {2, 1, 0}};
    private int nbMetaChannels;
    private final int streamIndex;
    private final int distMultiplier;
    private final MTree tree;
    private final WPInfo wpParams;
    private final ITXInfo[] transforms;
    private final Frame frame;
    private Entropy stream;
    private boolean transformed;
    private final List<ModularInfo> channels = new ArrayList<ModularInfo>();
    private final Map<Integer, SqueezeInfo[]> squeezeMap = new HashMap<Integer, SqueezeInfo[]>();

    ModularStream(BitXL reader, Frame frame, int streamIndex, int channelCount, int ecStart) throws IOException {
        this(reader, frame, streamIndex, channelCount, ecStart, null);
    }

    ModularStream(BitXL reader, Frame frame, int streamIndex, ModularInfo[] channelArray) throws IOException {
        this(reader, frame, streamIndex, channelArray.length, 0, channelArray);
    }

    private ModularStream(BitXL reader, Frame frame, int streamIndex, int channelCount, int ecStart, ModularInfo[] channelArray) throws IOException {
        int i;
        this.frame = frame;
        this.streamIndex = streamIndex;
        if (channelCount == 0) {
            this.tree = null;
            this.wpParams = null;
            this.transforms = new ITXInfo[0];
            this.distMultiplier = 1;
            return;
        }
        boolean useGlobalTree = reader.bool();
        this.wpParams = new WPInfo(reader);
        int nbTransforms = reader.u32(0, 0, 1, 0, 2, 4, 18, 8);
        this.transforms = new ITXInfo[nbTransforms];
        for (int i2 = 0; i2 < nbTransforms; ++i2) {
            this.transforms[i2] = new ITXInfo(reader);
        }
        int w = frame.getModularFrameSize().x;
        int h = frame.getModularFrameSize().y;
        if (channelArray == null) {
            for (i = 0; i < channelCount; ++i) {
                int dimShift = i < ecStart ? 0 : frame.globalMetadata.getExtraChannel((int)(i - ecStart)).dimShift;
                this.channels.add(new ModularInfo(w, h, dimShift, dimShift));
            }
        } else {
            this.channels.addAll(Arrays.asList(channelArray));
        }
        block6: for (i = 0; i < nbTransforms; ++i) {
            switch (this.transforms[i].tr) {
                case 1: {
                    this.nbMetaChannels = this.transforms[i].beginC < this.nbMetaChannels ? (this.nbMetaChannels += 2 - this.transforms[i].numC) : ++this.nbMetaChannels;
                    int start = this.transforms[i].beginC + 1;
                    if (this.transforms[i].beginC + this.transforms[i].numC > start) {
                        this.channels.subList(start, this.transforms[i].beginC + this.transforms[i].numC).clear();
                    }
                    if (this.transforms[i].nbDeltas > 0 && this.transforms[i].dPred == 6) {
                        this.channels.get((int)this.transforms[i].beginC).forceWP = true;
                    }
                    this.channels.add(0, new ModularInfo(this.transforms[i].nbColors, this.transforms[i].numC, -1, -1));
                    continue block6;
                }
                case 2: {
                    ArrayList<SqueezeInfo> squeezeList = new ArrayList<SqueezeInfo>();
                    if (this.transforms[i].sp.length == 0) {
                        int first = this.nbMetaChannels;
                        int count = this.channels.size() - first;
                        w = this.channels.get((int)first).width;
                        h = this.channels.get((int)first).height;
                        if (count > 2 && this.channels.get((int)(first + 1)).width == w && this.channels.get((int)(first + 1)).height == h) {
                            squeezeList.add(new SqueezeInfo(true, false, first + 1, 2));
                            squeezeList.add(new SqueezeInfo(false, false, first + 1, 2));
                        }
                        if (h >= w && h > 8) {
                            squeezeList.add(new SqueezeInfo(false, true, first, count));
                            h = (h + 1) / 2;
                        }
                        while (w > 8 || h > 8) {
                            if (w > 8) {
                                squeezeList.add(new SqueezeInfo(true, true, first, count));
                                w = (w + 1) / 2;
                            }
                            if (h <= 8) continue;
                            squeezeList.add(new SqueezeInfo(false, true, first, count));
                            h = (h + 1) / 2;
                        }
                    } else {
                        squeezeList.addAll(Arrays.asList(this.transforms[i].sp));
                    }
                    SqueezeInfo[] sqi = squeezeList.toArray(new SqueezeInfo[0]);
                    this.squeezeMap.put(i, sqi);
                    for (SqueezeInfo sqa1 : sqi) {
                        int offset;
                        int begin = sqa1.beginC;
                        int end = begin + sqa1.numC - 1;
                        int n = offset = sqa1.inPlace ? end + 1 : this.channels.size();
                        if (begin < this.nbMetaChannels) {
                            this.nbMetaChannels += sqa1.numC;
                        }
                        for (int k = begin; k <= end; ++k) {
                            ModularInfo residual;
                            ModularInfo chan = this.channels.get(k);
                            int r = offset + k - begin;
                            if (sqa1.horizontal) {
                                w = chan.width;
                                chan.width = (w + 1) / 2;
                                ++chan.hshift;
                                residual = new ModularInfo(chan);
                                residual.width = w / 2;
                            } else {
                                h = chan.height;
                                chan.height = (h + 1) / 2;
                                ++chan.vshift;
                                residual = new ModularInfo(chan);
                                residual.height = h / 2;
                            }
                            this.channels.add(r, residual);
                        }
                    }
                    continue block6;
                }
            }
        }
        this.tree = !useGlobalTree ? new MTree(reader) : frame.getGlobalTree();
        this.stream = new Entropy(this.tree.entropy);
        this.distMultiplier = this.channels.stream().mapToInt(c -> c.width).reduce(0, Math::max);
    }

    void decodeChannels(BitXL reader) throws IOException {
        this.decodeChannels(reader, false);
    }

    void decodeChannels(BitXL reader, boolean partial) throws IOException {
        this.channels.replaceAll(ModularChannel::new);
        int groupDim = this.frame.getFrameHeader().groupDim;
        for (int i = 0; i < this.channels.size(); ++i) {
            ModularChannel channel = this.getChannel(i);
            if (partial && i >= this.nbMetaChannels && (channel.width > groupDim || channel.height > groupDim)) break;
            channel.decode(reader, this.stream, this.wpParams, this.tree, this, i, this.streamIndex, this.distMultiplier);
        }
        if (!partial) {
            this.applyTransforms();
        }
    }

    int getEncodedChannelCount() {
        return this.channels.size();
    }

    ModularChannel getChannel(int index) {
        ModularInfo channel = this.channels.get(index);
        return (ModularChannel)channel;
    }

    ModularInfo getChannelInfo(int index) {
        return this.channels.get(index);
    }

    void applyTransforms() {
        if (this.transformed) {
            return;
        }
        this.transformed = true;
        block14: for (int i = this.transforms.length - 1; i >= 0; --i) {
            switch (this.transforms[i].tr) {
                case 2: {
                    SqueezeInfo[] sqa = this.squeezeMap.get(i);
                    for (int j = sqa.length - 1; j >= 0; --j) {
                        int c;
                        SqueezeInfo sq = sqa[j];
                        int begin = sq.beginC;
                        int end = begin + sq.numC - 1;
                        int offset = sq.inPlace ? end + 1 : this.channels.size() + begin - end - 1;
                        for (c = begin; c <= end; ++c) {
                            ModularChannel output;
                            int r = offset + c - begin;
                            ModularChannel chan = this.getChannel(c);
                            ModularChannel residual = this.getChannel(r);
                            if (sq.horizontal) {
                                outputInfo = new ModularInfo(chan.width + residual.width, chan.height, chan.hshift - 1, chan.vshift);
                                output = ModularChannel.inverseHorizontalSqueeze(outputInfo, chan, residual);
                            } else {
                                outputInfo = new ModularInfo(chan.width, chan.height + residual.height, chan.hshift, chan.vshift - 1);
                                output = ModularChannel.inverseVerticalSqueeze(outputInfo, chan, residual);
                            }
                            this.channels.set(c, output);
                        }
                        for (c = 0; c < end - begin + 1; ++c) {
                            this.channels.remove(offset);
                        }
                    }
                    continue block14;
                }
                case 0: {
                    int j;
                    int permutation = this.transforms[i].rctType / 7;
                    int type = this.transforms[i].rctType % 7;
                    ModularChannel[] v = new ModularChannel[3];
                    int start = this.transforms[i].beginC;
                    for (j = 0; j < 3; ++j) {
                        v[j] = this.getChannel(start + j);
                    }
                    for (int y = 0; y < v[0].height; ++y) {
                        block20: for (int x = 0; x < v[0].width; ++x) {
                            switch (type) {
                                case 0: {
                                    continue block20;
                                }
                                case 1: {
                                    v[2].buffer[y][x] = v[0].buffer[y][x] + v[2].buffer[y][x];
                                    continue block20;
                                }
                                case 2: {
                                    v[1].buffer[y][x] = v[0].buffer[y][x] + v[1].buffer[y][x];
                                    continue block20;
                                }
                                case 3: {
                                    int a = v[0].buffer[y][x];
                                    v[2].buffer[y][x] = a + v[2].buffer[y][x];
                                    v[1].buffer[y][x] = a + v[1].buffer[y][x];
                                    continue block20;
                                }
                                case 4: {
                                    v[1].buffer[y][x] = v[1].buffer[y][x] + (v[0].buffer[y][x] + v[2].buffer[y][x]) >> 1;
                                    continue block20;
                                }
                                case 5: {
                                    int aa = v[0].buffer[y][x];
                                    int cc = v[2].buffer[y][x];
                                    int[] nArray = v[1].buffer[y];
                                    int n = x;
                                    nArray[n] = nArray[n] + (aa + (cc >> 1));
                                    v[2].buffer[y][x] = aa + cc;
                                    continue block20;
                                }
                                case 6: {
                                    int b = v[1].buffer[y][x];
                                    int c = v[2].buffer[y][x];
                                    int tmp = v[0].buffer[y][x] - (c >> 1);
                                    int f = tmp - (b >> 1);
                                    v[0].buffer[y][x] = f + b;
                                    v[1].buffer[y][x] = c + tmp;
                                    v[2].buffer[y][x] = f;
                                }
                            }
                        }
                    }
                    for (j = 0; j < 3; ++j) {
                        this.channels.set(start + permutationLut[permutation][j], v[j]);
                    }
                    continue block14;
                }
                case 1: {
                    int first = this.transforms[i].beginC + 1;
                    int endC = this.transforms[i].beginC + this.transforms[i].numC - 1;
                    int last = endC + 1;
                    int bitDepth = this.frame.globalMetadata.getBitDepthHeader().bitsPerSample;
                    ModularChannel firstChannel = this.getChannel(first);
                    ModularChannel c0 = this.getChannel(0);
                    for (int j = first + 1; j <= last; ++j) {
                        this.channels.add(j, new ModularChannel(firstChannel));
                    }
                    for (int c = 0; c < this.transforms[i].numC; ++c) {
                        ModularChannel chan = this.getChannel(first + c);
                        for (int y = 0; y < firstChannel.height; ++y) {
                            for (int x = 0; x < firstChannel.width; ++x) {
                                int value;
                                boolean isDelta;
                                int index = chan.buffer[y][x];
                                boolean bl = isDelta = index < this.transforms[i].nbDeltas;
                                if (index >= 0 && index < this.transforms[i].nbColors) {
                                    value = c0.buffer[c][index];
                                } else if (index >= this.transforms[i].nbColors) {
                                    if ((index -= this.transforms[i].nbColors) < 64) {
                                        value = (index >> 2 * c) % 4 * ((1 << bitDepth) - 1) / 4 + (1 << Math.max(0, bitDepth - 3));
                                    } else {
                                        index -= 64;
                                        for (int k = 0; k < c; ++k) {
                                            index /= 5;
                                        }
                                        value = index % 5 * ((1 << bitDepth) - 1) / 4;
                                    }
                                } else if (c < 3) {
                                    index = (-index - 1) % 143;
                                    value = DELTAS[index + 1 >> 1][c];
                                    if ((index & 1) == 0) {
                                        value = -value;
                                    }
                                    if (bitDepth > 8) {
                                        value <<= Math.min(bitDepth, 24) - 8;
                                    }
                                } else {
                                    value = 0;
                                }
                                chan.buffer[y][x] = value;
                                if (!isDelta) continue;
                                int[] nArray = chan.buffer[y];
                                int n = x;
                                nArray[n] = nArray[n] + chan.predict(x, y, this.transforms[i].dPred);
                            }
                        }
                    }
                    this.channels.remove(0);
                    --this.nbMetaChannels;
                    continue block14;
                }
            }
        }
    }

    int[][][] getDecodedBuffer() {
        int[][][] bands = new int[this.channels.size()][][];
        for (int i = 0; i < bands.length; ++i) {
            bands[i] = this.getChannel((int)i).buffer;
        }
        return bands;
    }
}

