/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpegxl.data;

import com.idrsolutions.image.jpegxl.data.BitXL;
import com.idrsolutions.image.jpegxl.data.Entropy;
import com.idrsolutions.image.jpegxl.data.HelperXL;
import com.idrsolutions.image.jpegxl.data.MTree;
import com.idrsolutions.image.jpegxl.data.MathXL;
import com.idrsolutions.image.jpegxl.data.ModularInfo;
import com.idrsolutions.image.jpegxl.data.ModularStream;
import com.idrsolutions.image.jpegxl.data.WPInfo;
import java.io.IOException;
import java.util.Arrays;

class ModularChannel
extends ModularInfo {
    private static final int[] oneL24OverKP1 = new int[64];
    int[][] buffer;
    protected int[][][] error;
    protected int[][] pred;
    private int[] subpred;
    private int[] weight;
    private boolean decoded;

    private static int tendency(int a, int b, int c) {
        if (a >= b && b >= c) {
            int x = (4 * a - 3 * c - b + 6) / 12;
            int d = 2 * (a - b);
            int e = 2 * (b - c);
            if (x - (x & 1) > d) {
                x = d + 1;
            }
            if (x + (x & 1) > e) {
                x = e;
            }
            return x;
        }
        if (a <= b && b <= c) {
            int x = (4 * a - 3 * c - b - 6) / 12;
            int d = 2 * (a - b);
            int e = 2 * (b - c);
            if (x + (x & 1) < d) {
                x = d - 1;
            }
            if (x - (x & 1) < e) {
                x = e;
            }
            return x;
        }
        return 0;
    }

    ModularChannel(ModularInfo info) {
        super(info);
        this.buffer = this.width == 0 || this.height == 0 ? (Object)new int[0][] : new int[this.height][this.width];
        this.decoded = false;
    }

    ModularChannel(int width, int height, int hshift, int vshift) {
        super(width, height, hshift, vshift);
    }

    ModularChannel(ModularChannel copy) {
        this((ModularInfo)copy);
        if (copy.buffer != null) {
            this.buffer = new int[this.height][];
            for (int y = 0; y < this.height; ++y) {
                this.buffer[y] = Arrays.copyOf(copy.buffer[y], copy.buffer[y].length);
            }
        }
        this.decoded = copy.decoded;
    }

    private int west(int x, int y) {
        return x > 0 ? this.buffer[y][x - 1] : (y > 0 ? this.buffer[y - 1][x] : 0);
    }

    private int north(int x, int y) {
        return y > 0 ? this.buffer[y - 1][x] : (x > 0 ? this.buffer[y][x - 1] : 0);
    }

    private int northWest(int x, int y) {
        return x > 0 && y > 0 ? this.buffer[y - 1][x - 1] : this.west(x, y);
    }

    private int northEast(int x, int y) {
        return x + 1 < this.width && y > 0 ? this.buffer[y - 1][x + 1] : this.north(x, y);
    }

    private int northNorth(int x, int y) {
        return y > 1 ? this.buffer[y - 2][x] : this.north(x, y);
    }

    private int northEastEast(int x, int y) {
        return x + 2 < this.width && y > 0 ? this.buffer[y - 1][x + 2] : this.northEast(x, y);
    }

    private int westWest(int x, int y) {
        return x > 1 ? this.buffer[y][x - 2] : this.west(x, y);
    }

    private int errorWest(int x, int y, int e) {
        return x > 0 ? this.error[e][y][x - 1] : 0;
    }

    private int errorNorth(int x, int y, int e) {
        return y > 0 ? this.error[e][y - 1][x] : 0;
    }

    private int errorWestWest(int x, int y, int e) {
        return x > 1 ? this.error[e][y][x - 2] : 0;
    }

    private int errorNorthWest(int x, int y, int e) {
        return x > 0 && y > 0 ? this.error[e][y - 1][x - 1] : this.errorNorth(x, y, e);
    }

    private int errorNorthEast(int x, int y, int e) {
        return x + 1 < this.width && y > 0 ? this.error[e][y - 1][x + 1] : this.errorNorth(x, y, e);
    }

    int predict(int x, int y, int k) {
        switch (k) {
            case 1: {
                return this.west(x, y);
            }
            case 2: {
                return this.north(x, y);
            }
            case 3: {
                return (this.west(x, y) + this.north(x, y)) / 2;
            }
            case 4: {
                int w = this.west(x, y);
                int n = this.north(x, y);
                int nw = this.northWest(x, y);
                return Math.abs(n - nw) < Math.abs(w - nw) ? w : n;
            }
            case 5: {
                int w = this.west(x, y);
                int n = this.north(x, y);
                int v = w + n - this.northWest(x, y);
                return MathXL.clamp(v, n, w);
            }
            case 6: {
                return this.pred[y][x] + 3 >> 3;
            }
            case 7: {
                return this.northEast(x, y);
            }
            case 8: {
                return this.northWest(x, y);
            }
            case 9: {
                return this.westWest(x, y);
            }
            case 10: {
                return (this.west(x, y) + this.northWest(x, y)) / 2;
            }
            case 11: {
                return (this.north(x, y) + this.northWest(x, y)) / 2;
            }
            case 12: {
                return (this.north(x, y) + this.northEast(x, y)) / 2;
            }
            case 13: {
                return (6 * this.north(x, y) - 2 * this.northNorth(x, y) + 7 * this.west(x, y) + this.westWest(x, y) + this.northEastEast(x, y) + 3 * this.northEast(x, y) + 8) / 16;
            }
        }
        return 0;
    }

    private int prePredictWP(WPInfo wpParams, int x, int y) {
        int n3 = this.north(x, y) << 3;
        int nw3 = this.northWest(x, y) << 3;
        int ne3 = this.northEast(x, y) << 3;
        int w3 = this.west(x, y) << 3;
        int nn3 = this.northNorth(x, y) << 3;
        int tN = this.errorNorth(x, y, 4);
        int tW = this.errorWest(x, y, 4);
        int tNE = this.errorNorthEast(x, y, 4);
        int tNW = this.errorNorthWest(x, y, 4);
        this.subpred[0] = w3 + ne3 - n3;
        this.subpred[1] = n3 - ((tW + tN + tNE) * wpParams.param1 >> 5);
        this.subpred[2] = w3 - ((tW + tN + tNW) * wpParams.param2 >> 5);
        this.subpred[3] = n3 - (tNW * wpParams.param3a + tN * wpParams.param3b + tNE * wpParams.param3c + (nn3 - n3) * wpParams.param3d + (nw3 - w3) * wpParams.param3e >> 5);
        int wSum = 0;
        for (int e = 0; e < 4; ++e) {
            int shift;
            int eSum = this.errorNorth(x, y, e) + this.errorWest(x, y, e) + this.errorNorthWest(x, y, e) + this.errorWestWest(x, y, e) + this.errorNorthEast(x, y, e);
            if (x + 1 == this.width) {
                eSum += this.errorWest(x, y, e);
            }
            if ((shift = MathXL.floorLog1p(eSum) - 5) < 0) {
                shift = 0;
            }
            this.weight[e] = 4 + (wpParams.weight[e] * oneL24OverKP1[eSum >> shift] >> shift);
            wSum += this.weight[e];
        }
        int logWeight = MathXL.floorLog1p(wSum - 1) - 4;
        wSum = 0;
        for (int e = 0; e < 4; ++e) {
            int n = e;
            this.weight[n] = this.weight[n] >> logWeight;
            wSum += this.weight[e];
        }
        long s = (long)(wSum >> 1) - 1L;
        for (int e = 0; e < 4; ++e) {
            s += (long)this.subpred[e] * (long)this.weight[e];
        }
        this.pred[y][x] = (int)(s * (long)oneL24OverKP1[wSum - 1] >> 24);
        if ((tN ^ tW | tN ^ tNW) <= 0) {
            this.pred[y][x] = MathXL.clamp(this.pred[y][x], w3, n3, ne3);
        }
        int maxError = tW;
        if (Math.abs(tN) > Math.abs(maxError)) {
            maxError = tN;
        }
        if (Math.abs(tNW) > Math.abs(maxError)) {
            maxError = tNW;
        }
        if (Math.abs(tNE) > Math.abs(maxError)) {
            maxError = tNE;
        }
        return maxError;
    }

    void decode(BitXL reader, Entropy stream, WPInfo wpParams, MTree tree, ModularStream parent, int channelIndex, int streamIndex, int distMultiplier) throws IOException {
        boolean useWP;
        if (this.decoded) {
            return;
        }
        this.decoded = true;
        tree = tree.compact(channelIndex, streamIndex);
        boolean bl = useWP = this.forceWP || tree.usesWeightedPredictor();
        if (useWP) {
            this.error = new int[5][this.height][this.width];
            this.pred = new int[this.height][this.width];
            this.subpred = new int[4];
            this.weight = new int[4];
        }
        for (int y : HelperXL.range(this.height)) {
            MTree refinedTree = tree.compact(channelIndex, streamIndex, y);
            for (int x : HelperXL.range(this.width)) {
                int trueValue;
                int maxError = useWP ? this.prePredictWP(wpParams, x, y) : 0;
                MTree leafNode = refinedTree.walk(k -> {
                    switch (k) {
                        case 0: {
                            return channelIndex;
                        }
                        case 1: {
                            return streamIndex;
                        }
                        case 2: {
                            return y;
                        }
                        case 3: {
                            return x;
                        }
                        case 4: {
                            return Math.abs(this.north(x, y));
                        }
                        case 5: {
                            return Math.abs(this.west(x, y));
                        }
                        case 6: {
                            return this.north(x, y);
                        }
                        case 7: {
                            return this.west(x, y);
                        }
                        case 8: {
                            return x > 0 ? this.west(x, y) - (this.west(x - 1, y) + this.north(x - 1, y) - this.northWest(x - 1, y)) : this.west(x, y);
                        }
                        case 9: {
                            return this.west(x, y) + this.north(x, y) - this.northWest(x, y);
                        }
                        case 10: {
                            return this.west(x, y) - this.northWest(x, y);
                        }
                        case 11: {
                            return this.northWest(x, y) - this.north(x, y);
                        }
                        case 12: {
                            return this.north(x, y) - this.northEast(x, y);
                        }
                        case 13: {
                            return this.north(x, y) - this.northNorth(x, y);
                        }
                        case 14: {
                            return this.west(x, y) - this.westWest(x, y);
                        }
                        case 15: {
                            return maxError;
                        }
                    }
                    if (k - 16 >= 4 * channelIndex) {
                        return 0;
                    }
                    int k2 = 16;
                    for (int j = channelIndex - 1; j >= 0; --j) {
                        ModularChannel channel = parent.getChannel(j);
                        if (channel.width != this.width || channel.height != this.height || channel.hshift != this.hshift || channel.vshift != this.vshift) continue;
                        if (k2 + 4 <= k) {
                            k2 += 4;
                            continue;
                        }
                        int rC = channel.buffer[y][x];
                        if (k2++ == k) {
                            return Math.abs(rC);
                        }
                        if (k2++ == k) {
                            return rC;
                        }
                        int rW = x > 0 ? channel.buffer[y][x - 1] : 0;
                        int rN = y > 0 ? channel.buffer[y - 1][x] : rW;
                        int rNW = x > 0 && y > 0 ? channel.buffer[y - 1][x - 1] : rW;
                        int rG = rC - MathXL.clamp(rW + rN - rNW, rN, rW);
                        if (k2++ == k) {
                            return Math.abs(rG);
                        }
                        if (k2++ != k) continue;
                        return rG;
                    }
                    return 0;
                });
                int diff = stream.readSymbol(reader, leafNode.context, distMultiplier);
                diff = MathXL.unpackSigned(diff) * leafNode.multiplier + leafNode.offset;
                this.buffer[y][x] = trueValue = diff + this.predict(x, y, leafNode.predictor);
                if (!useWP) continue;
                for (int e = 0; e < 4; ++e) {
                    this.error[e][y][x] = Math.abs(this.subpred[e] - (trueValue << 3)) + 3 >> 3;
                }
                this.error[4][y][x] = this.pred[y][x] - (trueValue << 3);
            }
        }
    }

    boolean isDecoded() {
        return this.decoded;
    }

    static ModularChannel inverseHorizontalSqueeze(ModularInfo info, ModularChannel orig, ModularChannel res) {
        int y;
        ModularChannel channel = new ModularChannel(info);
        for (y = 0; y < res.height; ++y) {
            for (int x = 0; x < res.width; ++x) {
                int first;
                int avg = orig.buffer[y][x];
                int residu = res.buffer[y][x];
                int nextAvg = x + 1 < orig.width ? orig.buffer[y][x + 1] : avg;
                int left = x > 0 ? channel.buffer[y][2 * x - 1] : avg;
                int diff = residu + ModularChannel.tendency(left, avg, nextAvg);
                channel.buffer[y][2 * x] = first = avg + diff / 2;
                channel.buffer[y][2 * x + 1] = first - diff;
            }
        }
        if (orig.width > res.width) {
            for (y = 0; y < channel.height; ++y) {
                channel.buffer[y][2 * res.width] = orig.buffer[y][res.width];
            }
        }
        return channel;
    }

    static ModularChannel inverseVerticalSqueeze(ModularInfo info, ModularChannel orig, ModularChannel res) {
        ModularChannel channel = new ModularChannel(info);
        for (int y = 0; y < res.height; ++y) {
            for (int x = 0; x < channel.width; ++x) {
                int first;
                int avg = orig.buffer[y][x];
                int residu = res.buffer[y][x];
                int nextAvg = y + 1 < orig.height ? orig.buffer[y + 1][x] : avg;
                int top = y > 0 ? channel.buffer[2 * y - 1][x] : avg;
                int diff = residu + ModularChannel.tendency(top, avg, nextAvg);
                channel.buffer[2 * y][x] = first = avg + diff / 2;
                channel.buffer[2 * y + 1][x] = first - diff;
            }
        }
        if (orig.height > res.height) {
            System.arraycopy(orig.buffer[res.height], 0, channel.buffer[2 * res.height], 0, channel.width);
        }
        return channel;
    }

    static {
        for (int i = 0; i < oneL24OverKP1.length; ++i) {
            ModularChannel.oneL24OverKP1[i] = 0x1000000 / (i + 1);
        }
    }
}

