/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpegxl.data;

import com.idrsolutions.image.jpegxl.data.BitXL;
import com.idrsolutions.image.jpegxl.data.IntXL;
import java.io.IOException;
import java.util.Arrays;

final class MathXL {
    static final float SQRT_2 = (float)StrictMath.sqrt(2.0);
    static final float SQRT_H = (float)StrictMath.sqrt(0.5);
    static final float SQRT_F = (float)StrictMath.sqrt(0.125);
    static final float PHI_BAR = (float)(StrictMath.sqrt(5.0) * 0.5 - 0.5);
    private static final float[][][] COSINES = new float[9][][];

    private MathXL() {
    }

    static int mirror(int coord, int size) {
        if (coord < 0) {
            return MathXL.mirror(~coord, size);
        }
        if (coord < size) {
            return coord;
        }
        return MathXL.mirror((size << 1) + ~coord, size);
    }

    static int ceilLog1p(long x) {
        return 64 - Long.numberOfLeadingZeros(x);
    }

    static int ceilLog2(long x) {
        return MathXL.ceilLog1p(x - 1L);
    }

    static int ceilDiv(int n, int d) {
        return (n - 1) / d + 1;
    }

    static int floorLog1p(long x) {
        int c = MathXL.ceilLog1p(x);
        if ((x + 1L & x) != 0L) {
            return c - 1;
        }
        return c;
    }

    static float max(float ... a) {
        float result = a[0];
        for (int i = 1; i < a.length; ++i) {
            result = Math.min(a[i], result);
        }
        return result;
    }

    static float signedPow(float base) {
        return (float)(base < 0.0f ? -Math.pow(-base, 0.3333333432674408) : Math.pow(base, 0.3333333432674408));
    }

    static int clamp(int v, int a, int b, int c) {
        int lower = Math.min(a, b);
        int upper = lower ^ a ^ b;
        lower = Math.min(lower, c);
        upper = Math.max(upper, c);
        return v < lower ? lower : Math.min(v, upper);
    }

    static int clamp(int v, int a, int b) {
        int lower = Math.min(a, b);
        int upper = lower ^ a ^ b;
        return v < lower ? lower : Math.min(v, upper);
    }

    static float clamp(float v, float a, float b) {
        float lower = Math.min(a, b);
        float upper = Math.max(a, b);
        return v < lower ? lower : Math.min(v, upper);
    }

    static int unpackSigned(int value) {
        return (value & 1) == 0 ? value >>> 1 : ~value >>> 1 | Integer.MIN_VALUE;
    }

    static int round(float d) {
        return (int)(d + 0.5f);
    }

    static float erf(float z) {
        float absErf;
        float az = Math.abs(z);
        if (az > 1.0E-4f) {
            float t = 1.0f / (az * 0.5f + 1.0f);
            float u = t * (t * (t * (t * (t * (t * (t * (t * (t * 0.17087276f - 0.82215226f) + 1.4885159f) - 1.135204f) + 0.27886808f) - 0.18628806f) + 0.09678418f) + 0.37409195f) + 1.0000237f) - 1.2655122f;
            absErf = 1.0f - t * (float)Math.exp(-z * z + u);
        } else {
            float t = 1.0f / (az * 0.47047f + 1.0f);
            float u = t * (t * (t * 0.7478556f - 0.0958798f) + 0.3480242f);
            absErf = 1.0f - u * (float)Math.exp(-z * z);
        }
        if (z < 0.0f) {
            return -absErf;
        }
        return absErf;
    }

    static void inverseDCTHorizontal(float[][] src, int yIn, int xStartIn, float[][] dest, int yOut, int xStartOut, int xLogLength, int xLength) {
        float[] d = dest[yOut];
        float[] s = src[yIn];
        Arrays.fill(d, xStartOut, xStartOut + xLength, s[xStartIn]);
        for (int n = 1; n < xLength; ++n) {
            float[] lut = COSINES[xLogLength][n - 1];
            float s2 = s[xStartIn + n];
            for (int k = 0; k < xLength; ++k) {
                int n2 = xStartOut + k;
                d[n2] = d[n2] + s2 * lut[k];
            }
        }
    }

    static void forwardDCTHorizontal(float[][] src, int yIn, int xStartIn, float[][] dest, int yOut, int xStartOut, int xLogLength, int xLength) {
        float invLength = 1.0f / (float)xLength;
        float[] d = dest[yOut];
        float[] s = src[yIn];
        float d2 = 0.0f;
        for (int x = 0; x < xLength; ++x) {
            d2 += s[xStartIn + x];
        }
        d[xStartOut] = d2 * invLength;
        for (int k = 1; k < xLength; ++k) {
            d2 = 0.0f;
            float[] lut = COSINES[xLogLength][k - 1];
            for (int n = 0; n < xLength; ++n) {
                d2 += s[xStartIn + n] * lut[n];
            }
            d[xStartOut + k] = d2 * invLength;
        }
    }

    static void inverseDCT2D(float[][] src, float[][] dest, IntXL startIn, IntXL startOut, IntXL length, float[][] scratchSpace1, float[][] scratchSpace2, boolean transposed) {
        int y;
        int xLogLength = MathXL.ceilLog2(length.x);
        int yLogLength = MathXL.ceilLog2(length.y);
        for (y = 0; y < length.y; ++y) {
            MathXL.inverseDCTHorizontal(src, y + startIn.y, startIn.x, scratchSpace1, y, 0, xLogLength, length.x);
        }
        MathXL.mmTransposeTo(scratchSpace1, scratchSpace2, IntXL.ZERO, IntXL.ZERO, length);
        if (transposed) {
            for (y = 0; y < length.x; ++y) {
                MathXL.inverseDCTHorizontal(scratchSpace2, y, 0, dest, startOut.y + y, startOut.x, yLogLength, length.y);
            }
        } else {
            for (int x = 0; x < length.x; ++x) {
                MathXL.inverseDCTHorizontal(scratchSpace2, x, 0, scratchSpace1, x, 0, yLogLength, length.y);
            }
            MathXL.mmTransposeTo(scratchSpace1, dest, IntXL.ZERO, startOut, length.transpose());
        }
    }

    static void forwardDCT2D(float[][] src, float[][] dest, IntXL startIn, IntXL startOut, IntXL length, float[][] scratchSpace1, float[][] scratchSpace2) {
        int xLogLength = MathXL.ceilLog2(length.x);
        int yLogLength = MathXL.ceilLog2(length.y);
        for (int y = 0; y < length.y; ++y) {
            MathXL.forwardDCTHorizontal(src, y + startIn.y, startIn.x, scratchSpace1, y, 0, xLogLength, length.x);
        }
        MathXL.mmTransposeTo(scratchSpace1, scratchSpace2, IntXL.ZERO, IntXL.ZERO, length);
        for (int x = 0; x < length.x; ++x) {
            MathXL.forwardDCTHorizontal(scratchSpace2, x, 0, scratchSpace1, x, 0, yLogLength, length.y);
        }
        MathXL.mmTransposeTo(scratchSpace1, dest, IntXL.ZERO, startOut, length.transpose());
    }

    static void mmTransposeTo(float[][] src, float[][] dest, IntXL srcStart, IntXL destStart, IntXL srcSize) {
        for (int y = 0; y < srcSize.y; ++y) {
            float[] srcy = src[srcStart.y + y];
            for (int x = 0; x < srcSize.x; ++x) {
                dest[destStart.y + x][destStart.x + y] = srcy[srcStart.x + x];
            }
        }
    }

    static float[][] mmTranspose(float[][] matrix, IntXL inSize) {
        float[][] dest = new float[inSize.x][inSize.y];
        MathXL.mmTransposeTo(matrix, dest, IntXL.ZERO, IntXL.ZERO, inSize);
        return dest;
    }

    static float[] mmMutliply(float[][] mm, float[] vector) {
        if (mm == null) {
            return vector;
        }
        int extra = vector.length - mm[0].length;
        float[] total = new float[mm.length + extra];
        for (int y = 0; y < mm.length; ++y) {
            float[] row = mm[y];
            for (int x = 0; x < row.length; ++x) {
                int n = y;
                total[n] = total[n] + row[x] * vector[x];
            }
        }
        if (extra != 0) {
            System.arraycopy(vector, vector.length - extra, total, total.length - extra, extra);
        }
        return total;
    }

    static void mmMutliplyFixed(float[][] mm, float[] vector, float[] total) {
        total[2] = 0.0f;
        total[1] = 0.0f;
        total[0] = 0.0f;
        int extra = vector.length - mm[0].length;
        for (int y = 0; y < mm.length; ++y) {
            float[] row = mm[y];
            for (int x = 0; x < row.length; ++x) {
                int n = y;
                total[n] = total[n] + row[x] * vector[x];
            }
        }
        if (extra != 0) {
            System.arraycopy(vector, vector.length - extra, total, total.length - extra, extra);
        }
    }

    static float[] mmMutliply(float[] vector, float[][] mm) {
        if (mm == null) {
            return vector;
        }
        float[] total = new float[mm[0].length];
        for (int y = 0; y < vector.length; ++y) {
            float[] row = mm[y];
            for (int x = 0; x < total.length; ++x) {
                int n = x;
                total[n] = total[n] + vector[y] * row[x];
            }
        }
        return total;
    }

    static float[][] mmMutliply(float[][] left, float[][] right) {
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        float[][] result = new float[left.length][right[0].length];
        for (int y = 0; y < right.length; ++y) {
            result[y] = MathXL.mmMutliply(left[y], right);
        }
        return result;
    }

    static float[][] mmIdentity(int n) {
        float[][] identity = new float[n][n];
        for (int i = 0; i < n; ++i) {
            identity[i][i] = 1.0f;
        }
        return identity;
    }

    static float[][] mmMutliply(float[][] a, float[][] b, float[][] c) {
        return MathXL.mmMutliply(MathXL.mmMutliply(a, b), c);
    }

    static float[][] mmInverse3x3(float[][] mm) {
        if (mm == null) {
            return null;
        }
        float det = 0.0f;
        for (int c = 0; c < 3; ++c) {
            int c1 = (c + 1) % 3;
            int c2 = (c + 2) % 3;
            det += mm[c][0] * mm[c1][1] * mm[c2][2] - mm[c][0] * mm[c1][2] * mm[c2][1];
        }
        if (det == 0.0f) {
            return null;
        }
        float invDet = 1.0f / det;
        float[][] result = new float[3][3];
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                int x1 = (x + 1) % 3;
                int x2 = (x + 2) % 3;
                int y1 = (y + 1) % 3;
                int y2 = (y + 2) % 3;
                result[y][x] = (mm[x1][y1] * mm[x2][y2] - mm[x2][y1] * mm[x1][y2]) * invDet;
            }
        }
        return result;
    }

    static float float16To32(int bits16) {
        int mantissa = bits16 & 0x3FF;
        int exp = bits16 >>> 10 & 0x1F;
        int sign = bits16 >>> 15 & 1;
        if (exp == 31) {
            return Float.NaN;
        }
        if (exp == 0) {
            return (float)((1 - 2 * sign) * mantissa) / 1.6777216E7f;
        }
        int total = (sign <<= 31) | (exp += 112) << 23 | (mantissa <<= 13);
        return Float.intBitsToFloat(total);
    }

    static float[][][] mmCopy(float[][][] array) {
        if (array == null) {
            return null;
        }
        float[][][] copy = new float[array.length][][];
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null) continue;
            copy[i] = new float[array[i].length][];
            for (int j = 0; j < array[i].length; ++j) {
                if (array[i][j] == null) continue;
                copy[i][j] = Arrays.copyOf(array[i][j], array[i][j].length);
            }
        }
        return copy;
    }

    static void skipExtensions(BitXL reader) throws IOException {
        int i;
        long extensionsKey = reader.u64();
        int[] payLen = new int[64];
        for (i = 0; i < 64; ++i) {
            if ((1L << i & extensionsKey) == 0L) continue;
            long length = reader.u64();
            payLen[i] = (int)length;
        }
        for (i = 0; i < 64; ++i) {
            if (payLen[i] == 0) continue;
            for (int j = 0; j < payLen[i]; ++j) {
                reader.u(8);
            }
        }
    }

    static {
        double root2 = StrictMath.sqrt(2.0);
        for (int l = 0; l < COSINES.length; ++l) {
            int s = 1 << l;
            MathXL.COSINES[l] = new float[s - 1][s];
            for (int n = 0; n < COSINES[l].length; ++n) {
                for (int k = 0; k < COSINES[l][n].length; ++k) {
                    MathXL.COSINES[l][n][k] = (float)(root2 * StrictMath.cos(Math.PI * (double)(n + 1) * ((double)k + 0.5) / (double)s));
                }
            }
        }
    }
}

