/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpegxl.data;

import com.idrsolutions.image.jpegxl.data.BitXL;
import com.idrsolutions.image.jpegxl.data.MathXL;
import java.io.IOException;

class LoopFilter {
    final boolean gab;
    final boolean customGab;
    final float[] gab1Weights = new float[]{0.115169525f, 0.115169525f, 0.115169525f};
    final float[] gab2Weights = new float[]{0.061248593f, 0.061248593f, 0.061248593f};
    final int epfIterations;
    final boolean epfSharpCustom;
    final float[] epfSharpLut = new float[]{0.0f, 0.14285715f, 0.2857143f, 0.42857143f, 0.5714286f, 0.71428573f, 0.85714287f, 1.0f};
    final boolean epfWeightCustom;
    final float[] epfChannelScale = new float[]{40.0f, 5.0f, 3.5f};
    final boolean epfSigmaCustom;
    final float epfQuantMul;
    final float epfPass0SigmaScale;
    final float epfPass2SigmaScale;
    final float epfBorderSadMul;
    final float epfSigmaForModular;

    LoopFilter() {
        this.gab = true;
        this.customGab = false;
        this.epfIterations = 2;
        this.epfSharpCustom = false;
        this.epfWeightCustom = false;
        this.epfSigmaCustom = false;
        this.epfQuantMul = 0.46f;
        this.epfPass0SigmaScale = 0.9f;
        this.epfPass2SigmaScale = 6.5f;
        this.epfBorderSadMul = 0.6666667f;
        this.epfSigmaForModular = 1.0f;
        int i = 0;
        while (i < 8) {
            int n = i++;
            this.epfSharpLut[n] = this.epfSharpLut[n] * this.epfQuantMul;
        }
    }

    LoopFilter(BitXL reader, int encoding) throws IOException {
        int i;
        boolean allDefault = reader.bool();
        this.gab = allDefault || reader.bool();
        boolean bl = this.customGab = !allDefault && this.gab && reader.bool();
        if (this.customGab) {
            for (i = 0; i < 3; ++i) {
                this.gab1Weights[i] = reader.f16();
                this.gab2Weights[i] = reader.f16();
            }
        }
        this.epfIterations = allDefault ? 2 : reader.u(2);
        boolean bl2 = this.epfSharpCustom = !allDefault && this.epfIterations > 0 && encoding == 0 && reader.bool();
        if (this.epfSharpCustom) {
            for (i = 0; i < this.epfSharpLut.length; ++i) {
                this.epfSharpLut[i] = reader.f16();
            }
        }
        boolean bl3 = this.epfWeightCustom = !allDefault && this.epfIterations > 0 && reader.bool();
        if (this.epfWeightCustom) {
            for (i = 0; i < this.epfChannelScale.length; ++i) {
                this.epfChannelScale[i] = reader.f16();
            }
            reader.u(32);
        }
        this.epfSigmaCustom = !allDefault && this.epfIterations > 0 && reader.bool();
        this.epfQuantMul = this.epfSigmaCustom && encoding == 0 ? reader.f16() : 0.46f;
        this.epfPass0SigmaScale = this.epfSigmaCustom ? reader.f16() : 0.9f;
        this.epfPass2SigmaScale = this.epfSigmaCustom ? reader.f16() : 6.5f;
        this.epfBorderSadMul = this.epfSigmaCustom ? reader.f16() : 0.6666667f;
        float f = this.epfSigmaForModular = !allDefault && this.epfIterations > 0 && encoding == 1 ? reader.f16() : 1.0f;
        if (!allDefault) {
            MathXL.skipExtensions(reader);
        }
        i = 0;
        while (i < 8) {
            int n = i++;
            this.epfSharpLut[n] = this.epfSharpLut[n] * this.epfQuantMul;
        }
    }
}

