/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpegxl.data;

import com.idrsolutions.image.jpegxl.data.BitXL;
import com.idrsolutions.image.jpegxl.data.Frame;
import com.idrsolutions.image.jpegxl.data.HFMetadata;
import com.idrsolutions.image.jpegxl.data.IntXL;
import com.idrsolutions.image.jpegxl.data.LFCoeff;
import com.idrsolutions.image.jpegxl.data.ModularInfo;
import com.idrsolutions.image.jpegxl.data.ModularStream;
import java.io.IOException;

class LFGroup {
    final int[][][] modularLFGroupBuffer;
    final ModularInfo[] modularLFGroupInfo;
    final LFCoeff lfCoeff;
    final HFMetadata hfMetadata;
    final int lfGroupID;
    final Frame frame;
    final IntXL size;

    LFGroup(BitXL reader, Frame parent, int index, ModularInfo[] replaced, float[][][] lfBuffer) throws IOException {
        this.lfGroupID = index;
        this.frame = parent;
        this.size = this.frame.getLFGroupSize(index).toRight(3);
        this.lfCoeff = parent.getFrameHeader().encoding == 0 ? new LFCoeff(reader, this, parent, lfBuffer) : null;
        ModularStream modularLFGroup = new ModularStream(reader, this.frame, 1 + this.frame.getNumLFGroups() + this.lfGroupID, replaced);
        modularLFGroup.decodeChannels(reader);
        this.modularLFGroupBuffer = modularLFGroup.getDecodedBuffer();
        this.modularLFGroupInfo = new ModularInfo[this.modularLFGroupBuffer.length];
        for (int c = 0; c < this.modularLFGroupInfo.length; ++c) {
            this.modularLFGroupInfo[c] = new ModularInfo(modularLFGroup.getChannelInfo(c));
        }
        this.hfMetadata = parent.getFrameHeader().encoding == 0 ? new HFMetadata(reader, this, parent) : null;
    }
}

