/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpegxl.data;

import com.idrsolutions.image.jpegxl.data.BitXL;
import com.idrsolutions.image.jpegxl.data.Entropy;
import com.idrsolutions.image.jpegxl.data.Frame;
import com.idrsolutions.image.jpegxl.data.GlobalModular;
import com.idrsolutions.image.jpegxl.data.HFBlock;
import com.idrsolutions.image.jpegxl.data.LFChannel;
import com.idrsolutions.image.jpegxl.data.Patch;
import com.idrsolutions.image.jpegxl.data.Quant;
import com.idrsolutions.image.jpegxl.data.SplinesGroup;
import java.io.IOException;

class LFGlobal {
    final Frame frame;
    final Patch[] patches;
    final SplinesGroup splines;
    final NoiseInfo noiseInfo;
    final float[] lfDequant = new float[]{2.4414062E-4f, 0.001953125f, 0.00390625f};
    final Quant quantizer;
    final HFBlock hfBlockCtx;
    final LFChannel lfChanCorr;
    final GlobalModular gModular;

    LFGlobal(BitXL reader, Frame parent) throws IOException {
        this.frame = parent;
        if ((this.frame.getFrameHeader().flags & 2L) != 0L) {
            Entropy stream = new Entropy(reader, 10);
            int numPatches = stream.readSymbol(reader, 0);
            this.patches = new Patch[numPatches];
            for (int i = 0; i < numPatches; ++i) {
                this.patches[i] = new Patch(stream, reader, parent.globalMetadata.getExtraChannelCount(), parent.globalMetadata.getNumAlphaChannels());
            }
        } else {
            this.patches = new Patch[0];
        }
        this.splines = (this.frame.getFrameHeader().flags & 0x10L) != 0L ? new SplinesGroup(reader) : null;
        this.noiseInfo = (this.frame.getFrameHeader().flags & 1L) != 0L ? new NoiseInfo(reader) : null;
        if (!reader.bool()) {
            for (int i = 0; i < 3; ++i) {
                this.lfDequant[i] = reader.f16() * 0.0078125f;
            }
        }
        if (this.frame.getFrameHeader().encoding == 0) {
            this.quantizer = new Quant(reader, this.lfDequant);
            this.hfBlockCtx = new HFBlock(reader);
            this.lfChanCorr = new LFChannel(reader);
        } else {
            this.quantizer = null;
            this.hfBlockCtx = null;
            this.lfChanCorr = new LFChannel();
        }
        this.gModular = new GlobalModular(reader, this.frame);
    }

    static class NoiseInfo {
        final float[] lut = new float[8];

        NoiseInfo(BitXL reader) throws IOException {
            for (int i = 0; i < this.lut.length; ++i) {
                this.lut[i] = (float)reader.u(10) / 1024.0f;
            }
        }
    }
}

