/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpegxl.data;

class JXLXor {
    private final long[] state0 = new long[8];
    private final long[] state1 = new long[8];
    private final long[] batch = new long[8];
    private int batchPos;

    private static long splitMix64(long z) {
        z = (z ^ z >>> 30) * -4658895280553007687L;
        z = (z ^ z >>> 27) * -7723592293110705685L;
        return z ^ z >>> 31;
    }

    JXLXor(long s0, long s1) {
        this.state0[0] = JXLXor.splitMix64(s0 + -7046029254386353131L);
        this.state1[0] = JXLXor.splitMix64(s1 + -7046029254386353131L);
        for (int i = 1; i < 8; ++i) {
            this.state0[i] = JXLXor.splitMix64(this.state0[i - 1]);
            this.state1[i] = JXLXor.splitMix64(this.state1[i - 1]);
        }
    }

    long nextLong() {
        this.fillBatch();
        return this.batch[this.batchPos++];
    }

    void fill(int[] bits) {
        for (int i = 0; i < bits.length; i += 2) {
            long l = this.nextLong();
            bits[i] = (int)(l & 0xFFFFFFFFL);
            bits[i + 1] = (int)(l >>> 32 & 0xFFFFFFFFL);
        }
    }

    private void fillBatch() {
        if (this.batchPos < this.batch.length) {
            return;
        }
        for (int i = 0; i < this.batch.length; ++i) {
            long a = this.state1[i];
            long b = this.state0[i];
            this.batch[i] = a + b;
            this.state0[i] = a;
            b ^= b << 23;
            this.state1[i] = b ^ a ^ b >>> 18 ^ a >>> 5;
        }
        this.batchPos = 0;
    }
}

