/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpegxl.data;

import com.idrsolutions.image.jpegxl.data.FifoStream;
import com.idrsolutions.image.jpegxl.data.UtilXL;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.function.Supplier;

class JXLSupplier
implements Supplier<byte[]> {
    private static final byte[] CONTAINER_SIGNATURE = new byte[]{0, 0, 0, 12, 74, 88, 76, 32, 13, 10, -121, 10};
    private static final int JXLC = (int)JXLSupplier.makeTag(new byte[]{106, 120, 108, 99});
    private static final int JXLP = (int)JXLSupplier.makeTag(new byte[]{106, 120, 108, 112});
    private static final int JXLL = (int)JXLSupplier.makeTag(new byte[]{106, 120, 108, 108});
    private final FifoStream in;
    private int level = 5;
    private boolean foundSignature;
    private long posInBox;
    private long boxSize;
    private boolean container;

    private static long makeTag(byte[] tagArray, int length) {
        long tag = 0L;
        for (int i = 0; i < length; ++i) {
            tag = tag << 8 | (long)(tagArray[i] & 0xFF);
        }
        return tag;
    }

    private static long makeTag(byte[] tagArray) {
        return JXLSupplier.makeTag(tagArray, tagArray.length);
    }

    JXLSupplier(InputStream in) {
        this.in = new FifoStream(in);
    }

    int getLevel() {
        return this.level;
    }

    void pushBack(byte[] buffer) {
        this.in.push(buffer);
    }

    private byte[] containerSupply() throws IOException {
        block14: {
            byte[] boxSizeArray = new byte[8];
            byte[] boxTag = new byte[4];
            while (true) {
                int c;
                if ((c = UtilXL.readFully(this.in, boxSizeArray, 0, 4)) != 0) {
                    if (c < 4) {
                        throw new IOException("invalid jpeg xl box size");
                    }
                    return new byte[0];
                }
                this.boxSize = JXLSupplier.makeTag(boxSizeArray, 4);
                if (this.boxSize == 1L) {
                    if (UtilXL.readFully(this.in, boxSizeArray, 0, 8) != 0) {
                        throw new IOException("invalid jpeg xl extended size");
                    }
                    this.boxSize = JXLSupplier.makeTag(boxSizeArray, 8);
                    if (this.boxSize > 0L) {
                        this.boxSize -= 8L;
                    }
                }
                if (this.boxSize > 0L) {
                    this.boxSize -= 8L;
                }
                if (this.boxSize < 0L) {
                    throw new IOException("Illegal box size");
                }
                if (UtilXL.readFully(this.in, boxTag) != 0) {
                    throw new IOException("invalid jpeg xl box tag");
                }
                int tag = (int)JXLSupplier.makeTag(boxTag);
                if (tag == JXLL) {
                    int l = this.in.read();
                    if (l != 5 && l != 10) {
                        throw new IOException("invalid jpeg xl level");
                    }
                    this.level = l;
                    continue;
                }
                if (tag == JXLP) {
                    if (UtilXL.readFully(this.in, boxTag) != 0) {
                        throw new IOException("Invalid jpeg xl sequence number");
                    }
                    this.boxSize -= 4L;
                }
                if (tag == JXLP || tag == JXLC) {
                    this.posInBox = 0L;
                    return this.getData();
                }
                if (this.boxSize <= 0L) break block14;
                long s = UtilXL.skipFully(this.in, this.boxSize);
                if (s != 0L) break;
            }
            throw new IOException("Invalid jpeg xl extra box");
        }
        return this.getData();
    }

    public byte[] getData() throws IOException {
        if (!this.foundSignature) {
            byte[] signature = new byte[12];
            int remaining = UtilXL.readFully(this.in, signature);
            this.foundSignature = true;
            if (!Arrays.equals(signature, CONTAINER_SIGNATURE)) {
                if (remaining != 0) {
                    byte[] buf = new byte[signature.length - remaining];
                    System.arraycopy(signature, 0, buf, 0, buf.length);
                    signature = buf;
                }
                this.boxSize = 0L;
                this.posInBox = signature.length;
                this.container = false;
                return signature;
            }
            this.boxSize = 12L;
            this.posInBox = 12L;
            this.container = true;
        }
        if (!this.container || this.boxSize > 0L && this.posInBox < this.boxSize || this.boxSize == 0L) {
            int len = 4096;
            if (this.boxSize > 0L && this.boxSize - this.posInBox < (long)len) {
                len = (int)Math.min(Integer.MAX_VALUE, this.boxSize - this.posInBox);
            }
            byte[] buf = new byte[len];
            int remaining = UtilXL.readFully(this.in, buf);
            this.posInBox += (long)(len - remaining);
            if (remaining > 0) {
                if (remaining == len) {
                    return new byte[0];
                }
                byte[] b2 = new byte[len - remaining];
                System.arraycopy(buf, 0, b2, 0, b2.length);
                buf = b2;
            }
            return buf;
        }
        return this.containerSupply();
    }

    @Override
    public byte[] get() {
        try {
            return this.getData();
        }
        catch (IOException ex) {
            return new byte[0];
        }
    }
}

