/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpegxl.data;

import com.idrsolutions.image.jpegxl.data.MathXL;

class IntXL {
    final int x;
    final int y;
    static final IntXL ZERO = new IntXL();

    static IntXL coordinates(int index, int rowStride) {
        return new IntXL(index % rowStride, index / rowStride);
    }

    static IntXL sizeOf(float[][] array) {
        return array.length == 0 ? new IntXL() : new IntXL(array[0].length, array.length);
    }

    IntXL(int x, int y) {
        this.x = x;
        this.y = y;
    }

    IntXL(int dim) {
        this(dim, dim);
    }

    IntXL(IntXL p) {
        this(p.x, p.y);
    }

    IntXL() {
        this(0, 0);
    }

    IntXL plus(IntXL p) {
        return new IntXL(this.x + p.x, this.y + p.y);
    }

    IntXL minus(IntXL p) {
        return new IntXL(this.x - p.x, this.y - p.y);
    }

    IntXL times(IntXL p) {
        return new IntXL(this.x * p.x, this.y * p.y);
    }

    IntXL times(int factor) {
        return new IntXL(this.x * factor, this.y * factor);
    }

    IntXL ceilDiv(int factor) {
        return new IntXL(MathXL.ceilDiv(this.x, factor), MathXL.ceilDiv(this.y, factor));
    }

    IntXL transpose() {
        return new IntXL(this.y, this.x);
    }

    IntXL toLeft(int hshift, int vshift) {
        int x = this.x << hshift;
        int y = this.y << vshift;
        return new IntXL(x, y);
    }

    IntXL toLeft(int shift) {
        return this.toLeft(shift, shift);
    }

    IntXL toRight(int hshift, int vshift) {
        int x = this.x >> hshift;
        int y = this.y >> vshift;
        return new IntXL(x, y);
    }

    IntXL toRight(int shift) {
        return this.toRight(shift, shift);
    }

    IntXL toRight(IntXL shift) {
        return this.toRight(shift.x, shift.y);
    }

    int unwrapCoord(int rowStride) {
        return this.y * rowStride + this.x;
    }

    IntXL min(IntXL p) {
        return new IntXL(Math.min(this.x, p.x), Math.min(this.y, p.y));
    }

    IntXL max(IntXL p) {
        return new IntXL(Math.max(this.x, p.x), Math.max(this.y, p.y));
    }
}

