/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpegxl.data;

import com.idrsolutions.image.jpegxl.data.BitXL;
import com.idrsolutions.image.jpegxl.data.Entropy;
import com.idrsolutions.image.jpegxl.data.Frame;
import com.idrsolutions.image.jpegxl.data.ITX;
import com.idrsolutions.image.jpegxl.data.IntXL;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.stream.Stream;
import org.jpedal.utils.LogWriter;

class HFPass {
    private static final int[][] naturalOrderX = new int[13][];
    private static final int[][] naturalOrderY = new int[13][];
    final int usedOrders;
    final IntXL[][][] order = new IntXL[13][3][];
    final Entropy contextStream;

    HFPass(BitXL reader, Frame frame) throws IOException {
        this.usedOrders = reader.u32(95, 0, 19, 0, 0, 0, 0, 13);
        Entropy stream = this.usedOrders != 0 ? new Entropy(reader, 8) : null;
        for (int b = 0; b < 13; ++b) {
            for (int c = 0; c < 3; ++c) {
                this.order[b][c] = new IntXL[naturalOrderX[b].length];
                if ((this.usedOrders & 1 << b) != 0) {
                    int[] perm = Frame.readPermutation(reader, stream, this.order[b][c].length, this.order[b][c].length / 64);
                    for (int i = 0; i < this.order[b][c].length; ++i) {
                        int x = naturalOrderX[b][perm[i]];
                        int y = naturalOrderY[b][perm[i]];
                        this.order[b][c][i] = new IntXL(x, y);
                    }
                    continue;
                }
                for (int i = 0; i < this.order[b][c].length; ++i) {
                    int x = naturalOrderX[b][i];
                    int y = naturalOrderY[b][i];
                    this.order[b][c][i] = new IntXL(x, y);
                }
            }
        }
        int numContexts = 495 * frame.getHFGlobal().numHfPresets * frame.getLFGlobal().hfBlockCtx.numClusters;
        this.contextStream = new Entropy(reader, numContexts);
    }

    static {
        try (InputStream fis = HFPass.class.getResourceAsStream("/com/idrsolutions/image/res/XLN.B64");){
            int nRead;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[4096];
            while ((nRead = fis.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            data = buffer.toByteArray();
            data = Base64.getDecoder().decode(data);
            ByteArrayInputStream bis = new ByteArrayInputStream(data);
            for (int i = 0; i < 13; ++i) {
                int j;
                int index = i;
                ITX tt = Stream.of(ITX.values()).filter(t -> t.orderID == index && !t.isVertical()).findAny().get();
                int len = tt.blockH * tt.blockW;
                HFPass.naturalOrderX[index] = new int[len];
                HFPass.naturalOrderY[index] = new int[len];
                HFPass.naturalOrderX[index][0] = bis.read();
                for (j = 1; j < len; ++j) {
                    HFPass.naturalOrderX[index][j] = bis.read() + naturalOrderX[index][j - 1] & 0xFF;
                }
                HFPass.naturalOrderY[index][0] = bis.read();
                for (j = 1; j < len; ++j) {
                    HFPass.naturalOrderY[index][j] = bis.read() + naturalOrderY[index][j - 1] & 0xFF;
                }
            }
        }
        catch (Exception ioe) {
            LogWriter.writeLog("Jpeg xl error reading passes");
        }
    }
}

