/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpegxl.data;

import com.idrsolutions.image.jpegxl.data.BitXL;
import com.idrsolutions.image.jpegxl.data.Frame;
import com.idrsolutions.image.jpegxl.data.ITX;
import com.idrsolutions.image.jpegxl.data.IntXL;
import com.idrsolutions.image.jpegxl.data.LFGroup;
import com.idrsolutions.image.jpegxl.data.MathXL;
import com.idrsolutions.image.jpegxl.data.ModularInfo;
import com.idrsolutions.image.jpegxl.data.ModularStream;
import com.idrsolutions.image.jpegxl.data.VBlock;
import java.io.IOException;
import java.util.Arrays;

class HFMetadata {
    final int nbBlocks;
    final ITX[][] dctSelect;
    final IntXL[] blockList;
    final VBlock[][] blockMap;
    final int[][] hfMultiplier;
    final int[][][] hfStreamBuffer;
    final LFGroup parent;

    HFMetadata(BitXL reader, LFGroup parent, Frame frame) throws IOException {
        this.parent = parent;
        IntXL size = frame.getLFGroupSize(parent.lfGroupID).toRight(3);
        int n = MathXL.ceilLog2((long)size.x * (long)size.y);
        this.nbBlocks = 1 + reader.u(n);
        IntXL aFromYSize = size.ceilDiv(8);
        ModularInfo xFromY = new ModularInfo(aFromYSize.x, aFromYSize.y, 0, 0);
        ModularInfo bFromY = new ModularInfo(aFromYSize.x, aFromYSize.y, 0, 0);
        ModularInfo blockInfo = new ModularInfo(this.nbBlocks, 2, 0, 0);
        ModularInfo sharpness = new ModularInfo(size.x, size.y, 0, 0);
        ModularStream hfStream = new ModularStream(reader, frame, 1 + 2 * frame.getNumLFGroups() + parent.lfGroupID, new ModularInfo[]{xFromY, bFromY, blockInfo, sharpness});
        hfStream.decodeChannels(reader);
        this.hfStreamBuffer = hfStream.getDecodedBuffer();
        this.dctSelect = new ITX[size.y][size.x];
        this.hfMultiplier = new int[size.y][size.x];
        this.blockList = new IntXL[this.nbBlocks];
        this.blockMap = new VBlock[size.y][size.x];
        int[][] blockInfoBuffer = this.hfStreamBuffer[2];
        IntXL lastBlock = new IntXL();
        ITX[] tta = ITX.values();
        for (int i = 0; i < this.nbBlocks; ++i) {
            int type = blockInfoBuffer[0][i];
            ITX tt = tta[type];
            IntXL pos = this.placeBlock(lastBlock, tt, 1 + blockInfoBuffer[1][i]);
            if (pos == null) continue;
            lastBlock = pos;
            this.blockList[i] = pos;
            VBlock varblock = new VBlock(parent, pos);
            for (int y = 0; y < tt.dctH; ++y) {
                Arrays.fill(this.blockMap[y + pos.y], pos.x, pos.x + tt.dctW, varblock);
            }
        }
    }

    private IntXL placeBlock(IntXL lastBlock, ITX block, int mul) {
        int x = lastBlock.x;
        for (int y = lastBlock.y; y < this.dctSelect.length; ++y) {
            ITX[] dctY = this.dctSelect[y];
            while (x < dctY.length && block.dctW + x <= dctY.length) {
                block4: {
                    for (int ix = 0; ix < block.dctW; ++ix) {
                        ITX tt = dctY[x + ix];
                        if (tt == null) continue;
                        x += tt.dctW - 1;
                        break block4;
                    }
                    IntXL pos = new IntXL(x, y);
                    this.hfMultiplier[y][x] = mul;
                    for (int iy = 0; iy < block.dctH; ++iy) {
                        Arrays.fill((Object[])this.dctSelect[y + iy], x, x + block.dctW, (Object)block);
                    }
                    return pos;
                }
                ++x;
            }
            x = 0;
        }
        return null;
    }

    VBlock getVBlock(int n) {
        IntXL block = this.blockList[n];
        return this.blockMap[block.y][block.x];
    }
}

