/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpegxl.data;

import com.idrsolutions.image.jpegxl.data.BitXL;
import com.idrsolutions.image.jpegxl.data.Frame;
import com.idrsolutions.image.jpegxl.data.HeaderFrame;
import com.idrsolutions.image.jpegxl.data.MTree;
import com.idrsolutions.image.jpegxl.data.ModularStream;
import java.io.IOException;

class GlobalModular {
    final MTree tree;
    final Frame frame;
    final ModularStream stream;

    GlobalModular(BitXL reader, Frame parent) throws IOException {
        this.frame = parent;
        boolean hasGlobalTree = reader.bool();
        this.tree = hasGlobalTree ? new MTree(reader) : null;
        this.frame.setGlobalTree(this.tree);
        int subModularChannelCount = this.frame.globalMetadata.getExtraChannelCount();
        HeaderFrame header = this.frame.getFrameHeader();
        int ecStart = 0;
        if (header.encoding == 1) {
            ecStart = !header.doYCbCr && !this.frame.globalMetadata.isXYBEncoded() && this.frame.globalMetadata.getColorEncoding().colorEncoding == 1 ? 1 : 3;
        }
        this.stream = new ModularStream(reader, parent, 0, subModularChannelCount += ecStart, ecStart);
        this.stream.decodeChannels(reader, true);
    }
}

