/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpegxl.data;

import com.idrsolutions.image.jpegxl.data.BitXL;
import com.idrsolutions.image.jpegxl.data.Configure;
import com.idrsolutions.image.jpegxl.data.Entropy;
import com.idrsolutions.image.jpegxl.data.ExFunction;
import com.idrsolutions.image.jpegxl.data.FunctionalHelper;
import com.idrsolutions.image.jpegxl.data.HFGlobal;
import com.idrsolutions.image.jpegxl.data.HFPass;
import com.idrsolutions.image.jpegxl.data.HeaderFrame;
import com.idrsolutions.image.jpegxl.data.HeaderImage;
import com.idrsolutions.image.jpegxl.data.HelperXL;
import com.idrsolutions.image.jpegxl.data.ITX;
import com.idrsolutions.image.jpegxl.data.IntXL;
import com.idrsolutions.image.jpegxl.data.JXLXor;
import com.idrsolutions.image.jpegxl.data.LFGlobal;
import com.idrsolutions.image.jpegxl.data.LFGroup;
import com.idrsolutions.image.jpegxl.data.MTree;
import com.idrsolutions.image.jpegxl.data.MathXL;
import com.idrsolutions.image.jpegxl.data.ModularChannel;
import com.idrsolutions.image.jpegxl.data.ModularInfo;
import com.idrsolutions.image.jpegxl.data.Pass;
import com.idrsolutions.image.jpegxl.data.PassGroup;
import com.idrsolutions.image.jpegxl.data.Spline;
import com.idrsolutions.image.jpegxl.data.TaskList;
import com.idrsolutions.image.jpegxl.data.VBlock;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.IntUnaryOperator;

class Frame {
    static final int[] cMap = new int[]{1, 0, 2};
    private static final IntXL[] epfCross = new IntXL[]{IntXL.ZERO, new IntXL(0, 1), new IntXL(1, 0), new IntXL(-1, 0), new IntXL(0, -1)};
    private static final IntXL[] epfDoubleCross = new IntXL[]{IntXL.ZERO, new IntXL(-1, 0), new IntXL(0, -1), new IntXL(1, 0), new IntXL(0, 1), new IntXL(1, -1), new IntXL(1, 1), new IntXL(-1, -1), new IntXL(-1, 1), new IntXL(2, 0), new IntXL(0, 2), new IntXL(-2, 0), new IntXL(-2, 2)};
    private static float[][] laplacian;
    private final BitXL globalReader;
    private HeaderFrame header;
    private int numGroups;
    private int numLFGroups;
    private CompletableFuture<byte[]>[] buffers;
    private int[] tocPermuation;
    private int[] tocLengths;
    private LFGlobal lfGlobal;
    final HeaderImage globalMetadata;
    float[][][] buffer;
    float[][][] noiseBuffer;
    private Pass[] passes;
    private boolean decoded;
    private HFGlobal hfGlobal;
    private LFGroup[] lfGroups;
    private int groupRowStride;
    private int lfGroupRowStride;
    private MTree globalTree;
    private int width;
    private int height;
    private final HelperXL flowHelper;
    private final Configure options;

    Frame(BitXL reader, HeaderImage globalMetadata, HelperXL flowHelper, Configure options) {
        this.globalReader = reader;
        this.globalMetadata = globalMetadata;
        this.flowHelper = flowHelper;
        this.options = options;
    }

    private void readHeader() throws IOException {
        this.globalReader.zeroPadToByte();
        this.header = new HeaderFrame(this.globalReader, this.globalMetadata);
        this.width = this.header.width;
        this.height = this.header.height;
        this.width = MathXL.ceilDiv(this.width, this.header.upsampling);
        this.height = MathXL.ceilDiv(this.height, this.header.upsampling);
        this.width = MathXL.ceilDiv(this.width, 1 << 3 * this.header.lfLevel);
        this.height = MathXL.ceilDiv(this.height, 1 << 3 * this.header.lfLevel);
        this.groupRowStride = MathXL.ceilDiv(this.width, this.header.groupDim);
        this.lfGroupRowStride = MathXL.ceilDiv(this.width, this.header.groupDim << 3);
        this.numGroups = this.groupRowStride * MathXL.ceilDiv(this.height, this.header.groupDim);
        this.numLFGroups = this.lfGroupRowStride * MathXL.ceilDiv(this.height, this.header.groupDim << 3);
        this.readTOC();
    }

    HeaderFrame readFrameHeader() throws IOException {
        this.readHeader();
        return this.header;
    }

    HeaderFrame getFrameHeader() {
        return this.header;
    }

    void skipFrameData() throws IOException {
        for (int tocLength : this.tocLengths) {
            this.globalReader.skipBits((long)tocLength << 3);
        }
    }

    private void readTOC() throws IOException {
        int i;
        int tocEntries = this.numGroups == 1 && this.header.passes.numPasses == 1 ? 1 : 1 + this.numLFGroups + 1 + this.numGroups * this.header.passes.numPasses;
        boolean permutedTOC = this.globalReader.bool();
        if (permutedTOC) {
            Entropy tocStream = new Entropy(this.globalReader, 8);
            this.tocPermuation = Frame.readPermutation(this.globalReader, tocStream, tocEntries, 0);
        } else {
            this.tocPermuation = new int[tocEntries];
            for (int i2 = 0; i2 < tocEntries; ++i2) {
                this.tocPermuation[i2] = i2;
            }
        }
        this.globalReader.zeroPadToByte();
        this.tocLengths = new int[tocEntries];
        this.buffers = new CompletableFuture[tocEntries];
        for (i = 0; i < tocEntries; ++i) {
            this.buffers[i] = new CompletableFuture();
        }
        for (i = 0; i < tocEntries; ++i) {
            this.tocLengths[i] = this.globalReader.u32(0, 10, 1024, 14, 17408, 22, 0x404400, 30);
        }
        this.globalReader.zeroPadToByte();
        if (tocEntries != 1 && !this.options.parseOnly) {
            new Thread(() -> {
                for (int i = 0; i < tocEntries; ++i) {
                    try {
                        byte[] buffer = this.readBuffer(i);
                        this.buffers[i].complete(buffer);
                        continue;
                    }
                    catch (Throwable ex) {
                        this.buffers[i].completeExceptionally(ex);
                    }
                }
            }).start();
        }
    }

    private byte[] readBuffer(int index) throws IOException {
        int length = this.tocLengths[index];
        byte[] buffer = new byte[length + 4];
        this.globalReader.read(buffer, 0, length);
        return buffer;
    }

    private CompletableFuture<BitXL> getBitreader(int index) {
        if (this.tocLengths.length == 1) {
            return CompletableFuture.completedFuture(this.globalReader);
        }
        int permutedIndex = this.tocPermuation[index];
        return this.buffers[permutedIndex].thenApply(buff -> new BitXL(new ByteArrayInputStream((byte[])buff)));
    }

    static int[] readPermutation(BitXL reader, Entropy stream, int size, int skip) throws IOException {
        IntUnaryOperator ctx = x -> Math.min(7, MathXL.ceilLog1p(x));
        int end = stream.readSymbol(reader, ctx.applyAsInt(size));
        int[] lehmer = new int[size];
        for (int i = skip; i < end + skip; ++i) {
            lehmer[i] = stream.readSymbol(reader, ctx.applyAsInt(i > skip ? lehmer[i - 1] : 0));
        }
        LinkedList<Integer> temp = new LinkedList<Integer>();
        int[] permutation = new int[size];
        for (int i = 0; i < size; ++i) {
            temp.add(i);
        }
        for (int i = 0; i < size; ++i) {
            int index = lehmer[i];
            permutation[i] = (Integer)temp.remove(index);
        }
        return permutation;
    }

    private float[][] doUpsampling(float[][] buffer, int c) {
        int color = this.getColorChannelCount();
        int k = c < color ? this.header.upsampling : this.header.ecUpsampling[c - color];
        if (k == 1) {
            return buffer;
        }
        int l = MathXL.ceilLog1p(k - 1) - 1;
        float[][][][] upWeights = this.globalMetadata.getUpWeights()[l];
        float[][] newBuffer = new float[buffer.length * k][];
        for (int y = 0; y < buffer.length; ++y) {
            for (int ky = 0; ky < k; ++ky) {
                newBuffer[y * k + ky] = new float[buffer[y].length * k];
                for (int x = 0; x < buffer[y].length; ++x) {
                    for (int kx = 0; kx < k; ++kx) {
                        float[][] weights = upWeights[ky][kx];
                        float total = 0.0f;
                        float min = Float.MAX_VALUE;
                        float max = Float.MIN_VALUE;
                        for (int iy = 0; iy < 5; ++iy) {
                            for (int ix = 0; ix < 5; ++ix) {
                                int newX;
                                int newY = MathXL.mirror(y + iy - 2, buffer.length);
                                float sample = buffer[newY][newX = MathXL.mirror(x + ix - 2, buffer[newY].length)];
                                if (sample < min) {
                                    min = sample;
                                }
                                if (sample > max) {
                                    max = sample;
                                }
                                total += weights[iy][ix] * sample;
                            }
                        }
                        newBuffer[y * k + ky][x * k + kx] = MathXL.clamp(total, min, max);
                    }
                }
            }
        }
        return newBuffer;
    }

    private void decodeLFGroups(float[][][] lfBuffer) throws IOException {
        int lfGroupID;
        ArrayList<ModularInfo> lfReplacementChannels = new ArrayList<ModularInfo>();
        ArrayList<Integer> lfReplacementChannelIndicies = new ArrayList<Integer>();
        for (int i = 0; i < this.lfGlobal.gModular.stream.getEncodedChannelCount(); ++i) {
            ModularChannel chan = this.lfGlobal.gModular.stream.getChannel(i);
            if (chan.isDecoded() || chan.hshift < 3 || chan.vshift < 3) continue;
            lfReplacementChannelIndicies.add(i);
            IntXL size = new IntXL(this.header.lfGroupDim).toRight(chan.hshift, chan.vshift);
            lfReplacementChannels.add(new ModularInfo(size.x, size.y, chan.hshift, chan.vshift));
        }
        this.lfGroups = new LFGroup[this.numLFGroups];
        for (lfGroupID = 0; lfGroupID < this.numLFGroups; ++lfGroupID) {
            BitXL reader = FunctionalHelper.join(this.getBitreader(1 + lfGroupID));
            IntXL lfGroupPos = IntXL.coordinates(lfGroupID, this.lfGroupRowStride);
            ModularInfo[] replaced = (ModularInfo[])lfReplacementChannels.stream().map(ModularInfo::new).toArray(ModularInfo[]::new);
            IntXL frameSize = this.getPaddedFrameSize();
            for (ModularInfo info : replaced) {
                IntXL shift = new IntXL(info.hshift, info.vshift);
                IntXL lfSize = frameSize.toRight(shift);
                IntXL chanSize = new IntXL(info.width, info.height);
                IntXL pos = lfGroupPos.times(chanSize);
                IntXL size = chanSize.min(lfSize.minus(pos));
                info.width = size.x;
                info.height = size.y;
                info.origin = pos;
            }
            this.lfGroups[lfGroupID] = new LFGroup(reader, this, lfGroupID, replaced, lfBuffer);
        }
        for (lfGroupID = 0; lfGroupID < this.numLFGroups; ++lfGroupID) {
            for (int j = 0; j < lfReplacementChannelIndicies.size(); ++j) {
                int index = (Integer)lfReplacementChannelIndicies.get(j);
                ModularChannel channel = this.lfGlobal.gModular.stream.getChannel(index);
                int[][] newChannel = this.lfGroups[lfGroupID].modularLFGroupBuffer[j];
                ModularInfo newChannelInfo = this.lfGroups[lfGroupID].modularLFGroupInfo[j];
                for (int y = 0; y < newChannel.length; ++y) {
                    System.arraycopy(newChannel[y], 0, channel.buffer[y + newChannelInfo.origin.y], newChannelInfo.origin.x, newChannel[y].length);
                }
            }
        }
    }

    private void decodePasses(BitXL reader) throws IOException {
        this.passes = new Pass[this.header.passes.numPasses];
        for (int pass = 0; pass < this.passes.length; ++pass) {
            this.passes[pass] = new Pass(reader, this, pass, pass > 0 ? this.passes[pass - 1].minShift : 0);
        }
    }

    private void decodePassGroups() {
        int numPasses = this.passes.length;
        PassGroup[][] passGroups = new PassGroup[numPasses][];
        TaskList<PassGroup> taskList = new TaskList<PassGroup>(this.flowHelper.getThreadPool(), numPasses);
        for (int pass : HelperXL.range(numPasses)) {
            for (int group : HelperXL.range(this.numGroups)) {
                taskList.submit(pass, this.getBitreader(2 + this.numLFGroups + pass * this.numGroups + group), reader -> {
                    ModularInfo[] replaced;
                    for (ModularInfo info : replaced = (ModularInfo[])Arrays.asList(this.passes[pass].replacedChannels).stream().filter(Objects::nonNull).map(ModularInfo::new).toArray(ModularInfo[]::new)) {
                        IntXL shift = new IntXL(info.hshift, info.vshift);
                        IntXL passGroupSize = new IntXL(this.header.groupDim).toRight(shift);
                        int rowStride = MathXL.ceilDiv(info.width, passGroupSize.x);
                        IntXL pos = IntXL.coordinates(group, rowStride).times(passGroupSize);
                        IntXL chanSize = new IntXL(info.width, info.height);
                        info.origin = pos;
                        IntXL size = passGroupSize.min(chanSize.minus(info.origin));
                        info.width = size.x;
                        info.height = size.y;
                    }
                    return new PassGroup((BitXL)reader, this, pass, group, replaced);
                });
            }
        }
        for (int pass = 0; pass < numPasses; ++pass) {
            passGroups[pass] = taskList.collect(pass).toArray(new PassGroup[0]);
            int j = 0;
            for (int i = 0; i < this.passes[pass].replacedChannels.length; ++i) {
                if (this.passes[pass].replacedChannels[i] == null) continue;
                ModularChannel channel = this.lfGlobal.gModular.stream.getChannel(i);
                for (int group = 0; group < this.numGroups; ++group) {
                    ModularInfo newChannelInfo = passGroups[pass][group].modularPassGroupInfo[j];
                    int[][] buff = passGroups[pass][group].modularPassGroupBuffer[j];
                    for (int y = 0; y < newChannelInfo.height; ++y) {
                        System.arraycopy(buff[y], 0, channel.buffer[y + newChannelInfo.origin.y], newChannelInfo.origin.x, newChannelInfo.width);
                    }
                }
                ++j;
            }
        }
        if (this.header.encoding == 0) {
            for (int pass : HelperXL.range(numPasses)) {
                for (int group : HelperXL.range(this.numGroups)) {
                    PassGroup passGroup = passGroups[pass][group];
                    PassGroup prev = pass > 0 ? passGroups[pass - 1][group] : null;
                    passGroup.invertVarDCT(this.buffer, prev);
                }
            }
        }
    }

    void decodeFrame(float[][][] lfBuffer) throws IOException {
        if (this.decoded) {
            return;
        }
        this.decoded = true;
        this.lfGlobal = (LFGlobal)FunctionalHelper.join(this.getBitreader(0).thenApplyAsync(ExFunction.of(reader -> new LFGlobal((BitXL)reader, this))));
        IntXL paddedSize = this.getPaddedFrameSize();
        this.buffer = new float[this.getColorChannelCount() + this.globalMetadata.getExtraChannelCount()][][];
        for (int c = 0; c < this.buffer.length; ++c) {
            if (c < 3 && c < this.getColorChannelCount()) {
                IntXL shiftedSize = paddedSize.toRight(this.header.jpegUpsampling[c]);
                this.buffer[c] = new float[shiftedSize.y][shiftedSize.x];
                continue;
            }
            this.buffer[c] = new float[paddedSize.y][paddedSize.x];
        }
        this.decodeLFGroups(lfBuffer);
        BitXL hfGlobalReader = FunctionalHelper.join(this.getBitreader(1 + this.numLFGroups));
        this.hfGlobal = this.header.encoding == 0 ? new HFGlobal(hfGlobalReader, this) : null;
        this.decodePasses(hfGlobalReader);
        this.decodePassGroups();
        this.lfGlobal.gModular.stream.applyTransforms();
        int[][][] modularBuffer = this.lfGlobal.gModular.stream.getDecodedBuffer();
        for (int c = 0; c < modularBuffer.length; ++c) {
            int x;
            int y;
            boolean isModularColor = this.header.encoding == 1 && c < this.getColorChannelCount();
            boolean isModularXYB = this.globalMetadata.isXYBEncoded() && isModularColor;
            int cOut = (isModularXYB ? cMap[c] : c) + this.buffer.length - modularBuffer.length;
            int ecIndex = c - (this.header.encoding == 1 ? this.globalMetadata.getColorChannelCount() : 0);
            float scaleFactor = isModularXYB ? this.lfGlobal.lfDequant[cOut] : (isModularColor && this.globalMetadata.getBitDepthHeader().expBits != 0 ? 1.0f : (isModularColor ? 1.0f / (float)(-1L << this.globalMetadata.getBitDepthHeader().bitsPerSample ^ 0xFFFFFFFFFFFFFFFFL) : (this.globalMetadata.getExtraChannel((int)ecIndex).bitDepth.expBits != 0 ? 1.0f : 1.0f / (float)(-1L << this.globalMetadata.getExtraChannel((int)ecIndex).bitDepth.bitsPerSample ^ 0xFFFFFFFFFFFFFFFFL))));
            if (isModularXYB && c == 2) {
                for (y = 0; y < this.height; ++y) {
                    for (x = 0; x < this.width; ++x) {
                        this.buffer[cOut][y][x] = scaleFactor * (float)(modularBuffer[0][y][x] + modularBuffer[2][y][x]);
                    }
                }
                continue;
            }
            for (y = 0; y < this.height; ++y) {
                for (x = 0; x < this.width; ++x) {
                    this.buffer[cOut][y][x] = scaleFactor * (float)modularBuffer[c][y][x];
                }
            }
        }
        this.invertSubsampling();
        if (this.header.restorationFilter.gab) {
            this.performGabConvolution();
        }
        if (this.header.restorationFilter.epfIterations > 0) {
            this.performEdgePreservingFilter();
        }
    }

    void drawVarblocks() {
        for (LFGroup lfg : this.lfGroups) {
            IntXL pixelPosInFrame = this.getLFGroupXY(lfg.lfGroupID).toLeft(11);
            for (int i = 0; i < lfg.hfMetadata.blockList.length; ++i) {
                VBlock varblock = lfg.hfMetadata.getVBlock(i);
                ITX tt = varblock.transformType();
                float hue = (float)tt.type * MathXL.PHI_BAR % 1.0f * 2.0f * (float)Math.PI;
                float rFactor = ((float)Math.cos(hue) + 0.5f) / 1.5f;
                float gFactor = ((float)Math.cos(hue - 2.0943952f) + 1.0f) / 2.0f;
                float bFactor = ((float)Math.cos(hue - 4.1887903f) + 1.0f) / 2.0f;
                IntXL corner = varblock.pixelPosInLFGroup.plus(pixelPosInFrame);
                IntXL size = varblock.sizeInPixels();
                for (int y = 0; y < size.y; ++y) {
                    for (int x = 0; x < size.x; ++x) {
                        float sampleR = this.buffer[0][y + corner.y][x + corner.x];
                        float sampleG = this.buffer[1][y + corner.y][x + corner.x];
                        float sampleB = this.buffer[2][y + corner.y][x + corner.x];
                        if (x == 0 || y == 0) {
                            this.buffer[1][y + corner.y][x + corner.x] = 0.0f;
                            this.buffer[0][y + corner.y][x + corner.x] = 0.0f;
                            this.buffer[2][y + corner.y][x + corner.x] = 0.0f;
                            continue;
                        }
                        float light = 0.25f * (sampleR + sampleB) + 0.5f * sampleG;
                        light = 0.5f * ((float)Math.cbrt(light) - 0.5f) + 0.5f;
                        this.buffer[0][y + corner.y][x + corner.x] = rFactor * 0.5f + 0.5f * sampleR / light;
                        this.buffer[1][y + corner.y][x + corner.x] = gFactor * 0.5f + 0.5f * sampleG / light;
                        this.buffer[2][y + corner.y][x + corner.x] = bFactor * 0.5f + 0.5f * sampleB / light;
                    }
                }
            }
        }
    }

    private void performGabConvolution() {
        float[][] normGabW = new float[3][this.getColorChannelCount()];
        for (int c = 0; c < this.getColorChannelCount(); ++c) {
            float mult;
            float gabW1 = this.header.restorationFilter.gab1Weights[c];
            float gabW2 = this.header.restorationFilter.gab2Weights[c];
            normGabW[0][c] = mult = 1.0f / (1.0f + 4.0f * (gabW1 + gabW2));
            normGabW[1][c] = gabW1 * mult;
            normGabW[2][c] = gabW2 * mult;
        }
        for (int c : HelperXL.range(this.getColorChannelCount())) {
            float[][] buffC = this.buffer[c];
            int hh = buffC.length;
            int ww = buffC[0].length;
            float[][] newBuffer = new float[hh][ww];
            for (int y : HelperXL.range(hh)) {
                int north = MathXL.mirror(y - 1, hh);
                int south = MathXL.mirror(y + 1, hh);
                float[] buffR = buffC[y];
                float[] buffN = buffC[north];
                float[] buffS = buffC[south];
                float[] newBuffR = newBuffer[y];
                for (int x = 0; x < ww; ++x) {
                    int west = MathXL.mirror(x - 1, ww);
                    int east = MathXL.mirror(x + 1, ww);
                    float adj = buffR[west] + buffR[east] + buffN[x] + buffS[x];
                    float diag = buffN[west] + buffN[east] + buffS[west] + buffS[east];
                    newBuffR[x] = normGabW[0][c] * buffR[x] + normGabW[1][c] * adj + normGabW[2][c] * diag;
                }
            }
            this.buffer[c] = newBuffer;
        }
    }

    private void performEdgePreservingFilter() {
        float stepMultiplier = (float)(6.6 * (1.0 - (double)MathXL.SQRT_H));
        IntXL size = this.getPaddedFrameSize();
        int blockW = MathXL.ceilDiv(size.x, 8);
        int blockH = MathXL.ceilDiv(size.y, 8);
        float[][] inverseSigma = new float[blockH][blockW];
        int dimS = this.header.logLFGroupDim - 3;
        CompletableFuture[] futures = new CompletableFuture[size.y];
        if (this.header.encoding == 1) {
            float inv = 1.0f / this.header.restorationFilter.epfSigmaForModular;
            for (y = 0; y < blockH; ++y) {
                Arrays.fill(inverseSigma[y], inv);
            }
        } else {
            int y0 = 0;
            while (y0 < blockH) {
                y = y0++;
                float[] invSY = inverseSigma[y];
                int lfY = y >> dimS;
                int bY = y - (lfY << dimS);
                int lfR = lfY * this.lfGroupRowStride;
                futures[y] = CompletableFuture.runAsync(() -> {
                    for (int x = 0; x < blockW; ++x) {
                        int lfX = x >> dimS;
                        int bX = x - (lfX << dimS);
                        LFGroup lfg = this.lfGroups[lfR + lfX];
                        int hf = lfg.hfMetadata.blockMap[bY][bX].hfMult();
                        int sharpness = lfg.hfMetadata.hfStreamBuffer[3][bY][bX];
                        float sigma = (float)hf * this.header.restorationFilter.epfSharpLut[sharpness];
                        invSY[x] = 1.0f / sigma;
                    }
                });
            }
            for (int y = 0; y < blockH; ++y) {
                futures[y].join();
            }
        }
        float[][][] outputBuffer = new float[this.getColorChannelCount()][size.y][size.x];
        for (int i : HelperXL.range(3)) {
            if (i == 0 && this.header.restorationFilter.epfIterations < 3) continue;
            if (i == 2 && this.header.restorationFilter.epfIterations < 2) break;
            float sigmaScale = stepMultiplier * (i == 0 ? this.header.restorationFilter.epfPass0SigmaScale : (i == 1 ? 1.0f : this.header.restorationFilter.epfPass2SigmaScale));
            IntXL[] pc = i == 0 ? epfDoubleCross : epfCross;
            for (int y : HelperXL.range(size.y)) {
                float[] invSY = inverseSigma[y >> 3];
                futures[y] = CompletableFuture.runAsync(() -> {
                    for (int x = 0; x < size.x; ++x) {
                        int c;
                        float sumWeights = 0.0f;
                        float[] sumChannels = new float[outputBuffer.length];
                        float s = invSY[x >> 3];
                        if (s != s || s > 3.3333333f) {
                            for (c = 0; c < outputBuffer.length; ++c) {
                                outputBuffer[c][y][x] = this.buffer[c][y][x];
                            }
                            continue;
                        }
                        for (IntXL ip : pc) {
                            int nX = x + ip.x;
                            int nY = y + ip.y;
                            int mX = MathXL.mirror(nX, size.x);
                            int mY = MathXL.mirror(nY, size.y);
                            float dist = i == 2 ? this.epfDistance2(this.buffer, outputBuffer.length, x, y, nX, nY, size) : this.epfDistance1(this.buffer, outputBuffer.length, x, y, nX, nY, size);
                            float weight = this.epfWeight(sigmaScale, dist, s, x, y);
                            sumWeights += weight;
                            for (int c2 = 0; c2 < outputBuffer.length; ++c2) {
                                int n = c2;
                                sumChannels[n] = sumChannels[n] + this.buffer[c2][mY][mX] * weight;
                            }
                        }
                        for (c = 0; c < outputBuffer.length; ++c) {
                            outputBuffer[c][y][x] = sumChannels[c] / sumWeights;
                        }
                    }
                });
            }
            for (int y = 0; y < size.y; ++y) {
                futures[y].join();
            }
            for (int c = 0; c < outputBuffer.length; ++c) {
                float[][] tmp = this.buffer[c];
                this.buffer[c] = outputBuffer[c];
                outputBuffer[c] = tmp;
            }
        }
    }

    private float epfDistance1(float[][][] buffer, int colors, int basePosX, int basePosY, int distPosX, int distPosY, IntXL size) {
        float dist = 0.0f;
        for (int c = 0; c < colors; ++c) {
            float[][] buffC = buffer[c];
            float scale = this.header.restorationFilter.epfChannelScale[c];
            for (IntXL p : epfCross) {
                int pX = MathXL.mirror(basePosX + p.x, size.x);
                int pY = MathXL.mirror(basePosY + p.y, size.y);
                int dX = MathXL.mirror(distPosX + p.x, size.x);
                int dY = MathXL.mirror(distPosY + p.y, size.y);
                dist += Math.abs(buffC[pY][pX] - buffC[dY][dX]) * scale;
            }
        }
        return dist;
    }

    private float epfDistance2(float[][][] buffer, int colors, int basePosX, int basePosY, int distPosX, int distPosY, IntXL size) {
        float dist = 0.0f;
        for (int c = 0; c < colors; ++c) {
            float[][] buffC = buffer[c];
            int dX = MathXL.mirror(distPosX, size.x);
            int dY = MathXL.mirror(distPosY, size.y);
            dist += Math.abs(buffC[basePosY][basePosX] - buffC[dY][dX]) * this.header.restorationFilter.epfChannelScale[c];
        }
        return dist;
    }

    private float epfWeight(float stepMultiplier, float distance, float inverseSigma, int refX, int refY) {
        int modX = refX & 7;
        int modY = refY & 7;
        float dist = modX == 0 || modX == 7 || modY == 0 || modY == 7 ? distance * this.header.restorationFilter.epfBorderSadMul : distance;
        float v = 1.0f - dist * stepMultiplier * inverseSigma;
        if (v <= 0.0f) {
            return 0.0f;
        }
        return v;
    }

    private void invertSubsampling() {
        for (int c = 0; c < 3; ++c) {
            float[] oldRow;
            int y;
            float[][] newChannel;
            float[][] oldChannel;
            int xShift = this.header.jpegUpsampling[c].x;
            int yShift = this.header.jpegUpsampling[c].y;
            while (xShift-- > 0) {
                oldChannel = this.buffer[c];
                newChannel = new float[oldChannel.length][];
                for (y = 0; y < oldChannel.length; ++y) {
                    oldRow = oldChannel[y];
                    float[] newRow = new float[oldRow.length * 2];
                    for (int x = 0; x < oldRow.length; ++x) {
                        float b75 = 0.75f * oldRow[x];
                        newRow[2 * x] = b75 + 0.25f * oldRow[x == 0 ? 0 : x - 1];
                        newRow[2 * x + 1] = b75 + 0.25f * oldRow[x + 1 == oldRow.length ? oldRow.length - 1 : x + 1];
                    }
                    newChannel[y] = newRow;
                }
                this.buffer[c] = newChannel;
            }
            while (yShift-- > 0) {
                oldChannel = this.buffer[c];
                newChannel = new float[oldChannel.length * 2][];
                for (y = 0; y < oldChannel.length; ++y) {
                    oldRow = oldChannel[y];
                    float[] oldRowPrev = oldChannel[y == 0 ? 0 : y - 1];
                    float[] oldRowNext = oldChannel[y + 1 == oldChannel.length ? oldChannel.length - 1 : y + 1];
                    float[] firstNewRow = new float[oldRow.length];
                    float[] secondNewRow = new float[oldRow.length];
                    for (int x = 0; x < oldRow.length; ++x) {
                        float b75 = 0.75f * oldRow[x];
                        firstNewRow[x] = b75 + 0.25f * oldRowPrev[x];
                        secondNewRow[x] = b75 + 0.25f * oldRowNext[x];
                    }
                    newChannel[2 * y] = firstNewRow;
                    newChannel[2 * y + 1] = secondNewRow;
                }
                this.buffer[c] = newChannel;
            }
        }
    }

    void upsample() {
        for (int c = 0; c < this.buffer.length; ++c) {
            this.buffer[c] = this.doUpsampling(this.buffer[c], c);
        }
        this.width *= this.header.upsampling;
        this.height *= this.header.upsampling;
        this.header.origin = this.header.origin.times(this.header.upsampling);
    }

    void renderSplines() {
        if (this.lfGlobal.splines == null) {
            return;
        }
        for (int s = 0; s < this.lfGlobal.splines.numSplines; ++s) {
            Spline spline = new Spline(this.lfGlobal.splines.points[s]);
            spline.renderSpline(this);
        }
    }

    void initializeNoise(long s0) {
        if (this.lfGlobal.noiseInfo == null) {
            return;
        }
        int rowStride = MathXL.ceilDiv(this.header.width, this.header.groupDim);
        float[][][] localNoiseBuffer = new float[3][this.header.height][this.header.width];
        int numGroups = rowStride * MathXL.ceilDiv(this.header.height, this.header.groupDim);
        for (int group = 0; group < numGroups; ++group) {
            IntXL groupXYUp = IntXL.coordinates(group, rowStride).times(this.header.upsampling);
            for (int iy = 0; iy < this.header.upsampling; ++iy) {
                for (int ix = 0; ix < this.header.upsampling; ++ix) {
                    int x0 = (groupXYUp.x + ix) * this.header.groupDim;
                    int y0 = (groupXYUp.y + iy) * this.header.groupDim;
                    Frame.readNoiseGroup(this.header, s0, localNoiseBuffer, x0, y0);
                }
            }
        }
        if (laplacian == null) {
            laplacian = new float[5][5];
            for (int i = 0; i < 5; ++i) {
                for (int j = 0; j < 5; ++j) {
                    Frame.laplacian[i][j] = i == 2 && j == 2 ? -3.84f : 0.16f;
                }
            }
        }
        this.noiseBuffer = new float[3][this.header.height][this.header.width];
        for (int c = 0; c < 3; ++c) {
            for (int y = 0; y < this.header.height; ++y) {
                for (int x = 0; x < this.header.width; ++x) {
                    for (int iy = 0; iy < 5; ++iy) {
                        for (int ix = 0; ix < 5; ++ix) {
                            int cy = MathXL.mirror(y + iy - 2, this.header.height);
                            int cx = MathXL.mirror(x + ix - 2, this.header.width);
                            float[] fArray = this.noiseBuffer[c][y];
                            int n = x;
                            fArray[n] = fArray[n] + localNoiseBuffer[c][cy][cx] * laplacian[iy][ix];
                        }
                    }
                }
            }
        }
    }

    void synthesizeNoise() {
        if (this.lfGlobal.noiseInfo == null) {
            return;
        }
        float[] lut = this.lfGlobal.noiseInfo.lut;
        for (int y = 0; y < this.header.height; ++y) {
            int x = 0;
            while (x < this.header.width) {
                float fracInG;
                int intInG;
                float fracInR;
                float inScaledR = 3.0f * Math.max(0.0f, this.buffer[1][y][x] + this.buffer[0][y][x]);
                float inScaledG = 3.0f * Math.max(0.0f, this.buffer[1][y][x] - this.buffer[0][y][x]);
                int intInR = inScaledR >= 7.0f ? 6 : (int)inScaledR;
                float f = fracInR = inScaledR >= 7.0f ? 1.0f : inScaledR - (float)intInR;
                if (inScaledG >= 7.0f) {
                    intInG = 6;
                    fracInG = 1.0f;
                } else {
                    intInG = (int)inScaledG;
                    fracInG = inScaledG - (float)intInG;
                }
                float sr = (lut[intInR + 1] - lut[intInR]) * fracInR + lut[intInR];
                float sg = (lut[intInG + 1] - lut[intInG]) * fracInG + lut[intInG];
                float nr = 0.22f * sr * (0.0078125f * this.noiseBuffer[0][y][x] + 0.9921875f * this.noiseBuffer[2][y][x]);
                float ng = 0.22f * sg * (0.0078125f * this.noiseBuffer[1][y][x] + 0.9921875f * this.noiseBuffer[2][y][x]);
                float nrg = nr + ng;
                float[] fArray = this.buffer[0][y];
                int n = x;
                fArray[n] = fArray[n] + (this.lfGlobal.lfChanCorr.baseX * nrg + nr - ng);
                float[] fArray2 = this.buffer[1][y];
                int n2 = x;
                fArray2[n2] = fArray2[n2] + nrg;
                float[] fArray3 = this.buffer[2][y];
                int n3 = x++;
                fArray3[n3] = fArray3[n3] + this.lfGlobal.lfChanCorr.baseB * nrg;
            }
        }
    }

    LFGlobal getLFGlobal() {
        return this.lfGlobal;
    }

    HFGlobal getHFGlobal() {
        return this.hfGlobal;
    }

    HFPass getHFPass(int index) {
        return this.passes[index].hfPass;
    }

    LFGroup getLFGroupForGroup(int group) {
        return this.lfGroups[this.groupXY(group).toRight(3).unwrapCoord(this.lfGroupRowStride)];
    }

    int getNumLFGroups() {
        return this.numLFGroups;
    }

    int getNumGroups() {
        return this.numGroups;
    }

    int getGroupRowStride() {
        return this.groupRowStride;
    }

    float[][][] getBuffer() {
        return this.buffer;
    }

    int getColorChannelCount() {
        return this.globalMetadata.isXYBEncoded() || this.header.encoding == 0 ? 3 : this.globalMetadata.getColorChannelCount();
    }

    IntXL groupXY(int group) {
        return IntXL.coordinates(group, this.groupRowStride);
    }

    IntXL getLFGroupXY(int lfGroup) {
        return IntXL.coordinates(lfGroup, this.lfGroupRowStride);
    }

    IntXL groupSize(int group) {
        IntXL groupxy = this.groupXY(group);
        IntXL paddedSize = this.getPaddedFrameSize();
        return new IntXL(Math.min(this.header.groupDim, paddedSize.x - groupxy.x * this.header.groupDim), Math.min(this.header.groupDim, paddedSize.y - groupxy.y * this.header.groupDim));
    }

    IntXL getLFGroupSize(int lfGroup) {
        IntXL lfGroupXY = this.getLFGroupXY(lfGroup);
        IntXL paddedSize = this.getPaddedFrameSize();
        return new IntXL(Math.min(this.header.lfGroupDim, paddedSize.x - lfGroupXY.x * this.header.lfGroupDim), Math.min(this.header.lfGroupDim, paddedSize.y - lfGroupXY.y * this.header.lfGroupDim));
    }

    IntXL getPaddedFrameSize() {
        if (this.header.encoding == 0) {
            return new IntXL(this.width, this.height).ceilDiv(8).times(8);
        }
        return new IntXL(this.width, this.height);
    }

    IntXL getModularFrameSize() {
        return new IntXL(this.width, this.height);
    }

    MTree getGlobalTree() {
        return this.globalTree;
    }

    void setGlobalTree(MTree tree) {
        this.globalTree = tree;
    }

    boolean isVisible() {
        return !(this.header.type != 0 && this.header.type != 3 || this.header.duration == 0 && !this.header.isLast);
    }

    float getSample(int c, int x, int y) {
        return x < this.header.origin.x || y < this.header.origin.y || x - this.header.origin.x >= this.width || y - this.header.origin.y >= this.height ? 0.0f : this.buffer[c][y - this.header.origin.y][x - this.header.origin.x];
    }

    private static void readNoiseGroup(HeaderFrame header, long s0, float[][][] noise, int x0, int y0) {
        long s1 = (long)x0 << 32 | (long)y0;
        int xSize = Math.min(header.groupDim, header.width - x0);
        int ySize = Math.min(header.groupDim, header.height - y0);
        JXLXor rng = new JXLXor(s0, s1);
        int[] bits = new int[16];
        for (int c = 0; c < 3; ++c) {
            for (int y = 0; y < ySize; ++y) {
                for (int x = 0; x < xSize; x += 16) {
                    rng.fill(bits);
                    for (int i = 0; i < 16 && x + i < xSize; ++i) {
                        int f = bits[i] >>> 9 | 0x3F800000;
                        noise[c][y0 + y][x0 + x + i] = Float.intBitsToFloat(f);
                    }
                }
            }
        }
    }
}

