/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpegxl.data;

import com.idrsolutions.image.jpegxl.data.MathXL;
import com.idrsolutions.image.jpegxl.data.UtilXL;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

class BitXL
extends InputStream {
    private final InputStream in;
    private long cache;
    private int cacheBits;
    private long bitsRead;

    public BitXL(InputStream ins) {
        this.in = ins;
    }

    @Override
    public int read(byte[] data) throws IOException {
        return this.read(data, 0, data.length);
    }

    int u(int n) throws IOException {
        int b;
        if (n == 0) {
            return 0;
        }
        if (n <= this.cacheBits) {
            int ret = (int)(this.cache & (-1L << n ^ 0xFFFFFFFFFFFFFFFFL));
            this.cacheBits -= n;
            this.cache >>>= n;
            this.bitsRead += (long)n;
            return ret;
        }
        int count = this.in.available();
        int max = (64 - this.cacheBits) / 8;
        count = count > 0 ? Math.min(count, max) : 1;
        for (int i = 0; i < count && (b = this.in.read()) >= 0; ++i) {
            this.cache |= ((long)b & 0xFFL) << this.cacheBits;
            this.cacheBits += 8;
        }
        return this.u(n);
    }

    boolean bool() throws IOException {
        return this.u(1) != 0;
    }

    int u32(int c0, int u0, int c1, int u1, int c2, int u2, int c3, int u3) throws IOException {
        int choice = this.u(2);
        int[] c = new int[]{c0, c1, c2, c3};
        int[] u = new int[]{u0, u1, u2, u3};
        return c[choice] + this.u(u[choice]);
    }

    long u64() throws IOException {
        int index = this.u(2);
        if (index == 0) {
            return 0L;
        }
        if (index == 1) {
            return 1L + (long)this.u(4);
        }
        if (index == 2) {
            return 17L + (long)this.u(8);
        }
        long value = this.u(12);
        int shift = 12;
        while (this.bool()) {
            if (shift == 60) {
                value |= (long)this.u(4) << 60;
                break;
            }
            value |= (long)this.u(8) << shift;
            shift += 8;
        }
        return value;
    }

    int readEnum() throws IOException {
        return this.u32(0, 0, 1, 0, 2, 4, 18, 6);
    }

    int u8() throws IOException {
        if (this.u(1) == 0) {
            return 0;
        }
        int n = this.u(3);
        if (n == 0) {
            return 1;
        }
        return this.u(n) + (1 << n);
    }

    float f16() throws IOException {
        int bits16 = this.u(16);
        return MathXL.float16To32(bits16);
    }

    int variant() throws IOException {
        long value = 0L;
        for (int shift = 0; shift < 63; shift += 7) {
            long b = this.u(8);
            value |= (b & 0x7FL) << shift;
            if (b <= 127L) break;
        }
        return (int)value;
    }

    boolean atEnd() throws IOException {
        try {
            this.showBits(1);
        }
        catch (EOFException eof) {
            return true;
        }
        return false;
    }

    int showBits(int bits) throws IOException {
        int n = 0;
        while (bits > 0) {
            try {
                n = this.u(bits);
                break;
            }
            catch (EOFException eof) {
                if (bits-- != 1) continue;
                throw eof;
            }
        }
        this.bitsRead -= (long)bits;
        this.cache = this.cache << bits | (long)n & (-1L << bits ^ 0xFFFFFFFFFFFFFFFFL);
        this.cacheBits += bits;
        return n;
    }

    void zeroPadToByte() throws IOException {
        int remaining = this.cacheBits % 8;
        if (remaining > 0) {
            this.u(remaining);
        }
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public long skip(long bytes) throws IOException {
        return this.skipBits(bytes << 3) >> 3;
    }

    long skipBits(long bits) throws IOException {
        if (bits == 0L) {
            return 0L;
        }
        if (bits <= (long)this.cacheBits) {
            this.cacheBits = (int)((long)this.cacheBits - bits);
            this.cache >>>= (int)bits;
            this.bitsRead += bits;
            return bits;
        }
        long cacheSave = this.cacheBits;
        this.skipBits(this.cacheBits);
        long dangler = (bits -= cacheSave) % 8L;
        long skipped = bits - dangler - 8L * UtilXL.skipFully(this.in, (bits - dangler) / 8L);
        this.bitsRead += skipped;
        this.u((int)dangler);
        return (skipped += cacheSave) + dangler;
    }

    long getBitsCount() {
        return this.bitsRead;
    }

    @Override
    public int read() throws IOException {
        try {
            return this.u(8);
        }
        catch (EOFException eof) {
            return -1;
        }
    }

    byte[] drainCache() throws IOException {
        int cacheBytes = this.cacheBits / 8;
        if (cacheBytes == 0) {
            return null;
        }
        byte[] buffer = new byte[cacheBytes];
        this.read(buffer);
        return buffer;
    }

    @Override
    public int read(byte[] buffer, int offset, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        int cacheBytes = this.cacheBits / 8;
        for (int i = 0; i < cacheBytes; ++i) {
            if (len-- < 1) {
                return i;
            }
            buffer[offset + i] = (byte)this.u(8);
        }
        int remaining = UtilXL.readFully(this.in, buffer, offset + cacheBytes, len);
        this.bitsRead += (long)(len - remaining) * 8L;
        int ret = cacheBytes + len - remaining;
        if (ret == 0) {
            return -1;
        }
        return ret;
    }
}

