/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpegxl.data;

import com.idrsolutions.image.jpegxl.data.ANS;
import com.idrsolutions.image.jpegxl.data.BitXL;
import com.idrsolutions.image.jpegxl.data.Symbols;
import com.idrsolutions.image.jpegxl.data.VLC;
import java.io.IOException;
import java.util.ArrayDeque;

class ANSSymbols
extends Symbols {
    private static final VLC kLogCountLut = new VLC(7, new int[][]{{10, 3}, {12, 7}, {7, 3}, {3, 4}, {6, 3}, {8, 3}, {9, 3}, {5, 4}, {10, 3}, {4, 4}, {7, 3}, {1, 4}, {6, 3}, {8, 3}, {9, 3}, {2, 4}, {10, 3}, {0, 5}, {7, 3}, {3, 4}, {6, 3}, {8, 3}, {9, 3}, {5, 4}, {10, 3}, {4, 4}, {7, 3}, {1, 4}, {6, 3}, {8, 3}, {9, 3}, {2, 4}, {10, 3}, {11, 6}, {7, 3}, {3, 4}, {6, 3}, {8, 3}, {9, 3}, {5, 4}, {10, 3}, {4, 4}, {7, 3}, {1, 4}, {6, 3}, {8, 3}, {9, 3}, {2, 4}, {10, 3}, {0, 5}, {7, 3}, {3, 4}, {6, 3}, {8, 3}, {9, 3}, {5, 4}, {10, 3}, {4, 4}, {7, 3}, {1, 4}, {6, 3}, {8, 3}, {9, 3}, {2, 4}, {10, 3}, {13, 7}, {7, 3}, {3, 4}, {6, 3}, {8, 3}, {9, 3}, {5, 4}, {10, 3}, {4, 4}, {7, 3}, {1, 4}, {6, 3}, {8, 3}, {9, 3}, {2, 4}, {10, 3}, {0, 5}, {7, 3}, {3, 4}, {6, 3}, {8, 3}, {9, 3}, {5, 4}, {10, 3}, {4, 4}, {7, 3}, {1, 4}, {6, 3}, {8, 3}, {9, 3}, {2, 4}, {10, 3}, {11, 6}, {7, 3}, {3, 4}, {6, 3}, {8, 3}, {9, 3}, {5, 4}, {10, 3}, {4, 4}, {7, 3}, {1, 4}, {6, 3}, {8, 3}, {9, 3}, {2, 4}, {10, 3}, {0, 5}, {7, 3}, {3, 4}, {6, 3}, {8, 3}, {9, 3}, {5, 4}, {10, 3}, {4, 4}, {7, 3}, {1, 4}, {6, 3}, {8, 3}, {9, 3}, {2, 4}});
    private final int[] frequencies;
    private int[] cutoffs;
    private int[] symbols;
    private int[] offsets;

    ANSSymbols(BitXL reader, int logAlphabetSize) throws IOException {
        this.logAlphabetSize = logAlphabetSize;
        int uniqPos = -1;
        if (reader.bool()) {
            if (reader.bool()) {
                int v1 = reader.u8();
                int v2 = reader.u8();
                this.alphabetSize = 1 + Math.max(v1, v2);
                this.frequencies = new int[this.alphabetSize];
                this.frequencies[v1] = reader.u(12);
                this.frequencies[v2] = 4096 - this.frequencies[v1];
                if (this.frequencies[v1] == 0) {
                    uniqPos = v2;
                }
            } else {
                int x = reader.u8();
                this.alphabetSize = 1 + x;
                this.frequencies = new int[this.alphabetSize];
                this.frequencies[x] = 4096;
                uniqPos = x;
            }
        } else if (reader.bool()) {
            int i;
            this.alphabetSize = 1 + reader.u8();
            if (this.alphabetSize == 1) {
                uniqPos = 0;
            }
            this.frequencies = new int[this.alphabetSize];
            for (i = 0; i < this.alphabetSize; ++i) {
                this.frequencies[i] = 4096 / this.alphabetSize;
            }
            i = 0;
            while (i < 4096 % this.alphabetSize) {
                int n = i++;
                this.frequencies[n] = this.frequencies[n] + 1;
            }
        } else {
            int len;
            for (len = 0; len < 3 && reader.bool(); ++len) {
            }
            int shift = (reader.u(len) | 1 << len) - 1;
            this.alphabetSize = 3 + reader.u8();
            this.frequencies = new int[this.alphabetSize];
            int[] logCounts = new int[this.alphabetSize];
            int[] same = new int[this.alphabetSize];
            int omitLog = -1;
            int omitPos = -1;
            for (int i = 0; i < this.alphabetSize; ++i) {
                logCounts[i] = kLogCountLut.getVLC(reader);
                if (logCounts[i] == 13) {
                    int rle = reader.u8();
                    same[i] = rle + 5;
                    i += rle + 3;
                    continue;
                }
                if (logCounts[i] <= omitLog) continue;
                omitLog = logCounts[i];
                omitPos = i;
            }
            int totalCount = 0;
            int numSame = 0;
            int prev = 0;
            for (int i = 0; i < this.alphabetSize; ++i) {
                if (same[i] != 0) {
                    numSame = same[i] - 1;
                    int n = prev = i > 0 ? this.frequencies[i - 1] : 0;
                }
                if (numSame != 0) {
                    this.frequencies[i] = prev;
                    --numSame;
                } else {
                    if (i == omitPos || logCounts[i] == 0) continue;
                    if (logCounts[i] == 1) {
                        this.frequencies[i] = 1;
                    } else {
                        int bitcount = shift - (12 - logCounts[i] + 1 >> 1);
                        if (bitcount < 0) {
                            bitcount = 0;
                        }
                        if (bitcount > logCounts[i] - 1) {
                            bitcount = logCounts[i] - 1;
                        }
                        this.frequencies[i] = (1 << logCounts[i] - 1) + (reader.u(bitcount) << logCounts[i] - 1 - bitcount);
                    }
                }
                totalCount += this.frequencies[i];
            }
            this.frequencies[omitPos] = 4096 - totalCount;
        }
        this.generateAliasMapping(uniqPos);
    }

    @Override
    public int readSymbol(BitXL reader, ANS stateObj) throws IOException {
        int offset;
        int state = stateObj.hasState ? stateObj.state : reader.u(32);
        int index = state & 0xFFF;
        int pos = index & (1 << this.logBucketSize) - 1;
        int i = index >>> this.logBucketSize;
        boolean greater = pos >= this.cutoffs[i];
        int symbol = greater ? this.symbols[i] : i;
        if (((state = this.frequencies[symbol] * (state >>> 12) + (offset = greater ? this.offsets[i] + pos : pos)) & 0xFFFF0000) == 0) {
            state = state << 16 | reader.u(16);
        }
        stateObj.state = state;
        stateObj.hasState = true;
        return symbol;
    }

    private void generateAliasMapping(int uniqPos) {
        int i;
        this.logBucketSize = 12 - this.logAlphabetSize;
        ArrayDeque<Integer> overfull = new ArrayDeque<Integer>();
        ArrayDeque<Integer> underfull = new ArrayDeque<Integer>();
        int bucketSize = 1 << this.logBucketSize;
        int tableSize = 1 << this.logAlphabetSize;
        this.symbols = new int[tableSize];
        this.cutoffs = new int[tableSize];
        this.offsets = new int[tableSize];
        if (uniqPos >= 0) {
            for (int i2 = 0; i2 < tableSize; ++i2) {
                this.symbols[i2] = uniqPos;
                this.offsets[i2] = i2 * bucketSize;
                this.cutoffs[i2] = 0;
            }
            return;
        }
        for (i = 0; i < this.alphabetSize; ++i) {
            this.cutoffs[i] = this.frequencies[i];
            if (this.cutoffs[i] > bucketSize) {
                overfull.addFirst(i);
                continue;
            }
            if (this.cutoffs[i] >= bucketSize) continue;
            underfull.addFirst(i);
        }
        for (i = this.alphabetSize; i < tableSize; ++i) {
            underfull.addFirst(i);
        }
        while (!overfull.isEmpty()) {
            int u = (Integer)underfull.removeFirst();
            int o = (Integer)overfull.removeFirst();
            int by = bucketSize - this.cutoffs[u];
            int n = o;
            this.cutoffs[n] = this.cutoffs[n] - by;
            this.symbols[u] = o;
            this.offsets[u] = this.cutoffs[o];
            if (this.cutoffs[o] < bucketSize) {
                underfull.addFirst(o);
                continue;
            }
            if (this.cutoffs[o] <= bucketSize) continue;
            overfull.addFirst(o);
        }
        for (i = 0; i < tableSize; ++i) {
            if (this.cutoffs[i] == bucketSize) {
                this.symbols[i] = i;
                this.offsets[i] = 0;
                this.cutoffs[i] = 0;
                continue;
            }
            int n = i;
            this.offsets[n] = this.offsets[n] - this.cutoffs[i];
        }
    }
}

