/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpeg2000.data;

import com.idrsolutions.image.jpeg2000.data.CodeBlock;
import com.idrsolutions.image.jpeg2000.data.Info;
import com.idrsolutions.image.jpeg2000.data.Packet;
import com.idrsolutions.image.jpeg2000.data.Progression;
import com.idrsolutions.image.jpeg2000.data.SIZ;
import com.idrsolutions.image.jpeg2000.data.Tile;
import com.idrsolutions.image.jpeg2000.data.TileBand;
import com.idrsolutions.image.jpeg2000.data.TileComponent;
import com.idrsolutions.image.jpeg2000.data.TileResolution;

public class LRCP
implements Progression {
    private final int layersCount;
    private final int componentsCount;
    private final int maxNL;
    private final Tile tile;
    private int c;
    private int r;
    private int l;
    private int p;

    public LRCP(Info info, int tileIndex) {
        SIZ siz = info.siz;
        this.tile = info.tilesMap.get(tileIndex);
        this.layersCount = this.tile.cod.nLayers;
        this.componentsCount = siz.Csiz;
        this.maxNL = this.tile.cod.nDecompLevel;
    }

    @Override
    public Packet getNextPacket() {
        while (this.l < this.layersCount) {
            while (this.r <= this.maxNL) {
                while (this.c < this.componentsCount) {
                    TileComponent component = this.tile.components.get(this.c);
                    TileResolution resolution = component.resolutions.get(this.r);
                    int numprecincts = resolution.precinctInfo.numPrecincts;
                    if (this.p < numprecincts) {
                        Packet pack = this.createPacket(resolution, this.p, this.l);
                        ++this.p;
                        return pack;
                    }
                    this.p = 0;
                    ++this.c;
                }
                this.c = 0;
                ++this.r;
            }
            this.r = 0;
            ++this.l;
        }
        return null;
    }

    @Override
    public Packet createPacket(TileResolution resolution, int precintNumber, int layerNumber) {
        Packet packet = new Packet();
        packet.layerNumber = layerNumber;
        for (TileBand subband : resolution.tileBands) {
            for (CodeBlock codeBlock : subband.codeBlocks) {
                if (codeBlock.precinctNumber != precintNumber) continue;
                packet.codeBlocks.add(codeBlock);
            }
        }
        return packet;
    }
}

