/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.heic.common;

import com.idrsolutions.image.heic.common.HImg;
import com.idrsolutions.image.utility.Access;
import com.idrsolutions.image.utility.PixGet;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;

final class YuvDisplay {
    private YuvDisplay() {
    }

    static BufferedImage fromMonoGray(int w, int h, int[] luma) {
        BufferedImage res = new BufferedImage(w, h, 10);
        byte[] pixelsByte = ((DataBufferByte)res.getRaster().getDataBuffer()).getData();
        for (int i = 0; i < luma.length; ++i) {
            pixelsByte[i] = (byte)luma[i];
        }
        return res;
    }

    static BufferedImage fromYUV444(HImg img) {
        int[] luma = img.getImagePlane(0);
        int[] chroma1 = img.getImagePlane(1);
        int[] chroma2 = img.getImagePlane(2);
        int w = img.getWidth(0);
        int h = img.getHeight(0);
        BufferedImage res = new BufferedImage(w, h, 5);
        byte[] pixelsByte = ((DataBufferByte)res.getRaster().getDataBuffer()).getData();
        int p = 0;
        for (int i = 0; i < luma.length; ++i) {
            int y = ((luma[i] & 0xFF) << 8) + 128;
            int u = (chroma1[i] & 0xFF) - 128;
            int v = (chroma2[i] & 0xFF) - 128;
            int r = y + 359 * v >> 8;
            int g = y - 88 * u - 183 * v >> 8;
            int b = y + 454 * u >> 8;
            r = Math.max(0, Math.min(255, r));
            g = Math.max(0, Math.min(255, g));
            b = Math.max(0, Math.min(255, b));
            pixelsByte[p++] = (byte)b;
            pixelsByte[p++] = (byte)g;
            pixelsByte[p++] = (byte)r;
        }
        return res;
    }

    static BufferedImage fromYUV420(HImg img) {
        int[] luma = img.getImagePlane(0);
        int[] chroma1 = img.getImagePlane(1);
        int[] chroma2 = img.getImagePlane(2);
        int w = img.getWidth(0);
        int h = img.getHeight(0);
        int cw = img.getWidth(1);
        BufferedImage res = new BufferedImage(w, h, 5);
        byte[] pixelsByte = ((DataBufferByte)res.getRaster().getDataBuffer()).getData();
        int p = 0;
        int c = 0;
        int l = 0;
        for (int hh = 0; hh < h; ++hh) {
            int cStart = (hh >> 1) * cw;
            for (int ww = 0; ww < w; ++ww) {
                c = cStart + (ww >> 1);
                int y = ((luma[l++] & 0xFF) << 8) + 128;
                int u = (chroma1[c] & 0xFF) - 128;
                int v = (chroma2[c] & 0xFF) - 128;
                int r = y + 359 * v >> 8;
                int g = y - 88 * u - 183 * v >> 8;
                int b = y + 454 * u >> 8;
                r = Math.max(0, Math.min(255, r));
                g = Math.max(0, Math.min(255, g));
                b = Math.max(0, Math.min(255, b));
                pixelsByte[p++] = (byte)b;
                pixelsByte[p++] = (byte)g;
                pixelsByte[p++] = (byte)r;
            }
        }
        return res;
    }

    static void getAsYUV420(BufferedImage bImg, HImg hImg) {
        int b;
        int g;
        int r;
        int p;
        int x;
        int y;
        int h = hImg.Height;
        int w = hImg.Width;
        int bw = bImg.getWidth();
        int bh = bImg.getHeight();
        byte[] planY = hImg.planesBytes[0];
        byte[] planCB = hImg.planesBytes[1];
        byte[] planCR = hImg.planesBytes[2];
        PixGet pg = Access.getPixGet(bImg);
        int strideY = w;
        int strideC = hImg.ChromaW;
        for (y = 0; y < h; ++y) {
            for (x = 0; x < w; ++x) {
                if (x >= bw || y >= bh) continue;
                p = pg.getRGB(x, y);
                r = p >> 16 & 0xFF;
                g = p >> 8 & 0xFF;
                b = p & 0xFF;
                planY[y * strideY + x] = (byte)((128 + 77 * r + 150 * g + 29 * b >> 8) - 128);
            }
        }
        for (y = 0; y < h; y += 2) {
            for (x = 0; x < w; x += 2) {
                if (x >= bw || y >= bh) continue;
                p = pg.getRGB(x, y);
                r = p >> 16 & 0xFF;
                g = p >> 8 & 0xFF;
                b = p & 0xFF;
                p = y / 2 * strideC + x / 2;
                planCB[p] = (byte)(128 + 127 * b - 84 * g - 43 * r >> 8);
                planCR[p] = (byte)(128 + 127 * r - 106 * g - 21 * b >> 8);
            }
        }
        pg = null;
    }

    static BufferedImage fromYUV422(HImg img) {
        int[] luma = img.getImagePlane(0);
        int[] chroma1 = img.getImagePlane(1);
        int[] chroma2 = img.getImagePlane(2);
        int w = img.getWidth(0);
        int h = img.getHeight(0);
        int cw = img.getWidth(1);
        BufferedImage res = new BufferedImage(w, h, 5);
        byte[] pixelsByte = ((DataBufferByte)res.getRaster().getDataBuffer()).getData();
        int p = 0;
        int l = 0;
        for (int hh = 0; hh < h; ++hh) {
            int cStart = hh * cw;
            for (int ww = 0; ww < w; ++ww) {
                int c = cStart + (ww >> 1);
                int y = luma[l++];
                int u = chroma1[c];
                int v = chroma2[c];
                int r = (int)((double)y + 1.402 * (double)(v - 128));
                int g = (int)((double)y - 0.34414 * (double)(u - 128) - 0.71414 * (double)(v - 128));
                int b = (int)((double)y + 1.772 * (double)(u - 128));
                r = Math.max(0, Math.min(255, r));
                g = Math.max(0, Math.min(255, g));
                b = Math.max(0, Math.min(255, b));
                pixelsByte[p++] = (byte)b;
                pixelsByte[p++] = (byte)g;
                pixelsByte[p++] = (byte)r;
            }
        }
        return res;
    }
}

