/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.heic.common;

import com.idrsolutions.image.heic.common.HeicMath;

final class Transform {
    private static final int[] DST4 = new int[]{29, 55, 74, 84, 74, 74, 0, -74, 84, -29, -74, 55, 55, -84, 74, -29};
    private static final int[] DCT4 = new int[]{64, 64, 64, 64, 83, 36, -36, -83, 64, -64, -64, 64, 36, -83, 83, -36};
    private static final int[] DCT8 = new int[]{64, 64, 64, 64, 64, 64, 64, 64, 89, 75, 50, 18, -18, -50, -75, -89, 83, 36, -36, -83, -83, -36, 36, 83, 75, -18, -89, -50, 50, 89, 18, -75, 64, -64, -64, 64, 64, -64, -64, 64, 50, -89, 18, 75, -75, -18, 89, -50, 36, -83, 83, -36, -36, 83, -83, 36, 18, -50, 75, -89, 89, -75, 50, -18};
    private static final int[] DCT16 = new int[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 90, 87, 80, 70, 57, 43, 25, 9, -9, -25, -43, -57, -70, -80, -87, -90, 89, 75, 50, 18, -18, -50, -75, -89, -89, -75, -50, -18, 18, 50, 75, 89, 87, 57, 9, -43, -80, -90, -70, -25, 25, 70, 90, 80, 43, -9, -57, -87, 83, 36, -36, -83, -83, -36, 36, 83, 83, 36, -36, -83, -83, -36, 36, 83, 80, 9, -70, -87, -25, 57, 90, 43, -43, -90, -57, 25, 87, 70, -9, -80, 75, -18, -89, -50, 50, 89, 18, -75, -75, 18, 89, 50, -50, -89, -18, 75, 70, -43, -87, 9, 90, 25, -80, -57, 57, 80, -25, -90, -9, 87, 43, -70, 64, -64, -64, 64, 64, -64, -64, 64, 64, -64, -64, 64, 64, -64, -64, 64, 57, -80, -25, 90, -9, -87, 43, 70, -70, -43, 87, 9, -90, 25, 80, -57, 50, -89, 18, 75, -75, -18, 89, -50, -50, 89, -18, -75, 75, 18, -89, 50, 43, -90, 57, 25, -87, 70, 9, -80, 80, -9, -70, 87, -25, -57, 90, -43, 36, -83, 83, -36, -36, 83, -83, 36, 36, -83, 83, -36, -36, 83, -83, 36, 25, -70, 90, -80, 43, 9, -57, 87, -87, 57, -9, -43, 80, -90, 70, -25, 18, -50, 75, -89, 89, -75, 50, -18, -18, 50, -75, 89, -89, 75, -50, 18, 9, -25, 43, -57, 70, -80, 87, -90, 90, -87, 80, -70, 57, -43, 25, -9};
    private static final int[] DCT32 = new int[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 90, 90, 88, 85, 82, 78, 73, 67, 61, 54, 46, 38, 31, 22, 13, 4, -4, -13, -22, -31, -38, -46, -54, -61, -67, -73, -78, -82, -85, -88, -90, -90, 90, 87, 80, 70, 57, 43, 25, 9, -9, -25, -43, -57, -70, -80, -87, -90, -90, -87, -80, -70, -57, -43, -25, -9, 9, 25, 43, 57, 70, 80, 87, 90, 90, 82, 67, 46, 22, -4, -31, -54, -73, -85, -90, -88, -78, -61, -38, -13, 13, 38, 61, 78, 88, 90, 85, 73, 54, 31, 4, -22, -46, -67, -82, -90, 89, 75, 50, 18, -18, -50, -75, -89, -89, -75, -50, -18, 18, 50, 75, 89, 89, 75, 50, 18, -18, -50, -75, -89, -89, -75, -50, -18, 18, 50, 75, 89, 88, 67, 31, -13, -54, -82, -90, -78, -46, -4, 38, 73, 90, 85, 61, 22, -22, -61, -85, -90, -73, -38, 4, 46, 78, 90, 82, 54, 13, -31, -67, -88, 87, 57, 9, -43, -80, -90, -70, -25, 25, 70, 90, 80, 43, -9, -57, -87, -87, -57, -9, 43, 80, 90, 70, 25, -25, -70, -90, -80, -43, 9, 57, 87, 85, 46, -13, -67, -90, -73, -22, 38, 82, 88, 54, -4, -61, -90, -78, -31, 31, 78, 90, 61, 4, -54, -88, -82, -38, 22, 73, 90, 67, 13, -46, -85, 83, 36, -36, -83, -83, -36, 36, 83, 83, 36, -36, -83, -83, -36, 36, 83, 83, 36, -36, -83, -83, -36, 36, 83, 83, 36, -36, -83, -83, -36, 36, 83, 82, 22, -54, -90, -61, 13, 78, 85, 31, -46, -90, -67, 4, 73, 88, 38, -38, -88, -73, -4, 67, 90, 46, -31, -85, -78, -13, 61, 90, 54, -22, -82, 80, 9, -70, -87, -25, 57, 90, 43, -43, -90, -57, 25, 87, 70, -9, -80, -80, -9, 70, 87, 25, -57, -90, -43, 43, 90, 57, -25, -87, -70, 9, 80, 78, -4, -82, -73, 13, 85, 67, -22, -88, -61, 31, 90, 54, -38, -90, -46, 46, 90, 38, -54, -90, -31, 61, 88, 22, -67, -85, -13, 73, 82, 4, -78, 75, -18, -89, -50, 50, 89, 18, -75, -75, 18, 89, 50, -50, -89, -18, 75, 75, -18, -89, -50, 50, 89, 18, -75, -75, 18, 89, 50, -50, -89, -18, 75, 73, -31, -90, -22, 78, 67, -38, -90, -13, 82, 61, -46, -88, -4, 85, 54, -54, -85, 4, 88, 46, -61, -82, 13, 90, 38, -67, -78, 22, 90, 31, -73, 70, -43, -87, 9, 90, 25, -80, -57, 57, 80, -25, -90, -9, 87, 43, -70, -70, 43, 87, -9, -90, -25, 80, 57, -57, -80, 25, 90, 9, -87, -43, 70, 67, -54, -78, 38, 85, -22, -90, 4, 90, 13, -88, -31, 82, 46, -73, -61, 61, 73, -46, -82, 31, 88, -13, -90, -4, 90, 22, -85, -38, 78, 54, -67, 64, -64, -64, 64, 64, -64, -64, 64, 64, -64, -64, 64, 64, -64, -64, 64, 64, -64, -64, 64, 64, -64, -64, 64, 64, -64, -64, 64, 64, -64, -64, 64, 61, -73, -46, 82, 31, -88, -13, 90, -4, -90, 22, 85, -38, -78, 54, 67, -67, -54, 78, 38, -85, -22, 90, 4, -90, 13, 88, -31, -82, 46, 73, -61, 57, -80, -25, 90, -9, -87, 43, 70, -70, -43, 87, 9, -90, 25, 80, -57, -57, 80, 25, -90, 9, 87, -43, -70, 70, 43, -87, -9, 90, -25, -80, 57, 54, -85, -4, 88, -46, -61, 82, 13, -90, 38, 67, -78, -22, 90, -31, -73, 73, 31, -90, 22, 78, -67, -38, 90, -13, -82, 61, 46, -88, 4, 85, -54, 50, -89, 18, 75, -75, -18, 89, -50, -50, 89, -18, -75, 75, 18, -89, 50, 50, -89, 18, 75, -75, -18, 89, -50, -50, 89, -18, -75, 75, 18, -89, 50, 46, -90, 38, 54, -90, 31, 61, -88, 22, 67, -85, 13, 73, -82, 4, 78, -78, -4, 82, -73, -13, 85, -67, -22, 88, -61, -31, 90, -54, -38, 90, -46, 43, -90, 57, 25, -87, 70, 9, -80, 80, -9, -70, 87, -25, -57, 90, -43, -43, 90, -57, -25, 87, -70, -9, 80, -80, 9, 70, -87, 25, 57, -90, 43, 38, -88, 73, -4, -67, 90, -46, -31, 85, -78, 13, 61, -90, 54, 22, -82, 82, -22, -54, 90, -61, -13, 78, -85, 31, 46, -90, 67, 4, -73, 88, -38, 36, -83, 83, -36, -36, 83, -83, 36, 36, -83, 83, -36, -36, 83, -83, 36, 36, -83, 83, -36, -36, 83, -83, 36, 36, -83, 83, -36, -36, 83, -83, 36, 31, -78, 90, -61, 4, 54, -88, 82, -38, -22, 73, -90, 67, -13, -46, 85, -85, 46, 13, -67, 90, -73, 22, 38, -82, 88, -54, -4, 61, -90, 78, -31, 25, -70, 90, -80, 43, 9, -57, 87, -87, 57, -9, -43, 80, -90, 70, -25, -25, 70, -90, 80, -43, -9, 57, -87, 87, -57, 9, 43, -80, 90, -70, 25, 22, -61, 85, -90, 73, -38, -4, 46, -78, 90, -82, 54, -13, -31, 67, -88, 88, -67, 31, 13, -54, 82, -90, 78, -46, 4, 38, -73, 90, -85, 61, -22, 18, -50, 75, -89, 89, -75, 50, -18, -18, 50, -75, 89, -89, 75, -50, 18, 18, -50, 75, -89, 89, -75, 50, -18, -18, 50, -75, 89, -89, 75, -50, 18, 13, -38, 61, -78, 88, -90, 85, -73, 54, -31, 4, 22, -46, 67, -82, 90, -90, 82, -67, 46, -22, -4, 31, -54, 73, -85, 90, -88, 78, -61, 38, -13, 9, -25, 43, -57, 70, -80, 87, -90, 90, -87, 80, -70, 57, -43, 25, -9, -9, 25, -43, 57, -70, 80, -87, 90, -90, 87, -80, 70, -57, 43, -25, 9, 4, -13, 22, -31, 38, -46, 54, -61, 67, -73, 78, -82, 85, -88, 90, -90, 90, -90, 88, -85, 82, -78, 73, -67, 61, -54, 46, -38, 31, -22, 13, -4};
    static final int[] LEVELSCALE = new int[]{40, 45, 51, 57, 64, 72};
    private static final int[] TAB_22 = new int[]{29, 30, 31, 32, 33, 33, 34, 34, 35, 35, 36, 36, 37};
    private static final int MAX_TR_DYNAMIC_RANGE = 15;
    private static final int QUANT_SHIFT = 14;
    private static final int[] G_QUANTSCALES = new int[]{26214, 23302, 20560, 18396, 16384, 14564};

    static void quantCoefficients(int[] output, int[] input, int log2TrSize, int qp, boolean intra) {
        int qpDiv6 = qp / 6;
        int qpMod6 = qp % 6;
        int uiQ = G_QUANTSCALES[qpMod6];
        int bitDepth = 8;
        int transformShift = 7 - log2TrSize;
        int qBits = 14 + qpDiv6 + transformShift;
        int rnd = (intra ? 171 : 85) << qBits - 9;
        int nStride = 1 << log2TrSize;
        for (int y = 0; y < nStride; ++y) {
            for (int x = 0; x < nStride; ++x) {
                int blockPos = y * nStride + x;
                int level = input[blockPos];
                int sign = level < 0 ? -1 : 1;
                level = Math.abs(level) * uiQ + rnd >> qBits;
                output[blockPos] = HeicMath.clip3(Short.MIN_VALUE, Short.MAX_VALUE, level *= sign);
            }
        }
    }

    private Transform() {
    }

    static int tab22(int qPi) {
        if (qPi < 30) {
            return qPi;
        }
        if (qPi >= 43) {
            return qPi - 6;
        }
        return TAB_22[qPi - 30];
    }

    static void skipReisidual(int[] residual, int[] coeffs, int nT, int tsShift, int bdShift) {
        int rnd = 1 << bdShift - 1;
        for (int y = 0; y < nT; ++y) {
            for (int x = 0; x < nT; ++x) {
                int c = coeffs[x + y * nT] << tsShift;
                residual[x + y * nT] = c + rnd >> bdShift;
            }
        }
    }

    static void bypass_rdpcm_v(int[] dst, int[] coeffs, int nT) {
        for (int x = 0; x < nT; ++x) {
            int sum = 0;
            for (int y = 0; y < nT; ++y) {
                dst[y * nT + x] = sum += coeffs[x + y * nT];
            }
        }
    }

    static void bypass_rdpcm_h(int[] dst, int[] coeffs, int nT) {
        for (int y = 0; y < nT; ++y) {
            int sum = 0;
            for (int x = 0; x < nT; ++x) {
                dst[y * nT + x] = sum += coeffs[x + y * nT];
            }
        }
    }

    static void rdpcm_v(int[] residual, int[] coeffs, int nT, int tsShift, int bdShift) {
        int rnd = 1 << bdShift - 1;
        for (int x = 0; x < nT; ++x) {
            int sum = 0;
            for (int y = 0; y < nT; ++y) {
                int c = coeffs[x + y * nT] << tsShift;
                residual[y * nT + x] = sum += c + rnd >> bdShift;
            }
        }
    }

    static void rdpcm_h(int[] residual, int[] coeffs, int nT, int tsShift, int bdShift) {
        int rnd = 1 << bdShift - 1;
        for (int y = 0; y < nT; ++y) {
            int sum = 0;
            for (int x = 0; x < nT; ++x) {
                int c = coeffs[x + y * nT] << tsShift;
                residual[y * nT + x] = sum += c + rnd >> bdShift;
            }
        }
    }

    static void bypass(int[] dst, int[] coeffs, int nT) {
        for (int y = 0; y < nT; ++y) {
            for (int x = 0; x < nT; ++x) {
                int c;
                dst[y * nT + x] = c = coeffs[x + y * nT];
            }
        }
    }

    static void rotate(int[] coeff, int nT) {
        for (int y = 0; y < nT / 2; ++y) {
            for (int x = 0; x < nT; ++x) {
                int temp = coeff[y * nT + x];
                coeff[y * nT + x] = coeff[(nT - 1 - y) * nT + nT - 1 - x];
                coeff[(nT - 1 - y) * nT + nT - 1 - x] = temp;
            }
        }
    }

    static void addResidual(int[] dst, int dOffset, int stride, int[] r, int nT, int bit_depth) {
        for (int y = 0; y < nT; ++y) {
            for (int x = 0; x < nT; ++x) {
                dst[dOffset + y * stride + x] = HeicMath.clipBitDepth(dst[dOffset + y * stride + x] + r[y * nT + x], bit_depth);
            }
        }
    }

    static void transformDST(int[] dst, int dOffset, int[] coeffs, int[] g, int dstStride, int bitDepth) {
        int sum;
        int d;
        int c;
        int b;
        int a;
        int y;
        int postShift = 20 - bitDepth;
        int rndV = 64;
        int rndH = 1 << postShift - 1;
        for (y = 0; y < 4; ++y) {
            a = coeffs[y];
            b = coeffs[y + 4];
            c = coeffs[y + 8];
            d = coeffs[y + 12];
            sum = 29 * a + 74 * b + 84 * c + 55 * d;
            g[y] = HeicMath.clip3(Short.MIN_VALUE, Short.MAX_VALUE, sum + 64 >> 7);
            sum = 55 * a + 74 * b - 29 * c - 84 * d;
            g[4 + y] = HeicMath.clip3(Short.MIN_VALUE, Short.MAX_VALUE, sum + 64 >> 7);
            sum = 74 * a - 74 * c + 74 * d;
            g[8 + y] = HeicMath.clip3(Short.MIN_VALUE, Short.MAX_VALUE, sum + 64 >> 7);
            sum = 84 * a - 74 * b + 55 * c - 29 * d;
            g[12 + y] = HeicMath.clip3(Short.MIN_VALUE, Short.MAX_VALUE, sum + 64 >> 7);
        }
        for (y = 0; y < 4; ++y) {
            int y4 = y << 2;
            a = g[y4];
            b = g[y4 + 1];
            c = g[y4 + 2];
            d = g[y4 + 3];
            int ds = dOffset + y * dstStride;
            sum = 29 * a + 74 * b + 84 * c + 55 * d;
            int out = HeicMath.clip3(Short.MIN_VALUE, Short.MAX_VALUE, sum + rndH >> postShift);
            dst[ds] = HeicMath.clipBitDepth(dst[ds] + out, bitDepth);
            sum = 55 * a + 74 * b - 29 * c - 84 * d;
            out = HeicMath.clip3(Short.MIN_VALUE, Short.MAX_VALUE, sum + rndH >> postShift);
            dst[ds + 1] = HeicMath.clipBitDepth(dst[ds + 1] + out, bitDepth);
            sum = 74 * a - 74 * c + 74 * d;
            out = HeicMath.clip3(Short.MIN_VALUE, Short.MAX_VALUE, sum + rndH >> postShift);
            dst[ds + 2] = HeicMath.clipBitDepth(dst[ds + 2] + out, bitDepth);
            sum = 84 * a - 74 * b + 55 * c - 29 * d;
            out = HeicMath.clip3(Short.MIN_VALUE, Short.MAX_VALUE, sum + rndH >> postShift);
            dst[ds + 3] = HeicMath.clipBitDepth(dst[ds + 3] + out, bitDepth);
        }
    }

    static void transform_idct_add(int[] dst, int[] coeffs, int nT, int bdShift, int max_coeff_bits) {
        int j;
        int sum;
        int i;
        int lastCol;
        int rnd1 = 64;
        int rnd2 = 1 << bdShift - 1;
        int[] g = new int[1024];
        int CoeffMax = (1 << max_coeff_bits) - 1;
        int CoeffMin = -(1 << max_coeff_bits);
        int[] dct = DCT4;
        switch (nT) {
            case 8: {
                dct = DCT8;
                break;
            }
            case 16: {
                dct = DCT16;
                break;
            }
            case 32: {
                dct = DCT32;
            }
        }
        for (int c = 0; c < nT; ++c) {
            for (lastCol = nT - 1; lastCol >= 0 && coeffs[c + lastCol * nT] == 0; --lastCol) {
            }
            for (i = 0; i < nT; ++i) {
                sum = 0;
                for (j = 0; j <= lastCol; ++j) {
                    sum += dct[j * nT + i] * coeffs[c + j * nT];
                }
                g[c + i * nT] = HeicMath.clip3(CoeffMin, CoeffMax, sum + 64 >> 7);
            }
        }
        for (int y = 0; y < nT; ++y) {
            for (lastCol = nT - 1; lastCol >= 0 && g[y * nT + lastCol] == 0; --lastCol) {
            }
            for (i = 0; i < nT; ++i) {
                sum = 0;
                for (j = 0; j <= lastCol; ++j) {
                    sum += dct[j * nT + i] * g[y * nT + j];
                }
                dst[y * nT + i] = sum + rnd2 >> bdShift;
            }
        }
    }

    static void transformDCT(int[] dst, int dstOffset, int stride, int[] coeffs, int[] g, int nT, int bit_depth) {
        int j;
        int sum;
        int i;
        int lastCol;
        int postShift = 20 - bit_depth;
        int rnd1 = 64;
        int rnd2 = 1 << postShift - 1;
        int[] dct = DCT4;
        switch (nT) {
            case 8: {
                dct = DCT8;
                break;
            }
            case 16: {
                dct = DCT16;
                break;
            }
            case 32: {
                dct = DCT32;
            }
        }
        for (int c = 0; c < nT; ++c) {
            for (lastCol = nT - 1; lastCol >= 0 && coeffs[c + lastCol * nT] == 0; --lastCol) {
            }
            for (i = 0; i < nT; ++i) {
                sum = 0;
                for (j = 0; j <= lastCol; ++j) {
                    sum += dct[j * nT + i] * coeffs[c + j * nT];
                }
                g[c + i * nT] = HeicMath.clip3(Short.MIN_VALUE, Short.MAX_VALUE, sum + 64 >> 7);
            }
        }
        for (int y = 0; y < nT; ++y) {
            int ds = dstOffset + y * stride;
            for (lastCol = nT - 1; lastCol >= 0 && g[y * nT + lastCol] == 0; --lastCol) {
            }
            for (i = 0; i < nT; ++i) {
                sum = 0;
                for (j = 0; j <= lastCol; ++j) {
                    sum += dct[j * nT + i] * g[y * nT + j];
                }
                int out = sum + rnd2 >> postShift;
                dst[ds + i] = HeicMath.clipBitDepth(dst[ds + i] + out, bit_depth);
            }
        }
    }

    static void transform_idst_4x4(int[] dst, int[] coeffs, int bdShift, int max_coeff_bits) {
        int j;
        int sum;
        int i;
        int[][] g = new int[4][4];
        int rndV = 64;
        int rndH = 1 << bdShift - 1;
        int CoeffMax = (1 << max_coeff_bits) - 1;
        int CoeffMin = -(1 << max_coeff_bits);
        for (int c = 0; c < 4; ++c) {
            for (i = 0; i < 4; ++i) {
                sum = 0;
                for (j = 0; j < 4; ++j) {
                    sum += DST4[j * 4 + i] * coeffs[c + j * 4];
                }
                g[i][c] = HeicMath.clip3(CoeffMin, CoeffMax, sum + 64 >> 7);
            }
        }
        for (int y = 0; y < 4; ++y) {
            for (i = 0; i < 4; ++i) {
                sum = 0;
                for (j = 0; j < 4; ++j) {
                    sum += DST4[j * 4 + i] * g[y][j];
                }
                dst[y * 4 + i] = sum + rndH >> bdShift;
            }
        }
    }

    static void fdct(int[] coeffs, int[] input, int nT, int[] g) {
        int out;
        int j;
        int sum;
        int i;
        int[] dct = DCT4;
        switch (nT) {
            case 8: {
                dct = DCT8;
                break;
            }
            case 16: {
                dct = DCT16;
                break;
            }
            case 32: {
                dct = DCT32;
            }
        }
        int BitDepth = 8;
        int shift1 = HeicMath.log2(nT) + 6 + 8 - 15;
        int shift2 = HeicMath.log2(nT) + 6;
        int rnd1 = 1 << shift1 - 1;
        int rnd2 = 1 << shift2 - 1;
        for (int c = 0; c < nT; ++c) {
            for (i = 0; i < nT; ++i) {
                sum = 0;
                for (j = 0; j < nT; ++j) {
                    sum += dct[i * nT + j] * input[c + j * nT];
                }
                out = sum + rnd1 >> shift1;
                g[c + i * nT] = HeicMath.clip3(Short.MIN_VALUE, Short.MAX_VALUE, out);
            }
        }
        for (int y = 0; y < nT; ++y) {
            for (i = 0; i < nT; ++i) {
                sum = 0;
                for (j = 0; j < nT; ++j) {
                    sum += dct[i * nT + j] * g[y * nT + j];
                }
                out = sum + rnd2 >> shift2;
                coeffs[y * nT + i] = HeicMath.clip3(Short.MIN_VALUE, Short.MAX_VALUE, out);
            }
        }
    }

    static void fdst(int[] coeffs, int[] input, int stride, int[] g) {
        int j;
        int sum;
        int i;
        int BD = 8;
        int shift1 = HeicMath.log2(4) + 8 - 9;
        int shift2 = HeicMath.log2(4) + 6;
        int rnd1 = 1 << shift1 - 1;
        int rnd2 = 1 << shift2 - 1;
        for (int c = 0; c < 4; ++c) {
            for (i = 0; i < 4; ++i) {
                sum = 0;
                for (j = 0; j < 4; ++j) {
                    sum += DST4[i * 4 + j] * input[c + j * stride];
                }
                g[c + 4 * i] = HeicMath.clip3(Short.MIN_VALUE, Short.MAX_VALUE, sum + rnd1 >> shift1);
            }
        }
        for (int y = 0; y < 4; ++y) {
            for (i = 0; i < 4; ++i) {
                int out;
                sum = 0;
                for (j = 0; j < 4; ++j) {
                    sum += DST4[i * 4 + j] * g[y * 4 + j];
                }
                coeffs[y * 4 + i] = out = sum + rnd2 >> shift2;
            }
        }
    }

    static void dequantCoefficients(int[] out_coeff, int[] in_coeff, int log2TrSize, int qP) {
        boolean m_x_y = true;
        int bitDepth = 8;
        int bdShift = 8 + log2TrSize - 5;
        int offset = 1 << (bdShift -= 4) - 1;
        int fact = 1 * LEVELSCALE[qP % 6] << qP / 6;
        int nC = 1 << (log2TrSize << 1);
        for (int i = 0; i < nC; ++i) {
            int currCoeff = in_coeff[i];
            out_coeff[i] = currCoeff = HeicMath.clip3(Short.MIN_VALUE, Short.MAX_VALUE, currCoeff * fact + offset >> bdShift);
        }
    }
}

