/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.heic.common;

import com.idrsolutions.image.heic.common.Bitstream;
import com.idrsolutions.image.heic.common.Cabac;
import com.idrsolutions.image.heic.common.CtxTbl;
import com.idrsolutions.image.heic.common.HImg;
import com.idrsolutions.image.heic.common.HeicMath;
import com.idrsolutions.image.heic.common.Pps;
import com.idrsolutions.image.heic.common.Rps;
import com.idrsolutions.image.heic.common.Sps;
import java.util.Arrays;
import org.jpedal.utils.LogWriter;

class Ssh {
    byte first_slice_segment_in_pic_flag;
    byte no_output_of_prior_pics_flag;
    int slice_pic_parameter_set_id;
    byte dependent_slice_segment_flag;
    int slice_segment_address;
    int slice_type = 2;
    int num_ref_idx_l0_active;
    int num_ref_idx_l1_active;
    byte pic_output_flag = 1;
    int colour_plane_id;
    int slice_pic_order_cnt_lsb;
    byte short_term_ref_pic_set_sps_flag;
    int short_term_ref_pic_set_idx;
    int num_long_term_sps;
    int num_long_term_pics;
    byte slice_temporal_mvp_enabled_flag;
    byte slice_sao_luma_flag;
    byte slice_sao_chroma_flag;
    byte num_ref_idx_active_override_flag;
    byte mvd_l1_zero_flag;
    byte cabac_init_flag;
    byte collocated_from_l0_flag = 1;
    int collocated_ref_idx;
    int five_minus_max_num_merge_cand;
    byte use_integer_mv_flag;
    int slice_qp_delta;
    int slice_cb_qp_offset;
    int slice_cr_qp_offset;
    int cu_chroma_qp_offset_enabled_flag;
    int slice_act_y_qp_offset;
    int slice_act_cb_qp_offset;
    int slice_act_cr_qp_offset;
    Rps slice_ref_pic_set = new Rps();
    byte deblocking_filter_override_flag;
    byte slice_deblocking_filter_disabled_flag;
    int slice_beta_offset;
    int slice_tc_offset;
    byte slice_loop_filter_across_slices_enabled_flag;
    int num_entry_point_offsets;
    int offset_len;
    int slice_segment_header_extension_length;
    int[] slice_segment_header_extension_data_byte;
    int[] entry_point_offset;
    final int[] lt_idx_sps = new int[16];
    final int[] poc_lsb_lt = new int[16];
    final byte[] used_by_curr_pic_lt_flag = new byte[16];
    final byte[] delta_poc_msb_present_flag = new byte[16];
    final int[] delta_poc_msb_cycle_lt = new int[16];
    int luma_log2_weight_denom;
    int ChromaLog2WeightDenom;
    final byte[][] luma_weight_flag = new byte[2][16];
    final byte[][] chroma_weight_flag = new byte[2][16];
    final int[][] luma_offset = new int[2][16];
    final int[][] LumaWeight = new int[2][16];
    final int[][][] ChromaWeight = new int[2][16][2];
    final int[][][] ChromaOffset = new int[2][16][2];
    final int[] list_entry_l0 = new int[16];
    final int[] list_entry_l1 = new int[16];
    byte ref_pic_list_modification_flag_l0;
    byte ref_pic_list_modification_flag_l1;
    int NumPocTotalCurr_shortterm_only;
    int SliceQPY;
    int initType;
    int SliceAddrRS;
    int MaxNumMergeCand;
    int CurrRpsIdx;
    private Rps CurrRps;
    int NumPocTotalCurr;
    int[][] RefPicList = new int[2][16];
    int[][] RefPicList_POC = new int[2][16];
    int[][] RefPicList_PicState = new int[2][16];
    int[][] LongTermRefPic = new int[2][16];
    int sliceIndex;
    CtxTbl ctx_model_storage;
    boolean ctx_model_storage_defined;

    Ssh() {
    }

    private void resetSsh(HImg d, Pps pps) {
        int j;
        int i;
        this.sliceIndex = 0;
        this.first_slice_segment_in_pic_flag = 0;
        this.no_output_of_prior_pics_flag = 0;
        this.slice_pic_parameter_set_id = 0;
        this.dependent_slice_segment_flag = 0;
        this.slice_segment_address = 0;
        this.slice_type = 0;
        this.num_ref_idx_l0_active = 1;
        this.num_ref_idx_l1_active = 1;
        this.pic_output_flag = 1;
        this.colour_plane_id = 0;
        this.slice_pic_order_cnt_lsb = 0;
        this.short_term_ref_pic_set_sps_flag = 0;
        this.short_term_ref_pic_set_idx = 0;
        this.num_long_term_sps = 0;
        this.num_long_term_pics = 0;
        this.slice_temporal_mvp_enabled_flag = 0;
        this.slice_sao_luma_flag = 0;
        this.slice_sao_chroma_flag = 0;
        this.num_ref_idx_active_override_flag = 0;
        this.mvd_l1_zero_flag = 0;
        this.cabac_init_flag = 0;
        this.collocated_from_l0_flag = 1;
        this.collocated_ref_idx = 0;
        this.five_minus_max_num_merge_cand = 0;
        this.use_integer_mv_flag = 0;
        this.slice_qp_delta = 0;
        this.slice_cb_qp_offset = 0;
        this.slice_cr_qp_offset = 0;
        this.cu_chroma_qp_offset_enabled_flag = 0;
        this.slice_act_y_qp_offset = 0;
        this.slice_act_cb_qp_offset = 0;
        this.slice_act_cr_qp_offset = 0;
        this.slice_ref_pic_set.reset();
        this.deblocking_filter_override_flag = 0;
        this.slice_deblocking_filter_disabled_flag = 0;
        this.num_entry_point_offsets = 0;
        this.offset_len = 0;
        this.slice_segment_header_extension_length = 0;
        this.slice_segment_header_extension_data_byte = null;
        this.entry_point_offset = null;
        this.slice_beta_offset = pps.beta_offset;
        this.slice_tc_offset = pps.tc_offset;
        this.slice_loop_filter_across_slices_enabled_flag = pps.loop_filter_across_slices_enabled_flag;
        Arrays.fill(this.lt_idx_sps, 0);
        Arrays.fill(this.poc_lsb_lt, 0);
        Arrays.fill(this.used_by_curr_pic_lt_flag, (byte)0);
        Arrays.fill(this.delta_poc_msb_present_flag, (byte)0);
        Arrays.fill(this.delta_poc_msb_cycle_lt, 0);
        Arrays.fill(this.list_entry_l0, 0);
        Arrays.fill(this.list_entry_l1, 0);
        for (i = 0; i < 2; ++i) {
            for (j = 0; j < 16; ++j) {
                this.luma_weight_flag[i][j] = 0;
                this.chroma_weight_flag[i][j] = 0;
                this.LumaWeight[i][j] = 0;
                this.luma_offset[i][j] = 0;
                this.ChromaWeight[i][j][1] = 0;
                this.ChromaWeight[i][j][0] = 0;
                this.ChromaOffset[i][j][1] = 0;
                this.ChromaOffset[i][j][0] = 0;
            }
        }
        this.SliceAddrRS = 0;
        this.SliceQPY = 0;
        this.MaxNumMergeCand = 0;
        this.CurrRpsIdx = 0;
        this.CurrRps = new Rps();
        this.NumPocTotalCurr = 0;
        for (i = 0; i < 2; ++i) {
            for (j = 0; j < 16; ++j) {
                this.RefPicList[i][j] = 0;
                this.RefPicList_POC[i][j] = 0;
                this.RefPicList_PicState[i][j] = 0;
                this.LongTermRefPic[i][j] = 0;
            }
        }
    }

    boolean readSsh(Bitstream reader, HImg d, Sps sps, Pps pps, int nalType, int nuh_layer_id) {
        int i;
        this.resetSsh(d, pps);
        this.dependent_slice_segment_flag = 0;
        this.first_slice_segment_in_pic_flag = reader.readBit();
        if (nalType >= 16 && nalType <= 23) {
            this.no_output_of_prior_pics_flag = reader.readBit();
        }
        this.slice_pic_parameter_set_id = reader.ue();
        if (this.slice_pic_parameter_set_id > pps.pic_parameter_set_id) {
            return false;
        }
        if (this.first_slice_segment_in_pic_flag == 0) {
            this.dependent_slice_segment_flag = pps.dependent_slice_segments_enabled_flag != 0 ? reader.readBit() : (byte)0;
            int len = HeicMath.log2Ceil(sps.PicSizeInCtbsY);
            this.slice_segment_address = reader.readBits(len);
        } else {
            this.dependent_slice_segment_flag = 0;
            this.slice_segment_address = 0;
        }
        if (this.dependent_slice_segment_flag == 0) {
            int i2;
            for (i = 0; i < pps.num_extra_slice_header_bits; ++i) {
                reader.readBit();
            }
            this.slice_type = reader.ue();
            if (this.slice_type > 2) {
                LogWriter.writeLog("invalid slice type");
            }
            this.pic_output_flag = pps.output_flag_present_flag != 0 ? reader.readBit() : (byte)1;
            if (sps.separate_colour_plane_flag == 1) {
                this.colour_plane_id = reader.readBits(2);
            }
            this.slice_pic_order_cnt_lsb = 0;
            this.short_term_ref_pic_set_sps_flag = 0;
            int NumLtPics = 0;
            if (nalType != 19 && nalType != 20) {
                this.slice_pic_order_cnt_lsb = reader.readBits(sps.log2_max_pic_order_cnt_lsb);
                this.short_term_ref_pic_set_sps_flag = reader.readBit();
                if (this.short_term_ref_pic_set_sps_flag == 0) {
                    Rps.read(reader, sps, this.slice_ref_pic_set, sps.ref_pic_sets.size(), sps.ref_pic_sets, true);
                    this.CurrRpsIdx = sps.num_short_term_ref_pic_sets;
                    this.CurrRps = this.slice_ref_pic_set;
                } else {
                    int len = HeicMath.log2Ceil(sps.num_short_term_ref_pic_sets);
                    this.short_term_ref_pic_set_idx = len > 0 ? reader.readBits(len) : 0;
                    this.CurrRpsIdx = this.short_term_ref_pic_set_idx;
                    this.CurrRps = sps.ref_pic_sets.get(this.CurrRpsIdx);
                }
                if (sps.long_term_ref_pics_present_flag != 0) {
                    this.num_long_term_sps = sps.num_long_term_ref_pics_sps > 0 ? reader.ue() : 0;
                    this.num_long_term_pics = reader.ue();
                    int ii = this.num_long_term_sps + this.num_long_term_pics;
                    for (i2 = 0; i2 < ii; ++i2) {
                        if (i2 < this.num_long_term_sps) {
                            int len = HeicMath.log2Ceil(sps.num_long_term_ref_pics_sps);
                            this.lt_idx_sps[i2] = reader.readBits(len);
                            d.PocLsbLt[i2] = sps.lt_ref_pic_poc_lsb_sps[this.lt_idx_sps[i2]];
                            d.UsedByCurrPicLt[i2] = sps.used_by_curr_pic_lt_sps_flag[this.lt_idx_sps[i2]];
                        } else {
                            this.poc_lsb_lt[i2] = reader.readBits(sps.log2_max_pic_order_cnt_lsb);
                            this.used_by_curr_pic_lt_flag[i2] = reader.readBit();
                            d.PocLsbLt[i2] = this.poc_lsb_lt[i2];
                            d.UsedByCurrPicLt[i2] = this.used_by_curr_pic_lt_flag[i2];
                        }
                        if (d.UsedByCurrPicLt[i2] != 0) {
                            ++NumLtPics;
                        }
                        this.delta_poc_msb_present_flag[i2] = reader.readBit();
                        this.delta_poc_msb_cycle_lt[i2] = this.delta_poc_msb_present_flag[i2] != 0 ? reader.ue() : 0;
                        d.DeltaPocMsbCycleLt[i2] = i2 == 0 || i2 == this.num_long_term_sps ? this.delta_poc_msb_cycle_lt[i2] : this.delta_poc_msb_cycle_lt[i2] + d.DeltaPocMsbCycleLt[i2 - 1];
                    }
                } else {
                    this.num_long_term_sps = 0;
                    this.num_long_term_pics = 0;
                }
                this.slice_temporal_mvp_enabled_flag = sps.sps_temporal_mvp_enabled_flag != 0 ? reader.readBit() : (byte)0;
            } else {
                this.slice_pic_order_cnt_lsb = 0;
                this.num_long_term_sps = 0;
                this.num_long_term_pics = 0;
            }
            if (sps.sample_adaptive_offset_enabled_flag != 0) {
                this.slice_sao_luma_flag = reader.readBit();
                this.slice_sao_chroma_flag = sps.ChromaArrayType != 0 ? reader.readBit() : (byte)0;
            } else {
                this.slice_sao_luma_flag = 0;
                this.slice_sao_chroma_flag = 0;
            }
            this.num_ref_idx_l0_active = 0;
            this.num_ref_idx_l1_active = 0;
            if (this.slice_type == 0 || this.slice_type == 1) {
                this.num_ref_idx_active_override_flag = reader.readBit();
                if (this.num_ref_idx_active_override_flag != 0) {
                    this.num_ref_idx_l0_active = reader.ue() + 1;
                    if (this.slice_type == 0) {
                        this.num_ref_idx_l1_active = reader.ue() + 1;
                    }
                } else {
                    this.num_ref_idx_l0_active = pps.num_ref_idx_l0_default_active;
                    this.num_ref_idx_l1_active = pps.num_ref_idx_l1_default_active;
                }
                this.NumPocTotalCurr = this.CurrRps.NumPocTotalCurr_shortterm_only + NumLtPics;
                if (pps.lists_modification_present_flag != 0 && this.NumPocTotalCurr > 1) {
                    int nBits = HeicMath.log2Ceil(this.NumPocTotalCurr);
                    this.ref_pic_list_modification_flag_l0 = reader.readBit();
                    if (this.ref_pic_list_modification_flag_l0 != 0) {
                        for (i2 = 0; i2 < this.num_ref_idx_l0_active; ++i2) {
                            this.list_entry_l0[i2] = reader.readBits(nBits);
                        }
                    }
                    if (this.slice_type == 0) {
                        this.ref_pic_list_modification_flag_l1 = reader.readBit();
                        if (this.ref_pic_list_modification_flag_l1 != 0) {
                            for (i2 = 0; i2 < this.num_ref_idx_l1_active; ++i2) {
                                this.list_entry_l1[i2] = reader.readBits(nBits);
                            }
                        }
                    } else {
                        this.ref_pic_list_modification_flag_l1 = 0;
                    }
                } else {
                    this.ref_pic_list_modification_flag_l0 = 0;
                    this.ref_pic_list_modification_flag_l1 = 0;
                }
                if (this.slice_type == 0) {
                    this.mvd_l1_zero_flag = reader.readBit();
                }
                this.cabac_init_flag = pps.cabac_init_present_flag != 0 ? reader.readBit() : (byte)0;
                if (this.slice_temporal_mvp_enabled_flag != 0) {
                    this.collocated_from_l0_flag = this.slice_type == 0 ? reader.readBit() : (byte)1;
                    this.collocated_ref_idx = this.collocated_from_l0_flag != 0 && this.num_ref_idx_l0_active > 1 || this.collocated_from_l0_flag == 0 && this.num_ref_idx_l1_active > 1 ? reader.ue() : 0;
                }
                if (pps.weighted_pred_flag != 0 && this.slice_type == 1 || pps.weighted_bipred_flag != 0 && this.slice_type == 0) {
                    this.readPredWeightTable(reader, d, sps, nuh_layer_id);
                }
                this.five_minus_max_num_merge_cand = reader.ue();
                this.MaxNumMergeCand = 5 - this.five_minus_max_num_merge_cand;
            }
            this.slice_qp_delta = reader.se();
            if (pps.slice_chroma_qp_offsets_present_flag != 0) {
                this.slice_cb_qp_offset = reader.se();
                this.slice_cr_qp_offset = reader.se();
            } else {
                this.slice_cb_qp_offset = 0;
                this.slice_cr_qp_offset = 0;
            }
            if (pps.chroma_qp_offset_list_enabled_flag != 0) {
                this.cu_chroma_qp_offset_enabled_flag = reader.readBit();
            }
            this.deblocking_filter_override_flag = pps.deblocking_filter_override_enabled_flag != 0 ? reader.readBit() : (byte)0;
            this.slice_beta_offset = pps.beta_offset;
            this.slice_tc_offset = pps.tc_offset;
            if (this.deblocking_filter_override_flag != 0) {
                this.slice_deblocking_filter_disabled_flag = reader.readBit();
                if (this.slice_deblocking_filter_disabled_flag == 0) {
                    this.slice_beta_offset = reader.se() * 2;
                    this.slice_tc_offset = reader.se() * 2;
                }
            } else {
                this.slice_deblocking_filter_disabled_flag = pps.deblocking_filter_disabled_flag;
            }
            this.slice_loop_filter_across_slices_enabled_flag = pps.loop_filter_across_slices_enabled_flag != 0 && (this.slice_sao_luma_flag != 0 || this.slice_sao_chroma_flag != 0 || this.slice_deblocking_filter_disabled_flag == 0) ? reader.readBit() : pps.loop_filter_across_slices_enabled_flag;
        }
        if (pps.tiles_enabled_flag != 0 || pps.entropy_coding_sync_enabled_flag != 0) {
            this.num_entry_point_offsets = reader.ue();
            if (this.num_entry_point_offsets > 0) {
                this.offset_len = reader.ue() + 1;
                this.entry_point_offset = new int[this.num_entry_point_offsets];
                for (i = 0; i < this.num_entry_point_offsets; ++i) {
                    this.entry_point_offset[i] = reader.readBits(this.offset_len) + 1;
                    if (i <= 0) continue;
                    int n = i;
                    this.entry_point_offset[n] = this.entry_point_offset[n] + this.entry_point_offset[i - 1];
                }
            }
        } else {
            this.num_entry_point_offsets = 0;
        }
        if (pps.slice_segment_header_extension_present_flag != 0) {
            this.slice_segment_header_extension_length = reader.ue();
            this.slice_segment_header_extension_data_byte = new int[this.slice_segment_header_extension_length];
            for (i = 0; i < this.slice_segment_header_extension_length; ++i) {
                this.slice_segment_header_extension_data_byte[i] = reader.readU8();
            }
        }
        this.computeDerivedValues(pps);
        return true;
    }

    void computeDerivedValues(Pps pps) {
        this.SliceQPY = pps.init_qp + this.slice_qp_delta;
        switch (this.slice_type) {
            case 2: {
                this.initType = 0;
                break;
            }
            case 1: {
                this.initType = this.cabac_init_flag + 1;
                break;
            }
            case 0: {
                this.initType = 2 - this.cabac_init_flag;
            }
        }
        this.MaxNumMergeCand = 5 - this.five_minus_max_num_merge_cand;
    }

    private void readPredWeightTable(Bitstream reader, HImg d, Sps sps, int nuh_layer_id) {
        int vlc;
        LogWriter.writeLog("reading prediction Weight @@@@@@@@");
        this.luma_log2_weight_denom = vlc = reader.ue();
        if (vlc < 0 || vlc > 7) {
            return;
        }
        if (sps.chroma_format_idc != 0) {
            vlc = reader.se();
            if ((vlc += this.luma_log2_weight_denom) < 0 || vlc > 7) {
                return;
            }
            this.ChromaLog2WeightDenom = vlc;
        }
        int sumWeightFlags = 0;
        for (int l = 0; l <= 1; ++l) {
            int i;
            if (l != 0 && (l != true || this.slice_type != 0)) continue;
            int num_ref = l == 0 ? this.num_ref_idx_l0_active - 1 : this.num_ref_idx_l1_active - 1;
            for (i = 0; i <= num_ref; ++i) {
                this.luma_weight_flag[l][i] = reader.readBit();
                if (this.luma_weight_flag[l][i] == 0) continue;
                ++sumWeightFlags;
            }
            if (sps.chroma_format_idc != 0) {
                for (i = 0; i <= num_ref; ++i) {
                    this.chroma_weight_flag[l][i] = reader.readBit();
                    if (this.chroma_weight_flag[l][i] == 0) continue;
                    sumWeightFlags += 2;
                }
            }
            for (i = 0; i <= num_ref; ++i) {
                int j;
                if (this.luma_weight_flag[l][i] != 0) {
                    vlc = reader.se();
                    if (vlc < -128 || vlc > 127) {
                        return;
                    }
                    this.LumaWeight[l][i] = (1 << this.luma_log2_weight_denom) + vlc;
                    vlc = reader.se();
                    if (vlc < -sps.WpOffsetHalfRangeY || vlc > sps.WpOffsetHalfRangeY - 1) {
                        return;
                    }
                    this.luma_offset[l][i] = vlc;
                } else {
                    this.LumaWeight[l][i] = 1 << this.luma_log2_weight_denom;
                    this.luma_offset[l][i] = 0;
                }
                if (this.chroma_weight_flag[l][i] != 0) {
                    for (j = 0; j < 2; ++j) {
                        vlc = reader.se();
                        if (vlc < -128 || vlc > 127) {
                            return;
                        }
                        this.ChromaWeight[l][i][j] = (1 << this.ChromaLog2WeightDenom) + vlc;
                        vlc = reader.se();
                        if (vlc < -4 * sps.WpOffsetHalfRangeC || vlc > 4 * sps.WpOffsetHalfRangeC - 1) {
                            return;
                        }
                        this.ChromaOffset[l][i][j] = vlc = HeicMath.clip3(-sps.WpOffsetHalfRangeC, sps.WpOffsetHalfRangeC - 1, sps.WpOffsetHalfRangeC + vlc - (sps.WpOffsetHalfRangeC * this.ChromaWeight[l][i][j] >> this.ChromaLog2WeightDenom));
                    }
                    continue;
                }
                for (j = 0; j < 2; ++j) {
                    this.ChromaWeight[l][i][j] = 1 << this.ChromaLog2WeightDenom;
                    this.ChromaOffset[l][i][j] = 0;
                }
            }
        }
    }

    void setDefaults() {
        this.sliceIndex = 0;
        this.first_slice_segment_in_pic_flag = 1;
        this.no_output_of_prior_pics_flag = 0;
        this.slice_pic_parameter_set_id = 0;
        this.dependent_slice_segment_flag = 0;
        this.slice_segment_address = 0;
        this.slice_type = 2;
        this.pic_output_flag = 1;
        this.colour_plane_id = 0;
        this.slice_pic_order_cnt_lsb = 0;
        this.short_term_ref_pic_set_sps_flag = 1;
        this.short_term_ref_pic_set_idx = 0;
        this.num_long_term_sps = 0;
        this.num_long_term_pics = 0;
        this.slice_temporal_mvp_enabled_flag = 0;
        this.slice_sao_luma_flag = 0;
        this.slice_sao_chroma_flag = 0;
        this.num_ref_idx_active_override_flag = 0;
        this.num_ref_idx_l0_active = 1;
        this.num_ref_idx_l1_active = 1;
        this.ref_pic_list_modification_flag_l0 = 0;
        this.ref_pic_list_modification_flag_l1 = 0;
        this.mvd_l1_zero_flag = 0;
        this.cabac_init_flag = 0;
        this.collocated_from_l0_flag = 0;
        this.collocated_ref_idx = 0;
        this.luma_log2_weight_denom = 0;
        this.five_minus_max_num_merge_cand = 0;
        this.slice_qp_delta = 0;
        this.slice_cb_qp_offset = 0;
        this.slice_cr_qp_offset = 0;
        this.cu_chroma_qp_offset_enabled_flag = 0;
        this.deblocking_filter_override_flag = 0;
        this.slice_deblocking_filter_disabled_flag = 0;
        this.slice_beta_offset = 0;
        this.slice_tc_offset = 0;
        this.slice_loop_filter_across_slices_enabled_flag = 0;
        this.num_entry_point_offsets = 0;
        this.slice_segment_header_extension_length = 0;
        this.SliceAddrRS = this.slice_segment_address;
    }

    void write(Cabac out, HImg img, Sps sps, Pps pps, int nalUnitType) {
        int i;
        out.write_bit(this.first_slice_segment_in_pic_flag);
        if (nalUnitType >= 16 && nalUnitType <= 23) {
            out.write_bit(this.no_output_of_prior_pics_flag);
        }
        out.writeUE(this.slice_pic_parameter_set_id);
        if (this.dependent_slice_segment_flag == 0) {
            for (i = 0; i < pps.num_extra_slice_header_bits; ++i) {
                out.skip_bits(1);
            }
            out.writeUE(this.slice_type);
            if (pps.output_flag_present_flag != 0) {
                out.write_bit(this.pic_output_flag);
            }
            if (sps.separate_colour_plane_flag == 1) {
                out.write_bits(this.colour_plane_id, 2);
            }
            out.writeSE(this.slice_qp_delta);
            if (pps.slice_chroma_qp_offsets_present_flag != 0) {
                out.writeSE(this.slice_cb_qp_offset);
                out.writeSE(this.slice_cr_qp_offset);
            }
            if (pps.deblocking_filter_override_enabled_flag != 0) {
                out.write_bit(this.deblocking_filter_override_flag);
            }
            if (this.deblocking_filter_override_flag != 0) {
                out.write_bit(this.slice_deblocking_filter_disabled_flag);
                if (this.slice_deblocking_filter_disabled_flag == 0) {
                    out.writeSE(this.slice_beta_offset / 2);
                    out.writeSE(this.slice_tc_offset / 2);
                }
            }
            if (pps.loop_filter_across_slices_enabled_flag != 0 && (this.slice_sao_luma_flag != 0 || this.slice_sao_chroma_flag != 0 || this.slice_deblocking_filter_disabled_flag == 0)) {
                out.write_bit(this.slice_loop_filter_across_slices_enabled_flag);
            }
        }
        if (pps.tiles_enabled_flag != 0 || pps.entropy_coding_sync_enabled_flag != 0) {
            out.writeUE(this.num_entry_point_offsets);
            if (this.num_entry_point_offsets > 0) {
                out.writeUE(this.offset_len - 1);
                for (i = 0; i < this.num_entry_point_offsets; ++i) {
                    int prev = 0;
                    if (i > 0) {
                        prev = this.entry_point_offset[i - 1];
                    }
                    out.write_bits(this.entry_point_offset[i] - prev - 1, this.offset_len);
                }
            }
        }
        if (pps.slice_segment_header_extension_present_flag != 0) {
            out.writeUE(this.slice_segment_header_extension_length);
            for (i = 0; i < this.slice_segment_header_extension_length; ++i) {
                out.skip_bits(8);
            }
        }
    }
}

