/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.heic.common;

import com.idrsolutions.image.heic.common.HImg;
import com.idrsolutions.image.heic.common.HeicMath;
import com.idrsolutions.image.heic.common.Pps;
import com.idrsolutions.image.heic.common.Sps;
import com.idrsolutions.image.heic.common.Type;
import java.util.Arrays;

class IntraPred {
    private static final int NOFFSET = 130;
    private final int[] outBorder = new int[260];
    private final boolean[] available = new boolean[260];
    private final int[] refAng = new int[260];
    private final int[] pF = new int[260];
    private int nT;
    private int cIdx;
    private int xB;
    private int yB;
    private int SubWidth;
    private int SubHeight;
    private boolean hasLeft;
    private boolean hasTop;
    private boolean hasTopRight;
    private boolean hasTopLeft;
    private int nBottom;
    private int nRight;
    private int nAvail;
    private int firstValue;

    IntraPred() {
    }

    void decode(HImg img, Sps sps, Pps pps, int xB0, int yB0, int predMode, int nT, int cIdx) {
        Arrays.fill(this.outBorder, 0);
        Arrays.fill(this.available, false);
        this.fillBorderSamples(img, sps, pps, xB0, yB0, nT, cIdx);
        if (sps.intra_smoothing_disabled_flag == 0 && (cIdx == 0 || sps.ChromaArrayType == 3)) {
            this.sampleFilter(sps, this.outBorder, nT, cIdx, predMode);
        }
        int[] dst = img.getImagePlane(cIdx);
        int dstStride = img.getImageStride(cIdx);
        int dstOffset = img.getImageStride(cIdx) * yB0 + xB0;
        switch (predMode) {
            case 0: {
                IntraPred.doPlanar(dst, dstStride, dstOffset, nT, this.outBorder);
                break;
            }
            case 1: {
                IntraPred.doDC(dst, dstStride, dstOffset, nT, cIdx, this.outBorder);
                break;
            }
            default: {
                int bit_depth = cIdx == 0 ? sps.BitDepthY : sps.BitDepthC;
                boolean disableIntraBoundaryFilter = sps.implicit_rdpcm_enabled_flag != 0 && img.get_cu_transquant_bypass(xB0, yB0);
                this.doAngular(dst, dstStride, dstOffset, bit_depth, disableIntraBoundaryFilter, predMode, nT, cIdx, this.outBorder);
            }
        }
    }

    private void sampleFilter(Sps sps, int[] p, int nT, int cIdx, int predMode) {
        boolean filterFlag = false;
        if (predMode != 1 && nT != 4) {
            int minDistVerHor = Math.min(Math.abs(predMode - 26), Math.abs(predMode - 10));
            switch (nT) {
                case 8: {
                    filterFlag = minDistVerHor > 7;
                    break;
                }
                case 16: {
                    filterFlag = minDistVerHor > 1;
                    break;
                }
                case 32: {
                    boolean bl = filterFlag = minDistVerHor > 0;
                }
            }
        }
        if (filterFlag) {
            boolean biIntFlag = sps.strong_intra_smoothing_enabled_flag != 0 && cIdx == 0 && nT == 32 && Math.abs(p[130] + p[194] - 2 * p[162]) < 1 << sps.BitDepthY - 5 && Math.abs(p[130] + p[66] - 2 * p[98]) < 1 << sps.BitDepthY - 5;
            Arrays.fill(this.pF, 0);
            if (biIntFlag) {
                this.pF[130 - 2 * nT] = p[130 - 2 * nT];
                this.pF[130 + 2 * nT] = p[130 + 2 * nT];
                this.pF[130] = p[130];
                for (int i = 1; i <= 63; ++i) {
                    this.pF[130 - i] = p[130] + (i * (p[66] - p[130]) + 32 >> 6);
                    this.pF[130 + i] = p[130] + (i * (p[194] - p[130]) + 32 >> 6);
                }
            } else {
                this.pF[130 - 2 * nT] = p[130 - 2 * nT];
                this.pF[130 + 2 * nT] = p[130 + 2 * nT];
                for (int i = -(2 * nT - 1); i <= 2 * nT - 1; ++i) {
                    this.pF[130 + i] = p[130 + i + 1] + 2 * p[130 + i] + p[130 + i - 1] + 2 >> 2;
                }
            }
            System.arraycopy(this.pF, 130 - 2 * nT, p, 130 - 2 * nT, 4 * nT + 1);
        }
    }

    private void fillBorderSamples(HImg img, Sps sps, Pps pps, int xB, int yB, int nT, int cIdx) {
        this.nT = nT;
        this.xB = xB;
        this.yB = yB;
        this.cIdx = cIdx;
        this.hasLeft = true;
        this.hasTop = true;
        this.hasTopRight = true;
        this.hasTopLeft = true;
        this.preproc(img, sps, pps);
        this.fillFromImage(img, sps, pps);
        this.sampleSubstitution(img);
    }

    private void preproc(HImg d, Sps sps, Pps pps) {
        int toprightCTBTileID;
        this.SubWidth = this.cIdx == 0 ? 1 : sps.SubWidthC;
        this.SubHeight = this.cIdx == 0 ? 1 : sps.SubHeightC;
        int xBLuma = this.xB * this.SubWidth;
        int yBLuma = this.yB * this.SubHeight;
        int log2CtbSize = sps.Log2CtbSizeY;
        int picWidthInCtbs = sps.PicWidthInCtbsY;
        if (xBLuma == 0) {
            this.hasLeft = false;
            this.hasTopLeft = false;
        }
        if (yBLuma == 0) {
            this.hasTop = false;
            this.hasTopLeft = false;
            this.hasTopRight = false;
        }
        if (xBLuma + this.nT * this.SubWidth >= sps.pic_width_in_luma_samples) {
            this.hasTopRight = false;
        }
        int xCurrCtb = xBLuma >> log2CtbSize;
        int yCurrCtb = yBLuma >> log2CtbSize;
        int xLeftCtb = xBLuma - 1 >> log2CtbSize;
        int xRightCtb = xBLuma + this.nT * this.SubWidth >> log2CtbSize;
        int yTopCtb = yBLuma - 1 >> log2CtbSize;
        int currCTBSlice = d.getSliceAddrRS(xCurrCtb, yCurrCtb);
        int leftCTBSlice = this.hasLeft ? d.getSliceAddrRS(xLeftCtb, yCurrCtb) : -1;
        int topCTBSlice = this.hasTop ? d.getSliceAddrRS(xCurrCtb, yTopCtb) : -1;
        int toprightCTBSlice = this.hasTopRight ? d.getSliceAddrRS(xRightCtb, yTopCtb) : -1;
        int topleftCTBSlice = this.hasTopLeft ? d.getSliceAddrRS(xLeftCtb, yTopCtb) : -1;
        int currCTBTileID = pps.TileIdRS[xCurrCtb + yCurrCtb * picWidthInCtbs];
        int leftCTBTileID = this.hasLeft ? pps.TileIdRS[xLeftCtb + yCurrCtb * picWidthInCtbs] : -1;
        int topCTBTileID = this.hasTop ? pps.TileIdRS[xCurrCtb + yTopCtb * picWidthInCtbs] : -1;
        int topleftCTBTileID = this.hasTopLeft ? pps.TileIdRS[xLeftCtb + yTopCtb * picWidthInCtbs] : -1;
        int n = toprightCTBTileID = this.hasTopRight ? pps.TileIdRS[xRightCtb + yTopCtb * picWidthInCtbs] : -1;
        if (leftCTBSlice != currCTBSlice || leftCTBTileID != currCTBTileID) {
            this.hasLeft = false;
        }
        if (topCTBSlice != currCTBSlice || topCTBTileID != currCTBTileID) {
            this.hasTop = false;
        }
        if (topleftCTBSlice != currCTBSlice || topleftCTBTileID != currCTBTileID) {
            this.hasTopLeft = false;
        }
        if (toprightCTBSlice != currCTBSlice || toprightCTBTileID != currCTBTileID) {
            this.hasTopRight = false;
        }
        this.nBottom = sps.pic_height_in_luma_samples - this.yB * this.SubHeight;
        this.nBottom = (this.nBottom + this.SubHeight - 1) / this.SubHeight;
        if (this.nBottom > 2 * this.nT) {
            this.nBottom = 2 * this.nT;
        }
        this.nRight = sps.pic_width_in_luma_samples - this.xB * this.SubWidth;
        this.nRight = (this.nRight + this.SubWidth - 1) / this.SubWidth;
        if (this.nRight > 2 * this.nT) {
            this.nRight = 2 * this.nT;
        }
        this.nAvail = 0;
    }

    private void fillFromImage(HImg d, Sps sps, Pps pps) {
        int[] image = d.getImagePlane(this.cIdx);
        int stride = d.getImageStride(this.cIdx);
        int xBLuma = this.xB * this.SubWidth;
        int yBLuma = this.yB * this.SubHeight;
        int currBlockAddr = pps.MinTbAddrZS[(xBLuma >> sps.Log2MinTrafoSize) + (yBLuma >> sps.Log2MinTrafoSize) * sps.PicWidthInTbsY];
        for (int y = this.nBottom - 1; y >= 0; y -= 4) {
            boolean availableN;
            if (!this.hasLeft) continue;
            int NBlockAddr = pps.MinTbAddrZS[((this.xB - 1) * this.SubWidth >> sps.Log2MinTrafoSize) + ((this.yB + y) * this.SubHeight >> sps.Log2MinTrafoSize) * sps.PicWidthInTbsY];
            boolean bl = availableN = NBlockAddr <= currBlockAddr;
            if (pps.constrained_intra_pred_flag != 0 && d.getPredMode((this.xB - 1) * this.SubWidth, (this.yB + y) * this.SubHeight) != 0) {
                availableN = false;
            }
            if (!availableN) continue;
            if (this.nAvail == 0) {
                this.firstValue = image[this.xB - 1 + (this.yB + y) * stride];
            }
            for (int i = 0; i < 4; ++i) {
                this.available[130 - y + i - 1] = availableN;
                this.outBorder[130 - y + i - 1] = image[this.xB - 1 + (this.yB + y - i) * stride];
            }
            this.nAvail += 4;
        }
        if (this.hasTopLeft) {
            boolean availableN;
            int NBlockAddr = pps.MinTbAddrZS[((this.xB - 1) * this.SubWidth >> sps.Log2MinTrafoSize) + ((this.yB - 1) * this.SubHeight >> sps.Log2MinTrafoSize) * sps.PicWidthInTbsY];
            boolean bl = availableN = NBlockAddr <= currBlockAddr;
            if (pps.constrained_intra_pred_flag != 0 && d.getPredMode((this.xB - 1) * this.SubWidth, (this.yB - 1) * this.SubHeight) != 0) {
                availableN = false;
            }
            if (availableN) {
                if (this.nAvail == 0) {
                    this.firstValue = image[this.xB - 1 + (this.yB - 1) * stride];
                }
                this.outBorder[130] = image[this.xB - 1 + (this.yB - 1) * stride];
                this.available[130] = availableN;
                ++this.nAvail;
            }
        }
        for (int x = 0; x < this.nRight; x += 4) {
            boolean availableN;
            boolean borderAvailable;
            boolean bl = borderAvailable = x < this.nT ? this.hasTop : this.hasTopRight;
            if (!borderAvailable) continue;
            int NBlockAddr = pps.MinTbAddrZS[((this.xB + x) * this.SubWidth >> sps.Log2MinTrafoSize) + ((this.yB - 1) * this.SubHeight >> sps.Log2MinTrafoSize) * sps.PicWidthInTbsY];
            boolean bl2 = availableN = NBlockAddr <= currBlockAddr;
            if (pps.constrained_intra_pred_flag != 0 && d.getPredMode((this.xB + x) * this.SubWidth, (this.yB - 1) * this.SubHeight) != 0) {
                availableN = false;
            }
            if (!availableN) continue;
            if (this.nAvail == 0) {
                this.firstValue = image[this.xB + x + (this.yB - 1) * stride];
            }
            for (int i = 0; i < 4; ++i) {
                this.outBorder[130 + x + i + 1] = image[this.xB + x + i + (this.yB - 1) * stride];
                this.available[130 + x + i + 1] = availableN;
            }
            this.nAvail += 4;
        }
    }

    private void sampleSubstitution(HImg d) {
        int bit_depth = d.getBitDepth(this.cIdx);
        if (this.nAvail != 4 * this.nT + 1) {
            if (this.nAvail == 0) {
                Arrays.fill(this.outBorder, 130 - 2 * this.nT, 130 + 2 * this.nT + 1, 1 << bit_depth - 1);
            } else {
                if (!this.available[130 - 2 * this.nT]) {
                    this.outBorder[130 - 2 * this.nT] = this.firstValue;
                }
                int max = 2 * this.nT;
                for (int i = -2 * this.nT + 1; i <= max; ++i) {
                    if (this.available[130 + i]) continue;
                    this.outBorder[130 + i] = this.outBorder[130 + i - 1];
                }
            }
        }
    }

    static void fillCandidates(HImg d, Sps sps, int[] candModeList, int x, int y, int PUidx, boolean availableA, boolean availableB) {
        int candA = !availableA ? 1 : (d.getPredMode(x - 1, y) != 0 || d.getPcmFlag(x - 1, y) ? 1 : d.getIntraPredModeAtIndex(PUidx - 1));
        int candB = !availableB ? 1 : (d.getPredMode(x, y - 1) != 0 || d.getPcmFlag(x, y - 1) ? 1 : (y - 1 < y >> sps.Log2CtbSizeY << sps.Log2CtbSizeY ? 1 : d.getIntraPredModeAtIndex(PUidx - sps.PicWidthInMinPus)));
        IntraPred.fillCandidatesInternal(candModeList, candA, candB);
    }

    private static void fillCandidatesInternal(int[] candModeList, int candA, int candB) {
        if (candA == candB) {
            if (candA < 2) {
                candModeList[0] = 0;
                candModeList[1] = 1;
                candModeList[2] = 26;
            } else {
                candModeList[0] = candA;
                candModeList[1] = 2 + (candA - 2 - 1 + 32) % 32;
                candModeList[2] = 2 + (candA - 2 + 1) % 32;
            }
        } else {
            candModeList[0] = candA;
            candModeList[1] = candB;
            candModeList[2] = candA != 0 && candB != 0 ? 0 : (candA != 1 && candB != 1 ? 1 : 26);
        }
    }

    private static void doPlanar(int[] dst, int dstStride, int dstOffset, int nT, int[] b) {
        int Log2_nT = HeicMath.log2(nT);
        for (int y = 0; y < nT; ++y) {
            for (int x = 0; x < nT; ++x) {
                dst[dstOffset + x + y * dstStride] = (nT - 1 - x) * b[129 - y] + (x + 1) * b[131 + nT] + (nT - 1 - y) * b[131 + x] + (y + 1) * b[129 - nT] + nT >> Log2_nT + 1;
            }
        }
    }

    private static void doDC(int[] dst, int dstStride, int dstOffset, int nT, int cIdx, int[] b) {
        int Log2_nT = HeicMath.log2(nT);
        int dcVal = 0;
        for (int i = 0; i < nT; ++i) {
            dcVal += b[130 + i + 1];
            dcVal += b[130 - i - 1];
        }
        dcVal += nT;
        dcVal >>= Log2_nT + 1;
        if (cIdx == 0 && nT < 32) {
            int y;
            dst[dstOffset] = b[129] + 2 * dcVal + b[131] + 2 >> 2;
            for (x = 1; x < nT; ++x) {
                dst[dstOffset + x] = b[130 + x + 1] + 3 * dcVal + 2 >> 2;
            }
            for (y = 1; y < nT; ++y) {
                dst[dstOffset + y * dstStride] = b[130 - y - 1] + 3 * dcVal + 2 >> 2;
            }
            for (y = 1; y < nT; ++y) {
                for (x = 1; x < nT; ++x) {
                    dst[dstOffset + x + y * dstStride] = dcVal;
                }
            }
        } else {
            for (int y = 0; y < nT; ++y) {
                for (x = 0; x < nT; ++x) {
                    dst[dstOffset + x + y * dstStride] = dcVal;
                }
            }
        }
    }

    private void doAngular(int[] dst, int dstStride, int planOffset, int bit_depth, boolean disableBoundary, int predMode, int nT, int cIdx, int[] b) {
        block20: {
            int x;
            int nT2;
            int angle;
            block19: {
                int y;
                int x2;
                Arrays.fill(this.refAng, 0);
                angle = Type.INTRA_PRED_ANGLES[predMode];
                nT2 = nT << 1;
                if (predMode < 18) break block19;
                for (x2 = 0; x2 <= nT; ++x2) {
                    this.refAng[130 + x2] = b[130 + x2];
                }
                if (angle < 0) {
                    int invAngle = Type.INV_ANGLES[predMode - 11];
                    if (nT * angle >> 5 < -1) {
                        for (x2 = nT * angle >> 5; x2 <= -1; ++x2) {
                            this.refAng[130 + x2] = b[130 - (x2 * invAngle + 128 >> 8)];
                        }
                    }
                } else {
                    for (x2 = nT + 1; x2 <= nT2; ++x2) {
                        this.refAng[130 + x2] = b[130 + x2];
                    }
                }
                for (y = 0; y < nT; ++y) {
                    for (x2 = 0; x2 < nT; ++x2) {
                        int iIdx = (y + 1) * angle >> 5;
                        int iFact = (y + 1) * angle & 0x1F;
                        dst[planOffset + x2 + y * dstStride] = iFact != 0 ? (32 - iFact) * this.refAng[130 + x2 + iIdx + 1] + iFact * this.refAng[130 + x2 + iIdx + 2] + 16 >> 5 : this.refAng[130 + x2 + iIdx + 1];
                    }
                }
                if (predMode != 26 || cIdx != 0 || nT >= 32 || disableBoundary) break block20;
                for (y = 0; y < nT; ++y) {
                    dst[planOffset + y * dstStride] = HeicMath.clipBitDepth(b[131] + (b[129 - y] - b[130] >> 1), bit_depth);
                }
                break block20;
            }
            for (x = 0; x <= nT; ++x) {
                this.refAng[130 + x] = b[130 - x];
            }
            if (angle < 0) {
                int invAngle = Type.INV_ANGLES[predMode - 11];
                if (nT * angle >> 5 < -1) {
                    for (x = nT * angle >> 5; x <= -1; ++x) {
                        this.refAng[130 + x] = b[130 + (x * invAngle + 128 >> 8)];
                    }
                }
            } else {
                for (x = nT + 1; x <= nT2; ++x) {
                    this.refAng[130 + x] = b[130 - x];
                }
            }
            for (int y = 0; y < nT; ++y) {
                for (x = 0; x < nT; ++x) {
                    int iIdx = (x + 1) * angle >> 5;
                    int iFact = (x + 1) * angle & 0x1F;
                    dst[planOffset + x + y * dstStride] = iFact != 0 ? (32 - iFact) * this.refAng[130 + y + iIdx + 1] + iFact * this.refAng[130 + y + iIdx + 2] + 16 >> 5 : this.refAng[130 + y + iIdx + 1];
                }
            }
            if (predMode == 10 && cIdx == 0 && nT < 32 && !disableBoundary) {
                for (x = 0; x < nT; ++x) {
                    dst[planOffset + x] = HeicMath.clipBitDepth(b[129] + (b[131 + x] - b[130] >> 1), bit_depth);
                }
            }
        }
    }

    static int getIntraScanIdx(int log2TrafoSize, int predMode, int cIdx, int chromaType) {
        if (log2TrafoSize == 2 || log2TrafoSize == 3 && (cIdx == 0 || chromaType == 3)) {
            if (predMode >= 6 && predMode <= 14) {
                return 2;
            }
            if (predMode >= 22 && predMode <= 30) {
                return 1;
            }
        }
        return 0;
    }
}

