/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.heic.common;

import com.idrsolutions.image.heic.common.CtxTbl;
import com.idrsolutions.image.heic.common.InfoSAO;
import com.idrsolutions.image.heic.common.Pps;
import com.idrsolutions.image.heic.common.Scan;
import com.idrsolutions.image.heic.common.Sps;
import com.idrsolutions.image.heic.common.Ssh;
import com.idrsolutions.image.heic.common.YuvDisplay;
import java.awt.image.BufferedImage;
import java.util.HashMap;

final class HImg {
    private Sps sps;
    private Pps pps;
    int[][] chromaOffsetL0;
    private int[][] planes;
    byte[][] planesBytes;
    int Width;
    int Height;
    int ChromaW;
    private int ChromaH;
    final Scan scan = new Scan();
    int CtbAddrInRS;
    int CtbAddrInTS;
    int[] PocLsbLt;
    byte[] UsedByCurrPicLt;
    int CuQpDelta;
    boolean IsCuQpDeltaCoded;
    boolean IsCuChromaQpOffsetCoded;
    int CuQpOffsetCb;
    int CuQpOffsetCr;
    final int[] DeltaPocMsbCycleLt = new int[16];
    int ResScaleVal;
    private int[] INTRA_PRED_MODES;
    private int INTRA_PRED_MODES_LOG2UNIT;
    private int INTRA_PRED_MODES_WIDTHUNIT;
    private int[] INTRA_PRED_MODES_C;
    private int INTRA_PRED_MODES_C_LOG2UNIT;
    private int INTRA_PRED_MODES_C_WIDTHUNIT;
    private int StrideY;
    private int StrideC;
    int CtbX;
    int CtbY;
    final HashMap<Integer, CtxTbl> ctx_models = new HashMap();
    final HashMap<Integer, Ssh> slices = new HashMap();
    int PicState;
    private int chroma_format = 1;
    private MetaCB metaCB;
    private MetaCTB metaCTB;
    private MetaTU metaTU;

    HImg() {
    }

    private void initIntrPredModes(int w, int h, int log2) {
        int dim = w * h;
        this.INTRA_PRED_MODES_WIDTHUNIT = w;
        this.INTRA_PRED_MODES_LOG2UNIT = log2;
        this.INTRA_PRED_MODES = new int[dim];
    }

    private void initIntrPredModesC(int w, int h, int log2) {
        int dim = w * h;
        this.INTRA_PRED_MODES_C_WIDTHUNIT = w;
        this.INTRA_PRED_MODES_C_LOG2UNIT = log2;
        this.INTRA_PRED_MODES_C = new int[dim];
    }

    void allocateImage(Sps sps, Pps pps) {
        this.sps = sps;
        this.pps = pps;
        this.chroma_format = sps.ChromaArrayType;
        this.Width = sps.pic_width_in_luma_samples;
        this.Height = sps.pic_height_in_luma_samples;
        this.ChromaW = this.Width;
        this.ChromaH = this.Height;
        switch (sps.ChromaArrayType) {
            case 1: {
                this.ChromaW = (this.ChromaW + 1) / 2;
                this.ChromaH = (this.ChromaH + 1) / 2;
                break;
            }
            case 2: {
                this.ChromaW = (this.ChromaW + 1) / 2;
                break;
            }
            case 0: {
                this.ChromaW = 0;
                this.ChromaH = 0;
            }
        }
        this.planes = new int[3][];
        this.planes[0] = new int[this.Width * this.Height];
        this.StrideY = this.Width;
        this.StrideC = this.ChromaW;
        if (sps.ChromaArrayType != 0) {
            this.planes[1] = new int[this.ChromaW * this.ChromaH];
            this.planes[2] = new int[this.ChromaW * this.ChromaH];
        }
        this.metaCB = new MetaCB(sps.PicWidthInMinCbsY, sps.PicHeightInMinCbsY, sps.Log2MinCbSizeY);
        this.metaCTB = new MetaCTB(sps.PicWidthInCtbsY, sps.PicHeightInCtbsY, sps.Log2CtbSizeY);
        this.initIntrPredModes(sps.PicWidthInMinPus, sps.PicHeightInMinPus, sps.Log2MinPuSize);
        this.initIntrPredModesC(sps.PicWidthInMinPus, sps.PicHeightInMinPus, sps.Log2MinPuSize);
        this.metaTU = new MetaTU(sps.PicWidthInTbsY, sps.PicHeightInTbsY, sps.Log2MinTrafoSize);
    }

    void allocateImage(Sps sps, Pps pps, BufferedImage image) {
        this.sps = sps;
        this.pps = pps;
        this.chroma_format = sps.ChromaArrayType;
        this.Width = sps.pic_width_in_luma_samples;
        this.Height = sps.pic_height_in_luma_samples;
        this.ChromaW = this.Width;
        this.ChromaH = this.Height;
        switch (sps.ChromaArrayType) {
            case 1: {
                this.ChromaW = (this.ChromaW + 1) / 2;
                this.ChromaH = (this.ChromaH + 1) / 2;
                break;
            }
            case 2: {
                this.ChromaW = (this.ChromaW + 1) / 2;
                break;
            }
            case 0: {
                this.ChromaW = 0;
                this.ChromaH = 0;
            }
        }
        this.planesBytes = new byte[3][this.Width * this.Height];
        this.StrideY = this.Width;
        this.StrideC = this.ChromaW;
        this.metaCB = new MetaCB(sps.PicWidthInMinCbsY, sps.PicHeightInMinCbsY, sps.Log2MinCbSizeY);
        this.metaCTB = new MetaCTB(sps.PicWidthInCtbsY, sps.PicHeightInCtbsY, sps.Log2CtbSizeY);
        this.initIntrPredModes(sps.PicWidthInMinPus, sps.PicHeightInMinPus, sps.Log2MinPuSize);
        this.initIntrPredModesC(sps.PicWidthInMinPus, sps.PicHeightInMinPus, sps.Log2MinPuSize);
        this.metaTU = new MetaTU(sps.PicWidthInTbsY, sps.PicHeightInTbsY, sps.Log2MinTrafoSize);
        YuvDisplay.getAsYUV420(image, this);
    }

    int getImageStride(int cIdx) {
        return cIdx == 0 ? this.StrideY : this.StrideC;
    }

    int getWidth(int cIdx) {
        return cIdx == 0 ? this.Width : this.ChromaW;
    }

    int getHeight(int cIdx) {
        return cIdx == 0 ? this.Height : this.ChromaH;
    }

    int getBitDepth(int cIdx) {
        return cIdx == 0 ? this.sps.BitDepthY : this.sps.BitDepthC;
    }

    void addSliceSegmentHeader(Ssh ssh) {
        ssh.sliceIndex = this.slices.size();
        this.slices.put(this.slices.size(), ssh);
    }

    void setPredMode(int x, int y, int log2BlkWidth, byte v) {
        int cbX = x >> this.metaCB.log2unitSize;
        int cbY = y >> this.metaCB.log2unitSize;
        int ww = 1 << log2BlkWidth - this.metaCB.log2unitSize;
        int yy = cbY + ww;
        int xx = cbX + ww;
        for (int cby = cbY; cby < yy; ++cby) {
            for (int cbx = cbX; cbx < xx; ++cbx) {
                this.metaCB.CBS[cbx + cby * this.metaCB.width_in_units].predMode = v;
            }
        }
    }

    byte getPredMode(int x, int y) {
        return this.metaCB.get((int)x, (int)y).predMode;
    }

    boolean getCuSkipFlag(int x, int y) {
        return this.getPredMode(x, y) == 2;
    }

    void setPcmFlag(int x, int y, int log2BlkWidth) {
        int cbX = x >> this.metaCB.log2unitSize;
        int cbY = y >> this.metaCB.log2unitSize;
        int ww = 1 << log2BlkWidth - this.metaCB.log2unitSize;
        int yy = cbY + ww;
        int xx = cbX + ww;
        for (int cby = cbY; cby < yy; ++cby) {
            for (int cbx = cbX; cbx < xx; ++cbx) {
                this.metaCB.CBS[cbx + cby * this.metaCB.width_in_units].pcmFlag = true;
            }
        }
        this.metaCTB.get((int)x, (int)y).has_pcm_or_cu_transquant_bypass = true;
    }

    boolean getPcmFlag(int x, int y) {
        return this.metaCB.get((int)x, (int)y).pcmFlag;
    }

    void set_cu_transquant_bypass(int x, int y, int log2BlkWidth) {
        int cbX = x >> this.metaCB.log2unitSize;
        int cbY = y >> this.metaCB.log2unitSize;
        int ww = 1 << log2BlkWidth - this.metaCB.log2unitSize;
        int yy = cbY + ww;
        int xx = cbX + ww;
        for (int cby = cbY; cby < yy; ++cby) {
            for (int cbx = cbX; cbx < xx; ++cbx) {
                this.metaCB.CBS[cbx + cby * this.metaCB.width_in_units].cuTransquantBypass = true;
            }
        }
        this.metaCTB.get((int)x, (int)y).has_pcm_or_cu_transquant_bypass = true;
    }

    boolean get_cu_transquant_bypass(int x, int y) {
        return this.metaCB.get((int)x, (int)y).cuTransquantBypass;
    }

    void setLog2CbSize(int x, int y, int log2CbSize) {
        int cbX = x >> this.metaCB.log2unitSize;
        int cbY = y >> this.metaCB.log2unitSize;
        int ww = 1 << log2CbSize - this.metaCB.log2unitSize;
        int yy = cbY + ww;
        int xx = cbX + ww;
        for (int cby = cbY; cby < yy; ++cby) {
            for (int cbx = cbX; cbx < xx; ++cbx) {
                this.metaCB.CBS[cbx + cby * this.metaCB.width_in_units].log2 = 0;
            }
        }
        this.metaCB.get((int)x, (int)y).log2 = (byte)log2CbSize;
    }

    int getLog2CbSize(int x, int y) {
        return this.metaCB.get((int)x, (int)y).log2;
    }

    void setPartMode(int x, int y, int v) {
        this.metaCB.get((int)x, (int)y).partMode = (byte)v;
    }

    byte getPartMode(int x, int y) {
        return this.metaCB.get((int)x, (int)y).partMode;
    }

    void setCTDepth(int x, int y, int log2BlkWidth, int v) {
        int cbX = x >> this.metaCB.log2unitSize;
        int cbY = y >> this.metaCB.log2unitSize;
        int ww = 1 << log2BlkWidth - this.metaCB.log2unitSize;
        int yy = cbY + ww;
        int xx = cbX + ww;
        for (int cby = cbY; cby < yy; ++cby) {
            for (int cbx = cbX; cbx < xx; ++cbx) {
                this.metaCB.CBS[cbx + cby * this.metaCB.width_in_units].ctDepth = (byte)v;
            }
        }
    }

    byte getCTDepth(int x, int y) {
        return this.metaCB.get((int)x, (int)y).ctDepth;
    }

    void setQPY(int x, int y, int log2BlkWidth, int qpy) {
        int cbX = x >> this.metaCB.log2unitSize;
        int cbY = y >> this.metaCB.log2unitSize;
        int ww = 1 << log2BlkWidth - this.metaCB.log2unitSize;
        int yy = cbY + ww;
        int xx = cbX + ww;
        for (int cby = cbY; cby < yy; ++cby) {
            for (int cbx = cbX; cbx < xx; ++cbx) {
                this.metaCB.CBS[cbx + cby * this.metaCB.width_in_units].qpY = (byte)qpy;
            }
        }
    }

    byte getQPY(int x, int y) {
        return this.metaCB.get((int)x, (int)y).qpY;
    }

    void setSplitTransformFlag(int x, int y, int trafoDepth) {
        int v = this.metaTU.get(x, y);
        this.metaTU.set(x, y, v | 1 << trafoDepth);
    }

    void clearSplitTransformFlags(int x, int y, int log2BlkWidth) {
        this.metaTU.clearBlk(x, y, log2BlkWidth);
    }

    void set_nonzero_coefficient(int x, int y, int log2TrafoSize) {
        int tuX = x >> this.metaTU.log2unitSize;
        int tuY = y >> this.metaTU.log2unitSize;
        int ww = 1 << log2TrafoSize - this.metaTU.log2unitSize;
        int yy = tuY + ww;
        int xx = tuX + ww;
        for (int tuy = tuY; tuy < yy; ++tuy) {
            for (int tux = tuX; tux < xx; ++tux) {
                int n = tux + tuy * this.metaTU.width_in_units;
                this.metaTU.TUS[n] = this.metaTU.TUS[n] | 0x80;
            }
        }
    }

    int getIntraPredMode(int x, int y) {
        int unitX = x >> this.INTRA_PRED_MODES_LOG2UNIT;
        int unitY = y >> this.INTRA_PRED_MODES_LOG2UNIT;
        return this.INTRA_PRED_MODES[unitX + unitY * this.INTRA_PRED_MODES_WIDTHUNIT];
    }

    int getIntraPredModeAtIndex(int idx) {
        return this.INTRA_PRED_MODES[idx];
    }

    void setIntraPredMode(int PUidx, int log2blkSize, int mode) {
        int pbSize = 1 << log2blkSize - this.INTRA_PRED_MODES_LOG2UNIT;
        for (int y = 0; y < pbSize; ++y) {
            for (int x = 0; x < pbSize; ++x) {
                this.INTRA_PRED_MODES[PUidx + x + y * this.INTRA_PRED_MODES_WIDTHUNIT] = mode;
            }
        }
    }

    int getIntraPredModeC(int x, int y) {
        int unitX = x >> this.INTRA_PRED_MODES_C_LOG2UNIT;
        int unitY = y >> this.INTRA_PRED_MODES_C_LOG2UNIT;
        int vv = this.INTRA_PRED_MODES_C[unitX + unitY * this.INTRA_PRED_MODES_C_WIDTHUNIT];
        return vv & 0x3F;
    }

    boolean isIntraPredModeC_Mode4(int x, int y) {
        int unitX = x >> this.INTRA_PRED_MODES_C_LOG2UNIT;
        int unitY = y >> this.INTRA_PRED_MODES_C_LOG2UNIT;
        int vv = this.INTRA_PRED_MODES_C[unitX + unitY * this.INTRA_PRED_MODES_C_WIDTHUNIT];
        return (vv & 0x80) != 0;
    }

    void setIntraPredModeC(int x0, int y0, int log2blkSize, int mode, boolean isMode4) {
        int combinedValue = mode;
        if (isMode4) {
            combinedValue |= 0x80;
        }
        int pbSize = 1 << log2blkSize - this.INTRA_PRED_MODES_C_LOG2UNIT;
        int PUidx = (x0 >> this.sps.Log2MinPuSize) + (y0 >> this.sps.Log2MinPuSize) * this.sps.PicWidthInMinPus;
        for (int y = 0; y < pbSize; ++y) {
            for (int x = 0; x < pbSize; ++x) {
                int idx = PUidx + x + y * this.INTRA_PRED_MODES_C_WIDTHUNIT;
                this.INTRA_PRED_MODES_C[idx] = combinedValue;
            }
        }
    }

    void setSliceAddrRS(int x, int y, int v) {
        int idx = x + y * this.metaCTB.width_in_units;
        this.metaCTB.CTBS[idx].sliceAddrRS = v;
    }

    int getSliceAddrRS(int x, int y) {
        return this.metaCTB.CTBS[x + y * this.metaCTB.width_in_units].sliceAddrRS;
    }

    private int getSliceAddrRsAtCtbRS(int ctbRS) {
        return this.metaCTB.CTBS[ctbRS].sliceAddrRS;
    }

    void setSliceHeaderIndex(int x, int y, int v) {
        this.metaCTB.get((int)x, (int)y).sliceHeaderIndex = v;
    }

    int getSliceHeaderIndexAtIndex(int ctb) {
        return this.metaCTB.CTBS[ctb].sliceHeaderIndex;
    }

    void setSaoInfo(int x, int y, InfoSAO is) {
        this.metaCTB.CTBS[x + y * this.metaCTB.width_in_units].infoSAO = is;
    }

    InfoSAO getSaoInfo(int x, int y) {
        return this.metaCTB.CTBS[x + y * this.metaCTB.width_in_units].infoSAO;
    }

    boolean availableZscan(int xCurr, int yCurr, int xN, int yN) {
        if (xN < 0 || yN < 0 || xN >= this.Width || yN >= this.Height) {
            return false;
        }
        int minBlockAddrN = this.pps.MinTbAddrZS[(xN >> this.sps.Log2MinTrafoSize) + (yN >> this.sps.Log2MinTrafoSize) * this.sps.PicWidthInTbsY];
        int minBlockAddrCurr = this.pps.MinTbAddrZS[(xCurr >> this.sps.Log2MinTrafoSize) + (yCurr >> this.sps.Log2MinTrafoSize) * this.sps.PicWidthInTbsY];
        if (minBlockAddrN > minBlockAddrCurr) {
            return false;
        }
        int xCurrCtb = xCurr >> this.sps.Log2CtbSizeY;
        int yCurrCtb = yCurr >> this.sps.Log2CtbSizeY;
        int xNCtb = xN >> this.sps.Log2CtbSizeY;
        int yNCtb = yN >> this.sps.Log2CtbSizeY;
        return this.getSliceAddrRS(xCurrCtb, yCurrCtb) == this.getSliceAddrRS(xNCtb, yNCtb) && this.pps.TileIdRS[xCurrCtb + yCurrCtb * this.sps.PicWidthInCtbsY] == this.pps.TileIdRS[xNCtb + yNCtb * this.sps.PicWidthInCtbsY];
    }

    boolean checkCTBavailable(int xC, int yC, int xN, int yN) {
        if (xN < 0 || yN < 0 || xN >= this.Width || yN >= this.Height) {
            return false;
        }
        int current_ctbAddrRS = this.lumaPosToCtbAddrRS(xC, yC);
        int neighbor_ctbAddrRS = this.lumaPosToCtbAddrRS(xN, yN);
        return this.getSliceAddrRsAtCtbRS(current_ctbAddrRS) == this.getSliceAddrRsAtCtbRS(neighbor_ctbAddrRS) && this.pps.TileIdRS[current_ctbAddrRS] == this.pps.TileIdRS[neighbor_ctbAddrRS];
    }

    private int lumaPosToCtbAddrRS(int x, int y) {
        int ctbX = x >> this.sps.Log2CtbSizeY;
        int ctbY = y >> this.sps.Log2CtbSizeY;
        return ctbY * this.sps.PicWidthInCtbsY + ctbX;
    }

    int getChromaShiftW(int cIdx) {
        return cIdx != 0 ? this.sps.SubWidthC - 1 : 0;
    }

    int getChromaShiftH(int cIdx) {
        return cIdx != 0 ? this.sps.SubHeightC - 1 : 0;
    }

    int[] getImagePlane(int cIdx) {
        return this.planes[cIdx];
    }

    byte[] getImagePlaneByte(int cIdx) {
        return this.planesBytes[cIdx];
    }

    int getChromaFormat() {
        return this.chroma_format;
    }

    private static class MetaCB {
        final int width_in_units;
        final int height_in_units;
        final int log2unitSize;
        final InfoCB[] CBS;

        MetaCB(int w, int h, int log2) {
            this.width_in_units = w;
            this.height_in_units = h;
            this.log2unitSize = log2;
            int dim = w * h;
            this.CBS = new InfoCB[dim];
            for (int i = 0; i < dim; ++i) {
                this.CBS[i] = new InfoCB();
            }
        }

        InfoCB get(int x, int y) {
            int unitX = x >> this.log2unitSize;
            int unitY = y >> this.log2unitSize;
            return this.CBS[unitX + unitY * this.width_in_units];
        }
    }

    private static class MetaCTB {
        final int width_in_units;
        final int height_in_units;
        final int log2unitSize;
        final InfoCTB[] CTBS;

        MetaCTB(int w, int h, int log2) {
            this.width_in_units = w;
            this.height_in_units = h;
            this.log2unitSize = log2;
            int dim = w * h;
            this.CTBS = new InfoCTB[dim];
            for (int i = 0; i < dim; ++i) {
                this.CTBS[i] = new InfoCTB();
            }
        }

        InfoCTB get(int x, int y) {
            int unitX = x >> this.log2unitSize;
            int unitY = y >> this.log2unitSize;
            return this.CTBS[unitX + unitY * this.width_in_units];
        }
    }

    private static class MetaTU {
        final int width_in_units;
        final int height_in_units;
        final int log2unitSize;
        final int[] TUS;

        MetaTU(int w, int h, int log2) {
            this.width_in_units = w;
            this.height_in_units = h;
            this.log2unitSize = log2;
            this.TUS = new int[w * h];
        }

        int get(int x, int y) {
            int unitX = x >> this.log2unitSize;
            int unitY = y >> this.log2unitSize;
            return this.TUS[unitX + unitY * this.width_in_units];
        }

        void set(int x, int y, int v) {
            int unitX = x >> this.log2unitSize;
            int unitY = y >> this.log2unitSize;
            this.TUS[unitX + unitY * this.width_in_units] = v;
        }

        void clearBlk(int x, int y, int log2BlkWidth) {
            int tuX = x >> this.log2unitSize;
            int tuY = y >> this.log2unitSize;
            int width = 1 << log2BlkWidth - this.log2unitSize;
            for (int tuy = tuY; tuy < tuY + width; ++tuy) {
                for (int tux = tuX; tux < tuX + width; ++tux) {
                    this.TUS[tux + tuy * this.width_in_units] = 0;
                }
            }
        }
    }

    private static final class InfoCB {
        byte log2 = (byte)3;
        byte ctDepth = (byte)2;
        byte predMode = (byte)2;
        byte partMode = (byte)3;
        boolean pcmFlag;
        boolean cuTransquantBypass;
        byte qpY;

        private InfoCB() {
        }
    }

    private static final class InfoCTB {
        int sliceAddrRS;
        int sliceHeaderIndex;
        InfoSAO infoSAO;
        boolean has_pcm_or_cu_transquant_bypass;

        private InfoCTB() {
        }
    }
}

