/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.heic.common;

import com.idrsolutions.image.heic.common.Cabac;
import com.idrsolutions.image.heic.common.CtxTbl;
import com.idrsolutions.image.heic.common.EImageData;
import com.idrsolutions.image.heic.common.EIntraPred;
import com.idrsolutions.image.heic.common.EPacket;
import com.idrsolutions.image.heic.common.ESop;
import com.idrsolutions.image.heic.common.Ecb;
import com.idrsolutions.image.heic.common.EpicBuf;
import com.idrsolutions.image.heic.common.Etb;
import com.idrsolutions.image.heic.common.EtbMatrix;
import com.idrsolutions.image.heic.common.HImg;
import com.idrsolutions.image.heic.common.HeicMath;
import com.idrsolutions.image.heic.common.Nal;
import com.idrsolutions.image.heic.common.Pps;
import com.idrsolutions.image.heic.common.Scan;
import com.idrsolutions.image.heic.common.Sps;
import com.idrsolutions.image.heic.common.Ssh;
import com.idrsolutions.image.heic.common.Transform;
import com.idrsolutions.image.heic.common.Vps;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jpedal.utils.LogWriter;

class EContext {
    HImg img;
    Vps vps = new Vps();
    Sps sps = new Sps();
    Pps pps = new Pps();
    Ssh ssh = new Ssh();
    final Cabac cabac = new Cabac();
    final CtxTbl ctxTbl = new CtxTbl();
    EtbMatrix ctbs = new EtbMatrix();
    EImageData imgdata;
    final EpicBuf picbuf = new EpicBuf();
    ESop sop;
    List<EPacket> output_packets = new ArrayList<EPacket>();
    final EIntraPred eIntraPred = new EIntraPred();
    private static final int MIN_CB_SIZE = 8;
    private static final int MAX_CB_SIZE = 32;
    private static final int MIN_TB_SIZE = 4;
    private static final int MAX_TB_SIZE = 32;
    private static final int MAX_TRANSFORM_DEPTH = 3;
    int active_qp;
    int image_width;
    int image_height;
    boolean use_adaptive_context;
    private final int[] coeff_value = new int[16];
    private final int[] coeff_scan_pos = new int[16];
    private final int[] coeff_sign = new int[16];
    private final int[] coeff_has_max_base_level = new int[16];
    private final int[] coeff_baseLevel = new int[16];
    private final int[] coded_sub_block_neighbors = new int[64];
    private final int[] dstG = new int[16];
    private final int[] dctG4 = new int[16];
    private final int[] dctG8 = new int[64];
    private final int[] dctG16 = new int[256];
    private final int[] dctG32 = new int[1024];
    private int lastInvocation_greater1Ctx;
    private int lastInvocation_coeff_abs_level_greater1_flag;
    private int lastInvocation_ctxSet;
    private int lastSignificantX;
    private int lastSignificantY;
    private int lastSubBlock;
    private int lastScanPos;
    private int prefixX;
    private int suffixX;
    private int suffixBitsX;
    private int prefixY;
    private int suffixY;
    private int suffixBitsY;

    private static void debug(String message, int v) {
    }

    static List<byte[]> encodeImage(BufferedImage image, int spsW, int spsH) {
        ArrayList<byte[]> res = new ArrayList<byte[]>();
        EContext ectx = new EContext();
        ectx.start_encoder();
        ectx.sop.insert_new_input_image(image);
        ectx.encode_picture_from_input_buffer(image, spsW, spsH);
        ectx.sop.insert_end_of_stream();
        for (EPacket ep : ectx.output_packets) {
            res.add(ep.data);
        }
        return res;
    }

    EContext() {
        this.vps = new Vps();
        this.sps = new Sps();
        this.pps = new Pps();
    }

    private EPacket createPacket(int t) {
        EPacket pck = new EPacket();
        byte[] data = this.cabac.getEncodedData();
        pck.data = data;
        pck.length = data.length;
        pck.frame_number = -1;
        pck.content_type = t;
        pck.nuh_layer_id = 0;
        pck.nuh_temporal_id = 0;
        pck.encoder_context = this;
        pck.input_image = null;
        this.cabac.reset();
        return pck;
    }

    private void start_encoder() {
        this.sop = new ESop();
        this.sop.set_encoder_context(this);
        this.sop.set_encoder_picture_buffer(this.picbuf);
    }

    private void encode_headers() {
        this.vps.setDefaults(0, 6, 2);
        this.sps.setDefaults();
        this.sps.set_CB_log2size_range(HeicMath.log2(8), HeicMath.log2(32));
        this.sps.set_TB_log2size_range(HeicMath.log2(4), HeicMath.log2(32));
        this.sps.max_transform_hierarchy_depth_intra = 3;
        this.sps.max_transform_hierarchy_depth_inter = 3;
        this.sps.setResolution(this.image_width, this.image_height);
        this.sop.set_SPS_header_values();
        this.sps.deriveValues();
        this.pps.setDefaults();
        this.pps.deblocking_filter_control_present_flag = 0;
        this.pps.deblocking_filter_override_enabled_flag = 0;
        this.pps.deblocking_filter_disabled_flag = 1;
        this.pps.loop_filter_across_slices_enabled_flag = 0;
        this.pps.deriveValues(this.sps);
        Nal.writeNal(this.cabac, 32, 0, 0);
        this.vps.write(this.img, this.cabac);
        this.cabac.add_trailing_bits();
        EPacket pck = this.createPacket(32);
        pck.nal_unit_type = 32;
        this.output_packets.add(pck);
        Nal.writeNal(this.cabac, 33, 0, 0);
        this.sps.write(this.img, this.cabac);
        this.cabac.add_trailing_bits();
        pck = this.createPacket(33);
        pck.nal_unit_type = 33;
        this.output_packets.add(pck);
        Nal.writeNal(this.cabac, 34, 0, 0);
        this.pps.write(this.img, this.cabac);
        this.cabac.add_trailing_bits();
        pck = this.createPacket(34);
        pck.nal_unit_type = 34;
        this.output_packets.add(pck);
    }

    private void encode_picture_from_input_buffer(BufferedImage input, int spsW, int spsH) {
        this.image_width = spsW;
        this.image_height = spsH;
        this.ctbs.alloc(this.image_width, this.image_height, HeicMath.log2(32));
        this.imgdata = new EImageData();
        this.imgdata = this.picbuf.get_next_picture_to_encode();
        this.ssh = this.imgdata.shdr;
        this.encode_headers();
        this.imgdata.shdr.slice_deblocking_filter_disabled_flag = 1;
        this.imgdata.shdr.slice_loop_filter_across_slices_enabled_flag = 0;
        this.imgdata.shdr.computeDerivedValues(this.pps);
        Nal.writeNal(this.cabac, this.imgdata.nal.nal_unit_type, this.imgdata.nal.nuh_layer_id, this.imgdata.nal.nuh_temporal_id);
        this.imgdata.shdr.write(this.cabac, this.img, this.sps, this.pps, this.imgdata.nal.nal_unit_type);
        this.cabac.add_trailing_bits();
        this.cabac.init_CABAC();
        this.img = new HImg();
        this.img.allocateImage(this.sps, this.pps, input);
        this.encode_image(this.img);
        this.cabac.add_trailing_bits();
        EPacket pck = this.createPacket(20);
        pck.input_image = this.img;
        pck.frame_number = this.imgdata.frame_number;
        pck.nal_unit_type = this.imgdata.nal.nal_unit_type;
        pck.nuh_layer_id = this.imgdata.nal.nuh_layer_id;
        pck.nuh_temporal_id = this.imgdata.nal.nuh_temporal_id;
        this.output_packets.add(pck);
    }

    private void encode_split_cu_flag(Cabac cabac, int x0, int y0, int ctDepth, int split_flag) {
        EContext.debug("split cu", 0);
        boolean availableL = this.img.checkCTBavailable(x0, y0, x0 - 1, y0);
        boolean availableA = this.img.checkCTBavailable(x0, y0, x0, y0 - 1);
        int condL = 0;
        int condA = 0;
        if (availableL && this.ctbs.getCB((int)(x0 - 1), (int)y0).ctDepth > ctDepth) {
            condL = 1;
        }
        if (availableA && this.ctbs.getCB((int)x0, (int)(y0 - 1)).ctDepth > ctDepth) {
            condA = 1;
        }
        int context = condL + condA;
        cabac.write_CABAC_bit(2 + context, split_flag);
    }

    private static void encode_part_mode(Cabac cabac, int PredMode, int PartMode) {
        EContext.debug("part mode", PartMode);
        if (PredMode == 0) {
            int bin = PartMode == 0 ? 1 : 0;
            cabac.write_CABAC_bit(8, bin);
        } else {
            LogWriter.writeLog("######interpart mode should not be called");
        }
    }

    private static void encode_pred_mode_flag(Cabac cabac, int PredMode) {
        EContext.debug("pred mode", PredMode);
        int flag = PredMode == 0 ? 1 : 0;
        cabac.write_CABAC_bit(149, flag);
    }

    private static void encode_prev_intra_luma_pred_flag(Cabac cabac, int intraPred) {
        EContext.debug("prev intra luma", intraPred);
        int bin = intraPred >= 0 ? 1 : 0;
        cabac.write_CABAC_bit(12, bin);
    }

    private static void encode_intra_mpm_or_rem(Cabac cabac, int intraPred) {
        EContext.debug("intra mpm", intraPred);
        if (intraPred >= 0) {
            if (intraPred > 2) {
                LogWriter.writeLog("######Error intra mpm or rem");
            }
            cabac.write_CABAC_TU_bypass(intraPred, 2);
        } else {
            cabac.write_CABAC_FL_bypass(-intraPred - 1, 5);
        }
    }

    private static void encode_intra_chroma_pred_mode(Cabac cabac, int mode) {
        EContext.debug("intra chroma", mode);
        if (mode == 4) {
            cabac.write_CABAC_bit(13, 0);
        } else {
            if (mode > 4) {
                LogWriter.writeLog("Error intra chroma pred mode");
            }
            cabac.write_CABAC_bit(13, 1);
            cabac.write_CABAC_FL_bypass(mode, 2);
        }
    }

    private static int find_chroma_pred_mode(int chroma_mode, int luma_mode) {
        if (luma_mode == chroma_mode) {
            return 4;
        }
        int mode = chroma_mode;
        if (chroma_mode == 34) {
            mode = luma_mode;
        }
        switch (mode) {
            case 0: {
                return 0;
            }
            case 26: {
                return 1;
            }
            case 10: {
                return 2;
            }
            case 1: {
                return 3;
            }
        }
        return 3;
    }

    private static void encode_split_transform_flag(Cabac cabac, int log2TrafoSize, int split_flag) {
        int context = 5 - log2TrafoSize;
        EContext.debug("split transform", 0);
        if (context < 0 || context > 2) {
            System.err.println("Error split transform flag");
        }
        cabac.write_CABAC_bit(20 + context, split_flag);
    }

    private static void encode_cbf_luma(Cabac cabac, boolean zeroTrafoDepth, int cbf_luma) {
        EContext.debug("cbf luma", cbf_luma);
        int context = zeroTrafoDepth ? 1 : 0;
        cabac.write_CABAC_bit(14 + context, cbf_luma);
    }

    private static void encode_cbf_chroma(Cabac cabac, int trafoDepth, int cbf_chroma) {
        EContext.debug("cbf luma", cbf_chroma);
        int context = trafoDepth;
        if (context < 0 || context > 3) {
            System.err.println("Error cbf chroma flag");
        }
        cabac.write_CABAC_bit(16 + context, cbf_chroma);
    }

    private static void encode_coded_sub_block_flag(Cabac cabac, int cIdx, int coded_subblk_neighbors, int flag) {
        int ctxIdxInc = coded_subblk_neighbors & 1 | coded_subblk_neighbors >> 1;
        if (cIdx != 0) {
            ctxIdxInc += 2;
        }
        EContext.debug("coded sub block", flag);
        cabac.write_CABAC_bit(61 + ctxIdxInc, flag);
    }

    private static void encode_significant_coeff_flag_lookup(Cabac cabac, int ctxIdxInc, int significantFlag) {
        EContext.debug("sig coeff", significantFlag);
        cabac.write_CABAC_bit(65 + ctxIdxInc, significantFlag);
    }

    private void encode_coeff_abs_level_greater1(Cabac cabac, int cIdx, int i, boolean firstCoeffInSubblock, boolean firstSubblock, int lastSubblock_greater1Ctx, int c1, int value) {
        int greater1Ctx;
        int ctxSet;
        if (firstCoeffInSubblock) {
            ctxSet = i == 0 || cIdx > 0 ? 0 : 2;
            int lastGreater1Ctx = firstSubblock ? 1 : lastSubblock_greater1Ctx;
            if (lastGreater1Ctx == 0) {
                ++ctxSet;
            }
            greater1Ctx = 1;
        } else {
            ctxSet = this.lastInvocation_ctxSet;
            greater1Ctx = this.lastInvocation_greater1Ctx;
            if (greater1Ctx > 0) {
                int lastGreater1Flag = this.lastInvocation_coeff_abs_level_greater1_flag;
                greater1Ctx = lastGreater1Flag == 1 ? 0 : ++greater1Ctx;
            }
        }
        ctxSet = c1;
        int ctxIdxInc = ctxSet * 4 + (greater1Ctx >= 3 ? 3 : greater1Ctx);
        if (cIdx > 0) {
            ctxIdxInc += 16;
        }
        EContext.debug("coef abs level greater1", value);
        cabac.write_CABAC_bit(109 + ctxIdxInc, value);
        this.lastInvocation_greater1Ctx = greater1Ctx;
        this.lastInvocation_coeff_abs_level_greater1_flag = value;
        this.lastInvocation_ctxSet = ctxSet;
    }

    private static void encode_coeff_abs_level_greater2(Cabac cabac, int cIdx, int ctxSet, int value) {
        EContext.debug("coef abs level greater2", value);
        int ctxIdxInc = ctxSet;
        if (cIdx > 0) {
            ctxIdxInc += 4;
        }
        cabac.write_CABAC_bit(133 + ctxIdxInc, value);
    }

    private void findLastSignificantCoeff(int[] sbScan, int[] cScan, int[] coeff, int log2TrafoSize) {
        int nSb;
        int i = nSb = 1 << (log2TrafoSize - 2 << 1);
        while (i-- > 0) {
            int x0 = sbScan[i] >> 16 << 2;
            int y0 = (sbScan[i] & 0xFFFF) << 2;
            int c = 16;
            while (c-- > 0) {
                int x = x0 + (cScan[c] >> 16);
                int y = y0 + (cScan[c] & 0xFFFF);
                if (coeff[x + (y << log2TrafoSize)] == 0) continue;
                this.lastSignificantX = x;
                this.lastSignificantY = y;
                this.lastSubBlock = i;
                this.lastScanPos = c;
                return;
            }
        }
    }

    private static int subblock_has_nonzero_coefficient(int[] coeff, int coeffStride, int xS, int yS) {
        int x0 = xS << 2;
        int y0 = yS << 2;
        int sbOff = x0 + y0 * coeffStride;
        for (int y = 0; y < 4; ++y) {
            if (coeff[sbOff] != 0 || coeff[sbOff + 1] != 0 || coeff[sbOff + 2] != 0 || coeff[sbOff + 3] != 0) {
                return 1;
            }
            sbOff += coeffStride;
        }
        return 0;
    }

    private static void encode_last_signficiant_coeff_prefix(Cabac cabac, int log2TrafoSize, int cIdx, int lastSignificant, int context_model_index) {
        int ctxIdxInc;
        int binIdx;
        int ctxShift;
        int ctxOffset;
        EContext.debug("last sig coeff", lastSignificant);
        int cMax = (log2TrafoSize << 1) - 1;
        if (cIdx == 0) {
            ctxOffset = 3 * (log2TrafoSize - 2) + (log2TrafoSize - 1 >> 2);
            ctxShift = log2TrafoSize + 1 >> 2;
        } else {
            ctxOffset = 15;
            ctxShift = log2TrafoSize - 2;
        }
        for (binIdx = 0; binIdx < lastSignificant; ++binIdx) {
            ctxIdxInc = binIdx >> ctxShift;
            cabac.write_CABAC_bit(context_model_index + ctxOffset + ctxIdxInc, 1);
        }
        if (lastSignificant != cMax) {
            binIdx = lastSignificant;
            ctxIdxInc = binIdx >> ctxShift;
            cabac.write_CABAC_bit(context_model_index + ctxOffset + ctxIdxInc, 0);
        }
    }

    private void split_last_significant_positionX(int pos) {
        int range;
        if (pos <= 3) {
            this.prefixX = pos;
            this.suffixX = -1;
            this.suffixBitsX = 0;
            return;
        }
        pos -= 4;
        int nBits = 1;
        for (range = 4; pos >= range; pos -= range, range <<= 1) {
            ++nBits;
        }
        this.prefixX = 1 + nBits << 1;
        if (pos >= range >> 1) {
            this.prefixX |= 1;
            pos -= range >> 1;
        }
        this.suffixX = pos;
        this.suffixBitsX = nBits;
    }

    private void split_last_significant_positionY(int pos) {
        int range;
        if (pos <= 3) {
            this.prefixY = pos;
            this.suffixY = -1;
            this.suffixBitsY = 0;
            return;
        }
        pos -= 4;
        int nBits = 1;
        for (range = 4; pos >= range; pos -= range, range <<= 1) {
            ++nBits;
        }
        this.prefixY = 1 + nBits << 1;
        if (pos >= range >> 1) {
            this.prefixY |= 1;
            pos -= range >> 1;
        }
        this.suffixY = pos;
        this.suffixBitsY = nBits;
    }

    private void encode_residual(Cabac cabac, Etb tb, Ecb cb, int xx, int yy, int log2TrafoSize, int cIdx) {
        int[] coeff = tb.coeff[cIdx];
        byte PredMode = cb.predMode;
        int scanIdx = 0;
        if (PredMode == 0) {
            scanIdx = cIdx == 0 ? EContext.getIntraScanIdx(log2TrafoSize, tb.intra_mode, cIdx, this.sps.ChromaArrayType) : EContext.getIntraScanIdx(log2TrafoSize, tb.intra_mode_chroma, cIdx, this.sps.ChromaArrayType);
        }
        int[] ScanOrderSub = Scan.get_scan_order(log2TrafoSize - 2, scanIdx);
        int[] ScanOrderPos = Scan.get_scan_order(2, scanIdx);
        this.lastSignificantX = 0;
        this.lastSignificantY = 0;
        this.lastScanPos = 0;
        this.lastSubBlock = 0;
        this.findLastSignificantCoeff(ScanOrderSub, ScanOrderPos, coeff, log2TrafoSize);
        int codedSignificantX = this.lastSignificantX;
        int codedSignificantY = this.lastSignificantY;
        if (scanIdx == 2) {
            int temp = codedSignificantX;
            codedSignificantX = codedSignificantY;
            codedSignificantY = temp;
        }
        this.prefixX = 0;
        this.prefixY = 0;
        this.suffixX = 0;
        this.suffixY = 0;
        this.suffixBitsX = 0;
        this.suffixBitsY = 0;
        this.split_last_significant_positionX(codedSignificantX);
        this.split_last_significant_positionY(codedSignificantY);
        EContext.encode_last_signficiant_coeff_prefix(cabac, log2TrafoSize, cIdx, this.prefixX, 25);
        EContext.encode_last_signficiant_coeff_prefix(cabac, log2TrafoSize, cIdx, this.prefixY, 43);
        if (codedSignificantX > 3) {
            cabac.write_CABAC_FL_bypass(this.suffixX, this.suffixBitsX);
        }
        if (codedSignificantY > 3) {
            cabac.write_CABAC_FL_bypass(this.suffixY, this.suffixBitsY);
        }
        int sbWidth = 1 << log2TrafoSize - 2;
        int CoeffStride = 1 << log2TrafoSize;
        Arrays.fill(this.coded_sub_block_neighbors, 0);
        int c1 = 1;
        boolean firstSubblock = true;
        int lastSubblock_greater1Ctx = 0;
        this.lastInvocation_greater1Ctx = 0;
        this.lastInvocation_coeff_abs_level_greater1_flag = 0;
        this.lastInvocation_ctxSet = 0;
        for (int i = this.lastSubBlock; i >= 0; --i) {
            int ctxSet;
            int xS = ScanOrderSub[i] >> 16;
            int yS = ScanOrderSub[i] & 0xFFFF;
            boolean inferSbDcSigCoeffFlag = false;
            int sub_block_is_coded = 0;
            if (i < this.lastSubBlock && i > 0) {
                sub_block_is_coded = EContext.subblock_has_nonzero_coefficient(coeff, CoeffStride, xS, yS);
                EContext.encode_coded_sub_block_flag(cabac, cIdx, this.coded_sub_block_neighbors[xS + yS * sbWidth], sub_block_is_coded);
                inferSbDcSigCoeffFlag = true;
            } else if (i == 0 || i == this.lastSubBlock) {
                sub_block_is_coded = 1;
            }
            if (sub_block_is_coded != 0) {
                if (xS > 0) {
                    int n = xS - 1 + yS * sbWidth;
                    this.coded_sub_block_neighbors[n] = this.coded_sub_block_neighbors[n] | 1;
                }
                if (yS > 0) {
                    int n = xS + (yS - 1) * sbWidth;
                    this.coded_sub_block_neighbors[n] = this.coded_sub_block_neighbors[n] | 2;
                }
            }
            Arrays.fill(this.coeff_value, 0);
            Arrays.fill(this.coeff_scan_pos, 0);
            Arrays.fill(this.coeff_sign, 0);
            Arrays.fill(this.coeff_has_max_base_level, 0);
            Arrays.fill(this.coeff_baseLevel, 0);
            int nCoefficients = 0;
            if (sub_block_is_coded != 0) {
                int last_coeff;
                int xx0 = xS << 2;
                int yy0 = yS << 2;
                int log2w = log2TrafoSize - 2;
                int prevCsbf = this.coded_sub_block_neighbors[xS + yS * sbWidth];
                int sc = scanIdx == 0 ? 0 : 1;
                int cc = cIdx == 0 ? 0 : 1;
                byte[] ctxIdxMap = CtxTbl.CTXINDEXLOOKUP[log2w][cc][sc][prevCsbf];
                int n = last_coeff = i == this.lastSubBlock ? this.lastScanPos - 1 : 15;
                if (i == this.lastSubBlock) {
                    this.coeff_value[nCoefficients] = coeff[this.lastSignificantX + (this.lastSignificantY << log2TrafoSize)];
                    this.coeff_has_max_base_level[nCoefficients] = 1;
                    this.coeff_scan_pos[nCoefficients] = this.lastScanPos;
                    ++nCoefficients;
                }
                for (int n2 = last_coeff; n2 > 0; --n2) {
                    int xC = xx0 + (ScanOrderPos[n2] >> 16);
                    int yC = yy0 + (ScanOrderPos[n2] & 0xFFFF);
                    int isSignificant = coeff[xC + (yC << log2TrafoSize)] == 0 ? 0 : 1;
                    int ctxInc = ctxIdxMap[xC + (yC << log2TrafoSize)] & 0xFF;
                    EContext.encode_significant_coeff_flag_lookup(cabac, ctxInc, isSignificant);
                    if (isSignificant == 0) continue;
                    this.coeff_value[nCoefficients] = coeff[xC + (yC << log2TrafoSize)];
                    this.coeff_has_max_base_level[nCoefficients] = 1;
                    this.coeff_scan_pos[nCoefficients] = n2;
                    ++nCoefficients;
                    inferSbDcSigCoeffFlag = false;
                }
                if (last_coeff >= 0) {
                    if (!inferSbDcSigCoeffFlag) {
                        int isSignificant = coeff[xx0 + (yy0 << log2TrafoSize)] == 0 ? 0 : 1;
                        int ctxInc = ctxIdxMap[xx0 + (yy0 << log2TrafoSize)] & 0xFF;
                        EContext.encode_significant_coeff_flag_lookup(cabac, ctxInc, isSignificant);
                        if (isSignificant != 0) {
                            this.coeff_value[nCoefficients] = coeff[xx0 + (yy0 << log2TrafoSize)];
                            this.coeff_has_max_base_level[nCoefficients] = 1;
                            this.coeff_scan_pos[nCoefficients] = 0;
                            ++nCoefficients;
                        }
                    } else {
                        this.coeff_value[nCoefficients] = coeff[xx0 + (yy0 << log2TrafoSize)];
                        this.coeff_has_max_base_level[nCoefficients] = 1;
                        this.coeff_scan_pos[nCoefficients] = 0;
                        ++nCoefficients;
                    }
                }
            }
            if (nCoefficients == 0) continue;
            for (int l = 0; l < nCoefficients; ++l) {
                if (this.coeff_value[l] < 0) {
                    this.coeff_value[l] = -this.coeff_value[l];
                    this.coeff_sign[l] = 1;
                } else {
                    this.coeff_sign[l] = 0;
                }
                this.coeff_baseLevel[l] = 1;
            }
            int n = ctxSet = i == 0 || cIdx > 0 ? 0 : 2;
            if (c1 == 0) {
                ++ctxSet;
            }
            c1 = 1;
            int newLastGreater1ScanPos = -1;
            int lastGreater1Coefficient = Math.min(8, nCoefficients);
            for (int c = 0; c < lastGreater1Coefficient; ++c) {
                int greater1_flag = this.coeff_value[c] > 1 ? 1 : 0;
                this.encode_coeff_abs_level_greater1(cabac, cIdx, i, c == 0, firstSubblock, lastSubblock_greater1Ctx, ctxSet, greater1_flag);
                if (greater1_flag != 0) {
                    int n3 = c;
                    this.coeff_baseLevel[n3] = this.coeff_baseLevel[n3] + 1;
                    c1 = 0;
                    if (newLastGreater1ScanPos != -1) continue;
                    newLastGreater1ScanPos = c;
                    continue;
                }
                this.coeff_has_max_base_level[c] = 0;
                if (c1 >= 3 || c1 <= 0) continue;
                ++c1;
            }
            firstSubblock = false;
            lastSubblock_greater1Ctx = this.lastInvocation_greater1Ctx;
            if (newLastGreater1ScanPos != -1) {
                int greater2_flag = this.coeff_value[newLastGreater1ScanPos] > 2 ? 1 : 0;
                EContext.encode_coeff_abs_level_greater2(cabac, cIdx, this.lastInvocation_ctxSet, greater2_flag);
                int n4 = newLastGreater1ScanPos;
                this.coeff_baseLevel[n4] = this.coeff_baseLevel[n4] + greater2_flag;
                this.coeff_has_max_base_level[newLastGreater1ScanPos] = greater2_flag;
            }
            boolean signHidden = this.coeff_scan_pos[0] - this.coeff_scan_pos[nCoefficients - 1] > 3 && !cb.cu_transquant_bypass_flag;
            for (int n5 = 0; n5 < nCoefficients - 1; ++n5) {
                cabac.write_CABAC_bypass(this.coeff_sign[n5]);
            }
            if (this.pps.sign_data_hiding_enabled_flag == 0 || !signHidden) {
                cabac.write_CABAC_bypass(this.coeff_sign[nCoefficients - 1]);
            }
            int uiGoRiceParam = 0;
            for (int n6 = 0; n6 < nCoefficients; ++n6) {
                int baseLevel = this.coeff_baseLevel[n6];
                int coeff_abs_level_remaining = 0;
                if (this.coeff_has_max_base_level[n6] == 0) continue;
                coeff_abs_level_remaining = this.coeff_value[n6] - this.coeff_baseLevel[n6];
                EContext.encode_coeff_abs_level_remaining(cabac, uiGoRiceParam, coeff_abs_level_remaining);
                if (baseLevel + coeff_abs_level_remaining <= 3 * (1 << uiGoRiceParam) || ++uiGoRiceParam <= 4) continue;
                uiGoRiceParam = 4;
            }
        }
        tb.clearData(cIdx);
    }

    private static void encode_coeff_abs_level_remaining(Cabac cabac, int cRiceParam, int level) {
        int remain;
        EContext.debug("coef abs level remaining", level);
        int cTRMax = 4 << cRiceParam;
        int prefixPart = Math.min(level, cTRMax);
        int nOnes = prefixPart >> cRiceParam;
        cabac.write_CABAC_TU_bypass(nOnes, 4);
        if (cTRMax > prefixPart) {
            remain = prefixPart & (1 << cRiceParam) - 1;
            cabac.write_CABAC_FL_bypass(remain, cRiceParam);
        }
        if (nOnes == 4) {
            remain = level - cTRMax;
            int ExpGRiceParam = cRiceParam + 1;
            int prefix = remain >> ExpGRiceParam;
            int suffix = remain - (prefix << ExpGRiceParam);
            int base = 0;
            int range = 1;
            int nBits = 0;
            while (prefix >= base + range) {
                cabac.write_CABAC_bypass(1);
                base += range;
                range *= 2;
                ++nBits;
            }
            cabac.write_CABAC_bypass(0);
            cabac.write_CABAC_FL_bypass(prefix - base, nBits);
            cabac.write_CABAC_FL_bypass(suffix, ExpGRiceParam);
        }
    }

    private void encode_transform_unit(Cabac cabac, Etb tb, Ecb cb, int x0, int y0, int xBase, int yBase, int log2TrafoSize, int trafoDepth, int blkIdx) {
        if (tb.cbf[0] != 0 || tb.cbf[1] != 0 || tb.cbf[2] != 0) {
            if (tb.cbf[0] != 0) {
                this.encode_residual(cabac, tb, cb, x0, y0, log2TrafoSize, 0);
            }
            if (this.sps.chroma_format_idc == 3) {
                if (tb.cbf[1] != 0) {
                    this.encode_residual(cabac, tb, cb, x0, y0, log2TrafoSize, 1);
                }
                if (tb.cbf[2] != 0) {
                    this.encode_residual(cabac, tb, cb, x0, y0, log2TrafoSize, 2);
                }
            } else if (log2TrafoSize > 2) {
                if (tb.cbf[1] != 0) {
                    this.encode_residual(cabac, tb, cb, x0, y0, log2TrafoSize - 1, 1);
                }
                if (tb.cbf[2] != 0) {
                    this.encode_residual(cabac, tb, cb, x0, y0, log2TrafoSize - 1, 2);
                }
            } else if (blkIdx == 3) {
                if (tb.cbf[1] != 0) {
                    this.encode_residual(cabac, tb, cb, xBase, yBase, log2TrafoSize, 1);
                }
                if (tb.cbf[2] != 0) {
                    this.encode_residual(cabac, tb, cb, xBase, yBase, log2TrafoSize, 2);
                }
            }
        }
    }

    private void encode_transform_tree(Cabac cabac, Etb tb, Ecb cb, int x0, int y0, int xBase, int yBase, int log2TrafoSize, int trafoDepth, int blkIdx, int MaxTrafoDepth, int IntraSplitFlag, boolean recurse) {
        if (log2TrafoSize <= this.sps.Log2MaxTrafoSize && log2TrafoSize > this.sps.Log2MinTrafoSize && trafoDepth < MaxTrafoDepth && (IntraSplitFlag == 0 || trafoDepth != 0)) {
            int split_transform_flag = tb.split_transform_flag ? 1 : 0;
            EContext.encode_split_transform_flag(cabac, log2TrafoSize, split_transform_flag);
        } else {
            boolean bl;
            boolean interSplitFlag = false;
            boolean bl2 = log2TrafoSize > this.sps.Log2MaxTrafoSize || IntraSplitFlag == 1 && trafoDepth == 0 ? true : (bl = false);
        }
        if (log2TrafoSize > 2 || this.sps.ChromaArrayType == 3) {
            if (trafoDepth == 0 || tb.parent.cbf[1] != 0) {
                EContext.encode_cbf_chroma(cabac, trafoDepth, tb.cbf[1]);
            }
            if (trafoDepth == 0 || tb.parent.cbf[2] != 0) {
                EContext.encode_cbf_chroma(cabac, trafoDepth, tb.cbf[2]);
            }
        }
        if (tb.split_transform_flag) {
            if (recurse) {
                int x1 = x0 + (1 << log2TrafoSize - 1);
                int y1 = y0 + (1 << log2TrafoSize - 1);
                this.encode_transform_tree(cabac, tb.children[0], cb, x0, y0, x0, y0, log2TrafoSize - 1, trafoDepth + 1, 0, MaxTrafoDepth, IntraSplitFlag, true);
                this.encode_transform_tree(cabac, tb.children[1], cb, x1, y0, x0, y0, log2TrafoSize - 1, trafoDepth + 1, 1, MaxTrafoDepth, IntraSplitFlag, true);
                this.encode_transform_tree(cabac, tb.children[2], cb, x0, y1, x0, y0, log2TrafoSize - 1, trafoDepth + 1, 2, MaxTrafoDepth, IntraSplitFlag, true);
                this.encode_transform_tree(cabac, tb.children[3], cb, x1, y1, x0, y0, log2TrafoSize - 1, trafoDepth + 1, 3, MaxTrafoDepth, IntraSplitFlag, true);
            }
        } else {
            if (cb.predMode == 0 || trafoDepth != 0 || tb.cbf[1] != 0 || tb.cbf[2] != 0) {
                EContext.encode_cbf_luma(cabac, trafoDepth == 0, tb.cbf[0]);
            }
            this.encode_transform_unit(cabac, tb, cb, x0, y0, xBase, yBase, log2TrafoSize, trafoDepth, blkIdx);
        }
    }

    private void encode_cu_skip_flag(Cabac cabac, Ecb cb, boolean skip) {
        short x0 = cb.x;
        short y0 = cb.y;
        boolean availableL = this.img.checkCTBavailable(x0, y0, x0 - 1, y0);
        boolean availableA = this.img.checkCTBavailable(x0, y0, x0, y0 - 1);
        int condL = 0;
        int condA = 0;
        if (availableL && this.ctbs.getCB((int)(x0 - 1), (int)y0).predMode == 2) {
            condL = 1;
        }
        if (availableA && this.ctbs.getCB((int)x0, (int)(y0 - 1)).predMode == 2) {
            condA = 1;
        }
        int context = condL + condA;
        int bit = skip ? 1 : 0;
        cabac.write_CABAC_bit(5 + context, bit);
    }

    private void encode_coding_unit(Cabac cabac, Ecb cb, int x0, int y0, int log2CbSize, boolean recurse) {
        int nCbS = 1 << log2CbSize;
        if (this.ssh.slice_type != 2) {
            this.encode_cu_skip_flag(cabac, cb, cb.predMode == 2);
        }
        byte PredMode = cb.predMode;
        byte PartMode = 0;
        int IntraSplitFlag = 0;
        if (this.ssh.slice_type != 2) {
            EContext.encode_pred_mode_flag(cabac, PredMode);
        }
        if (PredMode != 0 || log2CbSize == this.sps.Log2MinCbSizeY) {
            PartMode = cb.partMode;
            EContext.encode_part_mode(cabac, PredMode, PartMode);
        }
        if (PredMode == 0) {
            boolean availableA0 = this.img.checkCTBavailable(x0, y0, x0 - 1, y0);
            boolean availableB0 = this.img.checkCTBavailable(x0, y0, x0, y0 - 1);
            if (PartMode == 0) {
                int[] candModeList = new int[3];
                EIntraPred.fillIntraPredModeCandidates(candModeList, x0, y0, availableA0, availableB0, this.ctbs, this.sps);
                byte mode = cb.transform_tree.intra_mode;
                int intraPred = this.eIntraPred.find_intra_pred_mode(mode, candModeList);
                EContext.encode_prev_intra_luma_pred_flag(cabac, intraPred);
                EContext.encode_intra_mpm_or_rem(cabac, intraPred);
                int chromaPredMode = EContext.find_chroma_pred_mode(cb.transform_tree.intra_mode_chroma, cb.transform_tree.intra_mode);
                EContext.encode_intra_chroma_pred_mode(cabac, chromaPredMode);
            } else {
                int i;
                IntraSplitFlag = 1;
                int pbOffset = nCbS / 2;
                int[] intraPred = new int[4];
                int childIdx = 0;
                for (int j = 0; j < nCbS; j += pbOffset) {
                    int i2 = 0;
                    while (i2 < nCbS) {
                        int x = x0 + i2;
                        int y = y0 + j;
                        boolean availableA = availableA0 || i2 > 0;
                        boolean availableB = availableB0 || j > 0;
                        int[] candModeList = new int[3];
                        EIntraPred.fillIntraPredModeCandidates(candModeList, x, y, availableA, availableB, this.ctbs, this.sps);
                        byte mode = cb.transform_tree.children[childIdx].intra_mode;
                        intraPred[childIdx] = this.eIntraPred.find_intra_pred_mode(mode, candModeList);
                        i2 += pbOffset;
                        ++childIdx;
                    }
                }
                for (i = 0; i < 4; ++i) {
                    EContext.encode_prev_intra_luma_pred_flag(cabac, intraPred[i]);
                }
                for (i = 0; i < 4; ++i) {
                    EContext.encode_intra_mpm_or_rem(cabac, intraPred[i]);
                }
                if (this.sps.ChromaArrayType == 3) {
                    for (i = 0; i < 4; ++i) {
                        int chromaPredMode = EContext.find_chroma_pred_mode(cb.transform_tree.children[i].intra_mode_chroma, cb.transform_tree.children[i].intra_mode);
                        EContext.encode_intra_chroma_pred_mode(cabac, chromaPredMode);
                    }
                } else {
                    int chromaPredMode = EContext.find_chroma_pred_mode(cb.transform_tree.children[0].intra_mode_chroma, cb.transform_tree.children[0].intra_mode);
                    EContext.encode_intra_chroma_pred_mode(cabac, chromaPredMode);
                }
            }
        } else {
            LogWriter.writeLog("Error inter coding unit should not be called");
        }
        if (cb.predMode == 0) {
            int MaxTrafoDepth = PredMode == 0 ? this.sps.max_transform_hierarchy_depth_intra + IntraSplitFlag : this.sps.max_transform_hierarchy_depth_inter;
            if (recurse) {
                this.encode_transform_tree(cabac, cb.transform_tree, cb, x0, y0, x0, y0, log2CbSize, 0, 0, MaxTrafoDepth, IntraSplitFlag, true);
            }
        }
    }

    private int get_split_type(int x0, int y0, int log2CbSize) {
        if (x0 + (1 << log2CbSize) <= this.sps.pic_width_in_luma_samples && y0 + (1 << log2CbSize) <= this.sps.pic_height_in_luma_samples && log2CbSize > this.sps.Log2MinCbSizeY) {
            return 2;
        }
        if (log2CbSize > this.sps.Log2MinCbSizeY) {
            return 1;
        }
        return 0;
    }

    private void encode_quadtree(Cabac cabac, Ecb cb, int x0, int y0, int log2CbSize, int ctDepth, boolean recurse) {
        int split_flag = this.get_split_type(x0, y0, log2CbSize);
        if (split_flag == 2) {
            split_flag = cb.split_cu_flag ? 1 : 0;
            this.encode_split_cu_flag(cabac, x0, y0, ctDepth, split_flag);
        }
        if (split_flag != 0) {
            if (recurse) {
                int x1 = x0 + (1 << log2CbSize - 1);
                int y1 = y0 + (1 << log2CbSize - 1);
                this.encode_quadtree(cabac, cb.children[0], x0, y0, log2CbSize - 1, ctDepth + 1, true);
                if (x1 < this.sps.pic_width_in_luma_samples) {
                    this.encode_quadtree(cabac, cb.children[1], x1, y0, log2CbSize - 1, ctDepth + 1, true);
                }
                if (y1 < this.sps.pic_height_in_luma_samples) {
                    this.encode_quadtree(cabac, cb.children[2], x0, y1, log2CbSize - 1, ctDepth + 1, true);
                }
                if (x1 < this.sps.pic_width_in_luma_samples && y1 < this.sps.pic_height_in_luma_samples) {
                    this.encode_quadtree(cabac, cb.children[3], x1, y1, log2CbSize - 1, ctDepth + 1, true);
                }
            }
        } else {
            this.encode_coding_unit(cabac, cb, x0, y0, log2CbSize, true);
        }
    }

    private void encode_ctb(Cabac cabac, Ecb cb, int ctbX, int ctbY) {
        int log2ctbSize = this.sps.Log2CtbSizeY;
        this.encode_quadtree(cabac, cb, ctbX << log2ctbSize, ctbY << log2ctbSize, log2ctbSize, 0, true);
    }

    private static int getIntraScanIdx(int log2TrafoSize, int intraPredMode, int cIdx, int chromaArrayType) {
        if (log2TrafoSize == 2 || log2TrafoSize == 3 && (cIdx == 0 || chromaArrayType == 3)) {
            if (intraPredMode >= 6 && intraPredMode <= 14) {
                return 2;
            }
            if (intraPredMode >= 22 && intraPredMode <= 30) {
                return 1;
            }
        }
        return 0;
    }

    private void encode_image(HImg img) {
        this.active_qp = this.pps.init_qp;
        this.ctxTbl.init(this.ssh.initType, this.ssh.SliceQPY);
        this.cabac.set_context_models(this.ctxTbl);
        int Log2CtbSize = this.sps.Log2CtbSizeY;
        for (int y = 0; y < this.sps.PicHeightInCtbsY; ++y) {
            for (int x = 0; x < this.sps.PicWidthInCtbsY; ++x) {
                img.setSliceAddrRS(x, y, this.ssh.SliceAddrRS);
                int x0 = x << Log2CtbSize;
                int y0 = y << Log2CtbSize;
                Ecb cb = this.getCBFromCTB(x0, y0);
                this.encode_ctb(this.cabac, cb, x, y);
                int last = y == this.sps.PicHeightInCtbsY - 1 && x == this.sps.PicWidthInCtbsY - 1 ? 1 : 0;
                this.cabac.write_CABAC_term_bit(last);
            }
        }
        this.cabac.add_trailing_bits();
    }

    private Ecb getCBFromCTB(int x, int y) {
        Ecb cb = new Ecb();
        cb.log2Size = (byte)this.sps.Log2CtbSizeY;
        cb.ctDepth = 0;
        cb.x = (short)x;
        cb.y = (short)y;
        this.ctbs.setCTBRootPointer(x, y, cb);
        cb.qp = this.active_qp;
        this.getCBFromSplit(cb);
        return cb;
    }

    private Ecb getCBFromSplit(Ecb cb_) {
        boolean can_nosplit_CB;
        int split_type = this.get_split_type(cb_.x, cb_.y, cb_.log2Size);
        boolean can_split_CB = split_type != 0;
        boolean bl = can_nosplit_CB = split_type != 1;
        if (can_split_CB) {
            return this.encode_cb_split(cb_);
        }
        if (can_nosplit_CB) {
            return this.getCBIntra(cb_);
        }
        return null;
    }

    private Ecb encode_cb_split(Ecb cb) {
        int w = this.img.getWidth(0);
        int h = this.img.getHeight(0);
        cb.split_cu_flag = true;
        cb.children = new Ecb[4];
        for (int i = 0; i < 4; ++i) {
            Ecb childCB;
            int child_x = cb.x + ((i & 1) << cb.log2Size - 1);
            int child_y = cb.y + (i >> 1 << cb.log2Size - 1);
            if (child_x >= w || child_y >= h) continue;
            cb.children[i] = childCB = new Ecb();
            childCB.log2Size = (byte)(cb.log2Size - 1);
            childCB.ctDepth = (byte)(cb.ctDepth + 1);
            childCB.x = (short)child_x;
            childCB.y = (short)child_y;
            this.getCBFromSplit(childCB);
        }
        return cb;
    }

    private Ecb getCBIntra(Ecb cb_) {
        byte log2CbSize = cb_.log2Size;
        short x = cb_.x;
        short y = cb_.y;
        this.img.setPredMode(x, y, log2CbSize, (byte)0);
        Ecb cb_result = this.getCBIntraPart(cb_);
        return cb_result;
    }

    private Ecb getCBIntraPart(Ecb cb) {
        int PartMode = 0;
        byte log2CbSize = cb.log2Size;
        short x = cb.x;
        short y = cb.y;
        if (PartMode == 3 && log2CbSize != this.sps.Log2MinCbSizeY) {
            PartMode = 0;
        }
        cb.partMode = (byte)PartMode;
        this.img.setPartMode(x, y, PartMode);
        int IntraSplitFlag = cb.predMode == 0 && cb.partMode == 3 ? 1 : 0;
        int MaxTrafoDepth = this.sps.max_transform_hierarchy_depth_intra + IntraSplitFlag;
        Etb tb = new Etb(x, y, log2CbSize, cb);
        cb.transform_tree = this.getTBSplit(this.img, tb, 0, MaxTrafoDepth, IntraSplitFlag);
        return cb;
    }

    private Etb getTBSplit(HImg input, Etb tb, int TrafoDepth, int MaxTrafoDepth, int IntraSplitFlag) {
        Ecb cb = tb.cb;
        byte log2TbSize = tb.log2Size;
        boolean test_split = log2TbSize > 2 && TrafoDepth < MaxTrafoDepth && log2TbSize > this.sps.Log2MinTrafoSize;
        boolean test_no_split = true;
        if (IntraSplitFlag != 0 && TrafoDepth == 0) {
            test_no_split = false;
        }
        if (log2TbSize > this.sps.Log2MaxTrafoSize) {
            test_no_split = false;
        }
        if (test_no_split) {
            if (cb.predMode == 0) {
                this.compute_residual(tb, input, tb.blkIdx);
            }
            return this.getTBTransform(input, tb);
        }
        if (test_split) {
            return this.encodeTTsplit(input, tb, cb);
        }
        return null;
    }

    private Etb encodeTTsplit(HImg input, Etb tb, Ecb cb) {
        byte log2TbSize = tb.log2Size;
        short x0 = tb.x;
        short y0 = tb.y;
        tb.split_transform_flag = true;
        for (int i = 0; i < 4; ++i) {
            int dx = (i & 1) << log2TbSize - 1;
            int dy = i >> 1 << log2TbSize - 1;
            Etb child_tb = new Etb(x0 + dx, y0 + dy, (byte)(log2TbSize - 1), cb);
            child_tb.intra_mode = tb.intra_mode;
            child_tb.intra_mode_chroma = tb.intra_mode_chroma;
            child_tb.trafoDepth = (byte)(tb.trafoDepth + 1);
            child_tb.parent = tb;
            child_tb.blkIdx = (byte)i;
            tb.children[i] = child_tb;
            if (cb.predMode != 0) continue;
            tb.children[i] = this.getTBTransform(input, child_tb);
        }
        tb.set_cbf_flags_from_children();
        return tb;
    }

    private Etb getTBTransform(HImg input, Etb tb) {
        Ecb cb = tb.cb;
        cb.transform_tree = tb;
        short x0 = tb.x;
        short y0 = tb.y;
        short xBase = cb.x;
        short yBase = cb.y;
        byte log2TbSize = tb.log2Size;
        this.compute_transform_coeffs(tb, input, x0, y0, log2TbSize, cb, 0);
        if (this.sps.chroma_format_idc == 3) {
            this.compute_transform_coeffs(tb, input, x0, y0, log2TbSize, cb, 1);
            this.compute_transform_coeffs(tb, input, x0, y0, log2TbSize, cb, 2);
        } else if (log2TbSize > 2) {
            this.compute_transform_coeffs(tb, input, x0, y0, log2TbSize - 1, cb, 1);
            this.compute_transform_coeffs(tb, input, x0, y0, log2TbSize - 1, cb, 2);
        } else if (tb.blkIdx == 3) {
            this.compute_transform_coeffs(tb, input, xBase, yBase, log2TbSize, cb, 1);
            this.compute_transform_coeffs(tb, input, xBase, yBase, log2TbSize, cb, 2);
        }
        return tb;
    }

    private void compute_residual(Etb tb, HImg input, int blkIdx) {
        int tbSize = 1 << tb.log2Size;
        this.compute_residual_channel(tb, input, 0, tb.x, tb.y, tb.log2Size);
        if (this.sps.chroma_format_idc == 3) {
            this.compute_residual_channel(tb, input, 1, tb.x, tb.y, tb.log2Size);
            this.compute_residual_channel(tb, input, 2, tb.x, tb.y, tb.log2Size);
        } else if (tb.log2Size > 2) {
            int x = tb.x / this.sps.SubWidthC;
            int y = tb.y / this.sps.SubHeightC;
            int log2BlkSize = tb.log2Size - 1;
            this.compute_residual_channel(tb, input, 1, x, y, log2BlkSize);
            this.compute_residual_channel(tb, input, 2, x, y, log2BlkSize);
        } else if (blkIdx == 3) {
            int x = tb.parent.x / this.sps.SubWidthC;
            int y = tb.parent.y / this.sps.SubHeightC;
            byte log2BlkSize = tb.log2Size;
            this.compute_residual_channel(tb, input, 1, x, y, log2BlkSize);
            this.compute_residual_channel(tb, input, 2, x, y, log2BlkSize);
        }
    }

    private void compute_residual_channel(Etb tb, HImg input, int cIdx, int x, int y, int log2Size) {
        int blkSize = 1 << log2Size;
        byte mode = cIdx == 0 ? tb.intra_mode : tb.intra_mode_chroma;
        int size = 1 << log2Size;
        tb.alloc_coeff_memory(cIdx, size);
        this.eIntraPred.decode_intra_prediction_from_tree(this.img, this.sps, this.pps, tb, tb.coeff[cIdx], this.ctbs, cIdx);
        EContext.diff_blk(tb.coeff[cIdx], blkSize, input.getImagePlaneByte(cIdx), input.getImageStride(cIdx), input.getImageStride(cIdx) * y + x, blkSize, blkSize);
    }

    private static void diff_blk(int[] out, int out_stride, byte[] a_ptr, int a_stride, int a_offset, int b_stride, int blkSize) {
        for (int by = 0; by < blkSize; ++by) {
            for (int bx = 0; bx < blkSize; ++bx) {
                out[by * out_stride + bx] = a_ptr[a_offset + by * a_stride + bx] - out[by * b_stride + bx];
            }
        }
    }

    private void compute_transform_coeffs(Etb tb, HImg input, int x0, int y0, int log2TbSize, Ecb cb, int cIdx) {
        boolean trType;
        int tbSize = 1 << log2TbSize;
        byte predMode = cb.predMode;
        int[] residual = tb.coeff[cIdx];
        boolean bl = trType = cIdx == 0 && log2TbSize == 2 && predMode == 0;
        if (residual != null) {
            if (trType) {
                Transform.fdst(tb.coeff[cIdx], residual, tbSize, this.dstG);
            } else {
                int[] g = this.dctG4;
                switch (tbSize) {
                    case 8: {
                        g = this.dctG8;
                        break;
                    }
                    case 16: {
                        g = this.dctG16;
                        break;
                    }
                    case 32: {
                        g = this.dctG32;
                    }
                }
                Transform.fdct(tb.coeff[cIdx], residual, tbSize, g);
            }
        }
        Transform.quantCoefficients(tb.coeff[cIdx], tb.coeff[cIdx], log2TbSize, cb.qp, true);
        tb.cbf[cIdx] = EContext.has_nonzero_value(tb.coeff[cIdx], 1 << (log2TbSize << 1)) ? 1 : 0;
    }

    private static boolean has_nonzero_value(int[] data, int n) {
        for (int i = 0; i < n; ++i) {
            if (data[i] == 0) continue;
            return true;
        }
        return false;
    }
}

