/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.heic.common;

import com.idrsolutions.image.heic.common.HeicMath;
import com.idrsolutions.image.heic.common.Model;

class CtxTbl {
    static final byte[][][][][] CTXINDEXLOOKUP = new byte[4][][][][];
    private static final byte[] CTXIDXMAP = new byte[]{0, 1, 4, 5, 2, 3, 4, 5, 6, 6, 8, 8, 7, 7, 8, 99};
    static final int SAO_MERGE_FLAG = 0;
    static final int SAO_TYPE_IDX = 1;
    static final int SPLIT_CU_FLAG = 2;
    static final int CU_SKIP_FLAG = 5;
    static final int PART_MODE = 8;
    static final int PREV_INTRA_LUMA_PRED_FLAG = 12;
    static final int INTRA_CHROMA_PRED_MODE = 13;
    static final int CBF_LUMA = 14;
    static final int CBF_CHROMA = 16;
    static final int SPLIT_TRANSFORM_FLAG = 20;
    static final int CU_CHROMA_QP_OFFSET_FLAG = 23;
    static final int CU_CHROMA_QP_OFFSET_IDX = 24;
    static final int LAST_SIGNIFICANT_COEFFICIENT_X_PREFIX = 25;
    static final int LAST_SIGNIFICANT_COEFFICIENT_Y_PREFIX = 43;
    static final int CODED_SUB_BLOCK_FLAG = 61;
    static final int SIGNIFICANT_COEFF_FLAG = 65;
    static final int COEFF_ABS_LEVEL_GREATER1_FLAG = 109;
    static final int COEFF_ABS_LEVEL_GREATER2_FLAG = 133;
    static final int CU_QP_DELTA_ABS = 139;
    static final int TRANSFORM_SKIP_FLAG = 141;
    static final int RDPCM_FLAG = 143;
    static final int RDPCM_DIR = 145;
    private static final int MERGE_FLAG = 147;
    private static final int MERGE_IDX = 148;
    static final int PRED_MODE_FLAG = 149;
    private static final int ABS_MVD_GREATER01_FLAG = 150;
    private static final int MVP_LX_FLAG = 152;
    static final int RQT_ROOT_CBF = 153;
    private static final int REF_IDX_LX = 154;
    private static final int INTER_PRED_IDC = 156;
    static final int CU_TRANSQUANT_BYPASS_FLAG = 161;
    static final int LOG2_RES_SCALE_ABS_PLUS1 = 162;
    static final int RES_SCALE_SIGN_FLAG = 170;
    private static final int TABLE_LENGTH = 172;
    private static final int[][] INIT_SPLIT_CU;
    private static final int[][] INIT_CU_SKIP;
    private static final int[] INIT_PART_MODE;
    private static final int[] INIT_PREV_INTRA_LUMA_PRED;
    private static final int[] INIT_INTRA_CHROMA_PRED_MODE;
    private static final int[] INIT_CBF_LUMA;
    private static final int[] INIT_CBF_CHROMA;
    private static final int[] INIT_SPLIT_TRANSFORM;
    private static final int[] INIT_LAST_SIG_COEFF_PREFIX;
    private static final int[] INIT_CODED_SUB_BLOCK;
    private static final int[][] INIT_SIG_COEF_FLAG;
    private static final int[][] INIT_SIG_COEF_SKIPMODE;
    private static final int[] INIT_COEFF_ABS_LEVEL_GREATER1;
    private static final int[] INIT_COEFF_ABS_LEVEL_GREATER2;
    private static final int[] INIT_SAO_MERGE_LEFTUP;
    private static final int[] INIT_SAO_TYPE_IDX_LUMA_CHROMA;
    private static final int[] INIT_CU_QP_DELTA_ABS;
    private static final int[] INIT_TRANSFORM_SKIP;
    private static final int[] INIT_MERGE_FLAG;
    private static final int[] INIT_MERGE_IDX;
    private static final int[] INIT_PRED_MODE;
    private static final int[] INIT_ABS_MVD_GREATER0_1;
    private static final int[] INIT_MVP_LX;
    private static final int[] INIT_RQT_ROOT_CBF;
    private static final int[] INIT_REF_IDX_LX;
    private static final int[] INIT_INTER_PRED_IDC;
    private static final int[] INIT_CU_TRANSQUANT_BYPASS;
    Model[] models = new Model[172];

    CtxTbl() {
    }

    void init(int initType, int SliceQPY) {
        if (initType > 0) {
            this.initMultiContext(SliceQPY, 5, INIT_CU_SKIP[initType - 1], 3);
            this.initContext(SliceQPY, 149, INIT_PRED_MODE, initType - 1, 1);
            this.initContext(SliceQPY, 147, INIT_MERGE_FLAG, initType - 1, 1);
            this.initContext(SliceQPY, 148, INIT_MERGE_IDX, initType - 1, 1);
            this.initMultiContext(SliceQPY, 156, INIT_INTER_PRED_IDC, 5);
            this.initMultiContext(SliceQPY, 154, INIT_REF_IDX_LX, 2);
            this.initContext(SliceQPY, 150, INIT_ABS_MVD_GREATER0_1, initType == 1 ? 0 : 2, 2);
            this.initMultiContext(SliceQPY, 152, INIT_MVP_LX, 1);
            this.initMultiContext(SliceQPY, 153, INIT_RQT_ROOT_CBF, 1);
            this.initFixedContext(SliceQPY, 143, 139, 2);
            this.initFixedContext(SliceQPY, 145, 139, 2);
        }
        this.initMultiContext(SliceQPY, 2, INIT_SPLIT_CU[initType], 3);
        this.initContext(SliceQPY, 8, INIT_PART_MODE, initType != 2 ? initType : 5, 4);
        this.initContext(SliceQPY, 12, INIT_PREV_INTRA_LUMA_PRED, initType, 1);
        this.initContext(SliceQPY, 13, INIT_INTRA_CHROMA_PRED_MODE, initType, 1);
        this.initContext(SliceQPY, 14, INIT_CBF_LUMA, initType == 0 ? 0 : 2, 2);
        this.initContext(SliceQPY, 16, INIT_CBF_CHROMA, initType * 4, 4);
        this.initContext(SliceQPY, 20, INIT_SPLIT_TRANSFORM, initType * 3, 3);
        this.initContext(SliceQPY, 25, INIT_LAST_SIG_COEFF_PREFIX, initType * 18, 18);
        this.initContext(SliceQPY, 43, INIT_LAST_SIG_COEFF_PREFIX, initType * 18, 18);
        this.initContext(SliceQPY, 61, INIT_CODED_SUB_BLOCK, initType * 4, 4);
        this.initMultiContext(SliceQPY, 65, INIT_SIG_COEF_FLAG[initType], 42);
        this.initMultiContext(SliceQPY, 107, INIT_SIG_COEF_SKIPMODE[initType], 2);
        this.initContext(SliceQPY, 109, INIT_COEFF_ABS_LEVEL_GREATER1, initType * 24, 24);
        this.initContext(SliceQPY, 133, INIT_COEFF_ABS_LEVEL_GREATER2, initType * 6, 6);
        this.initContext(SliceQPY, 0, INIT_SAO_MERGE_LEFTUP, initType, 1);
        this.initContext(SliceQPY, 1, INIT_SAO_TYPE_IDX_LUMA_CHROMA, initType, 1);
        this.initMultiContext(SliceQPY, 139, INIT_CU_QP_DELTA_ABS, 2);
        this.initMultiContext(SliceQPY, 141, INIT_TRANSFORM_SKIP, 2);
        this.initContext(SliceQPY, 161, INIT_CU_TRANSQUANT_BYPASS, initType, 1);
        this.initFixedContext(SliceQPY, 162, 154, 8);
        this.initFixedContext(SliceQPY, 170, 154, 2);
        this.initFixedContext(SliceQPY, 23, 154, 1);
        this.initFixedContext(SliceQPY, 24, 154, 1);
    }

    private void initFixedContext(int SliceQPY, int offset, int initValue, int len) {
        CtxTbl.setInitValue(SliceQPY, this.models, offset, initValue, len);
    }

    private void initMultiContext(int SliceQPY, int offset, int[] initValues, int len) {
        for (int i = 0; i < len; ++i) {
            CtxTbl.setInitValue(SliceQPY, this.models, offset + i, initValues[i], 1);
        }
    }

    private void initContext(int SliceQPY, int offset, int[] arr, int arrOffset, int len) {
        for (int i = 0; i < len; ++i) {
            CtxTbl.setInitValue(SliceQPY, this.models, offset + i, arr[arrOffset + i], 1);
        }
    }

    private static void setInitValue(int SliceQPY, Model[] model, int offset, int initValue, int nContexts) {
        int m = (initValue >> 4) * 5 - 45;
        int n = ((initValue & 0xF) << 3) - 16;
        int preCtxState = HeicMath.clip3(1, 126, (m * HeicMath.clip3(0, 51, SliceQPY) >> 4) + n);
        for (int i = 0; i < nContexts; ++i) {
            Model temp = new Model();
            temp.mps = preCtxState <= 63 ? 0 : 1;
            temp.state = temp.mps != 0 ? preCtxState - 64 : 63 - preCtxState;
            model[offset + i] = temp;
        }
    }

    CtxTbl deepCopy() {
        CtxTbl res = new CtxTbl();
        res.models = new Model[this.models.length];
        for (int i = 0; i < this.models.length; ++i) {
            if (this.models[i] == null) continue;
            Model m = new Model();
            m.mps = this.models[i].mps;
            m.state = this.models[i].state;
            res.models[i] = m;
        }
        return res;
    }

    static {
        CtxTbl.CTXINDEXLOOKUP[0] = new byte[2][2][4][16];
        CtxTbl.CTXINDEXLOOKUP[1] = new byte[2][2][4][64];
        CtxTbl.CTXINDEXLOOKUP[2] = new byte[2][2][4][256];
        CtxTbl.CTXINDEXLOOKUP[3] = new byte[2][2][4][1024];
        for (int log2w = 2; log2w <= 5; ++log2w) {
            int w2 = 1 << log2w;
            for (int cIdx = 0; cIdx < 2; ++cIdx) {
                for (int scanIdx = 0; scanIdx < 2; ++scanIdx) {
                    for (int prevCsbf = 0; prevCsbf < 4; ++prevCsbf) {
                        for (int yC = 0; yC < w2; ++yC) {
                            for (int xC = 0; xC < w2; ++xC) {
                                int sigCtx;
                                int w = w2;
                                int sbWidth = w >> 2;
                                if (sbWidth == 1) {
                                    sigCtx = CTXIDXMAP[(yC << 2) + xC];
                                } else if (xC + yC == 0) {
                                    sigCtx = 0;
                                } else {
                                    int xS = xC >> 2;
                                    int yS = yC >> 2;
                                    int xP = xC & 3;
                                    int yP = yC & 3;
                                    switch (prevCsbf) {
                                        case 0: {
                                            int n;
                                            if (xP + yP >= 3) {
                                                n = 0;
                                                break;
                                            }
                                            if (xP + yP > 0) {
                                                n = 1;
                                                break;
                                            }
                                            n = 2;
                                            break;
                                        }
                                        case 1: {
                                            int n;
                                            if (yP == 0) {
                                                n = 2;
                                                break;
                                            }
                                            if (yP == 1) {
                                                n = 1;
                                                break;
                                            }
                                            n = 0;
                                            break;
                                        }
                                        case 2: {
                                            int n;
                                            if (xP == 0) {
                                                n = 2;
                                                break;
                                            }
                                            if (xP == 1) {
                                                n = 1;
                                                break;
                                            }
                                            n = 0;
                                            break;
                                        }
                                        default: {
                                            int n = sigCtx = 2;
                                        }
                                    }
                                    if (cIdx == 0) {
                                        if (xS + yS > 0) {
                                            sigCtx += 3;
                                        }
                                        sigCtx = sbWidth == 2 ? (sigCtx += scanIdx == 0 ? 9 : 15) : (sigCtx += 21);
                                    } else {
                                        sigCtx = sbWidth == 2 ? (sigCtx += 9) : (sigCtx += 12);
                                    }
                                }
                                int ctxIdxInc = cIdx == 0 ? sigCtx : 27 + sigCtx;
                                CtxTbl.CTXINDEXLOOKUP[log2w - 2][cIdx][scanIdx][prevCsbf][xC + (yC << log2w)] = (byte)(ctxIdxInc & 0xFF);
                            }
                        }
                    }
                }
            }
        }
        INIT_SPLIT_CU = new int[][]{{139, 141, 157}, {107, 139, 126}, {107, 139, 126}};
        INIT_CU_SKIP = new int[][]{{197, 185, 201}, {197, 185, 201}};
        INIT_PART_MODE = new int[]{184, 154, 139, 154, 154, 154, 139, 154, 154};
        INIT_PREV_INTRA_LUMA_PRED = new int[]{184, 154, 183};
        INIT_INTRA_CHROMA_PRED_MODE = new int[]{63, 152, 152};
        INIT_CBF_LUMA = new int[]{111, 141, 153, 111};
        INIT_CBF_CHROMA = new int[]{94, 138, 182, 154, 149, 107, 167, 154, 149, 92, 167, 154};
        INIT_SPLIT_TRANSFORM = new int[]{153, 138, 138, 124, 138, 94, 224, 167, 122};
        INIT_LAST_SIG_COEFF_PREFIX = new int[]{110, 110, 124, 125, 140, 153, 125, 127, 140, 109, 111, 143, 127, 111, 79, 108, 123, 63, 125, 110, 94, 110, 95, 79, 125, 111, 110, 78, 110, 111, 111, 95, 94, 108, 123, 108, 125, 110, 124, 110, 95, 94, 125, 111, 111, 79, 125, 126, 111, 111, 79, 108, 123, 93};
        INIT_CODED_SUB_BLOCK = new int[]{91, 171, 134, 141, 121, 140, 61, 154, 121, 140, 61, 154};
        INIT_SIG_COEF_FLAG = new int[][]{{111, 111, 125, 110, 110, 94, 124, 108, 124, 107, 125, 141, 179, 153, 125, 107, 125, 141, 179, 153, 125, 107, 125, 141, 179, 153, 125, 140, 139, 182, 182, 152, 136, 152, 136, 153, 136, 139, 111, 136, 139, 111}, {155, 154, 139, 153, 139, 123, 123, 63, 153, 166, 183, 140, 136, 153, 154, 166, 183, 140, 136, 153, 154, 166, 183, 140, 136, 153, 154, 170, 153, 123, 123, 107, 121, 107, 121, 167, 151, 183, 140, 151, 183, 140}, {170, 154, 139, 153, 139, 123, 123, 63, 124, 166, 183, 140, 136, 153, 154, 166, 183, 140, 136, 153, 154, 166, 183, 140, 136, 153, 154, 170, 153, 138, 138, 122, 121, 122, 121, 167, 151, 183, 140, 151, 183, 140}};
        INIT_SIG_COEF_SKIPMODE = new int[][]{{141, 111}, {140, 140}, {140, 140}};
        INIT_COEFF_ABS_LEVEL_GREATER1 = new int[]{140, 92, 137, 138, 140, 152, 138, 139, 153, 74, 149, 92, 139, 107, 122, 152, 140, 179, 166, 182, 140, 227, 122, 197, 154, 196, 196, 167, 154, 152, 167, 182, 182, 134, 149, 136, 153, 121, 136, 137, 169, 194, 166, 167, 154, 167, 137, 182, 154, 196, 167, 167, 154, 152, 167, 182, 182, 134, 149, 136, 153, 121, 136, 122, 169, 208, 166, 167, 154, 152, 167, 182};
        INIT_COEFF_ABS_LEVEL_GREATER2 = new int[]{138, 153, 136, 167, 152, 152, 107, 167, 91, 122, 107, 167, 107, 167, 91, 107, 107, 167};
        INIT_SAO_MERGE_LEFTUP = new int[]{153, 153, 153};
        INIT_SAO_TYPE_IDX_LUMA_CHROMA = new int[]{200, 185, 160};
        INIT_CU_QP_DELTA_ABS = new int[]{154, 154};
        INIT_TRANSFORM_SKIP = new int[]{139, 139};
        INIT_MERGE_FLAG = new int[]{110, 154};
        INIT_MERGE_IDX = new int[]{122, 137};
        INIT_PRED_MODE = new int[]{149, 134};
        INIT_ABS_MVD_GREATER0_1 = new int[]{140, 198, 169, 198};
        INIT_MVP_LX = new int[]{168};
        INIT_RQT_ROOT_CBF = new int[]{79};
        INIT_REF_IDX_LX = new int[]{153, 153};
        INIT_INTER_PRED_IDC = new int[]{95, 79, 63, 31, 31};
        INIT_CU_TRANSQUANT_BYPASS = new int[]{154, 154, 154};
    }
}

