/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.heic.common;

import com.idrsolutions.image.heic.common.Bitstream;
import com.idrsolutions.image.heic.common.Cabac;
import com.idrsolutions.image.heic.common.CtxTbl;
import com.idrsolutions.image.heic.common.HImg;
import com.idrsolutions.image.heic.common.HeicMath;
import com.idrsolutions.image.heic.common.InfoSAO;
import com.idrsolutions.image.heic.common.IntraPred;
import com.idrsolutions.image.heic.common.Nal;
import com.idrsolutions.image.heic.common.Pps;
import com.idrsolutions.image.heic.common.Scan;
import com.idrsolutions.image.heic.common.Sps;
import com.idrsolutions.image.heic.common.Ssh;
import com.idrsolutions.image.heic.common.Transform;
import com.idrsolutions.image.heic.common.Vps;
import java.util.Arrays;
import org.jpedal.utils.LogWriter;

final class Ctx {
    private static final byte[] MAP_CHROMA_422 = new byte[]{0, 1, 2, 2, 2, 2, 3, 5, 7, 8, 10, 12, 13, 15, 17, 18, 19, 20, 21, 22, 23, 23, 24, 24, 25, 25, 26, 27, 27, 28, 28, 29, 29, 30, 31};
    private static final int[] CCAND = new int[]{0, 26, 10, 1};
    private Pps pps;
    Sps sps;
    private Bitstream reader;
    HImg img;
    private CtxTbl ctxTbl = new CtxTbl();
    private final Cabac cabac = new Cabac();
    private final int[] StatCoeff = new int[4];
    private final IntraPred intraPred = new IntraPred();
    private int cu_transquant_bypass_flag;
    private final int[] transform_skip_flag = new int[3];
    private int explicit_rdpcm_flag;
    private int explicit_rdpcm_dir;
    private int lastInvocation_greater1Ctx;
    private int lastInvocation_coeff_abs_level_greater1_flag;
    private int lastInvocation_ctxSet;
    private final int[] coeffBuf4 = new int[24];
    private final int[] coeffBuf8 = new int[72];
    private final int[] coeffBuf16 = new int[264];
    private final int[] coeffBuf32 = new int[1032];
    private final int[][] coeffList = new int[3][1024];
    private final int[][] coeffPos = new int[3][1024];
    private final int[] nCoeff = new int[3];
    private final int[] residual_luma = new int[1024];
    private final int[] coded_sub_block_neighbors = new int[64];
    private final short[] coeff_value = new short[16];
    private final int[] coeff_scan_pos = new int[16];
    private final int[] coeff_sign = new int[16];
    private final int[] coeff_has_max_base_level = new int[16];
    private int currentQG_x;
    private int currentQG_y;
    private int currentQPY;
    private int qPYPrime;
    private int qPCbPrime;
    private int qPCrPrime;
    private int lastQPYinPreviousQG;
    private final int[] dstG = new int[16];
    private final int[] dctG4 = new int[16];
    private final int[] dctG8 = new int[64];
    private final int[] dctG16 = new int[256];
    private final int[] dctG32 = new int[1024];
    CB codemap = new CB();
    static boolean debugU;
    private Ssh ssh;

    Ctx() {
    }

    void readPps(byte[] data) {
        this.pps = new Pps();
        this.pps.readPps(new Bitstream(data), this.img, this.sps);
        this.img.allocateImage(this.sps, this.pps);
    }

    void readSps(byte[] data) {
        this.sps = new Sps();
        this.sps.readSps(new Bitstream(data), this.img);
    }

    void readVps(byte[] data) {
        Vps vps = new Vps();
        vps.readVps(new Bitstream(data), this.img);
    }

    void readSlice(Nal nal) {
        boolean isTile;
        this.ssh = new Ssh();
        this.reader = new Bitstream(nal.rbsp);
        boolean readFurther = this.ssh.readSsh(this.reader, this.img, this.sps, this.pps, nal.nal_unit_type, nal.nuh_layer_id);
        if (!readFurther) {
            return;
        }
        this.img.addSliceSegmentHeader(this.ssh);
        this.reader.readByteAlignment();
        boolean isWpp = this.pps.entropy_coding_sync_enabled_flag != 0;
        boolean bl = isTile = this.pps.tiles_enabled_flag != 0;
        if (isWpp) {
            this.decodeWPP();
        } else if (isTile) {
            this.decodeTILE();
        } else {
            this.decodeSequence();
        }
    }

    private void initThread() {
        Arrays.fill(this.coeffBuf4, 0);
        Arrays.fill(this.coeffBuf8, 0);
        Arrays.fill(this.coeffBuf16, 0);
        Arrays.fill(this.coeffBuf32, 0);
        this.currentQG_x = -1;
        this.currentQG_y = -1;
        if (this.ssh.slice_segment_address > 0) {
            int prevCtb = this.pps.CtbAddrTStoRS[this.pps.CtbAddrRStoTS[this.ssh.slice_segment_address] - 1];
            int ctbX = prevCtb % this.sps.PicWidthInCtbsY;
            int ctbY = prevCtb / this.sps.PicWidthInCtbsY;
            int x = (ctbX + 1 << this.sps.Log2CtbSizeY) - 1;
            int y = (ctbY + 1 << this.sps.Log2CtbSizeY) - 1;
            x = Math.min(x, this.img.Width - 1);
            y = Math.min(y, this.img.Height - 1);
            this.currentQPY = this.img.getQPY(x, y);
        }
    }

    private int decodeSubstream(boolean first_independent_substream) {
        int ctbW = this.sps.PicWidthInCtbsY;
        if (!first_independent_substream && this.pps.entropy_coding_sync_enabled_flag != 0 && this.img.CtbY >= 1 && this.img.CtbX == 0) {
            if (this.sps.PicWidthInCtbsY > 1) {
                this.ctxTbl = this.img.ctx_models.get(this.img.CtbY - 1);
                int toRemove = this.img.CtbY - 2;
                this.img.ctx_models.remove(toRemove);
            } else {
                this.initCabacModels();
            }
        }
        while (true) {
            boolean b;
            int end_of_slice_segment_flag;
            int ctby;
            int ctbx;
            if ((ctbx = this.img.CtbX) + (ctby = this.img.CtbY) * ctbW >= this.pps.CtbAddrRStoTS.length) {
                return 2;
            }
            if (ctbx >= this.sps.PicWidthInCtbsY || ctby >= this.sps.PicHeightInCtbsY) {
                return 2;
            }
            this.readCTU();
            if (this.pps.entropy_coding_sync_enabled_flag != 0 && ctbx == 1 && ctby < this.sps.PicHeightInCtbsY - 1) {
                this.img.ctx_models.put(ctby, this.ctxTbl.deepCopy());
            }
            if ((end_of_slice_segment_flag = this.cabac.decodeTermBit()) != 0 && this.pps.dependent_slice_segments_enabled_flag != 0) {
                this.ssh.ctx_model_storage = this.ctxTbl.deepCopy();
                this.ssh.ctx_model_storage_defined = true;
            }
            int lastCtbY = this.img.CtbY;
            boolean endOfPicture = this.advanceCtbAddr();
            if (endOfPicture && end_of_slice_segment_flag == 0) {
                return 2;
            }
            if (end_of_slice_segment_flag != 0) {
                return 0;
            }
            if (end_of_slice_segment_flag != 0) continue;
            boolean a = this.pps.tiles_enabled_flag != 0 && this.pps.TileId[this.img.CtbAddrInTS] != this.pps.TileId[this.img.CtbAddrInTS - 1];
            boolean bl = b = this.pps.entropy_coding_sync_enabled_flag != 0 && lastCtbY != this.img.CtbY;
            if (a || b) break;
        }
        if (this.cabac.decodeTermBit() == 0) {
            return 2;
        }
        this.cabac.initDecoder2();
        return 1;
    }

    private boolean advanceCtbAddr() {
        ++this.img.CtbAddrInTS;
        return this.setCtbAddrFromTS();
    }

    private boolean setCtbAddrFromTS() {
        if (this.img.CtbAddrInTS < this.sps.PicSizeInCtbsY) {
            this.img.CtbAddrInRS = this.pps.CtbAddrTStoRS[this.img.CtbAddrInTS];
            this.img.CtbX = this.img.CtbAddrInRS % this.sps.PicWidthInCtbsY;
            this.img.CtbY = this.img.CtbAddrInRS / this.sps.PicWidthInCtbsY;
            return false;
        }
        this.img.CtbAddrInRS = this.sps.PicSizeInCtbsY;
        this.img.CtbX = this.img.CtbAddrInRS % this.sps.PicWidthInCtbsY;
        this.img.CtbY = this.img.CtbAddrInRS / this.sps.PicWidthInCtbsY;
        return true;
    }

    private void readSsd() {
        int result;
        boolean first_slice_substream;
        this.setCtbAddrFromTS();
        this.initialize_CABAC_at_slice_segment_start();
        this.cabac.initDecoder2();
        boolean bl = first_slice_substream = this.ssh.dependent_slice_segment_flag == 0;
        while ((result = this.decodeSubstream(first_slice_substream)) != 0 && result != 2) {
            first_slice_substream = false;
            if (this.pps.tiles_enabled_flag == 0) continue;
            this.initCabacModels();
        }
    }

    private void work(int type, boolean firstSliceSubstream) {
        if (type == 1) {
            this.setCtbAddrFromTS();
            if (firstSliceSubstream) {
                this.initialize_CABAC_at_slice_segment_start();
            } else {
                this.initCabacModels();
            }
            this.cabac.initDecoder2();
            this.decodeSubstream(firstSliceSubstream);
        } else {
            this.setCtbAddrFromTS();
            if (firstSliceSubstream) {
                this.initialize_CABAC_at_slice_segment_start();
            }
            this.cabac.initDecoder2();
            boolean firstIndependentSubstream = firstSliceSubstream && this.ssh.dependent_slice_segment_flag == 0;
            this.decodeSubstream(firstIndependentSubstream);
        }
    }

    private void decodeSequence() {
        this.img.CtbAddrInTS = this.pps.CtbAddrRStoTS[this.ssh.slice_segment_address];
        this.initThread();
        this.cabac.initDecoder(this.reader, this.reader.byteRemaining());
        this.readSsd();
    }

    private void decodeWPP() {
        int nRows = this.ssh.num_entry_point_offsets + 1;
        int ctbsWidth = this.sps.PicWidthInCtbsY;
        int ctbAddrRS = this.ssh.slice_segment_address;
        int ctbRow = ctbAddrRS / ctbsWidth;
        for (int entryPt = 0; entryPt < nRows; ++entryPt) {
            if (entryPt > 0) {
                ctbAddrRS = ++ctbRow * ctbsWidth;
            } else if (nRows > 1 && ctbAddrRS % ctbsWidth != 0) break;
            this.img.CtbAddrInTS = this.pps.CtbAddrRStoTS[ctbAddrRS];
            this.initThread();
            int dataStart = entryPt == 0 ? 0 : this.ssh.entry_point_offset[entryPt - 1];
            int dataEnd = entryPt == nRows - 1 ? this.reader.byteRemaining() : this.ssh.entry_point_offset[entryPt];
            byte[] temp = new byte[dataEnd - dataStart];
            System.arraycopy(this.reader.data, this.reader.p + dataStart, temp, 0, temp.length);
            Bitstream stream = new Bitstream(temp);
            this.cabac.initDecoder(stream, temp.length);
            this.work(0, entryPt == 0);
        }
    }

    private void decodeTILE() {
        int ctbAddrRS = this.ssh.slice_segment_address;
        int tileID = this.pps.TileIdRS[ctbAddrRS];
        int nTiles = this.ssh.num_entry_point_offsets + 1;
        int ctbsWidth = this.sps.PicWidthInCtbsY;
        for (int entryPt = 0; entryPt < nTiles; ++entryPt) {
            if (entryPt > 0) {
                if (++tileID >= this.pps.num_tile_columns * this.pps.num_tile_rows) break;
                int ctbX = this.pps.colBd[tileID % this.pps.num_tile_columns];
                int ctbY = this.pps.rowBd[tileID / this.pps.num_tile_columns];
                ctbAddrRS = ctbY * ctbsWidth + ctbX;
            }
            this.img.CtbAddrInTS = this.pps.CtbAddrRStoTS[ctbAddrRS];
            this.initThread();
            int dataStart = entryPt == 0 ? 0 : this.ssh.entry_point_offset[entryPt - 1];
            int dataEnd = entryPt == nTiles - 1 ? this.reader.byteRemaining() : this.ssh.entry_point_offset[entryPt];
            byte[] temp = new byte[dataEnd - dataStart];
            System.arraycopy(this.reader.data, this.reader.p + dataStart, temp, 0, temp.length);
            Bitstream stream = new Bitstream(temp);
            this.cabac.initDecoder(stream, temp.length);
            this.work(1, entryPt == 0);
        }
    }

    private void initialize_CABAC_at_slice_segment_start() {
        if (this.ssh.dependent_slice_segment_flag != 0) {
            int prevCtb = this.pps.CtbAddrTStoRS[this.pps.CtbAddrRStoTS[this.ssh.slice_segment_address] - 1];
            int sliceIdx = this.img.getSliceHeaderIndexAtIndex(prevCtb);
            if (sliceIdx >= this.img.slices.size()) {
                return;
            }
            Ssh prevCtbHdr = this.img.slices.get(sliceIdx);
            if (this.pps.isTileStartCTB(this.ssh.slice_segment_address % this.sps.PicWidthInCtbsY, this.ssh.slice_segment_address / this.sps.PicWidthInCtbsY, this.img)) {
                this.initCabacModels();
            } else {
                if (!prevCtbHdr.ctx_model_storage_defined) {
                    return;
                }
                this.ctxTbl = prevCtbHdr.ctx_model_storage;
            }
        } else {
            this.initCabacModels();
        }
    }

    private void readCTU() {
        int xCtb = this.img.CtbAddrInRS % this.sps.PicWidthInCtbsY;
        int yCtb = this.img.CtbAddrInRS / this.sps.PicWidthInCtbsY;
        int xCtbPixels = xCtb << this.sps.Log2CtbSizeY;
        int yCtbPixels = yCtb << this.sps.Log2CtbSizeY;
        this.img.setSliceAddrRS(xCtb, yCtb, this.ssh.SliceAddrRS);
        this.img.setSliceHeaderIndex(xCtbPixels, yCtbPixels, this.ssh.sliceIndex);
        if (this.ssh.slice_sao_luma_flag != 0 || this.ssh.slice_sao_chroma_flag != 0) {
            this.read_sao(xCtb, yCtb);
        }
        this.readCQT(xCtbPixels, yCtbPixels, this.sps.Log2CtbSizeY, 0);
    }

    private void readCQT(int x0, int y0, int log2CbSize, int ctDepth) {
        if (debugU) {
            LogWriter.writeLog("CQT: " + x0 + " " + y0 + " D:" + ctDepth);
        }
        int split_flag = x0 + (1 << log2CbSize) <= this.sps.pic_width_in_luma_samples && y0 + (1 << log2CbSize) <= this.sps.pic_height_in_luma_samples && log2CbSize > this.sps.Log2MinCbSizeY ? this.read_split_cu_flag(x0, y0, ctDepth) : (log2CbSize > this.sps.Log2MinCbSizeY ? 1 : 0);
        if (this.pps.cu_qp_delta_enabled_flag != 0 && log2CbSize >= this.pps.Log2MinCuQpDeltaSize) {
            this.img.IsCuQpDeltaCoded = false;
            this.img.CuQpDelta = 0;
        }
        if (this.ssh.cu_chroma_qp_offset_enabled_flag != 0 && log2CbSize >= this.pps.Log2MinCuChromaQpOffsetSize) {
            this.img.IsCuChromaQpOffsetCoded = false;
        }
        if (split_flag != 0) {
            int x1 = x0 + (1 << log2CbSize - 1);
            int y1 = y0 + (1 << log2CbSize - 1);
            this.readCQT(x0, y0, log2CbSize - 1, ctDepth + 1);
            if (x1 < this.sps.pic_width_in_luma_samples) {
                this.readCQT(x1, y0, log2CbSize - 1, ctDepth + 1);
            }
            if (y1 < this.sps.pic_height_in_luma_samples) {
                this.readCQT(x0, y1, log2CbSize - 1, ctDepth + 1);
            }
            if (x1 < this.sps.pic_width_in_luma_samples && y1 < this.sps.pic_height_in_luma_samples) {
                this.readCQT(x1, y1, log2CbSize - 1, ctDepth + 1);
            }
        } else {
            this.img.setCTDepth(x0, y0, log2CbSize, ctDepth);
            this.readCU(x0, y0, log2CbSize);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readCU(int x0, int y0, int log2CbSize) {
        if (debugU) {
            LogWriter.writeLog("\t\tCU " + x0 + " " + y0);
        }
        this.img.setLog2CbSize(x0, y0, log2CbSize);
        this.img.clearSplitTransformFlags(x0, y0, log2CbSize);
        int nCbS = 1 << log2CbSize;
        this.decodeQuantizationParameters(x0, y0, x0, y0);
        if (this.pps.transquant_bypass_enabled_flag != 0) {
            this.cu_transquant_bypass_flag = this.read_cu_transquant_bypass_flag();
            if (this.cu_transquant_bypass_flag != 0) {
                this.img.set_cu_transquant_bypass(x0, y0, log2CbSize);
            }
        } else {
            this.cu_transquant_bypass_flag = 0;
        }
        int cu_skip_flag = 0;
        if (this.ssh.slice_type != 2) {
            cu_skip_flag = this.read_cu_skip_flag(x0, y0);
        }
        int IntraSplitFlag = 0;
        if (cu_skip_flag != 0) {
            LogWriter.writeLog("Decoding prediction unit for MOTION");
            return;
        } else {
            int PartMode;
            int pred_mode_flag;
            byte cuPredMode = this.ssh.slice_type != 2 ? ((pred_mode_flag = this.read_pred_mode_flag()) != 0 ? (byte)0 : 1) : (byte)0;
            this.img.setPredMode(x0, y0, log2CbSize, cuPredMode);
            if (cuPredMode != 0 || log2CbSize == this.sps.Log2MinCbSizeY) {
                PartMode = this.decode_part_mode(cuPredMode);
                if (PartMode == 3 && cuPredMode == 0) {
                    IntraSplitFlag = 1;
                }
            } else {
                PartMode = 0;
            }
            this.img.setPartMode(x0, y0, PartMode);
            boolean pcm_flag = false;
            if (cuPredMode == 0) {
                if (PartMode == 0 && this.sps.pcm_enabled_flag != 0 && log2CbSize >= this.sps.Log2MinIpcmCbSizeY && log2CbSize <= this.sps.Log2MaxIpcmCbSizeY) {
                    boolean bl = pcm_flag = this.cabac.decodeTermBit() != 0;
                }
                if (pcm_flag) {
                    this.img.setPcmFlag(x0, y0, log2CbSize);
                    this.readPcm(x0, y0, log2CbSize);
                } else {
                    int y;
                    int x;
                    int i;
                    int j;
                    int pbOffset = PartMode == 3 ? nCbS / 2 : nCbS;
                    int log2IntraPredSize = PartMode == 3 ? log2CbSize - 1 : log2CbSize;
                    int[] prev_intra_luma_pred_flag = new int[4];
                    int idx = 0;
                    for (int j2 = 0; j2 < nCbS; j2 += pbOffset) {
                        for (int i2 = 0; i2 < nCbS; i2 += pbOffset) {
                            prev_intra_luma_pred_flag[idx++] = this.read_prev_intra_luma_pred_flag();
                        }
                    }
                    int[] mpm_idx = new int[4];
                    int[] rem_intra_luma_pred_mode = new int[4];
                    idx = 0;
                    boolean availableA0 = this.img.checkCTBavailable(x0, y0, x0 - 1, y0);
                    boolean availableB0 = this.img.checkCTBavailable(x0, y0, x0, y0 - 1);
                    for (j = 0; j < nCbS; j += pbOffset) {
                        for (i = 0; i < nCbS; i += pbOffset) {
                            int predMode;
                            if (prev_intra_luma_pred_flag[idx] != 0) {
                                mpm_idx[idx] = this.read_mpm_idx();
                            } else {
                                rem_intra_luma_pred_mode[idx] = this.read_rem_intra_luma_pred_mode();
                            }
                            x = x0 + i;
                            y = y0 + j;
                            boolean availableA = availableA0 || i > 0;
                            boolean availableB = availableB0 || j > 0;
                            int PUidx = (x >> this.sps.Log2MinPuSize) + (y >> this.sps.Log2MinPuSize) * this.sps.PicWidthInMinPus;
                            int[] candModeList = new int[3];
                            IntraPred.fillCandidates(this.img, this.sps, candModeList, x, y, PUidx, availableA, availableB);
                            if (prev_intra_luma_pred_flag[idx] == 1) {
                                predMode = candModeList[mpm_idx[idx]];
                            } else {
                                int temp;
                                if (candModeList[0] > candModeList[1]) {
                                    temp = candModeList[0];
                                    candModeList[0] = candModeList[1];
                                    candModeList[1] = temp;
                                }
                                if (candModeList[0] > candModeList[2]) {
                                    temp = candModeList[0];
                                    candModeList[0] = candModeList[2];
                                    candModeList[2] = temp;
                                }
                                if (candModeList[1] > candModeList[2]) {
                                    temp = candModeList[1];
                                    candModeList[1] = candModeList[2];
                                    candModeList[2] = temp;
                                }
                                predMode = rem_intra_luma_pred_mode[idx];
                                for (int n = 0; n <= 2; ++n) {
                                    if (predMode < candModeList[n]) continue;
                                    ++predMode;
                                }
                            }
                            this.img.setIntraPredMode(PUidx, log2IntraPredSize, predMode);
                            ++idx;
                        }
                    }
                    if (this.sps.ChromaArrayType == 3) {
                        idx = 0;
                        for (j = 0; j < nCbS; j += pbOffset) {
                            for (i = 0; i < nCbS; i += pbOffset) {
                                x = x0 + i;
                                y = y0 + j;
                                int intra_chroma_pred_mode = this.read_intra_chroma_pred_mode();
                                int IntraPredMode = this.img.getIntraPredMode(x, y);
                                int IntraPredModeC = Ctx.mapChromaPredMode(intra_chroma_pred_mode, IntraPredMode);
                                this.img.setIntraPredModeC(x, y, log2IntraPredSize, IntraPredModeC, intra_chroma_pred_mode == 4);
                                ++idx;
                            }
                        }
                    } else if (this.sps.ChromaArrayType != 0) {
                        int intra_chroma_pred_mode = this.read_intra_chroma_pred_mode();
                        int IntraPredMode = this.img.getIntraPredMode(x0, y0);
                        int IntraPredModeC = Ctx.mapChromaPredMode(intra_chroma_pred_mode, IntraPredMode);
                        if (this.sps.ChromaArrayType == 2) {
                            IntraPredModeC = MAP_CHROMA_422[IntraPredModeC];
                        }
                        this.img.setIntraPredModeC(x0, y0, log2CbSize, IntraPredModeC, intra_chroma_pred_mode == 4);
                    }
                }
            } else {
                LogWriter.writeLog("NO inter Part Mode be called");
            }
            if (pcm_flag) return;
            boolean merge_flag = false;
            if (cuPredMode != 0) {
                if (PartMode == 0) {
                    // empty if block
                }
                if (this.read_rqt_root_cbf() == 0) return;
            }
            boolean bl = true;
            boolean rqt_root_cbf = bl;
            if (!rqt_root_cbf) return;
            int MaxTrafoDepth = cuPredMode == 0 ? this.sps.max_transform_hierarchy_depth_intra + IntraSplitFlag : this.sps.max_transform_hierarchy_depth_inter;
            int initial_chroma_cbf = 1;
            if (this.sps.ChromaArrayType == 0) {
                initial_chroma_cbf = 0;
            }
            this.readTT(x0, y0, x0, y0, x0, y0, log2CbSize, 0, 0, MaxTrafoDepth, IntraSplitFlag, cuPredMode, initial_chroma_cbf, initial_chroma_cbf);
        }
    }

    private void readTT(int x0, int y0, int xBase, int yBase, int xCUBase, int yCUBase, int log2TrafoSize, int trafoDepth, int blkIdx, int MaxTrafoDepth, int IntraSplitFlag, int cuPredMode, int parent_cbf_cb, int parent_cbf_cr) {
        boolean split_transform_flag;
        if (debugU) {
            LogWriter.writeLog("\t\t\tTT " + x0 + "-" + y0);
        }
        byte predMode = this.img.getPredMode(x0, y0);
        if (log2TrafoSize <= this.sps.Log2MaxTrafoSize && log2TrafoSize > this.sps.Log2MinTrafoSize && trafoDepth < MaxTrafoDepth && (IntraSplitFlag == 0 || trafoDepth != 0)) {
            split_transform_flag = this.read_split_transform_flag(log2TrafoSize) != 0;
        } else {
            byte PartMode = this.img.getPartMode(x0, y0);
            boolean interSplitFlag = this.sps.max_transform_hierarchy_depth_inter == 0 && trafoDepth == 0 && predMode == 1 && PartMode != 0;
            boolean bl = split_transform_flag = log2TrafoSize > this.sps.Log2MaxTrafoSize || IntraSplitFlag == 1 && trafoDepth == 0 || interSplitFlag;
        }
        if (split_transform_flag) {
            this.img.setSplitTransformFlag(x0, y0, trafoDepth);
        }
        int cbf_cb = -1;
        int cbf_cr = -1;
        if (log2TrafoSize > 2 && this.sps.ChromaArrayType != 0 || this.sps.ChromaArrayType == 3) {
            if (parent_cbf_cb != 0) {
                cbf_cb = this.read_cbf_chroma(trafoDepth);
                if (!(this.sps.ChromaArrayType != 2 || split_transform_flag && log2TrafoSize != 3)) {
                    cbf_cb |= this.read_cbf_chroma(trafoDepth) << 1;
                }
            }
            if (parent_cbf_cr != 0) {
                cbf_cr = this.read_cbf_chroma(trafoDepth);
                if (!(this.sps.ChromaArrayType != 2 || split_transform_flag && log2TrafoSize != 3)) {
                    cbf_cr |= this.read_cbf_chroma(trafoDepth) << 1;
                }
            }
        }
        if (cbf_cb < 0) {
            int n = cbf_cb = trafoDepth > 0 && log2TrafoSize == 2 ? parent_cbf_cb : 0;
        }
        if (cbf_cr < 0) {
            int n = cbf_cr = trafoDepth > 0 && log2TrafoSize == 2 ? parent_cbf_cr : 0;
        }
        if (split_transform_flag) {
            int x1 = x0 + (1 << log2TrafoSize - 1);
            int y1 = y0 + (1 << log2TrafoSize - 1);
            this.readTT(x0, y0, x0, y0, xCUBase, yCUBase, log2TrafoSize - 1, trafoDepth + 1, 0, MaxTrafoDepth, IntraSplitFlag, cuPredMode, cbf_cb, cbf_cr);
            this.readTT(x1, y0, x0, y0, xCUBase, yCUBase, log2TrafoSize - 1, trafoDepth + 1, 1, MaxTrafoDepth, IntraSplitFlag, cuPredMode, cbf_cb, cbf_cr);
            this.readTT(x0, y1, x0, y0, xCUBase, yCUBase, log2TrafoSize - 1, trafoDepth + 1, 2, MaxTrafoDepth, IntraSplitFlag, cuPredMode, cbf_cb, cbf_cr);
            this.readTT(x1, y1, x0, y0, xCUBase, yCUBase, log2TrafoSize - 1, trafoDepth + 1, 3, MaxTrafoDepth, IntraSplitFlag, cuPredMode, cbf_cb, cbf_cr);
        } else {
            int cbf_luma = 1;
            if (predMode == 0 || trafoDepth != 0 || cbf_cb != 0 || cbf_cr != 0) {
                cbf_luma = this.read_cbf_luma(trafoDepth);
            }
            this.readTU(x0, y0, xBase, yBase, xCUBase, yCUBase, log2TrafoSize, blkIdx, cbf_luma, cbf_cb, cbf_cr);
        }
    }

    private void readTU(int x0, int y0, int xBase, int yBase, int xCUBase, int yCUBase, int log2TrafoSize, int blkIdx, int cbf_luma, int cbf_cb, int cbf_cr) {
        int ChromaArrayType = this.sps.ChromaArrayType;
        int log2TrafoSizeC = ChromaArrayType == 3 ? log2TrafoSize : log2TrafoSize - 1;
        log2TrafoSizeC = Math.max(2, log2TrafoSizeC);
        int cbfLuma = cbf_luma;
        int cbfChroma = cbf_cb | cbf_cr;
        Arrays.fill(this.transform_skip_flag, 0);
        this.explicit_rdpcm_flag = 0;
        byte cuPredMode = this.img.getPredMode(x0, y0);
        if (cbfLuma != 0 || cbfChroma != 0) {
            boolean doDecodeQuantParameters = false;
            if (this.pps.cu_qp_delta_enabled_flag != 0 && !this.img.IsCuQpDeltaCoded) {
                int cu_qp_delta_abs = this.read_cu_qp_delta_abs();
                int cu_qp_delta_sign = 0;
                if (cu_qp_delta_abs != 0) {
                    cu_qp_delta_sign = this.cabac.decodeBypass();
                }
                this.img.IsCuQpDeltaCoded = true;
                this.img.CuQpDelta = cu_qp_delta_abs * (1 - 2 * cu_qp_delta_sign);
                doDecodeQuantParameters = true;
            }
            if (this.ssh.cu_chroma_qp_offset_enabled_flag != 0 && cbfChroma != 0 && this.cu_transquant_bypass_flag == 0 && !this.img.IsCuChromaQpOffsetCoded) {
                int cu_chroma_qp_offset_flag = this.cabac.decodeBit(this.ctxTbl.models[23]);
                int cu_chroma_qp_offset_idx = 0;
                if (cu_chroma_qp_offset_flag != 0 && this.pps.chroma_qp_offset_list_len > 1) {
                    cu_chroma_qp_offset_idx = this.cabac.decodeBit(this.ctxTbl.models[24]);
                }
                this.img.IsCuChromaQpOffsetCoded = true;
                if (cu_chroma_qp_offset_flag != 0) {
                    this.img.CuQpOffsetCb = this.pps.cb_qp_offset_list[cu_chroma_qp_offset_idx];
                    this.img.CuQpOffsetCr = this.pps.cr_qp_offset_list[cu_chroma_qp_offset_idx];
                } else {
                    this.img.CuQpOffsetCb = 0;
                    this.img.CuQpOffsetCr = 0;
                }
                doDecodeQuantParameters = true;
            }
            if (doDecodeQuantParameters) {
                this.decodeQuantizationParameters(x0, y0, xCUBase, yCUBase);
            }
        }
        int nT = 1 << log2TrafoSize;
        int nTC = 1 << log2TrafoSizeC;
        int SubWidthC = this.sps.SubWidthC;
        int SubHeightC = this.sps.SubHeightC;
        this.img.ResScaleVal = 0;
        if (cbf_luma != 0) {
            this.residualCoding(x0, y0, log2TrafoSize, 0);
        }
        this.decodeTU(x0, y0, nT, 0, cuPredMode, cbf_luma);
        if (log2TrafoSize > 2 || ChromaArrayType == 3) {
            int yOffset;
            boolean do_cross_component_prediction;
            boolean bl = do_cross_component_prediction = this.pps.cross_component_prediction_enabled_flag != 0 && cbf_luma != 0 && (cuPredMode == 1 || this.img.isIntraPredModeC_Mode4(x0, y0));
            if (do_cross_component_prediction) {
                this.readCrossCompPred(0);
            } else {
                this.img.ResScaleVal = 0;
            }
            if ((cbf_cb & 1) != 0) {
                this.residualCoding(x0, y0, log2TrafoSizeC, 1);
            }
            if (this.sps.ChromaArrayType != 0) {
                this.decodeTU(x0 / SubWidthC, y0 / SubHeightC, nTC, 1, cuPredMode, cbf_cb & 1);
            }
            if (ChromaArrayType == 2) {
                yOffset = 1 << log2TrafoSizeC;
                if ((cbf_cb & 2) != 0) {
                    this.residualCoding(x0, y0 + yOffset * SubHeightC, log2TrafoSizeC, 1);
                }
                this.decodeTU(x0 / SubWidthC, y0 / SubHeightC + yOffset, nTC, 1, cuPredMode, cbf_cb & 2);
            }
            if (do_cross_component_prediction) {
                this.readCrossCompPred(1);
            } else {
                this.img.ResScaleVal = 0;
            }
            if ((cbf_cr & 1) != 0) {
                this.residualCoding(x0, y0, log2TrafoSizeC, 2);
            }
            if (this.sps.ChromaArrayType != 0) {
                this.decodeTU(x0 / SubWidthC, y0 / SubHeightC, nTC, 2, cuPredMode, cbf_cr & 1);
            }
            if (ChromaArrayType == 2) {
                yOffset = 1 << log2TrafoSizeC;
                if ((cbf_cr & 2) != 0) {
                    this.residualCoding(x0, y0 + yOffset * SubHeightC, log2TrafoSizeC, 2);
                }
                this.decodeTU(x0 / SubWidthC, y0 / SubHeightC + yOffset, nTC, 2, cuPredMode, cbf_cr & 2);
            }
        } else if (blkIdx == 3) {
            if ((cbf_cb & 1) != 0) {
                this.residualCoding(xBase, yBase, log2TrafoSize, 1);
            }
            if (this.sps.ChromaArrayType != 0) {
                this.decodeTU(xBase / SubWidthC, yBase / SubHeightC, nT, 1, cuPredMode, cbf_cb & 1);
            }
            if ((cbf_cb & 2) != 0) {
                this.residualCoding(xBase, yBase + (1 << log2TrafoSize), log2TrafoSize, 1);
            }
            if (ChromaArrayType == 2) {
                this.decodeTU(xBase / SubWidthC, yBase / SubHeightC + (1 << log2TrafoSize), nT, 1, cuPredMode, cbf_cb & 2);
            }
            if ((cbf_cr & 1) != 0) {
                this.residualCoding(xBase, yBase, log2TrafoSize, 2);
            }
            if (this.sps.ChromaArrayType != 0) {
                this.decodeTU(xBase / SubWidthC, yBase / SubHeightC, nT, 2, cuPredMode, cbf_cr & 1);
            }
            if ((cbf_cr & 2) != 0) {
                this.residualCoding(xBase, yBase + (1 << log2TrafoSizeC), log2TrafoSize, 2);
            }
            if (ChromaArrayType == 2) {
                this.decodeTU(xBase / SubWidthC, yBase / SubHeightC + (1 << log2TrafoSize), nT, 2, cuPredMode, cbf_cr & 2);
            }
        }
    }

    private void decodeTU(int x0, int y0, int nT, int cIdx, int cuPredMode, int cbf) {
        if (debugU) {
            int planOffset = this.img.getImageStride(cIdx) * y0 + x0;
            LogWriter.writeLog("\t\t\t\tTU c:" + cIdx + " p:" + planOffset);
        }
        int residualDpcm = 0;
        if (cuPredMode == 0) {
            int intraPredMode = cIdx == 0 ? this.img.getIntraPredMode(x0, y0) : this.img.getIntraPredModeC(x0 * this.sps.SubWidthC, y0 * this.sps.SubHeightC);
            if (intraPredMode < 0 || intraPredMode >= 35) {
                intraPredMode = 1;
            }
            this.intraPred.decode(this.img, this.sps, this.pps, x0, y0, intraPredMode, nT, cIdx);
            int n = residualDpcm = !(this.sps.implicit_rdpcm_enabled_flag == 0 || this.cu_transquant_bypass_flag == 0 && this.transform_skip_flag[cIdx] == 0 || intraPredMode != 10 && intraPredMode != 26) ? 1 : 0;
            if (residualDpcm != 0 && intraPredMode == 26) {
                residualDpcm = 2;
            }
        } else if (this.explicit_rdpcm_flag != 0) {
            int n = residualDpcm = this.explicit_rdpcm_dir != 0 ? 2 : 1;
        }
        if (cbf != 0) {
            this.scaleCoefficients(x0, y0, nT, cIdx, this.transform_skip_flag[cIdx], cuPredMode == 0, residualDpcm);
        } else if (cbf == 0 && cIdx != 0 && this.img.ResScaleVal != 0) {
            this.nCoeff[cIdx] = 0;
            residualDpcm = 0;
            this.scaleCoefficients(x0, y0, nT, cIdx, this.transform_skip_flag[cIdx], cuPredMode == 0, residualDpcm);
        }
    }

    private void residualCoding(int x0, int y0, int log2TrafoSize, int cIdx) {
        int LastSigCoeffY;
        int LastSigCoeffX;
        int sbType;
        if (debugU) {
            LogWriter.writeLog("\t\t\t\t RC " + x0 + " " + y0 + " c:" + cIdx);
        }
        byte predMode = this.img.getPredMode(x0, y0);
        if (cIdx == 0) {
            this.img.set_nonzero_coefficient(x0, y0, log2TrafoSize);
        }
        this.transform_skip_flag[cIdx] = this.pps.transform_skip_enabled_flag != 0 && this.cu_transquant_bypass_flag == 0 && log2TrafoSize <= this.pps.Log2MaxTransformSkipSize ? this.read_transform_skip_flag(cIdx) : 0;
        this.explicit_rdpcm_flag = 0;
        if (predMode == 1 && this.sps.explicit_rdpcm_enabled_flag != 0 && (this.transform_skip_flag[cIdx] != 0 || this.cu_transquant_bypass_flag != 0)) {
            this.explicit_rdpcm_flag = this.read_explicit_rdpcm_flag(cIdx);
            if (this.explicit_rdpcm_flag != 0) {
                this.explicit_rdpcm_dir = this.read_explicit_rdpcm_dir(cIdx);
            }
        }
        int n = sbType = cIdx == 0 ? 2 : 0;
        if (this.transform_skip_flag[cIdx] != 0 || this.cu_transquant_bypass_flag != 0) {
            ++sbType;
        }
        int last_sig_coeff_x_prefix = this.read_last_sig_coeff_prefix(log2TrafoSize, cIdx, 25);
        int last_sig_coeff_y_prefix = this.read_last_sig_coeff_prefix(log2TrafoSize, cIdx, 43);
        if (last_sig_coeff_x_prefix > 3) {
            int nBits = (last_sig_coeff_x_prefix >> 1) - 1;
            int lastSigCoeffXSuffix = this.cabac.decodeBypassFL(nBits);
            LastSigCoeffX = (2 + (last_sig_coeff_x_prefix & 1) << nBits) + lastSigCoeffXSuffix;
        } else {
            LastSigCoeffX = last_sig_coeff_x_prefix;
        }
        if (last_sig_coeff_y_prefix > 3) {
            int nBits = (last_sig_coeff_y_prefix >> 1) - 1;
            int lastSigCoeffYSuffix = this.cabac.decodeBypassFL(nBits);
            LastSigCoeffY = (2 + (last_sig_coeff_y_prefix & 1) << nBits) + lastSigCoeffYSuffix;
        } else {
            LastSigCoeffY = last_sig_coeff_y_prefix;
        }
        int scanIdx = 0;
        if (predMode == 0) {
            scanIdx = cIdx == 0 ? IntraPred.getIntraScanIdx(log2TrafoSize, this.img.getIntraPredMode(x0, y0), cIdx, this.sps.ChromaArrayType) : IntraPred.getIntraScanIdx(log2TrafoSize, this.img.getIntraPredModeC(x0, y0), cIdx, this.sps.ChromaArrayType);
        }
        if (scanIdx == 2) {
            int temp = LastSigCoeffX;
            LastSigCoeffX = LastSigCoeffY;
            LastSigCoeffY = temp;
        }
        int[] ScanOrderSub = Scan.get_scan_order(log2TrafoSize - 2, scanIdx);
        int[] ScanOrderPos = Scan.get_scan_order(2, scanIdx);
        int lastScanP = this.img.scan.getScanPos(LastSigCoeffX, LastSigCoeffY, scanIdx, log2TrafoSize);
        int lastSubBlock = lastScanP >> 16;
        int lastScanPos = lastScanP & 0xFFFF;
        int sbWidth = 1 << log2TrafoSize - 2;
        Arrays.fill(this.coded_sub_block_neighbors, 0);
        int c1 = 1;
        boolean firstSubblock = true;
        int lastSubblock_greater1Ctx = 0;
        int CoeffStride = 1 << log2TrafoSize;
        this.lastInvocation_greater1Ctx = 0;
        this.lastInvocation_coeff_abs_level_greater1_flag = 0;
        this.lastInvocation_ctxSet = 0;
        this.nCoeff[cIdx] = 0;
        int[] iList = this.coeffList[cIdx];
        int[] iPos = this.coeffPos[cIdx];
        for (int i = lastSubBlock; i >= 0; --i) {
            int ctxSet;
            int yC;
            int xC;
            int xS = ScanOrderSub[i] >> 16;
            int yS = ScanOrderSub[i] & 0xFFFF;
            boolean inferSbDcSigCoeffFlag = false;
            int sub_block_is_coded = 0;
            if (i < lastSubBlock && i > 0) {
                sub_block_is_coded = this.read_coded_sub_block_flag(cIdx, this.coded_sub_block_neighbors[xS + yS * sbWidth]);
                inferSbDcSigCoeffFlag = true;
            } else if (i == 0 || i == lastSubBlock) {
                sub_block_is_coded = 1;
            }
            if (sub_block_is_coded != 0) {
                int cb;
                if (xS > 0) {
                    cb = this.coded_sub_block_neighbors[xS - 1 + yS * sbWidth] & 0xFF;
                    this.coded_sub_block_neighbors[xS - 1 + yS * sbWidth] = cb | 1;
                }
                if (yS > 0) {
                    cb = this.coded_sub_block_neighbors[xS + (yS - 1) * sbWidth] & 0xFF;
                    this.coded_sub_block_neighbors[xS + (yS - 1) * sbWidth] = cb | 2;
                }
            }
            int nCoefficients = 0;
            Arrays.fill(this.coeff_value, (short)0);
            Arrays.fill(this.coeff_scan_pos, 0);
            Arrays.fill(this.coeff_sign, 0);
            Arrays.fill(this.coeff_has_max_base_level, 0);
            if (sub_block_is_coded != 0) {
                int ctxInc;
                int last_coeff;
                int xx0 = xS << 2;
                int yy0 = yS << 2;
                int log2w = log2TrafoSize - 2;
                int prevCsbf = this.coded_sub_block_neighbors[xS + yS * sbWidth];
                int scanC = scanIdx == 0 ? 0 : 1;
                int cIdxC = cIdx == 0 ? 0 : 1;
                byte[] ctxIdxMap = CtxTbl.CTXINDEXLOOKUP[log2w][cIdxC][scanC][prevCsbf];
                int n2 = last_coeff = i == lastSubBlock ? lastScanPos - 1 : 15;
                if (i == lastSubBlock) {
                    this.coeff_value[nCoefficients] = 1;
                    this.coeff_has_max_base_level[nCoefficients] = 1;
                    this.coeff_scan_pos[nCoefficients] = lastScanPos;
                    ++nCoefficients;
                }
                for (int n3 = last_coeff; n3 > 0; --n3) {
                    xC = xx0 + (ScanOrderPos[n3] >> 16);
                    yC = yy0 + (ScanOrderPos[n3] & 0xFFFF);
                    ctxInc = this.sps.transform_skip_context_enabled_flag != 0 && (this.cu_transquant_bypass_flag != 0 || this.transform_skip_flag[cIdx] != 0) ? (cIdx == 0 ? 42 : 43) : ctxIdxMap[xC + (yC << log2TrafoSize)] & 0xFF;
                    int significant_coeff = this.read_significant_coef_flag(ctxInc);
                    if (significant_coeff == 0) continue;
                    this.coeff_value[nCoefficients] = 1;
                    this.coeff_has_max_base_level[nCoefficients] = 1;
                    this.coeff_scan_pos[nCoefficients] = n3;
                    ++nCoefficients;
                    inferSbDcSigCoeffFlag = false;
                }
                if (last_coeff >= 0) {
                    if (!inferSbDcSigCoeffFlag) {
                        ctxInc = this.sps.transform_skip_context_enabled_flag != 0 && (this.cu_transquant_bypass_flag != 0 || this.transform_skip_flag[cIdx] != 0) ? (cIdx == 0 ? 42 : 43) : ctxIdxMap[xx0 + (yy0 << log2TrafoSize)] & 0xFF;
                        int significant_coeff = this.read_significant_coef_flag(ctxInc);
                        if (significant_coeff != 0) {
                            this.coeff_value[nCoefficients] = 1;
                            this.coeff_has_max_base_level[nCoefficients] = 1;
                            this.coeff_scan_pos[nCoefficients] = 0;
                            ++nCoefficients;
                        }
                    } else {
                        this.coeff_value[nCoefficients] = 1;
                        this.coeff_has_max_base_level[nCoefficients] = 1;
                        this.coeff_scan_pos[nCoefficients] = 0;
                        ++nCoefficients;
                    }
                }
            }
            if (nCoefficients == 0) continue;
            int nMinus = nCoefficients - 1;
            int n4 = ctxSet = i == 0 || cIdx > 0 ? 0 : 2;
            if (c1 == 0) {
                ++ctxSet;
            }
            c1 = 1;
            int newLastGreater1ScanPos = -1;
            int lastGreater1Coefficient = Math.min(8, nCoefficients);
            for (int c = 0; c < lastGreater1Coefficient; ++c) {
                int greater1_flag = this.read_coeff_abs_level_greater1_flag(cIdx, i, c == 0, firstSubblock, lastSubblock_greater1Ctx, ctxSet);
                if (greater1_flag != 0) {
                    int n5 = c;
                    this.coeff_value[n5] = (short)(this.coeff_value[n5] + 1);
                    c1 = 0;
                    if (newLastGreater1ScanPos != -1) continue;
                    newLastGreater1ScanPos = c;
                    continue;
                }
                this.coeff_has_max_base_level[c] = 0;
                if (c1 >= 3 || c1 <= 0) continue;
                ++c1;
            }
            firstSubblock = false;
            lastSubblock_greater1Ctx = this.lastInvocation_greater1Ctx;
            if (newLastGreater1ScanPos != -1) {
                int flag = this.read_coeff_abs_level_greater2_flag(cIdx, this.lastInvocation_ctxSet);
                int n6 = newLastGreater1ScanPos;
                this.coeff_value[n6] = (short)(this.coeff_value[n6] + flag);
                this.coeff_has_max_base_level[newLastGreater1ScanPos] = flag;
            }
            int predModeIntra = cIdx == 0 ? this.img.getIntraPredMode(x0, y0) : this.img.getIntraPredModeC(x0, y0);
            boolean signHidden = this.cu_transquant_bypass_flag == 0 && (predMode != 0 || this.sps.implicit_rdpcm_enabled_flag == 0 || this.transform_skip_flag[cIdx] == 0 || predModeIntra != 10 && predModeIntra != 26) && this.explicit_rdpcm_flag == 0 && this.coeff_scan_pos[0] - this.coeff_scan_pos[nMinus] > 3;
            for (int n7 = 0; n7 < nMinus; ++n7) {
                this.coeff_sign[n7] = this.cabac.decodeBypass();
            }
            this.coeff_sign[nMinus] = this.pps.sign_data_hiding_enabled_flag == 0 || !signHidden ? this.cabac.decodeBypass() : 0;
            int sumAbsLevel = 0;
            int uiGoRiceParam = this.sps.persistent_rice_adaptation_enabled_flag == 0 ? 0 : this.StatCoeff[sbType] / 4;
            boolean firstCoeffWithAbsLevelRemaining = true;
            for (int n8 = 0; n8 < nCoefficients; ++n8) {
                short baseLevel = this.coeff_value[n8];
                int ug3 = 3 * (1 << uiGoRiceParam);
                int absLevelRemain = 0;
                if (this.coeff_has_max_base_level[n8] != 0) {
                    absLevelRemain = this.read_coeff_abs_level_remaining(uiGoRiceParam);
                    if (this.sps.persistent_rice_adaptation_enabled_flag == 0) {
                        if (baseLevel + absLevelRemain > ug3 && ++uiGoRiceParam > 4) {
                            uiGoRiceParam = 4;
                        }
                    } else if (baseLevel + absLevelRemain > ug3) {
                        ++uiGoRiceParam;
                    }
                    if (this.sps.persistent_rice_adaptation_enabled_flag != 0 && firstCoeffWithAbsLevelRemaining) {
                        if (absLevelRemain >= 3 << this.StatCoeff[sbType] / 4) {
                            int n9 = sbType;
                            this.StatCoeff[n9] = this.StatCoeff[n9] + 1;
                        } else if (2 * absLevelRemain < 1 << this.StatCoeff[sbType] / 4 && this.StatCoeff[sbType] > 0) {
                            int n10 = sbType;
                            this.StatCoeff[n10] = this.StatCoeff[n10] - 1;
                        }
                    }
                    firstCoeffWithAbsLevelRemaining = false;
                }
                int currCoeff = baseLevel + absLevelRemain;
                if (this.coeff_sign[n8] != 0) {
                    currCoeff = -currCoeff;
                }
                if (this.pps.sign_data_hiding_enabled_flag != 0 && signHidden && n8 == nCoefficients - 1 && ((sumAbsLevel += baseLevel + absLevelRemain) & 1) != 0) {
                    currCoeff = -currCoeff;
                }
                int p = this.coeff_scan_pos[n8];
                xC = (xS << 2) + (ScanOrderPos[p] >> 16);
                yC = (yS << 2) + (ScanOrderPos[p] & 0xFFFF);
                p = this.nCoeff[cIdx];
                iList[p] = currCoeff;
                iPos[p] = xC + yC * CoeffStride;
                int n11 = cIdx;
                this.nCoeff[n11] = this.nCoeff[n11] + 1;
            }
        }
    }

    private int read_coeff_abs_level_remaining(int cRice) {
        int value;
        int codeword;
        int prefix = -1;
        do {
            codeword = this.cabac.decodeBypass();
            if (++prefix <= 31) continue;
            return 0;
        } while (codeword != 0);
        if (prefix <= 3) {
            codeword = this.cabac.decodeBypassFL(cRice);
            value = (prefix << cRice) + codeword;
        } else {
            codeword = this.cabac.decodeBypassFL(prefix - 3 + cRice);
            value = ((1 << prefix - 3) + 3 - 1 << cRice) + codeword;
        }
        if (debugU) {
            this.codemap.put("coef abs level", value);
        }
        return value;
    }

    private void readPcm(int x0, int y0, int log2CbSize) {
        this.readPcmIdx(x0, y0, log2CbSize, 0);
        if (this.sps.ChromaArrayType != 0) {
            this.readPcmIdx(x0, y0, log2CbSize, 1);
            this.readPcmIdx(x0, y0, log2CbSize, 2);
        }
        this.reader.readByteAlignment();
        this.cabac.initDecoder2();
    }

    private void readPcmIdx(int x0, int y0, int log2CbSize, int cIdx) {
        int bitDepth;
        int nPcmBits;
        int w = 1 << log2CbSize;
        int h = 1 << log2CbSize;
        if (cIdx > 0) {
            w /= this.sps.SubWidthC;
            h /= this.sps.SubHeightC;
            x0 /= this.sps.SubWidthC;
            y0 /= this.sps.SubHeightC;
            nPcmBits = this.sps.pcm_sample_bit_depth_chroma;
            bitDepth = this.sps.BitDepthC;
        } else {
            nPcmBits = this.sps.pcm_sample_bit_depth_luma;
            bitDepth = this.sps.BitDepthY;
        }
        int[] dst = this.img.getImagePlane(cIdx);
        int stride = this.img.getImageStride(cIdx);
        int shift = bitDepth - nPcmBits;
        int dOffset = this.img.getImageStride(cIdx) * y0 + x0;
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int value = this.reader.readBits(nPcmBits);
                dst[dOffset + y * stride + x] = value << shift;
            }
        }
    }

    private void read_sao(int xCtb, int yCtb) {
        InfoSAO saoinfo = new InfoSAO();
        int sao_merge_left_flag = 0;
        int sao_merge_up_flag = 0;
        if (xCtb > 0) {
            boolean leftCtbInTile;
            boolean leftCtbInSliceSeg = this.img.CtbAddrInRS > this.ssh.SliceAddrRS;
            boolean bl = leftCtbInTile = this.pps.TileIdRS[xCtb + yCtb * this.sps.PicWidthInCtbsY] == this.pps.TileIdRS[xCtb - 1 + yCtb * this.sps.PicWidthInCtbsY];
            if (leftCtbInSliceSeg && leftCtbInTile) {
                sao_merge_left_flag = this.read_sao_merge_flag();
            }
        }
        if (yCtb > 0 && sao_merge_left_flag == 0) {
            boolean upCtbInTile;
            boolean upCtbInSliceSeg = this.img.CtbAddrInRS - this.sps.PicWidthInCtbsY >= this.ssh.SliceAddrRS;
            boolean bl = upCtbInTile = this.pps.TileIdRS[xCtb + yCtb * this.sps.PicWidthInCtbsY] == this.pps.TileIdRS[xCtb + (yCtb - 1) * this.sps.PicWidthInCtbsY];
            if (upCtbInSliceSeg && upCtbInTile) {
                sao_merge_up_flag = this.read_sao_merge_flag();
            }
        }
        if (sao_merge_up_flag == 0 && sao_merge_left_flag == 0) {
            int nChroma = 3;
            if (this.sps.ChromaArrayType == 0) {
                nChroma = 1;
            }
            for (int cIdx = 0; cIdx < nChroma; ++cIdx) {
                int saoTypeIdx;
                if ((this.ssh.slice_sao_luma_flag == 0 || cIdx != 0) && (this.ssh.slice_sao_chroma_flag == 0 || cIdx <= 0)) continue;
                switch (cIdx) {
                    case 0: {
                        int sao_type_idx_luma;
                        saoinfo.saoTypeIdx = saoTypeIdx = (sao_type_idx_luma = this.read_sao_type_idx());
                        break;
                    }
                    case 1: {
                        int sao_type_idx_chroma;
                        saoTypeIdx = sao_type_idx_chroma = this.read_sao_type_idx();
                        saoinfo.saoTypeIdx |= saoTypeIdx << 2;
                        saoinfo.saoTypeIdx |= saoTypeIdx << 4;
                        break;
                    }
                    default: {
                        saoTypeIdx = saoinfo.saoTypeIdx >> 2 * cIdx & 3;
                    }
                }
                if (saoTypeIdx == 0) continue;
                for (int i = 0; i < 4; ++i) {
                    saoinfo.saoOffsetVal[cIdx][i] = this.read_sao_offset_abs(this.img.getBitDepth(cIdx));
                }
                int[] sign = new int[4];
                if (saoTypeIdx == 1) {
                    for (int i = 0; i < 4; ++i) {
                        sign[i] = saoinfo.saoOffsetVal[cIdx][i] != 0 ? (this.read_sao_offset_sign() != 0 ? -1 : 1) : 0;
                    }
                    saoinfo.saoBandPos[cIdx] = this.read_sao_band_position();
                } else {
                    sign[1] = 1;
                    sign[0] = 1;
                    sign[3] = -1;
                    sign[2] = -1;
                    if (cIdx == 0) {
                        saoinfo.saoEoClass = saoEoClass = this.read_sao_class();
                    } else if (cIdx == 1) {
                        saoEoClass = this.read_sao_class();
                        saoinfo.saoEoClass |= saoEoClass << 2;
                        saoinfo.saoEoClass |= saoEoClass << 4;
                    }
                }
                int log2OffsetScale = cIdx == 0 ? this.pps.log2_sao_offset_scale_luma : this.pps.log2_sao_offset_scale_chroma;
                for (int i = 0; i < 4; ++i) {
                    saoinfo.saoOffsetVal[cIdx][i] = sign[i] * (saoinfo.saoOffsetVal[cIdx][i] << log2OffsetScale);
                }
            }
            this.img.setSaoInfo(xCtb, yCtb, saoinfo);
        }
        if (sao_merge_left_flag != 0) {
            this.img.setSaoInfo(xCtb, yCtb, this.img.getSaoInfo(xCtb - 1, yCtb));
        }
        if (sao_merge_up_flag != 0) {
            this.img.setSaoInfo(xCtb, yCtb, this.img.getSaoInfo(xCtb, yCtb - 1));
        }
    }

    void initCabacModels() {
        this.ctxTbl.init(this.ssh.initType, this.ssh.SliceQPY);
        for (int i = 0; i < 4; ++i) {
            this.StatCoeff[i] = 0;
        }
    }

    private int read_transform_skip_flag(int cIdx) {
        if (debugU) {
            this.codemap.put("transform skip", 0);
        }
        int context = cIdx == 0 ? 0 : 1;
        return this.cabac.decodeBit(this.ctxTbl.models[141 + context]);
    }

    private int read_sao_merge_flag() {
        if (debugU) {
            this.codemap.put("sao merge", 0);
        }
        return this.cabac.decodeBit(this.ctxTbl.models[0]);
    }

    private int read_sao_type_idx() {
        int bit;
        if (debugU) {
            this.codemap.put("sao type", 0);
        }
        if ((bit = this.cabac.decodeBit(this.ctxTbl.models[1])) == 0) {
            return 0;
        }
        bit = this.cabac.decodeBypass();
        return bit == 0 ? 1 : 2;
    }

    private int read_sao_offset_abs(int bitDepth) {
        if (debugU) {
            this.codemap.put("sao offset abs", 0);
        }
        int cMax = (1 << Math.min(bitDepth, 10) - 5) - 1;
        return this.cabac.decodeBypassTU(cMax);
    }

    private int read_sao_class() {
        if (debugU) {
            this.codemap.put("sao class", 0);
        }
        return this.cabac.decodeBypassFL(2);
    }

    private int read_sao_offset_sign() {
        if (debugU) {
            this.codemap.put("sao offset", 0);
        }
        return this.cabac.decodeBypass();
    }

    private int read_sao_band_position() {
        if (debugU) {
            this.codemap.put("sao band", 0);
        }
        return this.cabac.decodeBypassFL(5);
    }

    private int read_cu_transquant_bypass_flag() {
        if (debugU) {
            this.codemap.put("cu transquant", 0);
        }
        return this.cabac.decodeBit(this.ctxTbl.models[161]);
    }

    private int read_split_cu_flag(int x0, int y0, int ctDepth) {
        if (debugU) {
            this.codemap.put("split cu", 0);
        }
        boolean hasLeft = this.img.checkCTBavailable(x0, y0, x0 - 1, y0);
        boolean hasTop = this.img.checkCTBavailable(x0, y0, x0, y0 - 1);
        int condL = 0;
        int condA = 0;
        if (hasLeft && this.img.getCTDepth(x0 - 1, y0) > ctDepth) {
            condL = 1;
        }
        if (hasTop && this.img.getCTDepth(x0, y0 - 1) > ctDepth) {
            condA = 1;
        }
        int cc = condL + condA;
        return this.cabac.decodeBit(this.ctxTbl.models[2 + cc]);
    }

    private int read_cu_skip_flag(int x0, int y0) {
        if (debugU) {
            this.codemap.put("cu skip", 0);
        }
        boolean hasLeft = this.img.checkCTBavailable(x0, y0, x0 - 1, y0);
        boolean hasTop = this.img.checkCTBavailable(x0, y0, x0, y0 - 1);
        int condL = 0;
        int condA = 0;
        if (hasLeft && this.img.getCuSkipFlag(x0 - 1, y0)) {
            condL = 1;
        }
        if (hasTop && this.img.getCuSkipFlag(x0, y0 - 1)) {
            condA = 1;
        }
        int cc = condL + condA;
        return this.cabac.decodeBit(this.ctxTbl.models[5 + cc]);
    }

    private int read_log2_res_scale_abs_plus1(int cIdxMinus1) {
        int inc;
        int bit;
        if (debugU) {
            this.codemap.put("res scale abs", 0);
        }
        int value = 0;
        for (int binIdx = 0; binIdx < 4 && (bit = this.cabac.decodeBit(this.ctxTbl.models[162 + (inc = 4 * cIdxMinus1 + binIdx)])) != 0; ++binIdx) {
            ++value;
        }
        return value;
    }

    private int read_res_scale_sign_flag(int cIdxMinus1) {
        if (debugU) {
            this.codemap.put("res scale sign", 0);
        }
        return this.cabac.decodeBit(this.ctxTbl.models[170 + cIdxMinus1]);
    }

    private void readCrossCompPred(int c) {
        int resScalVal;
        int log2_res_scale_abs_plus1 = this.read_log2_res_scale_abs_plus1(c);
        if (log2_res_scale_abs_plus1 != 0) {
            int res_scale_sign_flag = this.read_res_scale_sign_flag(c);
            resScalVal = 1 << log2_res_scale_abs_plus1 - 1;
            resScalVal *= 1 - 2 * res_scale_sign_flag;
        } else {
            resScalVal = 0;
        }
        this.img.ResScaleVal = resScalVal;
    }

    private int decode_part_mode(int predMode) {
        if (predMode == 0) {
            int bit = this.cabac.decodeBit(this.ctxTbl.models[8]);
            if (debugU) {
                this.codemap.put("part mode", bit != 0 ? 0 : 3);
            }
            return bit != 0 ? 0 : 3;
        }
        LogWriter.writeLog("Decoding Inter Part");
        return 0;
    }

    private int read_prev_intra_luma_pred_flag() {
        if (debugU) {
            this.codemap.put("prev intra luma", 0);
        }
        return this.cabac.decodeBit(this.ctxTbl.models[12]);
    }

    private int read_mpm_idx() {
        int v = this.cabac.decodeBypassTU(2);
        if (debugU) {
            this.codemap.put("mpm idx", v);
        }
        return v;
    }

    private int read_rem_intra_luma_pred_mode() {
        if (debugU) {
            this.codemap.put("rem intra luma", 0);
        }
        return this.cabac.decodeBypassFL(5);
    }

    private int read_intra_chroma_pred_mode() {
        int prefix;
        if (debugU) {
            this.codemap.put("rem intra chroma", 0);
        }
        if ((prefix = this.cabac.decodeBit(this.ctxTbl.models[13])) == 0) {
            return 4;
        }
        return this.cabac.decodeBypassFL(2);
    }

    private int read_split_transform_flag(int log2TrafoSize) {
        if (debugU) {
            this.codemap.put("transform split", 0);
        }
        int cc = 5 - log2TrafoSize;
        return this.cabac.decodeBit(this.ctxTbl.models[20 + cc]);
    }

    private int read_cbf_chroma(int trafoDepth) {
        int v = this.cabac.decodeBit(this.ctxTbl.models[16 + trafoDepth]);
        if (debugU) {
            this.codemap.put("cbf chroma", v);
        }
        return v;
    }

    private int read_cbf_luma(int trafoDepth) {
        int vv = trafoDepth == 0 ? 1 : 0;
        int v = this.cabac.decodeBit(this.ctxTbl.models[14 + vv]);
        if (debugU) {
            this.codemap.put("cbf luma", v);
        }
        return v;
    }

    private int read_coded_sub_block_flag(int cIdx, int neighborSubBlock) {
        int csbfCtx;
        int ctxInc = csbfCtx = neighborSubBlock & 1 | neighborSubBlock >> 1;
        if (cIdx != 0) {
            ctxInc += 2;
        }
        int v = this.cabac.decodeBit(this.ctxTbl.models[61 + ctxInc]);
        if (debugU) {
            this.codemap.put("coded sub block", v);
        }
        return v;
    }

    private int read_cu_qp_delta_abs() {
        int bit;
        if (debugU) {
            this.codemap.put("cu qp delta", 0);
        }
        if ((bit = this.cabac.decodeBit(this.ctxTbl.models[139])) == 0) {
            return 0;
        }
        int prefix = 1;
        for (int i = 0; i < 4 && (bit = this.cabac.decodeBit(this.ctxTbl.models[140])) != 0; ++i) {
            ++prefix;
        }
        if (prefix == 5) {
            int value = this.cabac.decodeBypassEGK(0);
            return value + 5;
        }
        return prefix;
    }

    private int read_last_sig_coeff_prefix(int log2TrafoSize, int cIdx, int mOffset) {
        int ctxShift;
        int ctxOffset;
        int cMax = (log2TrafoSize << 1) - 1;
        if (cIdx == 0) {
            ctxOffset = 3 * (log2TrafoSize - 2) + (log2TrafoSize - 1 >> 2);
            ctxShift = log2TrafoSize + 1 >> 2;
        } else {
            ctxOffset = 15;
            ctxShift = log2TrafoSize - 2;
        }
        int value = cMax;
        for (int binIdx = 0; binIdx < cMax; ++binIdx) {
            int ctxIdxInc = binIdx >> ctxShift;
            int bit = this.cabac.decodeBit(this.ctxTbl.models[mOffset + ctxOffset + ctxIdxInc]);
            if (bit != 0) continue;
            value = binIdx;
            break;
        }
        if (debugU) {
            this.codemap.put("last sig coef", value);
        }
        return value;
    }

    private int read_significant_coef_flag(int ctxInc) {
        int v = this.cabac.decodeBit(this.ctxTbl.models[65 + ctxInc]);
        if (debugU) {
            this.codemap.put("sig coef", v);
            LogWriter.writeLog("ctxInc: " + ctxInc);
        }
        return v;
    }

    int read_coeff_abs_level_greater1_flag(int cIdx, int i, boolean firstCoeffInSubblock, boolean firstSubblock, int lastSubblock_greater1Ctx, int c1) {
        int greater1Ctx;
        if (firstCoeffInSubblock) {
            greater1Ctx = 1;
        } else {
            greater1Ctx = this.lastInvocation_greater1Ctx;
            if (greater1Ctx > 0) {
                greater1Ctx = this.lastInvocation_coeff_abs_level_greater1_flag == 1 ? 0 : ++greater1Ctx;
            }
        }
        int ctxSet = c1;
        int ctxIdxInc = ctxSet * 4 + (greater1Ctx >= 3 ? 3 : greater1Ctx);
        if (cIdx > 0) {
            ctxIdxInc += 16;
        }
        int bit = this.cabac.decodeBit(this.ctxTbl.models[109 + ctxIdxInc]);
        this.lastInvocation_greater1Ctx = greater1Ctx;
        this.lastInvocation_coeff_abs_level_greater1_flag = bit;
        this.lastInvocation_ctxSet = ctxSet;
        if (debugU) {
            this.codemap.put("coef abs level greater1", bit);
        }
        return bit;
    }

    private int read_coeff_abs_level_greater2_flag(int cIdx, int ctxSet) {
        int ctxIdxInc = ctxSet;
        if (cIdx > 0) {
            ctxIdxInc += 4;
        }
        int v = this.cabac.decodeBit(this.ctxTbl.models[133 + ctxIdxInc]);
        if (debugU) {
            this.codemap.put("coef abs level greater2", v);
        }
        return v;
    }

    private int read_pred_mode_flag() {
        int v = this.cabac.decodeBit(this.ctxTbl.models[149]);
        if (debugU) {
            this.codemap.put("pred mode", v);
        }
        return v;
    }

    private int read_rqt_root_cbf() {
        if (debugU) {
            this.codemap.put("rqt root cbf", 0);
        }
        return this.cabac.decodeBit(this.ctxTbl.models[153]);
    }

    private int read_explicit_rdpcm_flag(int cIdx) {
        if (debugU) {
            this.codemap.put("explicit flag", 0);
        }
        int vv = cIdx != 0 ? 1 : 0;
        return this.cabac.decodeBit(this.ctxTbl.models[143 + vv]);
    }

    private int read_explicit_rdpcm_dir(int cIdx) {
        if (debugU) {
            this.codemap.put("explicit dir", 0);
        }
        int vv = cIdx != 0 ? 1 : 0;
        return this.cabac.decodeBit(this.ctxTbl.models[145 + vv]);
    }

    private static int mapChromaPredMode(int chromaPred, int pred) {
        if (chromaPred == 4) {
            return pred;
        }
        int intraPredModeC = CCAND[chromaPred];
        return intraPredModeC == pred ? 34 : intraPredModeC;
    }

    private void decodeQuantizationParameters(int xC, int yC, int xCUBase, int yCUBase) {
        int log2CbSize;
        int qPCr;
        int qPCb;
        int minTbAddrB;
        int ctbAddrB;
        int yTmp;
        int xTmp;
        int minTbAddrA;
        int ctbAddrA;
        if (debugU) {
            LogWriter.writeLog("\t\tDQ " + xC + " " + yC);
        }
        int xQG = xCUBase - (xCUBase & (1 << this.pps.Log2MinCuQpDeltaSize) - 1);
        int yQG = yCUBase - (yCUBase & (1 << this.pps.Log2MinCuQpDeltaSize) - 1);
        if (xQG != this.currentQG_x || yQG != this.currentQG_y) {
            this.lastQPYinPreviousQG = this.currentQPY;
            this.currentQG_x = xQG;
            this.currentQG_y = yQG;
        }
        int ctbLSBMask = (1 << this.sps.Log2CtbSizeY) - 1;
        boolean firstInCTBRow = xQG == 0 && (yQG & ctbLSBMask) == 0;
        int first_ctb_in_slice_RS = this.ssh.SliceAddrRS;
        int SliceStartX = first_ctb_in_slice_RS % this.sps.PicWidthInCtbsY * this.sps.CtbSizeY;
        int SliceStartY = first_ctb_in_slice_RS / this.sps.PicWidthInCtbsY * this.sps.CtbSizeY;
        boolean firstQGInSlice = SliceStartX == xQG && SliceStartY == yQG;
        boolean firstQGInTile = false;
        if (this.pps.tiles_enabled_flag != 0 && (xQG & (1 << this.sps.Log2CtbSizeY) - 1) == 0 && (yQG & (1 << this.sps.Log2CtbSizeY) - 1) == 0) {
            int ctbX = xQG >> this.sps.Log2CtbSizeY;
            int ctbY = yQG >> this.sps.Log2CtbSizeY;
            firstQGInTile = this.pps.isTileStartCTB(ctbX, ctbY, this.img);
        }
        int qPY_PRED = firstQGInSlice || firstQGInTile || firstInCTBRow && this.pps.entropy_coding_sync_enabled_flag != 0 ? this.ssh.SliceQPY : this.lastQPYinPreviousQG;
        int qPYA = this.img.availableZscan(xQG, yQG, xQG - 1, yQG) ? ((ctbAddrA = (minTbAddrA = this.pps.MinTbAddrZS[(xTmp = xQG - 1 >> this.sps.Log2MinTrafoSize) + (yTmp = yQG >> this.sps.Log2MinTrafoSize) * this.sps.PicWidthInTbsY]) >> 2 * (this.sps.Log2CtbSizeY - this.sps.Log2MinTrafoSize)) == this.img.CtbAddrInTS ? (int)this.img.getQPY(xQG - 1, yQG) : qPY_PRED) : qPY_PRED;
        int qPYB = this.img.availableZscan(xQG, yQG, xQG, yQG - 1) ? ((ctbAddrB = (minTbAddrB = this.pps.MinTbAddrZS[(xTmp = xQG >> this.sps.Log2MinTrafoSize) + (yTmp = yQG - 1 >> this.sps.Log2MinTrafoSize) * this.sps.PicWidthInTbsY]) >> 2 * (this.sps.Log2CtbSizeY - this.sps.Log2MinTrafoSize)) == this.img.CtbAddrInTS ? (int)this.img.getQPY(xQG, yQG - 1) : qPY_PRED) : qPY_PRED;
        qPY_PRED = qPYA + qPYB + 1 >> 1;
        int QPY = (qPY_PRED + this.img.CuQpDelta + 52 + 2 * this.sps.QpBdOffsetY) % (52 + this.sps.QpBdOffsetY) - this.sps.QpBdOffsetY;
        this.qPYPrime = QPY + this.sps.QpBdOffsetY;
        if (this.qPYPrime < 0) {
            this.qPYPrime = 0;
        }
        int qPiCb = HeicMath.clip3(-this.sps.QpBdOffsetC, 57, QPY + this.pps.cb_qp_offset + this.ssh.slice_cb_qp_offset + this.img.CuQpOffsetCb);
        int qPiCr = HeicMath.clip3(-this.sps.QpBdOffsetC, 57, QPY + this.pps.cr_qp_offset + this.ssh.slice_cr_qp_offset + this.img.CuQpOffsetCr);
        if (this.sps.ChromaArrayType == 1) {
            qPCb = Transform.tab22(qPiCb);
            qPCr = Transform.tab22(qPiCr);
        } else {
            qPCb = qPiCb;
            qPCr = qPiCr;
        }
        this.qPCbPrime = qPCb + this.sps.QpBdOffsetC;
        if (this.qPCbPrime < 0) {
            this.qPCbPrime = 0;
        }
        this.qPCrPrime = qPCr + this.sps.QpBdOffsetC;
        if (this.qPCrPrime < 0) {
            this.qPCrPrime = 0;
        }
        if ((log2CbSize = this.img.getLog2CbSize(xCUBase, yCUBase)) < 3) {
            log2CbSize = 3;
        }
        this.img.setQPY(xCUBase, yCUBase, log2CbSize, QPY);
        this.currentQPY = QPY;
    }

    private int[] getCoeffBuff(int nT) {
        switch (nT) {
            case 4: {
                return this.coeffBuf4;
            }
            case 8: {
                return this.coeffBuf8;
            }
            case 16: {
                return this.coeffBuf16;
            }
        }
        return this.coeffBuf32;
    }

    private void scaleCoefficients(int xT, int yT, int nT, int cIdx, int transformSkipFlag, boolean intra, int rdpcmMode) {
        int qP = this.qPYPrime;
        switch (cIdx) {
            case 1: {
                qP = this.qPCbPrime;
                break;
            }
            case 2: {
                qP = this.qPCrPrime;
            }
        }
        int[] coeff = this.getCoeffBuff(nT);
        int[] pred = this.img.getImagePlane(cIdx);
        int stride = this.img.getImageStride(cIdx);
        int planOffset = this.img.getImageStride(cIdx) * yT + xT;
        int bit_depth = this.img.getBitDepth(cIdx);
        boolean cuPredModeIntra = this.img.getPredMode(xT, yT) == 0;
        boolean rotateCoeffs = this.sps.transform_skip_rotation_enabled_flag != 0 && nT == 4 && cuPredModeIntra;
        int iCoeff = this.nCoeff[cIdx];
        int[] iPos = this.coeffPos[cIdx];
        int[] iList = this.coeffList[cIdx];
        if (this.cu_transquant_bypass_flag != 0) {
            int[] residual = cIdx == 0 ? this.residual_luma : new int[nT * nT];
            for (int i = 0; i < iCoeff; ++i) {
                coeff[iPos[i]] = iList[i];
            }
            if (rotateCoeffs) {
                Transform.rotate(coeff, nT);
            }
            if (rdpcmMode != 0) {
                if (rdpcmMode == 2) {
                    Transform.bypass_rdpcm_v(residual, coeff, nT);
                } else {
                    Transform.bypass_rdpcm_h(residual, coeff, nT);
                }
            } else {
                Transform.bypass(residual, coeff, nT);
            }
            if (cIdx != 0 && this.img.ResScaleVal != 0) {
                this.crossCompPredTransform(residual, nT);
            }
            Transform.addResidual(pred, planOffset, stride, residual, nT, bit_depth);
            if (rotateCoeffs) {
                Arrays.fill(coeff, 0);
            }
        } else {
            int bdShift = (cIdx == 0 ? this.sps.BitDepthY : this.sps.BitDepthC) + HeicMath.log2(nT) - 5;
            int fact = Transform.LEVELSCALE[qP % 6] << qP / 6;
            if (this.sps.scaling_list_enabled_flag == 0) {
                offset = 1 << (bdShift -= 4) - 1;
                for (int i = 0; i < iCoeff; ++i) {
                    int currCoeff = iList[i];
                    coeff[iPos[i]] = currCoeff = HeicMath.clip3(Short.MIN_VALUE, Short.MAX_VALUE, currCoeff * fact + offset >> bdShift);
                }
            } else {
                offset = 1 << bdShift - 1;
                int[] sclist = null;
                int matrixID = cIdx;
                if (!intra) {
                    matrixID = nT < 32 ? (matrixID += 3) : ++matrixID;
                }
                switch (nT) {
                    case 4: {
                        sclist = this.img.scan.scaling0[matrixID];
                        break;
                    }
                    case 8: {
                        sclist = this.img.scan.scaling1[matrixID];
                        break;
                    }
                    case 16: {
                        sclist = this.img.scan.scaling2[matrixID];
                        break;
                    }
                    case 32: {
                        sclist = this.img.scan.scaling3[matrixID];
                    }
                }
                for (int i = 0; i < iCoeff; ++i) {
                    int pos = iPos[i];
                    int x = pos % nT;
                    int y = pos / nT;
                    int v = sclist[x + y * nT] * fact;
                    long currCoeff = iList[i];
                    currCoeff = currCoeff * (long)v + (long)offset >> bdShift;
                    coeff[this.coeffPos[cIdx][i]] = v = HeicMath.clip3(Short.MIN_VALUE, Short.MAX_VALUE, (int)currCoeff);
                }
            }
            if (transformSkipFlag != 0) {
                boolean extended_precision_processing_flag = false;
                int Log2nTbS = HeicMath.log2(nT);
                boolean temp = false;
                int bdShift3 = Math.max(20 - bit_depth, 0);
                int tsShift = 5 + Log2nTbS;
                if (rotateCoeffs) {
                    Transform.rotate(coeff, nT);
                }
                int[] residual = cIdx == 0 ? this.residual_luma : new int[nT * nT];
                if (rdpcmMode != 0) {
                    if (rdpcmMode == 2) {
                        Transform.rdpcm_v(residual, coeff, nT, tsShift, bdShift3);
                    } else {
                        Transform.rdpcm_h(residual, coeff, nT, tsShift, bdShift3);
                    }
                } else {
                    Transform.skipReisidual(residual, coeff, nT, tsShift, bdShift3);
                }
                if (cIdx != 0 && this.img.ResScaleVal != 0) {
                    this.crossCompPredTransform(residual, nT);
                }
                Transform.addResidual(pred, planOffset, stride, residual, nT, bit_depth);
                if (rotateCoeffs) {
                    Arrays.fill(coeff, 0);
                }
            } else {
                int trType;
                int n = trType = nT == 4 && cIdx == 0 && cuPredModeIntra ? 1 : 0;
                if (this.pps.cross_component_prediction_enabled_flag != 0) {
                    this.transform_coefficients_explicit(coeff, nT, trType, pred, planOffset, stride, bit_depth, cIdx);
                } else {
                    this.transform_coefficients(coeff, nT, trType, pred, planOffset, stride, bit_depth);
                }
            }
        }
        for (int i = 0; i < iCoeff; ++i) {
            coeff[iPos[i]] = 0;
        }
    }

    private void crossCompPredTransform(int[] residual, int nT) {
        for (int y = 0; y < nT; ++y) {
            for (int x = 0; x < nT; ++x) {
                int n = y * nT + x;
                residual[n] = residual[n] + (this.img.ResScaleVal * (this.residual_luma[y * nT + x] << this.sps.BitDepthC >> this.sps.BitDepthY) >> 3);
            }
        }
    }

    private void transform_coefficients_explicit(int[] coeff, int nT, int trType, int[] dst, int dstOffset, int dstStride, int bit_depth, int cIdx) {
        int[] residual = cIdx == 0 ? this.residual_luma : new int[nT * nT];
        int bdShift = 20 - bit_depth;
        int max_coeff_bits = 15;
        if (trType == 1) {
            Transform.transform_idst_4x4(residual, coeff, bdShift, 15);
        } else {
            Transform.transform_idct_add(residual, coeff, nT, bdShift, 15);
        }
        if (cIdx != 0 && this.img.ResScaleVal != 0) {
            this.crossCompPredTransform(residual, nT);
        }
        Transform.addResidual(dst, dstOffset, dstStride, residual, nT, bit_depth);
    }

    private void transform_coefficients(int[] coeff, int nT, int trType, int[] dst, int dstOffset, int dstStride, int bit_depth) {
        if (trType == 1) {
            Transform.transformDST(dst, dstOffset, coeff, this.dstG, dstStride, bit_depth);
        } else {
            int[] g = this.dctG4;
            switch (nT) {
                case 8: {
                    g = this.dctG8;
                    break;
                }
                case 16: {
                    g = this.dctG16;
                    break;
                }
                case 32: {
                    g = this.dctG32;
                }
            }
            Transform.transformDCT(dst, dstOffset, dstStride, coeff, g, nT, bit_depth);
        }
    }

    class CB {
        CB() {
        }

        private void put(String val, int v) {
            LogWriter.writeLog("#### " + val + " " + v);
        }
    }
}

