/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.heic.common;

import org.jpedal.utils.LogWriter;

class Bitstream {
    int p;
    final byte[] data;
    int bs;
    int b;
    private int p1 = -1;
    private int p2 = -1;

    Bitstream(byte[] data) {
        this.data = data;
    }

    byte readBit() {
        return (byte)this.readBits(1);
    }

    int readU8() {
        return this.readBits(8);
    }

    int readU16() {
        return this.readU8() << 8 | this.readU8();
    }

    int readU32() {
        return this.readU16() << 16 | this.readU16();
    }

    int readBits(int n) {
        while (this.bs < n) {
            int cur = this.data[this.p++] & 0xFF;
            if (this.p1 == 0 && this.p2 == 0 && cur == 3) {
                cur = this.data[this.p++] & 0xFF;
                this.p1 = -1;
                this.p2 = -1;
            }
            this.p1 = this.p2;
            this.p2 = cur;
            this.b = this.b << 8 | cur;
            this.bs += 8;
        }
        this.bs -= n;
        return this.b >>> this.bs & (1 << n) - 1;
    }

    private int nextBit() {
        int oldP = this.p;
        int oldBS = this.bs;
        int oldB = this.b;
        byte v = this.readBit();
        this.p = oldP;
        this.bs = oldBS;
        this.b = oldB;
        return v;
    }

    int ue() {
        int num_zeros = 0;
        while (this.readBit() == 0) {
            if (++num_zeros <= 31) continue;
            return 0;
        }
        if (num_zeros != 0) {
            int offset = this.readBits(num_zeros);
            return offset + (1 << num_zeros) - 1;
        }
        return 0;
    }

    int se() {
        int v = this.ue();
        if (v == 0) {
            return 0;
        }
        return (v & 1) == 0 ? -v / 2 : (v + 1) / 2;
    }

    private int bitsRemaining() {
        return (this.data.length - this.p << 3) + this.bs;
    }

    int byteRemaining() {
        return this.data.length - this.p;
    }

    boolean moreRbspData() {
        int rem = this.bitsRemaining();
        return rem == 0 || this.nextBit() == 1;
    }

    void readRbspTrailingBits() {
        this.readBit();
        while (!this.byteAligned()) {
            this.readBit();
        }
    }

    void readByteAlignment() {
        if (this.p < this.data.length) {
            byte alignBit = this.readBit();
            if (alignBit != 1) {
                LogWriter.writeLog("aligned bit is not 1");
            }
            this.bs = 0;
            this.b = 0;
        }
    }

    private boolean byteAligned() {
        return this.bs == 0;
    }
}

