/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.gif;

import com.idrsolutions.image.Encoder;
import com.idrsolutions.image.JDeliImage;
import com.idrsolutions.image.encoder.options.EncoderOptions;
import com.idrsolutions.image.gif.options.GifEncoderOptions;
import com.idrsolutions.image.png.data.D3;
import com.idrsolutions.image.png.data.Quant24;
import com.idrsolutions.image.utility.Access;
import com.idrsolutions.image.utility.PixGet;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;

public class GifEncoder
extends JDeliImage
implements Encoder {
    private GifEncoderOptions gifEncoderOptions = new GifEncoderOptions();

    public GifEncoder(EncoderOptions format) {
        if (format != null) {
            this.gifEncoderOptions = (GifEncoderOptions)format;
        }
    }

    public GifEncoder() {
    }

    @Override
    public GifEncoderOptions getEncoderOptions() {
        return this.gifEncoderOptions;
    }

    @Override
    public void write(BufferedImage image, OutputStream outputStream) throws IOException {
        GifEncoder.compress(image, outputStream);
    }

    private static void compress(BufferedImage image, OutputStream stream) throws IOException {
        int iw = image.getWidth();
        int ih = image.getHeight();
        int[] pixels = new int[iw * ih];
        PixGet pa = Access.getPixGet(image);
        int p = 0;
        for (int y = 0; y < ih; ++y) {
            for (int x = 0; x < iw; ++x) {
                pixels[p++] = pa.getARGB(x, y);
            }
        }
        Quant24 wu = new Quant24();
        byte[] colors_ = wu.getPalette(pixels, iw, ih);
        byte[] qBytes = D3.process(colors_, pixels, iw, ih);
        int nColors = colors_.length / 3;
        GifEncoder.writeString(stream, "GIF87a");
        GifEncoder.writeScreen(stream, iw, ih, nColors);
        stream.write(colors_, 0, colors_.length);
        GifEncoder.writeDescriptor(stream, iw, ih, ',');
        byte codeSize = GifEncoder.bitsNeeded(nColors);
        if (codeSize == 1) {
            codeSize = (byte)(codeSize + 1);
        }
        stream.write(codeSize);
        GifEncoder.writeLzwCompressed(stream, codeSize, qBytes);
        stream.write(0);
        GifEncoder.writeDescriptor(stream, 0, 0, ';');
        stream.flush();
        stream.close();
    }

    private static byte bitsNeeded(int n) {
        if (n-- == 0) {
            return 0;
        }
        byte nBitsNeeded = 1;
        while ((n >>= 1) != 0) {
            nBitsNeeded = (byte)(nBitsNeeded + 1);
        }
        return nBitsNeeded;
    }

    private static void writeWord(OutputStream stream, int w) throws IOException {
        stream.write(w & 0xFF);
        stream.write(w >> 8 & 0xFF);
    }

    private static void writeString(OutputStream stream, String string) throws IOException {
        for (int i = 0; i < string.length(); ++i) {
            stream.write((byte)string.charAt(i));
        }
    }

    private static void writeScreen(OutputStream stream, int iw, int ih, int nColors) throws IOException {
        GifEncoder.writeWord(stream, iw);
        GifEncoder.writeWord(stream, ih);
        int flag = 0;
        byte globalColorTableSize = (byte)(GifEncoder.bitsNeeded(nColors) - 1);
        flag = (byte)(flag | globalColorTableSize & 7);
        boolean globalColorTableFlag = true;
        flag = (byte)(flag | 0x80);
        int colorResolution = 7;
        flag = (byte)(flag | 0x70);
        boolean backgroundColorIndex = false;
        boolean pixelAspectRatio = false;
        stream.write(flag);
        stream.write(0);
        stream.write(0);
    }

    private static void writeDescriptor(OutputStream stream, int width, int height, char separator) throws IOException {
        stream.write(separator);
        GifEncoder.writeWord(stream, 0);
        GifEncoder.writeWord(stream, 0);
        GifEncoder.writeWord(stream, width);
        GifEncoder.writeWord(stream, height);
        byte flag = 0;
        boolean localColorTableSize = false;
        flag = (byte)(flag | 0);
        boolean reserved = false;
        flag = (byte)(flag | 0);
        boolean sortFlag = false;
        flag = (byte)(flag | 0);
        boolean interlaceFlag = false;
        flag = (byte)(flag | 0);
        boolean localColorTableFlag = false;
        flag = (byte)(flag | 0);
        stream.write(flag);
    }

    private static void writeLzwCompressed(OutputStream stream, int codeSize, byte[] toCompress) throws IOException {
        short prefix = -1;
        GifBit bitFile = new GifBit(stream);
        LzwTable strings = new LzwTable();
        int clearcode = 1 << codeSize;
        int endofinfo = clearcode + 1;
        int numbits = codeSize + 1;
        int limit = (1 << numbits) - 1;
        strings.clearTable(codeSize);
        bitFile.writeBits(clearcode, numbits);
        for (int loop = 0; loop < toCompress.length; ++loop) {
            byte c = toCompress[loop];
            short index = strings.findCharString(prefix, c);
            if (index != -1) {
                prefix = index;
                continue;
            }
            bitFile.writeBits(prefix, numbits);
            if (strings.addCharString(prefix, c) > limit) {
                if (++numbits > 12) {
                    bitFile.writeBits(clearcode, numbits - 1);
                    strings.clearTable(codeSize);
                    numbits = codeSize + 1;
                }
                limit = (1 << numbits) - 1;
            }
            prefix = (short)(c & 0xFF);
        }
        if (prefix != -1) {
            bitFile.writeBits(prefix, numbits);
        }
        bitFile.writeBits(endofinfo, numbits);
        bitFile.flush();
    }

    private static class GifBit {
        private final OutputStream stream_;
        private final byte[] buffer_;
        private int streamIndex_;
        private int bitsLeft_;

        GifBit(OutputStream stream) {
            this.stream_ = stream;
            this.buffer_ = new byte[256];
            this.streamIndex_ = 0;
            this.bitsLeft_ = 8;
        }

        void flush() throws IOException {
            int nBytes = this.streamIndex_ + (this.bitsLeft_ == 8 ? 0 : 1);
            if (nBytes > 0) {
                this.stream_.write(nBytes);
                this.stream_.write(this.buffer_, 0, nBytes);
                this.buffer_[0] = 0;
                this.streamIndex_ = 0;
                this.bitsLeft_ = 8;
            }
        }

        void writeBits(int bits, int nBits) throws IOException {
            int nBytes = 255;
            do {
                if (this.streamIndex_ == 254 && this.bitsLeft_ == 0 || this.streamIndex_ > 254) {
                    this.stream_.write(255);
                    this.stream_.write(this.buffer_, 0, 255);
                    this.buffer_[0] = 0;
                    this.streamIndex_ = 0;
                    this.bitsLeft_ = 8;
                }
                if (nBits <= this.bitsLeft_) {
                    int n = this.streamIndex_;
                    this.buffer_[n] = (byte)(this.buffer_[n] | (bits & (1 << nBits) - 1) << 8 - this.bitsLeft_);
                    this.bitsLeft_ -= nBits;
                    nBits = 0;
                    continue;
                }
                int n = this.streamIndex_++;
                this.buffer_[n] = (byte)(this.buffer_[n] | (bits & (1 << this.bitsLeft_) - 1) << 8 - this.bitsLeft_);
                bits >>= this.bitsLeft_;
                nBits -= this.bitsLeft_;
                this.buffer_[this.streamIndex_] = 0;
                this.bitsLeft_ = 8;
            } while (nBits != 0);
        }
    }

    private static class LzwTable {
        private static final int RES_CODES = 2;
        private static final int MAXBITS = 12;
        private static final int MAXSTR = 4096;
        private static final short HASH_FREE = -1;
        private static final short NEXT_FIRST = -1;
        private static final short HASHSIZE = 9973;
        private static final short HASHSTEP = 2039;
        private final byte[] strChr_ = new byte[4096];
        private final short[] strNxt_ = new short[4096];
        private final short[] strHsh_ = new short[9973];
        private short nStrings_;

        LzwTable() {
        }

        int addCharString(short index, byte b) {
            if (this.nStrings_ >= 4096) {
                return 65535;
            }
            int hshidx = this.hash((short)index, b);
            while (this.strHsh_[hshidx] != -1) {
                hshidx = (hshidx + 2039) % 9973;
            }
            this.strHsh_[hshidx] = this.nStrings_;
            this.strChr_[this.nStrings_] = b;
            this.strNxt_[this.nStrings_] = index != -1 ? index : -1;
            short s = this.nStrings_;
            this.nStrings_ = (short)(s + 1);
            return s;
        }

        short findCharString(short index, byte b) {
            short nxtidx;
            if (index == -1) {
                return b;
            }
            int hshidx = this.hash(index, b);
            while ((nxtidx = this.strHsh_[hshidx]) != -1) {
                if (this.strNxt_[nxtidx] == index && this.strChr_[nxtidx] == b) {
                    return nxtidx;
                }
                hshidx = (hshidx + 2039) % 9973;
            }
            return -1;
        }

        void clearTable(int codesize) {
            int q;
            this.nStrings_ = 0;
            for (q = 0; q < 9973; ++q) {
                this.strHsh_[q] = -1;
            }
            int w = (1 << codesize) + 2;
            for (q = 0; q < w; ++q) {
                this.addCharString((short)-1, (byte)q);
            }
        }

        int hash(short index, byte lastbyte) {
            return (((short)(lastbyte << 8) ^ index) & 0xFFFF) % 9973;
        }
    }
}

