/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.gif;

import com.idrsolutions.image.Decoder;
import com.idrsolutions.image.JDeliImage;
import com.idrsolutions.image.utility.DataByteLittle;
import com.idrsolutions.image.utility.DataFileLittle;
import com.idrsolutions.image.utility.DataReader;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.io.File;
import java.io.IOException;

public class GifDecoder
extends JDeliImage
implements Decoder {
    @Override
    public BufferedImage read(byte[] gifData) throws IOException {
        return GifDecoder.optimiseImage(GifDecoder.getBufferedImage(new DataByteLittle(gifData)));
    }

    @Override
    public BufferedImage read(File gifFile) throws IOException {
        return GifDecoder.getBufferedImage(new DataFileLittle(gifFile));
    }

    @Override
    public Rectangle readDimension(File gifFile) throws IOException {
        DataFileLittle reader = new DataFileLittle(gifFile);
        byte[] sign = new byte[6];
        reader.read(sign);
        if (sign[0] != 71 || sign[1] != 73 || sign[2] != 70 || sign[3] != 56 || !(sign[4] == 55 | sign[4] == 57) || sign[5] != 97) {
            throw new IOException("Invalid gif file format");
        }
        int width = reader.getU16();
        int height = reader.getU16();
        reader.close();
        return new Rectangle(width, height);
    }

    @Override
    public Rectangle readDimension(byte[] gifData) throws IOException {
        DataByteLittle reader = new DataByteLittle(gifData);
        byte[] sign = new byte[6];
        reader.read(sign);
        if (sign[0] != 71 || sign[1] != 73 || sign[2] != 70 || sign[3] != 56 || !(sign[4] == 55 | sign[4] == 57) || sign[5] != 97) {
            throw new IOException("Invalid gif file format");
        }
        int width = reader.getU16();
        int height = reader.getU16();
        reader.close();
        return new Rectangle(width, height);
    }

    private static BufferedImage getBufferedImage(DataReader reader) throws IOException {
        byte[] sign = new byte[6];
        reader.read(sign);
        if (sign[0] != 71 || sign[1] != 73 || sign[2] != 70 || sign[3] != 56 || !(sign[4] == 55 | sign[4] == 57) || sign[5] != 97) {
            throw new IOException("Invalid gif file format");
        }
        int width = reader.getU16();
        int height = reader.getU16();
        int mcrp = reader.getU8();
        reader.getU8();
        reader.getU8();
        byte[] rr = new byte[256];
        byte[] gg = new byte[256];
        byte[] bb = new byte[256];
        if (mcrp >> 7 == 1) {
            int bp = 1 << (mcrp & 0xF) + 1;
            for (int i = 0; i < bp; ++i) {
                rr[i] = (byte)reader.getU8();
                gg[i] = (byte)reader.getU8();
                bb[i] = (byte)reader.getU8();
            }
        }
        boolean canRead = true;
        while (canRead && reader.getPosition() < reader.getLength()) {
            int separator = reader.getU8();
            switch (separator) {
                case 33: {
                    int size;
                    reader.skip(1);
                    do {
                        size = reader.getU8();
                        reader.skip(size);
                    } while (size != 0);
                    break;
                }
                case 44: {
                    reader.getU16();
                    reader.getU16();
                    reader.getU16();
                    reader.getU16();
                    int mip = reader.getU8();
                    boolean lctFlag = (mip & 0x80) != 0;
                    int lctSize = 2 << (mip & 7);
                    if (lctFlag) {
                        mcrp = mip;
                        for (int i = 0; i < lctSize; ++i) {
                            rr[i] = (byte)reader.getU8();
                            gg[i] = (byte)reader.getU8();
                            bb[i] = (byte)reader.getU8();
                        }
                    }
                    IndexColorModel cm = new IndexColorModel((mcrp & 0xF) + 1, rr.length, rr, gg, bb);
                    BufferedImage img = new BufferedImage(width, height, 13, cm);
                    byte[] imgData = ((DataBufferByte)img.getRaster().getDataBuffer()).getData();
                    GifDecoder.decompress(reader, width, height, imgData);
                    return img;
                }
                case 59: {
                    canRead = false;
                }
            }
        }
        return null;
    }

    private static void decompress(DataReader reader, int width, int height, byte[] output) throws IOException {
        int lzLen = reader.getU8();
        int dim = width * height;
        int MAXLEN = 4096;
        int[] prefix = new int[4096];
        byte[] pixels = new byte[4097];
        byte[] block = new byte[256];
        int clear = 1 << lzLen;
        int eoi = clear + 1;
        int avail = clear + 2;
        int old = -1;
        int cLen = lzLen + 1;
        int cMask = (1 << cLen) - 1;
        byte[] suffix = GifDecoder.setSuffixes(clear);
        int i = 0;
        int bi = 0;
        int pi = 0;
        int top = 0;
        int first = 0;
        int count = 0;
        int bits = 0;
        int datum = 0;
        while (i < dim) {
            if (top == 0) {
                if (bits < cLen) {
                    if (count == 0) {
                        count = GifDecoder.getBlock(reader, block);
                        if (count <= 0) break;
                        bi = 0;
                    }
                    datum += (block[bi] & 0xFF) << bits;
                    bits += 8;
                    ++bi;
                    --count;
                    continue;
                }
                int code = datum & cMask;
                datum >>= cLen;
                bits -= cLen;
                if (code > avail || code == eoi) break;
                if (code == clear) {
                    cLen = lzLen + 1;
                    cMask = (1 << cLen) - 1;
                    avail = clear + 2;
                    old = -1;
                    continue;
                }
                if (old == -1) {
                    pixels[top++] = suffix[code];
                    old = code;
                    first = code;
                    continue;
                }
                int cur = code;
                if (code == avail) {
                    pixels[top++] = (byte)first;
                    code = old;
                }
                while (code > clear) {
                    pixels[top++] = suffix[code];
                    code = prefix[code];
                }
                first = suffix[code] & 0xFF;
                if (avail >= 4096) break;
                prefix[avail] = old;
                suffix[avail] = (byte)first;
                pixels[top++] = (byte)first;
                if ((++avail & cMask) == 0 && avail < 4096) {
                    ++cLen;
                    cMask += avail;
                }
                old = cur;
            }
            output[pi++] = pixels[--top];
            ++i;
        }
        i = pi;
        while (i < dim) {
            output[i++] = 0;
        }
    }

    private static byte[] setSuffixes(int clear) {
        byte[] suffix = new byte[4096];
        for (int code = 0; code < clear; ++code) {
            suffix[code] = (byte)code;
        }
        return suffix;
    }

    private static int getBlock(DataReader reader, byte[] block) throws IOException {
        int n;
        int blockSize = reader.getU8();
        if (blockSize > 0) {
            int cc;
            for (n = 0; n < blockSize; n += cc) {
                cc = blockSize - n;
                reader.moveTo(reader.getPosition() + n);
                for (int j = 0; j < cc; ++j) {
                    block[j] = (byte)reader.getU8();
                }
            }
        }
        return n;
    }
}

