/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.filter;

import com.idrsolutions.image.filter.FilterOptions;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import org.jpedal.io.IdrInputStream;
import org.jpedal.io.IdrOutputStream;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.filter.Predictor;
import org.jpedal.io.security.CryptoIDR;

public abstract class Filter {
    protected BufferedInputStream bis;
    protected BufferedOutputStream streamCache;
    protected FilterOptions options;
    protected Map<String, String> cachedObjects;
    protected FilterOptions.FilterMode mode;
    protected byte[] encHash;

    protected Filter(FilterOptions options) {
        this.options = options;
        this.mode = options.getMode();
        this.cachedObjects = new HashMap<String, String>();
    }

    protected Filter() {
        this.cachedObjects = new HashMap<String, String>();
    }

    protected byte[] applyPredictor(int predictor, byte[] data, int colors, int bitsPerComponent, int columns) throws Exception {
        boolean isCached;
        if (predictor == 1) {
            return data;
        }
        boolean bl = isCached = data == null;
        if (isCached) {
            Predictor.applyPredictor(predictor, this.bis, this.streamCache, colors, bitsPerComponent, columns);
            return null;
        }
        ByteArrayInputStream byis = new ByteArrayInputStream(data);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Predictor.applyPredictor(predictor, byis, bos, colors, bitsPerComponent, columns);
        byis.close();
        return bos.toByteArray();
    }

    public abstract byte[] decode(byte[] var1) throws Exception;

    public abstract void decode(BufferedInputStream var1, BufferedOutputStream var2, String var3, Map<String, String> var4) throws Exception;

    public abstract byte[] encode(byte[] var1);

    public abstract void encode(BufferedInputStream var1, BufferedOutputStream var2) throws Exception;

    public boolean hasError() {
        return false;
    }

    public void setupCachedObjectForDecoding(String cacheName) throws Exception {
        File tempFile2 = File.createTempFile("jpedal", ".raw", new File(ObjectStore.temp_dir));
        this.cachedObjects.put(tempFile2.getAbsolutePath(), "x");
        ObjectStore.copy(cacheName, tempFile2.getAbsolutePath());
        File rawFile = new File(cacheName);
        rawFile.delete();
        Path path = Paths.get(cacheName, new String[0]);
        if (this.encHash != null) {
            this.streamCache = new BufferedOutputStream(new IdrOutputStream(Files.newOutputStream(path, new OpenOption[0]), new CryptoIDR(this.encHash)));
            this.bis = new BufferedInputStream(new IdrInputStream(Files.newInputStream(tempFile2.toPath(), new OpenOption[0]), new CryptoIDR(this.encHash)));
        } else {
            this.streamCache = new BufferedOutputStream(Files.newOutputStream(path, new OpenOption[0]));
            this.bis = new BufferedInputStream(Files.newInputStream(tempFile2.toPath(), new OpenOption[0]));
        }
    }

    public void setEncHash(byte[] encHash) {
        this.encHash = encHash;
    }
}

