/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.emf.data;

import com.idrsolutions.image.emf.data.Design;
import com.idrsolutions.image.emf.data.FM;
import com.idrsolutions.image.emf.data.Space;
import java.awt.image.BufferedImage;
import java.util.Base64;

public class SvgSpace
implements Space {
    private int sc;
    private int ss = 0;
    private int fc;
    private int sw = 1;
    private int fontC = -16777216;
    private String fontName = "arial";
    private int fontSize = 12;
    private int fontWeight = 0;
    private final StringBuilder sb;
    private float[][] ctm = FM.getIdentity();
    private float[][] fontTM = FM.getIdentity();
    private Design design;

    public SvgSpace(StringBuilder sb) {
        this.sb = sb;
        sb.append("<svg xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\">");
    }

    @Override
    public void sLine(int x, int y, int x2, int y2) {
    }

    @Override
    public void rect(int x, int y, int w, int h) {
    }

    private static String rgbToHex(int argb) {
        if (argb == 0) {
            return "none";
        }
        if (argb == -1) {
            return "#fff";
        }
        if (argb == -16777216) {
            return "#000";
        }
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        return String.format("#%02x%02x%02x", r, g, b);
    }

    private void initPath(int[] cmds) {
        this.sb.append("\n<path d='");
        int i = 0;
        boolean hasMove = false;
        while (i < cmds.length) {
            switch (cmds[i]) {
                case 0: {
                    this.sb.append(SvgSpace.pathCommandM(cmds, i, this.ctm));
                    i += 3;
                    hasMove = true;
                    break;
                }
                case 1: {
                    this.sb.append(SvgSpace.pathCommandL(cmds, i, this.ctm));
                    i += 3;
                    hasMove = true;
                    break;
                }
                case 4: {
                    this.sb.append('Z');
                    ++i;
                    break;
                }
                case 2: {
                    if (!hasMove) {
                        this.sb.append(SvgSpace.pathCommandM(cmds, i, this.ctm));
                    }
                    this.sb.append(SvgSpace.pathCommandC(cmds, i, this.ctm));
                    i += 7;
                }
            }
        }
        this.sb.append("' ");
    }

    private static String pathCommandM(int[] cmds, int i, float[][] ctm) {
        float[] xy = new float[]{cmds[i + 1], cmds[i + 2]};
        FM.transform(ctm, xy);
        return "M" + Math.round(xy[0]) + " " + Math.round(xy[1]);
    }

    private static String pathCommandL(int[] cmds, int i, float[][] ctm) {
        float[] xy = new float[]{cmds[i + 1], cmds[i + 2]};
        FM.transform(ctm, xy);
        return "L" + Math.round(xy[0]) + " " + Math.round(xy[1]);
    }

    private static String pathCommandC(int[] cmds, int i, float[][] ctm) {
        float[] xy = new float[]{cmds[i + 1], cmds[i + 2]};
        float[] xy1 = new float[]{cmds[i + 3], cmds[i + 4]};
        float[] xy2 = new float[]{cmds[i + 5], cmds[i + 6]};
        FM.transform(ctm, xy);
        FM.transform(ctm, xy1);
        FM.transform(ctm, xy2);
        return "C" + Math.round(xy[0]) + " " + Math.round(xy[1]) + "," + Math.round(xy1[0]) + " " + Math.round(xy1[1]) + "," + Math.round(xy2[0]) + " " + Math.round(xy2[1]);
    }

    @Override
    public void sPath(int[] cmds) {
        int t;
        this.initPath(cmds);
        this.sb.append("fill='none' stroke='");
        this.sb.append(SvgSpace.rgbToHex(this.sc));
        this.sb.append("' ");
        float temp = Math.abs((float)this.sw * this.ctm[0][0]);
        if (temp < 1.0f && temp > 0.0f) {
            temp = 1.0f;
        }
        if ((t = Math.round(temp)) > 1) {
            this.sb.append("stroke-width='");
            this.sb.append(t);
            this.sb.append("' ");
        }
        this.sb.append("/>");
    }

    @Override
    public void fPath(int[] cmds) {
        this.initPath(cmds);
        this.sb.append("fill='");
        this.sb.append(SvgSpace.rgbToHex(this.fc));
        this.sb.append("'/>");
    }

    @Override
    public void sfPath(int[] cmds) {
        int t;
        this.initPath(cmds);
        this.sb.append("fill='");
        this.sb.append(SvgSpace.rgbToHex(this.fc));
        this.sb.append("' stroke='");
        this.sb.append(SvgSpace.rgbToHex(this.sc));
        this.sb.append("' ");
        float temp = Math.abs((float)this.sw * this.ctm[0][0]);
        if (temp < 1.0f && temp > 0.0f) {
            temp = 1.0f;
        }
        if ((t = Math.round(temp)) > 1) {
            this.sb.append("stroke-width='");
            this.sb.append(t);
            this.sb.append("' ");
        }
        this.sb.append("/>");
    }

    @Override
    public void image(int x, int y, BufferedImage image) {
    }

    @Override
    public void bmpImage(int x, int y, byte[] data) {
        byte[] enc = Base64.getEncoder().encode(data);
        this.sb.append("\n<image ");
        this.sb.append("x='");
        this.sb.append(x);
        this.sb.append("' y='");
        this.sb.append(y);
        this.sb.append("' transform='");
        this.sb.append(SvgSpace.getMatrixString(this.ctm));
        this.sb.append("' ");
        this.sb.append("xlink:href='data:image/bmp;base64,");
        this.sb.append(new String(enc));
        this.sb.append("'/>");
    }

    @Override
    public void fill() {
    }

    @Override
    public void stroke() {
    }

    @Override
    public void text(int x, int y, String str) {
        char[] chars;
        this.sb.append("\n<text x='");
        this.sb.append(x);
        this.sb.append("' y='");
        this.sb.append(y);
        this.sb.append("' font-size='");
        this.sb.append(this.fontSize);
        this.sb.append("' font-family='");
        this.sb.append(this.fontName);
        this.sb.append("' transform='");
        this.sb.append(SvgSpace.getMatrixString(this.ctm));
        switch (this.fontWeight) {
            case 1: {
                this.sb.append("' font-weight='");
                this.sb.append("bold");
                break;
            }
            case 2: {
                this.sb.append("' font-weight='");
                this.sb.append("italic");
            }
        }
        if (this.fontC != -16777216) {
            this.sb.append("' fill='");
            this.sb.append(SvgSpace.rgbToHex(this.fontC));
        }
        this.sb.append("'>");
        for (char c : chars = str.toCharArray()) {
            if (c == ' ' || c > '/' && c < ':' || c > '@' && c < '[' || c > '`' && c < '{') {
                this.sb.append(c);
                continue;
            }
            this.sb.append("&#x");
            this.sb.append(Integer.toHexString(c));
            this.sb.append(';');
        }
        this.sb.append("</text>");
    }

    private static String getMatrixString(float[][] mm) {
        StringBuilder sb = new StringBuilder();
        sb.append("matrix(");
        double t = (double)Math.round((double)mm[0][0] * 100.0) / 100.0;
        sb.append(t);
        sb.append(' ');
        t = (double)Math.round((double)mm[0][1] * 100.0) / 100.0;
        sb.append(t);
        sb.append(' ');
        t = (double)Math.round((double)mm[1][0] * 100.0) / 100.0;
        sb.append(t);
        sb.append(' ');
        t = (double)Math.round((double)mm[1][1] * 100.0) / 100.0;
        sb.append(t);
        sb.append(' ');
        t = (double)Math.round((double)mm[2][0] * 100.0) / 100.0;
        sb.append(t);
        sb.append(' ');
        t = (double)Math.round((double)mm[2][1] * 100.0) / 100.0;
        sb.append(t);
        sb.append(')');
        return sb.toString();
    }

    @Override
    public void clip(int x, int y, int x1, int y1) {
    }

    @Override
    public void font(String name, int size, int weight) {
        this.fontName = name;
        this.fontSize = size;
        this.fontWeight = weight;
    }

    @Override
    public void setFontC(int argb) {
        this.fontC = argb;
    }

    @Override
    public void setSC(int argb) {
        this.sc = argb;
    }

    @Override
    public void setFC(int argb) {
        this.fc = argb;
        this.design = null;
    }

    @Override
    public void setSW(int w) {
        this.sw = w;
    }

    @Override
    public void reset() {
        this.sc = 0;
        this.fc = 0;
        this.sw = 1;
        this.fontC = -16777216;
        this.fontName = "arial";
        this.fontSize = 12;
        this.fontWeight = 0;
    }

    @Override
    public void sStyle(int s) {
        this.ss = s;
    }

    @Override
    public void setMatrix(float[][] m) {
        this.ctm = m;
    }

    @Override
    public float[][] getMatrix() {
        return this.ctm;
    }

    @Override
    public void close() {
        this.sb.append("\n</svg>");
    }

    @Override
    public int getSC() {
        return this.sc;
    }

    @Override
    public int getFC() {
        return this.fc;
    }

    @Override
    public int getFontC() {
        return this.fontC;
    }

    @Override
    public void setFontMatrix(float[][] m) {
        this.fontTM = m;
    }

    @Override
    public float[][] getFontMatrix() {
        return this.fontTM;
    }

    @Override
    public void setFontName(String name) {
        this.fontName = name;
    }

    @Override
    public String getFontName() {
        return this.fontName;
    }

    @Override
    public void setFontSize(int size) {
        this.fontSize = size;
    }

    @Override
    public int getFontSize() {
        return this.fontSize;
    }

    @Override
    public void setDesign(Design design) {
        this.design = design;
    }

    @Override
    public Design getDesign() {
        return this.design;
    }

    @Override
    public void ellipse(int x, int y, int rx, int ry) {
        this.sb.append("<ellipse cx='");
        this.sb.append(x);
        this.sb.append("' cy='");
        this.sb.append(y);
        this.sb.append("' rx='");
        this.sb.append(rx);
        this.sb.append("' ry='");
        this.sb.append(ry);
        this.sb.append("' transform='");
        this.sb.append(SvgSpace.getMatrixString(this.ctm));
        this.sb.append("' ");
        this.sb.append("fill='");
        this.sb.append(SvgSpace.rgbToHex(this.fc));
        this.sb.append("' stroke='");
        this.sb.append(SvgSpace.rgbToHex(this.sc));
        this.sb.append("'/>");
    }
}

